/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.spezifteilesuche.federtabelle;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import webetk.app.Bedingungsmenge;
import webetk.app.aspg.Teil;
import webetk.app.federtabelle.FTZeile;
import webetk.app.federtabelle.FTZeilen;
import webetk.app.federtabelle.SalaZeile;
import webetk.app.federtabelle.SalaZeilen;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.extras.teileinfo.DlgTeileinfoKleinController;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.FedernTabelle;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.FedernTabelleModell;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.FedertabelleDlgController;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.FedertabelleDlgModel;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.RowSelectionModel;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.SelectionModel;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.SonderausstattungenTabelle;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.SonderausstattungenTabelleModell;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class FedertabelleDlgView
extends AbstractDlgMitTLView {
    private static final long serialVersionUID = 1L;
    static int VIER_FEDERN = 0;
    static int DREI_FEDERN_VA_2FEDERN = 1;
    static int DREI_FEDERN_HA_2FEDERN = 2;
    static int ZWEI_FEDERN = 3;
    private int mnLayout;
    private static Logger log = Logger.getLogger(FedertabelleDlgView.class);
    private MouseListener tabelleFedernListener = null;
    private JPanel titledPanFeder = null;
    private JPanel titledPanSA = null;
    private JPanel panContent = null;
    private JPanel panSonderausstattungen = null;
    private JPanel panFedern = null;
    private SonderausstattungenTabelleModell tableModelSALeft = null;
    private SonderausstattungenTabelleModell tableModelSARight = null;
    private SonderausstattungenTabelle tableSA = null;
    private JButtonEx buttonBerechnen = null;
    JTextArea txtHinweisFedern = null;
    private FedernTabelleModell tableModelFedern = null;
    private FedernTabelle tableFedern = null;
    private JTable tableFedernTable = null;
    private JPanel panTeileliste;
    private boolean mbInitial = true;
    private JPopupMenu menuPopup = null;
    private JMenuItem menuitemCopySachnummer = null;
    private FedertabelleDlgModel model;
    private FedertabelleDlgController controller;

    @Override
    public void initMenus() {
        this.menuPopup = new JPopupMenu();
        this.menuitemCopySachnummer = new MenuItemCopySachnummer(this);
        this.menuPopup.add(this.menuitemCopySachnummer);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        HeaderPanel panHeader = new HeaderPanel(Resource.getInstance().getFedertabelle(), this.model.getFzgIdString(), ImageCache.getInstance().getHeaderIcon("feder"));
        this.panContent = new JPanel();
        int[] w = new int[]{0, 0, 10};
        int[] h = new int[]{0, 0, 5, 0, 0};
        HIGLayout layout = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        layout.setColumnWeight(2, 1);
        this.panContent.setLayout(layout);
        this.panSonderausstattungen = this.createAnzeigeSonderaustattungen();
        this.panContent.add((Component)this.panSonderausstattungen, c.rc(2, 2, "ltrb"));
        this.panFedern = this.createAnzeigeFedern();
        this.panContent.add((Component)this.panFedern, c.rc(4, 2, "ltrb"));
        JScrollPane scContent = new JScrollPane(this.panContent, 20, 30);
        this.setLayout(new BorderLayout());
        this.add((Component)panHeader, "North");
        this.add((Component)scContent, "Center");
    }

    protected JPanel createAnzeigeFedern() {
        this.titledPanFeder = new TitledPanel(Resource.getInstance().getAnzeigeFedern());
        int[] w = new int[]{10, 950, 10};
        int[] h = new int[]{10, 0, 10, 0, 5, 0, 0, 10};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(2, 1);
        HIGConstraints c = new HIGConstraints();
        this.titledPanFeder.setLayout(hl);
        String[] columnNames = new String[]{Resource.getInstance().getTyp(), " ", " ", Resource.getInstance().getVorderachse() + " links", " ", " ", Resource.getInstance().getVorderachse() + " rechts", " ", " ", Resource.getInstance().getHinterachse() + " links", " ", " ", Resource.getInstance().getHinterachse() + " rechts"};
        Object[] prototypes = new Object[]{"AU51AU51", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderrachse rechts", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderrachse rechts", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderrachse rechts", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderrachse rechts"};
        boolean[] resizeable = new boolean[]{true, false, false, true, false, false, true, false, false, true, false, false, true};
        int columnCount = 13;
        this.mnLayout = VIER_FEDERN;
        this.tableModelFedern = new FedernTabelleModell(this.mnLayout, columnCount, columnNames, prototypes, resizeable);
        this.tableFedern = new FedernTabelle(this.tableModelFedern);
        this.tableFedernTable = this.tableFedern.getTable();
        this.tabelleFedernListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FedertabelleDlgView.this.handleAufruf(e, FedertabelleDlgView.this.tableFedernTable.getSelectedRow(), FedertabelleDlgView.this.tableFedernTable.getSelectedColumn());
            }

            @Override
            public void mouseExited(MouseEvent evt) {
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }
        };
        this.tableFedernTable.addMouseListener(this.tabelleFedernListener);
        this.panTeileliste = this.createTeilelistePanel();
        this.titledPanFeder.add((Component)this.panTeileliste, c.rc(2, 2, "tlbr"));
        this.txtHinweisFedern = new JTextArea(Resource.getInstance().getAspgHinweisFedern(), 2, 1);
        this.txtHinweisFedern.setEditable(false);
        this.txtHinweisFedern.setBackground(this.getBackground());
        this.titledPanFeder.add((Component)this.tableFedernTable.getTableHeader(), c.rc(6, 2, "tb"));
        this.titledPanFeder.add((Component)this.tableFedernTable, c.rc(7, 2, "tb"));
        return this.titledPanFeder;
    }

    protected JPanel createTeilelistePanel() {
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FedertabelleDlgView.this.uebernehmenInTeileliste();
            }
        });
        JPanel p = new JPanel();
        int[] w = new int[]{10, 0, 5, 0, 20, 0, 20, 0, 10};
        int[] h = new int[]{10, 0, 10};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(9, 1);
        HIGConstraints c = new HIGConstraints();
        p.setLayout(hl);
        p.add((Component)this.labTeileliste, c.rc(2, 2, "l"));
        p.add((Component)this.comboTeileliste, c.rc(2, 4, "l"));
        p.add((Component)this.buttonUebernehmen, c.rc(2, 6, "l"));
        p.add((Component)this.buttonUeberpruefen, c.rc(2, 8, "l"));
        return p;
    }

    protected JPanel createAnzeigeSonderaustattungen() {
        this.titledPanSA = new TitledPanel(Resource.getInstance().getAnzeigeSonderausstattungen());
        int[] w = new int[]{10, 0, 50, 0, 10};
        int[] h = new int[]{10, 0, 5, 0, 0, 20, 0, 10};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(2, 1);
        hl.setColumnWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.titledPanSA.setLayout(hl);
        JTextArea txtHinweis = new JTextArea(Resource.getInstance().getFedertabelleHinweisAuswaehlen() + "\n" + Resource.getInstance().getFedertabelleHinweisNachruestungen());
        txtHinweis.setEditable(false);
        txtHinweis.setBackground(this.getBackground());
        this.tableModelSALeft = new SonderausstattungenTabelleModell();
        this.tableModelSARight = new SonderausstattungenTabelleModell();
        this.tableSA = new SonderausstattungenTabelle(this.tableModelSALeft, this.tableModelSARight);
        JTable tblLeft = this.tableSA.getLeftTable();
        tblLeft.addKeyListener(new EnterKeyListener());
        JTable tblRight = this.tableSA.getRightTable();
        tblRight.addKeyListener(new EnterKeyListener());
        this.titledPanSA.add((Component)txtHinweis, c.rcwh(2, 2, 3, 1, "rltb"));
        this.titledPanSA.add((Component)tblLeft.getTableHeader(), c.rc(4, 2, "tblr"));
        this.titledPanSA.add((Component)tblLeft, c.rc(5, 2, "tblr"));
        this.titledPanSA.add((Component)tblRight.getTableHeader(), c.rc(4, 4, "tblr"));
        this.titledPanSA.add((Component)tblRight, c.rc(5, 4, "tblr"));
        this.buttonBerechnen = new JButtonEx(Resource.getInstance().getFedernAnzeigen(), ImageCache.getInstance().getIcon("federn.jpg"));
        this.buttonBerechnen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FedertabelleDlgView.this.berechnenFedern(0);
                FedertabelleDlgView.this.update();
            }
        });
        this.titledPanSA.add((Component)this.buttonBerechnen, c.rcwh(7, 2, 3, 1, "t"));
        return this.titledPanSA;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Iterator<JComponent> getMenus() {
        return null;
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        log.debug((Object)"init");
        super.init(oDlgModel, oDlgController);
        this.model = (FedertabelleDlgModel)oDlgModel;
        this.controller = (FedertabelleDlgController)oDlgController;
        this.controller.loadTeilelistenIDs();
        this.controller.loadSonderausstattungen();
        this.initMenus();
        this.initComponents();
        this.update();
        if (this.model.isEmptySonderausstattungen()) {
            this.berechnenFedern(100);
            this.update();
        }
    }

    @Override
    public void setFocus() {
        if (this.buttonBerechnen != null) {
            this.buttonBerechnen.requestFocus();
        }
    }

    @Override
    public void update() {
        if (this.mbInitial) {
            this.updateTeilelisten();
            Bedingungsmenge oBedingungen = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo().getBedingungsMenge();
            SalaZeilen sonderausstattungenLinks = this.model.getSonderausstattungenLinks();
            List<SalaZeile> salaZeileList = sonderausstattungenLinks.getZeilen();
            for (int i = 0; i < salaZeileList.size(); ++i) {
                SalaZeile salaZeile = salaZeileList.get(i);
                this.tableModelSALeft.addZeile(salaZeile.getCode(), salaZeile.getBenennung());
                if (!oBedingungen.isSchnittstellenBed(Long.valueOf(salaZeile.getId()))) continue;
                this.tableSA.getLeftTableSelectionModel().addSelection(i);
            }
            SalaZeilen sonderausstattungenRechts = this.model.getSonderausstattungenRechts();
            salaZeileList = sonderausstattungenRechts.getZeilen();
            for (int i = 0; i < salaZeileList.size(); ++i) {
                SalaZeile salaZeile = salaZeileList.get(i);
                this.tableModelSARight.addZeile(salaZeile.getCode(), salaZeile.getBenennung());
                if (!oBedingungen.isSchnittstellenBed(Long.valueOf(salaZeile.getId()))) continue;
                this.tableSA.getRightTableSelectionModel().addSelection(i);
            }
            this.mbInitial = false;
        }
        this.panFedern.setVisible(this.model.getFedern() != null);
        this.tableModelFedern.removeAllRows();
        FTZeilen ftZeilen = this.model.getFedern();
        if (ftZeilen != null) {
            for (FTZeile ftZeile : ftZeilen.getZeilen()) {
                String sTyp = ftZeile.getTyp();
                String sTeilenummerVA_links = StringUtils.nullsafe(ftZeile.getTeilenummerVA_links());
                String sTeilenummerVA_rechts = StringUtils.nullsafe(ftZeile.getTeilenummerVA_rechts());
                String sTeilenummerHA_links = StringUtils.nullsafe(ftZeile.getTeilenummerHA_links());
                String sTeilenummerHA_rechts = StringUtils.nullsafe(ftZeile.getTeilenummerHA_rechts());
                this.tableModelFedern.addZeile(sTyp, sTeilenummerVA_links, sTeilenummerVA_rechts, sTeilenummerHA_links, sTeilenummerHA_rechts);
            }
        }
        if (this.model.getCountFedernZeilen() == 1) {
            this.panFedern.remove(this.txtHinweisFedern);
        } else {
            HIGConstraints c = new HIGConstraints();
            this.panFedern.add((Component)this.txtHinweisFedern, c.rc(4, 2, "tb"));
        }
        this.panFedern.invalidate();
        this.panFedern.validate();
        this.panFedern.repaint();
    }

    private void berechnenFedern(int nHackDelay) {
        Vector<String> cSelSalaIds = new Vector<String>();
        SalaZeilen sonderausstattungenLinks = this.model.getSonderausstattungenLinks();
        SalaZeilen sonderausstattungenRechts = this.model.getSonderausstattungenRechts();
        RowSelectionModel oLeftTableSelectionModel = this.tableSA.getLeftTableSelectionModel();
        for (int i = 0; i < this.tableSA.getLeftTable().getRowCount(); ++i) {
            if (!oLeftTableSelectionModel.isSelected(i)) continue;
            cSelSalaIds.add(sonderausstattungenLinks.getZeilen().get(i).getId());
        }
        RowSelectionModel oRightTableSelectionModel = this.tableSA.getRightTableSelectionModel();
        for (int i = 0; i < this.tableSA.getRightTable().getRowCount(); ++i) {
            if (!oRightTableSelectionModel.isSelected(i)) continue;
            cSelSalaIds.add(sonderausstattungenRechts.getZeilen().get(i).getId());
        }
        this.controller.loadFedern(cSelSalaIds, nHackDelay);
        this.mnLayout = this.getSpaltenLayout();
        String[] columnNames = null;
        Object[] prototypes = null;
        int columnCount = 0;
        boolean[] resizeable = null;
        if (this.mnLayout == ZWEI_FEDERN) {
            columnNames = new String[]{Resource.getInstance().getTyp(), " ", " ", Resource.getInstance().getVorderachse(), " ", " ", Resource.getInstance().getHinterachse()};
            prototypes = new Object[]{"AU51AU51", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderachse rechts    VorderVorderachse rechts", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderachse rechts    VorderVorderachse rechts"};
            resizeable = new boolean[]{false, false, false, false, false, false, false};
            columnCount = 7;
        }
        if (this.mnLayout == DREI_FEDERN_VA_2FEDERN) {
            columnNames = new String[]{Resource.getInstance().getTyp(), " ", " ", Resource.getInstance().getVorderachse() + " " + Resource.getInstance().getLinks(), " ", " ", Resource.getInstance().getVorderachse() + " " + Resource.getInstance().getRechts(), " ", " ", Resource.getInstance().getHinterachse()};
            prototypes = new Object[]{"AU51AU51", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderachse rechts", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderachse rechts", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderachse rechts    VorderVorderachse rechts"};
            resizeable = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            columnCount = 10;
        }
        if (this.mnLayout == DREI_FEDERN_HA_2FEDERN) {
            columnNames = new String[]{Resource.getInstance().getTyp(), " ", " ", Resource.getInstance().getVorderachse(), " ", " ", Resource.getInstance().getHinterachse() + " " + Resource.getInstance().getLinks(), " ", " ", Resource.getInstance().getHinterachse() + " " + Resource.getInstance().getRechts()};
            prototypes = new Object[]{"AU51AU51", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderachse rechts    VorderVorderachse rechts", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderachse rechts", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderachse rechts"};
            resizeable = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            columnCount = 10;
        }
        if (this.mnLayout == VIER_FEDERN) {
            columnNames = new String[]{Resource.getInstance().getTyp(), " ", " ", Resource.getInstance().getVorderachse() + " " + Resource.getInstance().getLinks(), " ", " ", Resource.getInstance().getVorderachse() + " " + Resource.getInstance().getRechts(), " ", " ", Resource.getInstance().getHinterachse() + " " + Resource.getInstance().getLinks(), " ", " ", Resource.getInstance().getHinterachse() + " " + Resource.getInstance().getRechts()};
            prototypes = new Object[]{"AU51AU51", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderachse rechts", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderachse rechts", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderachse rechts", ImageCache.getInstance().getIcon("info.gif"), "MR", "VorderVorderachse rechts"};
            resizeable = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false};
            columnCount = 13;
        }
        this.titledPanFeder.remove(this.tableFedernTable.getTableHeader());
        this.titledPanFeder.remove(this.tableFedernTable);
        this.tableModelFedern = new FedernTabelleModell(this.mnLayout, columnCount, columnNames, prototypes, resizeable);
        this.tableFedern = new FedernTabelle(this.tableModelFedern);
        this.tableFedernTable = this.tableFedern.getTable();
        this.tableFedernTable.addMouseListener(this.tabelleFedernListener);
        HIGConstraints c = new HIGConstraints();
        this.titledPanFeder.add((Component)this.tableFedernTable.getTableHeader(), c.rc(6, 2, "tb"));
        this.titledPanFeder.add((Component)this.tableFedernTable, c.rc(7, 2, "tb"));
        this.titledPanFeder.setOpaque(true);
        this.titledPanFeder.validate();
        this.titledPanFeder.repaint();
    }

    private void uebernehmenInTeileliste() {
        Vector<Teil> cTeile = new Vector<Teil>();
        SelectionModel selModel = this.tableFedern.getSelectionModel();
        int nAnzahlZeilen = this.model.getCountFedernZeilen();
        for (int nRow = 0; nRow < nAnzahlZeilen; ++nRow) {
            Teil teil;
            String sKZGruppe;
            String sSachnummer;
            boolean isKoppelTeil;
            boolean isAnkerTeil;
            String sTeilenummer;
            if (selModel.isCellSelected(nRow, 3)) {
                sTeilenummer = (String)this.tableFedernTable.getValueAt(nRow, 3);
                sTeilenummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "");
                sTeilenummer = sTeilenummer.trim();
                isAnkerTeil = this.isAnker(nRow, 3, nAnzahlZeilen);
                isKoppelTeil = "--".equals((String)this.tableFedernTable.getValueAt(nRow, 2));
                if (!sTeilenummer.equals("") && !isKoppelTeil) {
                    sSachnummer = sTeilenummer.substring(4);
                    sKZGruppe = isAnkerTeil ? "AS" : "";
                    teil = new Teil(sSachnummer, "1", sKZGruppe);
                    cTeile.add(teil);
                    if (isAnkerTeil) {
                        teil.setAspgTyp("A");
                        teil.setAspgRef(sSachnummer);
                        teil.setAspgMenge("1");
                        cTeile.addAll(this.getAspgKitFromFedernTable(nRow, 3, nAnzahlZeilen, sSachnummer));
                    }
                }
            }
            if (selModel.isCellSelected(nRow, 6)) {
                sTeilenummer = (String)this.tableFedernTable.getValueAt(nRow, 6);
                sTeilenummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "");
                sTeilenummer = sTeilenummer.trim();
                isAnkerTeil = this.isAnker(nRow, 6, nAnzahlZeilen);
                isKoppelTeil = "--".equals((String)this.tableFedernTable.getValueAt(nRow, 5));
                if (!sTeilenummer.equals("") && !isKoppelTeil) {
                    sSachnummer = sTeilenummer.substring(4);
                    sKZGruppe = isAnkerTeil ? "AS" : "";
                    teil = new Teil(sSachnummer, "1", sKZGruppe);
                    cTeile.add(teil);
                    if (isAnkerTeil) {
                        teil.setAspgTyp("A");
                        teil.setAspgRef(sSachnummer);
                        teil.setAspgMenge("1");
                        cTeile.addAll(this.getAspgKitFromFedernTable(nRow, 6, nAnzahlZeilen, sSachnummer));
                    }
                }
            }
            if ((this.mnLayout == DREI_FEDERN_VA_2FEDERN || this.mnLayout == DREI_FEDERN_HA_2FEDERN || this.mnLayout == VIER_FEDERN) && selModel.isCellSelected(nRow, 9)) {
                sTeilenummer = (String)this.tableFedernTable.getValueAt(nRow, 9);
                sTeilenummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "");
                sTeilenummer = sTeilenummer.trim();
                isAnkerTeil = this.isAnker(nRow, 9, nAnzahlZeilen);
                isKoppelTeil = "--".equals((String)this.tableFedernTable.getValueAt(nRow, 8));
                if (!sTeilenummer.equals("") && !isKoppelTeil) {
                    sSachnummer = sTeilenummer.substring(4);
                    sKZGruppe = isAnkerTeil ? "AS" : "";
                    teil = new Teil(sSachnummer, "1", sKZGruppe);
                    cTeile.add(teil);
                    if (isAnkerTeil) {
                        teil.setAspgTyp("A");
                        teil.setAspgRef(sSachnummer);
                        teil.setAspgMenge("1");
                        cTeile.addAll(this.getAspgKitFromFedernTable(nRow, 9, nAnzahlZeilen, sSachnummer));
                    }
                }
            }
            if (this.mnLayout != VIER_FEDERN || !selModel.isCellSelected(nRow, 12)) continue;
            sTeilenummer = (String)this.tableFedernTable.getValueAt(nRow, 12);
            sTeilenummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "");
            sTeilenummer = sTeilenummer.trim();
            isAnkerTeil = this.isAnker(nRow, 12, nAnzahlZeilen);
            isKoppelTeil = "--".equals((String)this.tableFedernTable.getValueAt(nRow, 11));
            if (sTeilenummer.equals("") || isKoppelTeil) continue;
            sSachnummer = sTeilenummer.substring(4);
            sKZGruppe = isAnkerTeil ? "AS" : "";
            teil = new Teil(sSachnummer, "1", sKZGruppe);
            cTeile.add(teil);
            if (!isAnkerTeil) continue;
            teil.setAspgTyp("A");
            teil.setAspgRef(sSachnummer);
            teil.setAspgMenge("1");
            cTeile.addAll(this.getAspgKitFromFedernTable(nRow, 12, nAnzahlZeilen, sSachnummer));
        }
        this.uebernehmenInTeilelisteMitFIS(cTeile, false);
    }

    private boolean isAnker(int row, int col, int anzahlZeilen) {
        return row + 2 < anzahlZeilen && "".equals((String)this.tableFedernTable.getValueAt(row, col - 1)) && "".equals((String)this.tableFedernTable.getValueAt(row + 1, col - 1)) && "--".equals((String)this.tableFedernTable.getValueAt(row + 2, col - 1));
    }

    private Collection<Teil> getAspgKitFromFedernTable(int row, int col, int anzahlZeilen, String sAnkerSachnummer) {
        Vector<Teil> res = new Vector<Teil>();
        for (int i = row + 2; i < anzahlZeilen && "--".equals((String)this.tableFedernTable.getValueAt(i, col - 1)); ++i) {
            String sKoppelTeilenummer = (String)this.tableFedernTable.getValueAt(i, col);
            sKoppelTeilenummer = StringUtils.substituteStringStraight(sKoppelTeilenummer, " ", "");
            if ((sKoppelTeilenummer = sKoppelTeilenummer.trim()).equals("")) continue;
            String sKoppelSachnummer = sKoppelTeilenummer.substring(4);
            Teil koppelTeil = new Teil(sKoppelSachnummer, "1", "AS");
            res.add(koppelTeil);
            koppelTeil.setAspgTyp("K");
            koppelTeil.setAspgRef(sAnkerSachnummer);
            koppelTeil.setAspgMenge("1");
        }
        return res;
    }

    private void handleAufruf(MouseEvent evt, int nRow, int nCol) {
        boolean bTeileinfo = false;
        boolean bCopySachnummer = false;
        if (this.mnLayout == VIER_FEDERN) {
            if (nCol == 3 || nCol == 6 || nCol == 9 || nCol == 12) {
                bCopySachnummer = true;
            }
            if (nCol == 1 || nCol == 4 || nCol == 7 || nCol == 10) {
                bTeileinfo = true;
            }
        }
        if (this.mnLayout == DREI_FEDERN_VA_2FEDERN) {
            if (nCol == 3 || nCol == 6 || nCol == 9) {
                bCopySachnummer = true;
            }
            if (nCol == 1 || nCol == 4 || nCol == 7) {
                bTeileinfo = true;
            }
        }
        if (this.mnLayout == DREI_FEDERN_HA_2FEDERN) {
            if (nCol == 3 || nCol == 6 || nCol == 9) {
                bCopySachnummer = true;
            }
            if (nCol == 1 || nCol == 4 || nCol == 7) {
                bTeileinfo = true;
            }
        }
        if (this.mnLayout == ZWEI_FEDERN) {
            if (nCol == 3 || nCol == 6) {
                bCopySachnummer = true;
            }
            if (nCol == 1 || nCol == 4) {
                bTeileinfo = true;
            }
        }
        if (bTeileinfo) {
            String sTeilenummer = (String)this.tableFedernTable.getValueAt(nRow, nCol + 2);
            if (sTeilenummer.equals("")) {
                return;
            }
            String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
            new DlgTeileinfoKleinController((Frame)MainView.getInstance(), sSachnummer);
        }
        int nRowCount = this.tableFedernTable.getSelectedRowCount();
        int nColCount = this.tableFedernTable.getSelectedColumnCount();
        if (bCopySachnummer && nRowCount == 1 && nColCount == 1) {
            String sTeilenummer = (String)this.tableFedernTable.getValueAt(nRow, nCol);
            if (sTeilenummer.equals("")) {
                return;
            }
            this.menuPopup.show(this.tableFedernTable, evt.getX(), evt.getY());
        }
    }

    private int getSpaltenLayout() {
        int nLayout = ZWEI_FEDERN;
        FTZeilen ftZeilen = this.model.getFedern();
        if (ftZeilen == null) {
            return nLayout;
        }
        for (FTZeile ftZeile : ftZeilen.getZeilen()) {
            String sTeilenummerHA_rechts;
            String sTeilenummerHA_links;
            String sTeilenummerVA_rechts;
            String sTeilenummerVA_links = StringUtils.nullsafe(ftZeile.getTeilenummerVA_links());
            if (!sTeilenummerVA_links.equals(sTeilenummerVA_rechts = StringUtils.nullsafe(ftZeile.getTeilenummerVA_links()))) {
                if (nLayout == ZWEI_FEDERN) {
                    nLayout = DREI_FEDERN_VA_2FEDERN;
                }
                if (nLayout == DREI_FEDERN_HA_2FEDERN) {
                    nLayout = VIER_FEDERN;
                }
            }
            if (!(sTeilenummerHA_links = StringUtils.nullsafe(ftZeile.getTeilenummerHA_links())).equals(sTeilenummerHA_rechts = StringUtils.nullsafe(ftZeile.getTeilenummerHA_rechts()))) {
                if (nLayout == ZWEI_FEDERN) {
                    nLayout = DREI_FEDERN_HA_2FEDERN;
                }
                if (nLayout == DREI_FEDERN_VA_2FEDERN) {
                    nLayout = VIER_FEDERN;
                }
            }
            if (nLayout != VIER_FEDERN) continue;
            return nLayout;
        }
        return nLayout;
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        int nCol;
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        int nRow = this.tableFedernTable.getSelectedRow();
        String sTeilenummer = (String)this.tableFedernTable.getValueAt(nRow, nCol = this.tableFedernTable.getSelectedColumn());
        if (sTeilenummer.equals("")) {
            return null;
        }
        String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
        oHashMap.put("sachnummer", sSachnummer);
        return oHashMap;
    }

    protected class EnterKeyListener
    extends KeyAdapter {
        protected EnterKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if (ev.getKeyCode() == 10) {
                FedertabelleDlgView.this.berechnenFedern(0);
                FedertabelleDlgView.this.update();
            }
        }
    }
}

