/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.spezifteilesuche.federtabelle;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashSet;
import javax.swing.JTable;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.CellSelected;

public class RowSelectionModel
implements CellSelected {
    private static final boolean DEBUG = false;
    protected JTable table;
    protected MouseHandler mouseHandler;
    protected HashSet<Integer> selectedEntries = new HashSet();
    protected HashSet<Integer> backup;

    public RowSelectionModel(JTable table) {
        this.table = table;
        this.mouseHandler = new MouseHandler();
    }

    public void installMouseHandler() {
        this.table.addMouseListener(this.mouseHandler);
        this.table.addMouseMotionListener(this.mouseHandler);
    }

    public void removeMouseHandler() {
        this.table.removeMouseListener(this.mouseHandler);
        this.table.removeMouseMotionListener(this.mouseHandler);
    }

    public void addSelection(int row) {
        this.selectedEntries.add(row);
    }

    public void removeSelection(int row) {
        this.selectedEntries.remove(row);
    }

    public boolean isSelected(int row) {
        return this.selectedEntries.contains(row);
    }

    @Override
    public boolean isCellSelected(int row, int column) {
        return this.isSelected(row);
    }

    protected void makeBackup() {
        this.backup = new HashSet<Integer>(this.selectedEntries);
    }

    protected void revertToBackup() {
        this.selectedEntries = new HashSet<Integer>(this.backup);
    }

    class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        int startRow = -1;
        int startColumn = -1;
        boolean addSelection = false;
        boolean traceDragging = false;

        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.startRow = RowSelectionModel.this.table.rowAtPoint(e.getPoint());
            this.startColumn = RowSelectionModel.this.table.columnAtPoint(e.getPoint());
            if (this.startRow >= 0 && this.startColumn >= 0) {
                this.addSelection = !RowSelectionModel.this.isSelected(this.startRow);
                this.traceDragging = true;
                RowSelectionModel.this.makeBackup();
                this.doSelections(this.startRow, this.startRow);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.traceDragging) {
                return;
            }
            int endRow = RowSelectionModel.this.table.rowAtPoint(e.getPoint());
            int endColumn = RowSelectionModel.this.table.columnAtPoint(e.getPoint());
            RowSelectionModel.this.revertToBackup();
            if (this.startRow >= 0 && this.startColumn >= 0 && endRow >= 0 && endColumn >= 0) {
                this.doSelections(this.startRow, endRow);
            }
            this.traceDragging = false;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.traceDragging) {
                return;
            }
            RowSelectionModel.this.revertToBackup();
            int endRow = RowSelectionModel.this.table.rowAtPoint(e.getPoint());
            int endColumn = RowSelectionModel.this.table.columnAtPoint(e.getPoint());
            if (this.startRow >= 0 && this.startColumn >= 0 && endRow >= 0 && endColumn >= 0) {
                this.doSelections(this.startRow, endRow);
            }
            RowSelectionModel.this.table.repaint();
        }

        protected void doSelections(int sr, int er) {
            if (sr > er) {
                int t = sr;
                sr = er;
                er = t;
            }
            for (int r = sr; r <= er; ++r) {
                if (this.addSelection) {
                    RowSelectionModel.this.addSelection(r);
                    continue;
                }
                RowSelectionModel.this.removeSelection(r);
            }
            RowSelectionModel.this.table.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

