/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.spezifteilesuche.federtabelle;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashSet;
import javax.swing.JTable;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.CellSelected;
import webetk.javaclient.dialog.spezifteilesuche.federtabelle.CellSelectionAllowed;

public class SelectionModel
implements CellSelected {
    private static final boolean DEBUG = false;
    protected CellSelectionAllowed model;
    protected JTable table;
    protected MouseHandler mouseHandler;
    protected HashSet<String> selectedEntries = new HashSet();
    protected HashSet<String> backup;

    public SelectionModel(JTable table, CellSelectionAllowed model) {
        this.model = model;
        this.table = table;
        this.mouseHandler = new MouseHandler();
    }

    public void installMouseHandler() {
        this.table.addMouseListener(this.mouseHandler);
        this.table.addMouseMotionListener(this.mouseHandler);
    }

    public void removeMouseHandler() {
        this.table.removeMouseListener(this.mouseHandler);
        this.table.removeMouseMotionListener(this.mouseHandler);
    }

    public void addSelection(int row, int column) {
        if (!this.model.isCellSelectable(row, column)) {
            return;
        }
        String sel = row + "," + column;
        this.selectedEntries.add(sel);
    }

    public void removeSelection(int row, int column) {
        if (!this.model.isCellSelectable(row, column)) {
            return;
        }
        String sel = row + "," + column;
        this.selectedEntries.remove(sel);
    }

    @Override
    public boolean isCellSelected(int row, int column) {
        if (!this.model.isCellSelectable(row, column)) {
            return false;
        }
        String sel = row + "," + column;
        return this.selectedEntries.contains(sel);
    }

    protected void makeBackup() {
        this.backup = new HashSet<String>(this.selectedEntries);
    }

    protected void revertToBackup() {
        this.selectedEntries = new HashSet<String>(this.backup);
    }

    class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        int startRow = -1;
        int startColumn = -1;
        boolean addSelection = false;
        boolean traceDragging = false;

        MouseHandler() {
        }

        protected int getModelIndex(int viewColumnIndex) {
            return SelectionModel.this.table.getColumnModel().getColumn(viewColumnIndex).getModelIndex();
        }

        protected boolean isSelectable(int row, int column) {
            return SelectionModel.this.model.isCellSelectable(this.startRow, this.getModelIndex(column));
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.startRow = SelectionModel.this.table.rowAtPoint(e.getPoint());
            this.startColumn = SelectionModel.this.table.columnAtPoint(e.getPoint());
            if (this.startRow >= 0 && this.startColumn >= 0 && this.isSelectable(this.startRow, this.startColumn)) {
                this.addSelection = !SelectionModel.this.isCellSelected(this.startRow, this.getModelIndex(this.startColumn));
                this.traceDragging = true;
                SelectionModel.this.makeBackup();
                this.doSelections(this.startRow, this.startColumn, this.startRow, this.startColumn);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.traceDragging) {
                return;
            }
            int endRow = SelectionModel.this.table.rowAtPoint(e.getPoint());
            int endColumn = SelectionModel.this.table.columnAtPoint(e.getPoint());
            SelectionModel.this.revertToBackup();
            if (this.startRow >= 0 && this.startColumn >= 0 && endRow >= 0 && endColumn >= 0 && this.isSelectable(endRow, endColumn)) {
                this.doSelections(this.startRow, this.startColumn, endRow, endColumn);
            }
            this.traceDragging = false;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.traceDragging) {
                return;
            }
            SelectionModel.this.revertToBackup();
            int endRow = SelectionModel.this.table.rowAtPoint(e.getPoint());
            int endColumn = SelectionModel.this.table.columnAtPoint(e.getPoint());
            if (this.startRow >= 0 && this.startColumn >= 0 && endRow >= 0 && endColumn >= 0 && this.isSelectable(endRow, endColumn)) {
                this.doSelections(this.startRow, this.startColumn, endRow, endColumn);
            }
            SelectionModel.this.table.repaint();
        }

        protected void doSelections(int sr, int sc, int er, int ec) {
            int t;
            if (sr > er) {
                t = sr;
                sr = er;
                er = t;
            }
            if (sc > ec) {
                t = sc;
                sc = ec;
                ec = t;
            }
            for (int r = sr; r <= er; ++r) {
                for (int c = sc; c <= ec; ++c) {
                    if (this.addSelection) {
                        SelectionModel.this.addSelection(r, this.getModelIndex(c));
                        continue;
                    }
                    SelectionModel.this.removeSelection(r, this.getModelIndex(c));
                }
            }
            SelectionModel.this.table.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

