/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.spezifteilesuche.suche;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.communication.CommunicationException;
import webetk.communication.JavaAssSucheInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfTeilesuche;
import webetk.javaclient.dialog.spezifteilesuche.suche.DlgTeilesucheSucheModel;
import webetk.javaclient.dialog.spezifteilesuche.suche.DlgTeilesucheSucheView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgTeilesucheSucheController
extends AbstractDialogViewController {
    Logger log = Logger.getLogger(DlgTeilesucheSucheController.class);
    DlgTeilesucheSucheView view = new DlgTeilesucheSucheView();
    DlgTeilesucheSucheModel model = new DlgTeilesucheSucheModel();

    @Override
    public DialogView getDialogView() {
        this.log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
        if (GlobalObjects.getInstance().getEtkData().isScoreTeilesuche()) {
            this.view.setVisible(false);
        }
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("exitaction", "tssuchen");
        exitData.setWert("bildtafeln", this.model.getBildtafeln());
        exitData.setWert("bildtafeln_sel", this.model.getBildtafeln());
        exitData.setWert("teilenummern", this.model.getTeilenummern());
        exitData.setWert("tree", this.model.getHgFgTree());
        exitData.setWert("flag_ausweisung_elemente", this.model.isAusweisungenElementeErmitteln() ? "true" : "false");
        exitData.setWert("bed_filter", this.model.isBedFilter() ? "true" : "false");
        exitData.setWert("mouse_listener_hash_code", "" + this.model.getMouseListenerJTreeHashCode());
        exitData.setWert("index_next_hg", Integer.toString(this.model.getIndexHGNext()));
        exitData.setWert("index_prev_hg", Integer.toString(this.model.getIndexHGPrev()));
        exitData.setWert("HGFG_BENENNUNG", this.model.getHgFgs());
        return exitData;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    void loadHgFgs() {
        this.log.debug((Object)"Performing Load HgFgs");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfHgFgs = new TrfHashMap(null);
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            trfHgFgs.setValue("isfzg", "true");
        } else {
            trfHgFgs.setValue("isfzg", "false");
            trfHgFgs.setValue("marke", this.model.getMarke());
            trfHgFgs.setValue("produktart", this.model.getProduktart());
            trfHgFgs.setValue("katalogumfang", this.model.getKatalogumfang());
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHgFgs, Command.LOAD_TEILESUCHE_HGFG);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfHgFgs.getError() != null) {
            if (trfHgFgs.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Hauptgruppen/Funktionsgruppen gefunden!", (Throwable)trfHgFgs.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfHgFgs.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfHgFgs.getError().getMessage(), this.model.getDialogTitel(), 0);
            return;
        }
        this.model.storeHgFgs((List)trfHgFgs.getValue("hgfgs"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean performSearchTeilenummerOderBtNummer(String sHgUg, String sSachnummer, JComponent cTextfield, String btNummer) {
        this.log.debug((Object)"Performing Search Teilenummer");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        cTextfield.setCursor(Cursor.getPredefinedCursor(3));
        TrfTeilesuche trfSuche = new TrfTeilesuche(null);
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            trfSuche.setValue("isfzg", "true");
        } else {
            trfSuche.setValue("isfzg", "false");
            trfSuche.setValue("marke", this.model.getMarke());
            trfSuche.setValue("produktart", this.model.getProduktart());
            trfSuche.setValue("katalogumfang", this.model.getKatalogumfang());
        }
        trfSuche.setValue("modus", "sucheteilenummer");
        if (btNummer != null && !btNummer.isEmpty()) {
            trfSuche.setValue("hgug", "");
            trfSuche.setValue("sachnummer", "");
            trfSuche.setValue("btnummer", btNummer);
        } else {
            trfSuche.setValue("hgug", sHgUg);
            trfSuche.setValue("sachnummer", sSachnummer);
            trfSuche.setValue("btnummer", "");
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSuche, Command.PERFORM_TEILESUCHE);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            cTextfield.setCursor(Cursor.getPredefinedCursor(2));
            return false;
        }
        if (trfSuche.getError() != null) {
            if (trfSuche.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"Suchergebnisse gefunden", (Throwable)trfSuche.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                cTextfield.setCursor(Cursor.getPredefinedCursor(2));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), this.model.getDialogTitel(), 0);
                return false;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfSuche.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            cTextfield.setCursor(Cursor.getPredefinedCursor(2));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfSuche.getError().getMessage(), this.model.getDialogTitel(), 0);
            return false;
        }
        this.model.storeBildtafeln((Collection)trfSuche.getValue("bildtafeln"));
        this.model.storeTeilenummern((Collection)trfSuche.getValue("teilenummern"));
        if (this.model.getDialogModus().equals("Accessoires")) {
            JavaAssSucheInfo oAssSucheInfo = (JavaAssSucheInfo)trfSuche.getValue("asssucheinfo_java");
            GlobalObjects.getInstance().getEtkData().setSucheInfo(oAssSucheInfo);
        } else {
            JavaFzgSucheInfo oFzgSucheInfo = (JavaFzgSucheInfo)trfSuche.getValue("fzgsucheinfo_java");
            GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfo);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        cTextfield.setCursor(Cursor.getPredefinedCursor(2));
        return true;
    }

    public boolean performSearchBenennung(String sBenennung, JComponent cTextfield) {
        this.log.debug((Object)"Performing Search Benennung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        cTextfield.setCursor(Cursor.getPredefinedCursor(3));
        TrfTeilesuche trfSuche = new TrfTeilesuche(null);
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            trfSuche.setValue("isfzg", "true");
        } else {
            trfSuche.setValue("isfzg", "false");
            trfSuche.setValue("marke", this.model.getMarke());
            trfSuche.setValue("produktart", this.model.getProduktart());
            trfSuche.setValue("katalogumfang", this.model.getKatalogumfang());
        }
        trfSuche.setValue("modus", "suchebenennung");
        trfSuche.setValue("benennung", sBenennung);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSuche, Command.PERFORM_TEILESUCHE);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            cTextfield.setCursor(Cursor.getPredefinedCursor(2));
            return false;
        }
        if (trfSuche.getError() != null) {
            if (trfSuche.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"Suchergebnisse gefunden", (Throwable)trfSuche.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                cTextfield.setCursor(Cursor.getPredefinedCursor(2));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), this.model.getDialogTitel(), 0);
                return false;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfSuche.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            cTextfield.setCursor(Cursor.getPredefinedCursor(2));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfSuche.getError().getMessage(), this.model.getDialogTitel(), 0);
            return false;
        }
        this.log.info((Object)"DlgTeilesucheController: Wir waren erfolgreich");
        this.model.storeBildtafeln((Collection)trfSuche.getValue("bildtafeln"));
        this.model.storeTeilenummern((Collection)trfSuche.getValue("teilenummern"));
        if (this.model.getDialogModus().equals("Accessoires")) {
            JavaAssSucheInfo oAssSucheInfo = (JavaAssSucheInfo)trfSuche.getValue("asssucheinfo_java");
            GlobalObjects.getInstance().getEtkData().setSucheInfo(oAssSucheInfo);
        } else {
            JavaFzgSucheInfo oFzgSucheInfo = (JavaFzgSucheInfo)trfSuche.getValue("fzgsucheinfo_java");
            GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfo);
            this.log.info((Object)("oFzgSucheInfo: " + oFzgSucheInfo.printOut()));
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        cTextfield.setCursor(Cursor.getPredefinedCursor(2));
        return true;
    }

    public boolean performSearchSuchbegriff(String sSuchbegriff, JComponent cTextfield) {
        this.log.debug((Object)"Performing Search Suchbegriff");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        cTextfield.setCursor(Cursor.getPredefinedCursor(3));
        TrfTeilesuche trfSuche = new TrfTeilesuche(null);
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            trfSuche.setValue("isfzg", "true");
        } else {
            trfSuche.setValue("isfzg", "false");
            trfSuche.setValue("marke", this.model.getMarke());
            trfSuche.setValue("produktart", this.model.getProduktart());
            trfSuche.setValue("katalogumfang", this.model.getKatalogumfang());
        }
        trfSuche.setValue("modus", "suchesuchbegriff");
        trfSuche.setValue("suchbegriff", sSuchbegriff);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSuche, Command.PERFORM_TEILESUCHE);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            cTextfield.setCursor(Cursor.getPredefinedCursor(2));
            return false;
        }
        if (trfSuche.getError() != null) {
            if (trfSuche.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"Suchergebnisse gefunen", (Throwable)trfSuche.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                cTextfield.setCursor(Cursor.getPredefinedCursor(2));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), this.model.getDialogTitel(), 0);
                return false;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfSuche.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            cTextfield.setCursor(Cursor.getPredefinedCursor(2));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfSuche.getError().getMessage(), this.model.getDialogTitel(), 0);
            return false;
        }
        this.model.storeBildtafeln((Collection)trfSuche.getValue("bildtafeln"));
        this.model.storeTeilenummern((Collection)trfSuche.getValue("teilenummern"));
        if (this.model.getDialogModus().equals("Accessoires")) {
            JavaAssSucheInfo oAssSucheInfo = (JavaAssSucheInfo)trfSuche.getValue("asssucheinfo_java");
            GlobalObjects.getInstance().getEtkData().setSucheInfo(oAssSucheInfo);
        } else {
            JavaFzgSucheInfo oFzgSucheInfo = (JavaFzgSucheInfo)trfSuche.getValue("fzgsucheinfo_java");
            GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfo);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        cTextfield.setCursor(Cursor.getPredefinedCursor(2));
        return true;
    }

    public boolean performSearchFremdeTeilenummer(String sFremdeTeilenummer, JComponent cTextfield) {
        this.log.debug((Object)"Performing Search Fremde Teilenummer");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        cTextfield.setCursor(Cursor.getPredefinedCursor(3));
        TrfTeilesuche trfSuche = new TrfTeilesuche(null);
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            trfSuche.setValue("isfzg", "true");
        } else {
            trfSuche.setValue("isfzg", "false");
            trfSuche.setValue("marke", this.model.getMarke());
            trfSuche.setValue("produktart", this.model.getProduktart());
            trfSuche.setValue("katalogumfang", this.model.getKatalogumfang());
        }
        trfSuche.setValue("modus", "suchefremdeteilenummer");
        trfSuche.setValue("fremdeteilenummer", sFremdeTeilenummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSuche, Command.PERFORM_TEILESUCHE);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            cTextfield.setCursor(Cursor.getPredefinedCursor(2));
            return false;
        }
        if (trfSuche.getError() != null) {
            if (trfSuche.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"Suchergebnisse gefunen", (Throwable)trfSuche.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                cTextfield.setCursor(Cursor.getPredefinedCursor(2));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), this.model.getDialogTitel(), 0);
                return false;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfSuche.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            cTextfield.setCursor(Cursor.getPredefinedCursor(2));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfSuche.getError().getMessage(), this.model.getDialogTitel(), 0);
            return false;
        }
        this.model.storeBildtafeln((Collection)trfSuche.getValue("bildtafeln"));
        this.model.storeTeilenummern((Collection)trfSuche.getValue("teilenummern"));
        if (this.model.getDialogModus().equals("Accessoires")) {
            JavaAssSucheInfo oAssSucheInfo = (JavaAssSucheInfo)trfSuche.getValue("asssucheinfo_java");
            GlobalObjects.getInstance().getEtkData().setSucheInfo(oAssSucheInfo);
        } else {
            JavaFzgSucheInfo oFzgSucheInfo = (JavaFzgSucheInfo)trfSuche.getValue("fzgsucheinfo_java");
            GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfo);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        cTextfield.setCursor(Cursor.getPredefinedCursor(2));
        return true;
    }

    public boolean performSearchHgFg(ArrayList<String> cHgFg, String sHGSel, boolean bDirekt) {
        this.log.debug((Object)"Performing Search HgFg");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeilesuche trfSuche = new TrfTeilesuche(null);
        String sDirekt = bDirekt ? "true" : "false";
        trfSuche.setValue("direkt", sDirekt);
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            trfSuche.setValue("isfzg", "true");
        } else {
            trfSuche.setValue("isfzg", "false");
            trfSuche.setValue("marke", this.model.getMarke());
            trfSuche.setValue("produktart", this.model.getProduktart());
            trfSuche.setValue("katalogumfang", this.model.getKatalogumfang());
        }
        trfSuche.setValue("modus", "suchehgfg");
        trfSuche.setValue("hgfg", cHgFg);
        trfSuche.setValue("hg", sHGSel);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSuche, Command.PERFORM_TEILESUCHE);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfSuche.getError() != null) {
            if (trfSuche.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"Suchergebnisse gefunen", (Throwable)trfSuche.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), this.model.getDialogTitel(), 0);
                return false;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfSuche.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfSuche.getError().getMessage(), this.model.getDialogTitel(), 0);
            return false;
        }
        this.model.storeBildtafeln((Collection)trfSuche.getValue("bildtafeln"));
        this.model.storeTeilenummern((Collection)trfSuche.getValue("teilenummern"));
        String sIndexHGNext = (String)trfSuche.getValue("index_next_hg");
        int nIndexHGNext = sIndexHGNext == null ? -1 : Integer.parseInt(sIndexHGNext);
        this.model.setIndexHGNext(nIndexHGNext);
        String sIndexHGPrev = (String)trfSuche.getValue("index_prev_hg");
        int nIndexHGPrev = sIndexHGPrev == null ? -1 : Integer.parseInt(sIndexHGPrev);
        this.model.setIndexHGPrev(nIndexHGPrev);
        if (this.model.getDialogModus().equals("Accessoires")) {
            JavaAssSucheInfo oAssSucheInfo = (JavaAssSucheInfo)trfSuche.getValue("asssucheinfo_java");
            GlobalObjects.getInstance().getEtkData().setSucheInfo(oAssSucheInfo);
        } else {
            JavaFzgSucheInfo oFzgSucheInfo = (JavaFzgSucheInfo)trfSuche.getValue("fzgsucheinfo_java");
            GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfo);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public static class ExitActions {
        public static final String TS_SUCHEN = "tssuchen";
    }
}

