/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.spezifteilesuche.suchergebnisse;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.communication.CommunicationException;
import webetk.communication.JavaAssSucheInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.JavaSucheInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfTeilesuche;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.spezifteilesuche.suchergebnisse.SuchergebnisseModel;
import webetk.javaclient.dialog.spezifteilesuche.suchergebnisse.SuchergebnisseView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class SuchergebnisseController
extends AbstractDlgMitTLController {
    private static Logger log = Logger.getLogger(SuchergebnisseController.class);
    private SuchergebnisseView view = new SuchergebnisseView();
    private SuchergebnisseModel model = new SuchergebnisseModel();

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        super.init(this.model);
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        String sExitAction;
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("exitaction", this.model.getExitAction());
        exitData.setWert("HGFG_BENENNUNG", this.model.getHgFgList());
        exitData.setWert("bed_filter", this.model.isBedFilter() ? "true" : "false");
        if (this.model.getExitAction().endsWith("weiterbildtafeln_step1") || this.model.getExitAction().endsWith("weiterbildtafeln_step2")) {
            exitData.setWert("bildtafeln_sel", this.model.getSelBildtafeln());
            exitData.setWert("bildtafeln", this.model.getBildtafelnBlaettern());
            JavaSucheInfo oSucheInfo = GlobalObjects.getInstance().getEtkData().getSucheInfo();
            String sSuchSachnummer = oSucheInfo.getSuchSachnummer();
            exitData.setWert("sachnummersuch", sSuchSachnummer);
        }
        if (this.model.getExitAction().endsWith("weitersachnummern_step1")) {
            exitData.setWert("bildtafeln", this.model.getBildtafelnSortiertNachMarkt());
            exitData.setWert("bildtafeln_sel", this.model.getBildtafelnBlaettern());
            exitData.setWert("sachnummern", this.model.getSelSachnummern());
        }
        if ((sExitAction = this.model.getExitAction()).equals("search_hg_at_index")) {
            exitData.setWert("index", Integer.toString(this.model.getIndexHGtoSearch()));
        }
        if (sExitAction.equals("zurueckzuteilesuche")) {
            exitData.setWert("bed_filter", "true");
            exitData.setWert("bildtafeln", null);
            exitData.setWert("bildtafeln_bed_aend", null);
        }
        return exitData;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    public boolean performSearchSachnummern(Collection<String> cSachnummern) {
        JavaAssSucheInfo oAssSucheInfo;
        log.debug((Object)"Performing Search Sachnummern");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfTeilesuche trfSuche = new TrfTeilesuche(null);
        if (this.model.getDialogModus().equals("Fahrzeugteile")) {
            trfSuche.setValue("isfzg", "true");
        } else {
            trfSuche.setValue("isfzg", "false");
            oAssSucheInfo = GlobalObjects.getInstance().getEtkData().getAssSucheInfo();
            trfSuche.setValue("marke", oAssSucheInfo.getMarke());
            trfSuche.setValue("produktart", oAssSucheInfo.getProduktart());
            trfSuche.setValue("katalogumfang", oAssSucheInfo.getKatalogumfang());
        }
        trfSuche.setValue("modus", "suchesachnummer");
        trfSuche.setValue("sachnummern", cSachnummern);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSuche, Command.PERFORM_TEILESUCHE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("SuchergebnisseController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfSuche.getError() != null) {
            if (trfSuche.getError() instanceof NoDataFoundException) {
                log.error((Object)"Suchergebnisse gefunen", (Throwable)trfSuche.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), this.model.getDialogTitel(), 0);
                return false;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfSuche.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfSuche.getError().getMessage(), this.model.getDialogTitel(), 0);
            return false;
        }
        this.model.setBildtafeln((Collection)trfSuche.getValue("bildtafeln"));
        this.model.setBildTafelnBlaettern((Collection)trfSuche.getValue("bildtafeln"));
        this.model.storeTeilenummern(null);
        if (this.model.getDialogModus().equals("Accessoires")) {
            oAssSucheInfo = (JavaAssSucheInfo)trfSuche.getValue("asssucheinfo_java");
            GlobalObjects.getInstance().getEtkData().setSucheInfo(oAssSucheInfo);
        } else {
            JavaFzgSucheInfo oFzgSucheInfo = (JavaFzgSucheInfo)trfSuche.getValue("fzgsucheinfo_java");
            GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfo);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public boolean isUSETK() {
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        if (oLoginInfo == null) {
            return false;
        }
        return oLoginInfo.isUsETK();
    }

    public static class ExitActions {
        public static final String WEITER_BILDTAFELN_STEP1 = "weiterbildtafeln_step1";
        public static final String WEITER_BILDTAFELN_STEP2 = "weiterbildtafeln_step2";
        public static final String WEITER_SACHNUMMERN_STEP1 = "weitersachnummern_step1";
        public static final String ZURUECK_ZU_FI = "zurueck_zu_fi";
    }
}

