/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.steckerAnschlagteile;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import webetk.app.aspg.Teil;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.dialog.steckerAnschlagteile.DlgSteckerAnschlagteileController;
import webetk.javaclient.dialog.steckerAnschlagteile.DlgSteckerAnschlagteileModel;
import webetk.javaclient.dialog.steckerAnschlagteile.TeilenummernZeile;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;

public class DlgSteckerAnschlagteile
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DlgSteckerAnschlagteile.class);
    protected DlgSteckerAnschlagteileModel mModel;
    protected DlgSteckerAnschlagteileController moController;
    protected JPanel mHeaderPanel;
    protected JComboBox mComboTeileliste;
    protected JButtonEx mButtonUebernehmen;
    protected JButtonEx mButtonUeberpruefen;
    protected Font mDescFont;
    protected Font mLabelFont;
    protected ComboTeilelisteItem moSelTeileliste;
    protected boolean mbHandleSelChangeCbTeileliste;
    private GenericTableModel tableTeilenummernModel;
    private GenericTable tableTeilenummern;
    private JScrollPane scrollPaneTableTeile = null;
    private JPanel buttonPanel = null;

    public DlgSteckerAnschlagteile(Frame oOwner, DlgSteckerAnschlagteileModel oModel, DlgSteckerAnschlagteileController oController) {
        super(oOwner);
        this.setTitle(Resource.getInstance().getSteckerUndAnschlagteile());
        this.mModel = oModel;
        this.moController = oController;
        this.mLabelFont = UIHelper.getNormalFont();
        this.mDescFont = UIHelper.getNormalFont();
        this.setSize(852, 350);
        int xOwner = oOwner.getX();
        int yOwner = oOwner.getY();
        int wOwner = oOwner.getWidth();
        int hOwner = oOwner.getHeight();
        this.setLocation(xOwner + wOwner / 2 - this.getWidth() / 2, yOwner + hOwner / 2);
        if (GlobalObjects.isScore()) {
            this.setResizable(true);
        }
        this.initComponents();
    }

    protected void initComponents() {
        this.mHeaderPanel = new HeaderPanel(Resource.getInstance().getSteckerUndAnschlagteile(), ImageCache.getInstance().getHeaderIcon("teileinfo"));
        this.mButtonUebernehmen = new JButtonEx(Resource.getInstance().getUebernehmen(), ImageCache.getInstance().getIcon("ok.gif"));
        this.mButtonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgSteckerAnschlagteile.this.handleUebernahme();
            }
        });
        this.mButtonUeberpruefen = new JButtonEx(Resource.getInstance().getUeberpruefen(), ImageCache.getInstance().getIcon("ueberpruefen.png"));
        this.mButtonUeberpruefen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgSteckerAnschlagteile.this.ueberpruefenTeileliste();
            }
        });
        this.mComboTeileliste = new JComboBox();
        this.mComboTeileliste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DlgSteckerAnschlagteile.this.kannSelektierteTeilelisteWechseln();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DlgSteckerAnschlagteile.this.moController.refreshParent();
                        DlgSteckerAnschlagteile.this.scrollPaneTableTeile.repaint();
                    }
                });
            }
        });
        this.layoutAll();
    }

    protected void layoutAll() {
        JPanel panel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 10, 0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        panel.setLayout(l);
        panel.add((Component)this.mHeaderPanel, c.rc(1, 1, "tlbr"));
        this.buttonPanel = this.layoutDetails();
        panel.add((Component)this.buttonPanel, c.rc(3, 1, "tlbr"));
        JScrollPane sp = this.createTabelleTeilenummern();
        panel.add((Component)sp, c.rc(4, 1, "tlbr"));
        JScrollPane sc = new JScrollPane(panel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(sc);
    }

    protected JPanel layoutDetails() {
        JPanel p = new JPanel();
        int[] w = new int[]{10, 0, 5, 0, 30, 0, 30, 0, 10};
        int[] h = new int[]{0, 10, 0, 0, 0, 0, 5, 0, 5};
        int[] h_score = new int[]{0, 0, 0, 0, 5, 0, 5};
        HIGLayout l = null;
        l = !GlobalObjects.isScore() ? new HIGLayout(w, h) : new HIGLayout(w, h_score);
        l.setColumnWeight(w.length - 1, 1);
        HIGConstraints c = new HIGConstraints();
        p.setLayout(l);
        int row = 1;
        int col = 2;
        if (!GlobalObjects.isScore() && !GlobalObjects.isIpac()) {
            p.add((Component)this.createLabel(Resource.getInstance().getInTeileliste()), c.rc(row, col, "l"));
            p.add((Component)this.mComboTeileliste, c.rc(row, col + 2));
            p.add((Component)this.mButtonUebernehmen, c.rc(row, col + 4, "l"));
            p.add((Component)this.mButtonUeberpruefen, c.rc(row, col + 6, "l"));
        }
        return p;
    }

    protected JLabel createLabel(String s) {
        JLabel l = new JLabel(s);
        l.setFont(this.mLabelFont);
        l.setForeground(Color.black);
        return l;
    }

    private void handleUebernahme() {
        if (this.tableTeilenummern.getSelectedRow() != -1) {
            int[] selectedRows = this.tableTeilenummern.getSelectedRows();
            Vector<Teil> aSachnr = new Vector<Teil>();
            for (int i = 0; i < selectedRows.length; ++i) {
                aSachnr.add(this.mModel.getSachnummern().get(selectedRows[i]));
            }
            this.moController.handleUebernehmen(this.mComboTeileliste.getSelectedIndex(), aSachnr);
        } else {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getBtanzStNoSelected(), Resource.getInstance().getTeileinfo(), 0);
        }
    }

    public void update() {
        this.updateTeilelisten();
        if (this.tableTeilenummernModel.getRowCount() == 0) {
            this.updateTableTeilenummern();
        }
    }

    protected void updateTeilelisten() {
        TrfHashMap oTeilelistenIDs = this.mModel.getTeilelistenIDs();
        this.mbHandleSelChangeCbTeileliste = false;
        this.mComboTeileliste.removeAllItems();
        if (oTeilelistenIDs != null) {
            ComboTeilelisteItem oTeilelisteItem;
            int i = 1;
            while ((oTeilelisteItem = (ComboTeilelisteItem)oTeilelistenIDs.getValue(i + "teilelisteid")) != null) {
                this.mComboTeileliste.addItem(oTeilelisteItem);
                ++i;
            }
            ComboTeilelisteItem oItem = DlgTeilelisteController.ermittleSelTL(this.mModel.getTeilelistenCollection(), true);
            this.mComboTeileliste.setSelectedItem(oItem);
            this.moSelTeileliste = oItem;
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            oLoginInfo.setAktuelleTeileliste(oItem);
            this.mButtonUeberpruefen.setEnabled(this.moSelTeileliste != null && this.moSelTeileliste.getID() != null && this.moSelTeileliste.getID().length() > 0 && !this.moSelTeileliste.getID().equals(Resource.getInstance().getNeueListe()));
        }
        this.mbHandleSelChangeCbTeileliste = true;
    }

    private void kannSelektierteTeilelisteWechseln() {
        if (this.mbHandleSelChangeCbTeileliste) {
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            if (oLoginInfo == null) {
                oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            }
            ComboTeilelisteItem oAktTLOld = oLoginInfo.getAktuelleTeileliste();
            int nSelIndex = this.mComboTeileliste.getSelectedIndex();
            ComboTeilelisteItem oTeilelisteItem = this.mModel.getTeileliste(nSelIndex);
            if (!DlgTeilelisteController.kannSelektionWechseln(oTeilelisteItem, this.moSelTeileliste)) {
                this.mbHandleSelChangeCbTeileliste = false;
                this.mComboTeileliste.setSelectedItem(this.moSelTeileliste);
                this.mbHandleSelChangeCbTeileliste = true;
            } else {
                if (oAktTLOld != null && this.moSelTeileliste.getID().equals(oAktTLOld.getID()) && !oLoginInfo.getLogin().equals(oAktTLOld.getEigentuemer())) {
                    DlgTeilelisteController.removeListe(this.moSelTeileliste, this.mModel.getTeilelistenIDs());
                    this.update();
                }
                this.moSelTeileliste = (ComboTeilelisteItem)this.mComboTeileliste.getSelectedItem();
                this.mButtonUeberpruefen.setEnabled(this.moSelTeileliste != null && this.moSelTeileliste.getID() != null && this.moSelTeileliste.getID().length() > 0 && !this.moSelTeileliste.getID().equals(Resource.getInstance().getNeueListe()));
            }
        }
    }

    private void ueberpruefenTeileliste() {
        int nSelIndex = this.mComboTeileliste.getSelectedIndex();
        ComboTeilelisteItem oTeilelisteItem = this.mModel.getTeileliste(nSelIndex);
        String sTeilelisteID = oTeilelisteItem.getID();
        String sEigentuemer = oTeilelisteItem.getEigentuemer();
        DlgTeilelisteController.showKleineListe(oTeilelisteItem);
        if (!sTeilelisteID.equals(oTeilelisteItem.getID()) || !sEigentuemer.equals(oTeilelisteItem.getEigentuemer())) {
            this.moController.loadTLZumUebernehmen();
        }
        this.moController.refreshParent();
        this.update();
    }

    private JScrollPane createTabelleTeilenummern() {
        TableConfiguration tableTeilenummernConfig = new TableConfiguration();
        tableTeilenummernConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "52 10 1 942 724YYY");
        tableTeilenummernConfig.addColumn(Resource.getInstance().getMenge(), 0, false, "XXXXXX");
        tableTeilenummernConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableTeilenummernConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXX");
        tableTeilenummernConfig.setUsePrototypeIcons(true);
        this.tableTeilenummernModel = new GenericTableModel(tableTeilenummernConfig);
        this.tableTeilenummern = new GenericTable(this.tableTeilenummernModel);
        GenericTableMouseEventListener listenerTeileInfo = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
                DlgSteckerAnschlagteile.this.handleUebernahme();
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.tableTeilenummern.addMouseListener(listenerTeileInfo, 0);
        GenericTableMouseEventListener listenerTable = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
                DlgSteckerAnschlagteile.this.handleUebernahme();
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (DlgSteckerAnschlagteile.this.tableTeilenummern.getTable().getSelectedRowCount() != 1) {
                    // empty if block
                }
            }
        };
        this.tableTeilenummern.addMouseListener(listenerTable, 1);
        this.tableTeilenummern.addMouseListener(listenerTable, 2);
        this.tableTeilenummern.addMouseListener(listenerTable, 3);
        this.tableTeilenummern.addMouseListener(listenerTable, 4);
        this.scrollPaneTableTeile = this.tableTeilenummern.getScrollPane();
        return this.scrollPaneTableTeile;
    }

    private void updateTableTeilenummern() {
        log.info((Object)"update der Teilenummern Ergebnisliste");
        int nIndexTeilenummerSelMin = -1;
        ArrayList<Teil> cTeilenummern = this.mModel.getSachnummern();
        if (cTeilenummern != null && cTeilenummern.size() > 0) {
            int nIndex = 0;
            for (Teil teil : cTeilenummern) {
                String sTeilenummer = teil.getTeilenummer();
                String sBenennung = teil.getBenennung();
                String sZusatz = teil.getZusatz();
                String sMenge = teil.getMenge();
                if (sTeilenummer.length() == 11) {
                    sTeilenummer = sTeilenummer.substring(0, 2) + " " + sTeilenummer.substring(2, 4) + " " + sTeilenummer.substring(4, 5) + " " + sTeilenummer.substring(5, 8) + " " + sTeilenummer.substring(8, 11);
                }
                this.tableTeilenummernModel.addRow(new TeilenummernZeile(sTeilenummer, sMenge, sBenennung, sZusatz));
                ++nIndex;
            }
            int dialogHeight = this.mHeaderPanel.getPreferredSize().height + this.buttonPanel.getPreferredSize().height + this.tableTeilenummern.getPreferredSize().height + 90;
            this.setSize(852, dialogHeight);
            if (nIndexTeilenummerSelMin != -1) {
                JScrollPane sc = this.tableTeilenummern.getScrollPane();
                int nTeilenummerRowShowVisible = nIndexTeilenummerSelMin <= 2 ? 0 : nIndexTeilenummerSelMin - 2;
                Rectangle rect = this.tableTeilenummern.getTable().getCellRect(nTeilenummerRowShowVisible, 0, true);
                sc.getViewport().setViewPosition(rect.getLocation());
            }
        }
        this.moController.refreshParent();
        this.scrollPaneTableTeile.repaint();
    }
}

