/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.teileverwendung.tvnachbenennung;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.generictable.ETKDefaultTableCellRenderer;
import webetk.javaclient.generictable.GenericRowAdapter;
import webetk.resources.Resource;

public class DatenZeile
extends GenericRowAdapter {
    private boolean mbFzg = true;
    private String msBauart = null;
    private String msBaureihe = null;
    private String msBaureiheExt = null;
    private String msModell = null;
    private String msKarosserie = null;
    private String msKarosserieExt = null;
    private String msRegion = null;
    private String msBtNummer = null;
    private String msBtUeberschrift = null;
    private String msMenge = null;
    private boolean mbHasInfo = false;
    private String msMarktIso = null;
    private static ETKDefaultTableCellRenderer hasInfo = null;
    private static ETKDefaultTableCellRenderer hasNoInfo = null;

    public DatenZeile(boolean bHasInfo, String sBtNummer, String sBtUeberschrift, String sBaureihe, String sBaureiheExt, String sModell, String sKarosserie, String sKarosserieExt, String sRegion, String sMarktIso, String sMenge) {
        this.mbFzg = true;
        this.mbHasInfo = bHasInfo;
        this.msBtNummer = sBtNummer;
        this.msBtUeberschrift = sBtUeberschrift;
        this.msBaureihe = sBaureihe;
        this.msBaureiheExt = sBaureiheExt;
        this.msModell = sModell;
        this.msKarosserie = sKarosserie;
        this.msKarosserieExt = sKarosserieExt;
        this.msRegion = sRegion;
        this.msMarktIso = sMarktIso;
        this.msMenge = sMenge;
    }

    public DatenZeile(boolean bHasInfo, String sBtNummer, String sBtUeberschrift, String sBauart, String sBaureihe, String sBaureiheExt, String sModell, String sRegion, String sMarktIso, String sMenge) {
        this.mbFzg = false;
        this.mbHasInfo = bHasInfo;
        this.msBtNummer = sBtNummer;
        this.msBtUeberschrift = sBtUeberschrift;
        this.msBauart = sBauart;
        this.msBaureihe = sBaureihe;
        this.msBaureiheExt = sBaureiheExt;
        this.msModell = sModell;
        this.msRegion = sRegion;
        this.msMarktIso = sMarktIso;
        this.msMenge = sMenge;
    }

    @Override
    public Object get(int column) {
        switch (column) {
            case 0: {
                return this.mbHasInfo ? hasInfo : hasNoInfo;
            }
            case 1: {
                return ImageCache.getInstance().getIcon("visualisierung.gif");
            }
            case 3: {
                return this.msBaureiheExt;
            }
            case 4: {
                return this.msModell;
            }
            case 5: {
                if (this.mbFzg) {
                    return this.msKarosserieExt;
                }
                return this.msRegion;
            }
            case 6: {
                if (this.mbFzg) {
                    return this.msRegion;
                }
                return this.msBtNummer;
            }
            case 7: {
                if (this.mbFzg) {
                    return this.msBtNummer;
                }
                return this.msBtUeberschrift;
            }
            case 8: {
                if (this.mbFzg) {
                    return this.msBtUeberschrift;
                }
                return this.msMarktIso;
            }
            case 9: {
                if (this.mbFzg) {
                    if (this.msMenge == null) {
                        return this.msMarktIso;
                    }
                    return this.msMenge;
                }
                return this.msMenge;
            }
        }
        return null;
    }

    public boolean hasInfo() {
        return this.mbHasInfo;
    }

    public String getBtNummer() {
        return this.msBtNummer;
    }

    public String getBtUeberschrift() {
        return this.msBtUeberschrift;
    }

    public String getBaureihe() {
        return this.msBaureihe;
    }

    public String getBauart() {
        return this.msBauart;
    }

    public String getModell() {
        return this.msModell;
    }

    public String getRegion() {
        return this.msRegion;
    }

    public String getKarosserie() {
        return this.msKarosserie;
    }

    private static void initColumnIcons() {
        hasInfo = new ETKDefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
            }
        };
        hasInfo.getOriginalRenderer().setText("");
        hasInfo.getOriginalRenderer().setIcon(ImageCache.getInstance().getIcon("info.gif"));
        hasInfo.setToolTipText(Resource.getInstance().getBildtafelinformation());
        hasInfo.setHorizontalAlignment(0);
        hasNoInfo = new ETKDefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
            }
        };
        hasNoInfo.getOriginalRenderer().setText("");
        hasNoInfo.getOriginalRenderer().setIcon(ImageCache.getInstance().getIcon("info_insensitiv.jpg"));
        hasNoInfo.setToolTipText("");
        hasNoInfo.setHorizontalAlignment(0);
    }

    static TableCellRenderer getHasInfoRenderer() {
        if (hasInfo == null) {
            DatenZeile.initColumnIcons();
        }
        return hasInfo;
    }

    static TableCellRenderer getHasNoInfoRenderer() {
        if (hasNoInfo == null) {
            DatenZeile.initColumnIcons();
        }
        return hasNoInfo;
    }
}

