/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.teileverwendung.tvnachbenennung;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.InvalidInitializationException;
import webetk.NoDataFoundException;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teilevwdgben.Teilevwdgben;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfTeilesuche;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.teileverwendung.tvnachbenennung.DatenZeile;
import webetk.javaclient.dialog.teileverwendung.tvnachbenennung.TVNachBenennungModel;
import webetk.javaclient.dialog.teileverwendung.tvnachbenennung.TVNachBenennungView;
import webetk.javaclient.dialog.teileverwendung.tvnachteilen.TVNachTeilenController;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class TVNachBenennungController
extends AbstractDlgMitTLController {
    private static Logger log = Logger.getLogger(TVNachTeilenController.class);
    private TVNachBenennungView view = new TVNachBenennungView();
    private TVNachBenennungModel model = new TVNachBenennungModel();

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        super.init(this.model);
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("exitaction", this.model.getExitAction());
        exitData.setWert("sachnummer", this.model.getSachnummer());
        exitData.setWert("marke", this.model.getMarke());
        exitData.setWert("produktart", this.model.getProduktart());
        exitData.setWert("katalogumfang", this.model.getKatalogumfang());
        if (this.model.getExitAction().equals("anzeige_bt")) {
            exitData.setWert("currentbte", this.model.getCurrentBTE());
            exitData.setWert("sachnummersuch", this.model.getSachnummerGesucht());
        }
        return exitData;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    protected boolean checkSachnummer(String sSuchbegriff) {
        log.debug((Object)"Performing Check Sachnummer (Teileverwendung)");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfCheckSachnummer = new TrfHashMap(null);
        trfCheckSachnummer.setValue("benennung", sSuchbegriff);
        trfCheckSachnummer.setValue("marke", this.model.getMarke());
        trfCheckSachnummer.setValue("produktart", this.model.getProduktart());
        trfCheckSachnummer.setValue("katalogumfang", this.model.getKatalogumfang());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfCheckSachnummer, Command.CHECK_TEILEVERWENDUNGBEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfCheckSachnummer.getError() != null) {
            if (trfCheckSachnummer.getError() instanceof InvalidInitializationException) {
                log.warn((Object)"Teil nicht im Teilestamm enthalten (ggf. wegen 'falscher' Marke)!", (Throwable)trfCheckSachnummer.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
                return false;
            }
            if (trfCheckSachnummer.getError() instanceof NoDataFoundException) {
                log.warn((Object)"Teil nicht im Teilestamm enthalten", (Throwable)trfCheckSachnummer.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getTeilNichtImTeilestamm(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
                return false;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfCheckSachnummer.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfCheckSachnummer.getError().getMessage(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
            return false;
        }
        String sInfo = (String)trfCheckSachnummer.getValue("info_string");
        this.model.setSachnummerGesuchtInfo(sInfo);
        this.model.setSachnummerGesucht(sSuchbegriff);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    protected void performSearch(String sSuchbegriff, String sBaureihe) {
        log.debug((Object)"Performing Search Teileverwendung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTeileverwendung = new TrfHashMap(null);
        trfTeileverwendung.setValue("marke", this.model.getMarke());
        trfTeileverwendung.setValue("produktart", this.model.getProduktart());
        trfTeileverwendung.setValue("katalogumfang", this.model.getKatalogumfang());
        trfTeileverwendung.setValue("suchbegriff", sSuchbegriff);
        trfTeileverwendung.setValue("modus", "suchesuchbegriff");
        trfTeileverwendung.setValue("baureihe", sBaureihe);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTeileverwendung, Command.LOAD_TEILEVERWENDUNGBEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTeileverwendung.getError() != null) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)trfTeileverwendung.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        this.model.storeAnzeigedaten(trfTeileverwendung);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean performSearchBenennung(String sBenennung, JComponent cTextfield) {
        log.debug((Object)"Performing Search Sachnummer TVBenennung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        cTextfield.setCursor(Cursor.getPredefinedCursor(3));
        TrfTeilesuche trfSuche = new TrfTeilesuche(null);
        trfSuche.setValue("isfzg", "false");
        trfSuche.setValue("marke", this.model.getMarke());
        trfSuche.setValue("produktart", this.model.getProduktart());
        trfSuche.setValue("katalogumfang", this.model.getKatalogumfang());
        trfSuche.setValue("modus", "suchebenennung");
        trfSuche.setValue("benennung", sBenennung);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSuche, Command.LOAD_TEILEVERWENDUNGBEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgFzgUmfangController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            cTextfield.setCursor(Cursor.getPredefinedCursor(2));
            return false;
        }
        if (trfSuche.getError() != null) {
            return false;
        }
        this.model.storeTeilenummernBen((Collection)trfSuche.getValue("teilenummern"));
        return true;
    }

    protected CurrentBTE showBildtafel(DatenZeile zeile) {
        log.debug((Object)"Performing Anzeige Teileverwendung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfBildtafel = new TrfHashMap(null);
        trfBildtafel.setValue("btnummer", zeile.getBtNummer());
        trfBildtafel.setValue("marke", this.model.getMarke());
        trfBildtafel.setValue("produktart", this.model.getProduktart());
        trfBildtafel.setValue("katalogumfang", this.model.getKatalogumfang());
        trfBildtafel.setValue("baureihe", zeile.getBaureihe());
        trfBildtafel.setValue("region", zeile.getRegion());
        trfBildtafel.setValue("modell", zeile.getModell());
        if (this.model.isPKW()) {
            trfBildtafel.setValue("karosserie", zeile.getKarosserie());
        } else {
            trfBildtafel.setValue("bauart", zeile.getBauart());
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfBildtafel, Command.BT_SHOW_TV_TEIL);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfBildtafel.getError() != null) {
            if (trfBildtafel.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Teileverwendung gefunden!", (Throwable)trfBildtafel.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
                return null;
            }
            if (trfBildtafel.getError() instanceof InvalidInitializationException) {
                log.error((Object)"Teil nicht im Teilestamm enthalten (ggf. wegen 'falscher' Marke)!", (Throwable)trfBildtafel.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
                return null;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfBildtafel.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfBildtafel.getError().getMessage(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
            return null;
        }
        JavaFzgIdInfo oFzgIdInfo = (JavaFzgIdInfo)trfBildtafel.getValue("fzgidinfo_java");
        GlobalObjects.getInstance().setFzgIdInfo(oFzgIdInfo);
        JavaFzgSucheInfo oFzgSucheInfo = (JavaFzgSucheInfo)trfBildtafel.getValue("fzgsucheinfo_java");
        GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfo);
        CurrentBTE oCurrentBTE = (CurrentBTE)trfBildtafel.getValue("currentbte");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        ComboTeilelisteItem item = GlobalObjects.getInstance().getSessionInfo().getAktuelleTeileliste();
        if (item != null && !this.model.getMarke().equals(item.getMarke())) {
            GlobalObjects.getInstance().getSessionInfo().setAktuelleTeileliste(null);
        }
        return oCurrentBTE;
    }

    public boolean performSearchSachnummern(Collection<String> cSachnummern, String sBaureihe) {
        log.debug((Object)"Performing Search Teileverwendung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTeileverwendung = new TrfHashMap(null);
        trfTeileverwendung.setValue("marke", this.model.getMarke());
        trfTeileverwendung.setValue("produktart", this.model.getProduktart());
        trfTeileverwendung.setValue("katalogumfang", this.model.getKatalogumfang());
        trfTeileverwendung.setValue("sachnummern", cSachnummern);
        trfTeileverwendung.setValue("modus", "suchesachnummer");
        trfTeileverwendung.setValue("baureihe", sBaureihe);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTeileverwendung, Command.LOAD_TEILEVERWENDUNGBEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfTeileverwendung.getError() != null) {
            if (trfTeileverwendung.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Teileverwendung gefunden!", (Throwable)trfTeileverwendung.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
                return false;
            }
            if (trfTeileverwendung.getError() instanceof InvalidInitializationException) {
                log.error((Object)"Teil nicht im Teilestamm enthalten (ggf. wegen 'falscher' Marke)!", (Throwable)trfTeileverwendung.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
                return false;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTeileverwendung.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfTeileverwendung.getError().getMessage(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
            return false;
        }
        Teilevwdgben oTeileverwendungBen = (Teilevwdgben)trfTeileverwendung.getValue("Teilevwdgben");
        int i = 1;
        Collection cZeilen = oTeileverwendungBen.getZeilenHashtableCollection();
        for (Hashtable oHashtable : cZeilen) {
            String sHelp;
            String sIsBaureihe = (String)oHashtable.get("istBaureihe");
            if (sIsBaureihe != null && sIsBaureihe.equals("J")) {
                trfTeileverwendung.setValue(i + "art", "Baureihe");
                trfTeileverwendung.setValue(i + "baureihe", oHashtable.get("ID"));
                trfTeileverwendung.setValue(i + "baureihe_ext", oHashtable.get("Benennung"));
                sHelp = (String)oHashtable.get("istExpandiert");
                String sIsExpandiert = sHelp == null || sHelp.equals("N") ? "false" : "true";
                trfTeileverwendung.setValue(i + "isexpandiert", sIsExpandiert);
            } else {
                trfTeileverwendung.setValue(i + "art", "Modellspalte");
                trfTeileverwendung.setValue(i + "modell", oHashtable.get("Modell"));
                trfTeileverwendung.setValue(i + "baureihe_ext", oHashtable.get("Baureihe"));
                trfTeileverwendung.setValue(i + "baureihe", oHashtable.get("BaureiheID"));
                if (this.model.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                    trfTeileverwendung.setValue(i + "karosserie_ext", oHashtable.get("Karosserie"));
                    trfTeileverwendung.setValue(i + "karosserie", oHashtable.get("BauartKarosserieID"));
                } else {
                    trfTeileverwendung.setValue(i + "bauart", oHashtable.get("BauartKarosserieID"));
                }
                trfTeileverwendung.setValue(i + "region", oHashtable.get("Region"));
                trfTeileverwendung.setValue(i + "btnummer", oHashtable.get("BTNummer"));
                trfTeileverwendung.setValue(i + "benennung", oHashtable.get("BTUeberschrift"));
                trfTeileverwendung.setValue(i + "menge", oHashtable.get("Menge"));
                sHelp = (String)oHashtable.get("hatBtInfo");
                String sHasBtInfo = sHelp == null || sHelp.equals("N") ? "false" : "true";
                trfTeileverwendung.setValue(i + "hasbtinfo", sHasBtInfo);
                trfTeileverwendung.setValue(i + "markt", oHashtable.get("Markt"));
            }
            ++i;
        }
        this.model.storeAnzeigedatenTNR(trfTeileverwendung);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public static class ExitActions {
        public static final String ANZEIGE_BT = "anzeige_bt";
    }
}

