/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.teileverwendung.tvnachbenennung;

import de.esg.commonclient.GlobalObjects;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import webetk.app.Markt;
import webetk.app.SearchBTETeile;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.teilevwdgteil.Baureihe;
import webetk.app.teilevwdgteil.Modellspalte;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.MarktDaten;
import webetk.javaclient.dialog.AbstractDlgMitTLModel;
import webetk.javaclient.dialog.teileverwendung.tvnachbenennung.AufzuklappZeile;
import webetk.javaclient.dialog.teileverwendung.tvnachbenennung.DatenZeile;
import webetk.javaclient.generictable.GenericRow;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class TVNachBenennungModel
extends AbstractDlgMitTLModel {
    private boolean mbMarkeChanged = false;
    private String msDialogTitel = null;
    private String msProduktart = null;
    private String msKatalogumfang = null;
    private String msSachnummer = null;
    private String msSachnummerGesucht = null;
    private String msSachnummerGesuchtInfo = null;
    private List<Baureihe> mBaureihen = null;
    private TrfHashMap moAnzeigedatenTNR = null;
    private Collection<SearchBTETeile.PartOrBTE> moTeilenummernBen = null;
    private CurrentBTE moCurrentBTE = null;
    private String msExitAction = null;
    private Collection<String> moSelSachnummern = null;
    private String msSelTNRBen = null;
    private MarktDaten mMarktDaten = null;

    @Override
    public void init(WorkflowStateData oWFStateData) {
        super.init(oWFStateData);
        this.setMarke((String)oWFStateData.getWert("marke"));
        this.msProduktart = (String)oWFStateData.getWert("produktart");
        this.msKatalogumfang = (String)oWFStateData.getWert("katalogumfang");
        this.msSachnummer = (String)oWFStateData.getWert("sachnummer");
        this.msDialogTitel = Resource.getInstance().getTeileverwendungNachBenennung();
        this.mMarktDaten = new MarktDaten();
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        this.mMarktDaten.setSelPrimaerMarkt(oLoginInfo.getSettings().getEtkPrimaerMarkt());
        this.mMarktDaten.setSelSonstigeMaerkte(oLoginInfo.getSettings().getEtkSonstigeMaerkte());
        this.mMarktDaten.loadMaerkteandFillListen();
    }

    public void storeAnzeigedaten(TrfHashMap oTrfAnzeigedaten) {
        this.mBaureihen = (List)oTrfAnzeigedaten.getValue("baureihenListe");
    }

    public int getAnzBildtafeln() {
        int anzahl = 0;
        if (this.mBaureihen != null) {
            anzahl += this.mBaureihen.size();
            for (Baureihe baureihe : this.mBaureihen) {
                if (baureihe.getModellspalten() == null) continue;
                anzahl += baureihe.getModellspalten().size();
            }
        }
        return anzahl;
    }

    public String getBaureiheZuIndex(int index) {
        if (this.mBaureihen == null) {
            return null;
        }
        return this.mBaureihen.get(index).getID();
    }

    public List<Baureihe> getBaureihen() {
        return this.mBaureihen;
    }

    public Vector<GenericRow> getAnzeigedatenSortiertNachMarkt(boolean bFzg) {
        Vector<GenericRow> aResult = new Vector<GenericRow>();
        if (this.mBaureihen != null) {
            boolean bModellspaltenAbgearbeitet = false;
            for (int i = 0; i < this.mBaureihen.size(); ++i) {
                List<Modellspalte> modellspalten;
                aResult.add(this.getBaureihenZeile(i));
                if (bModellspaltenAbgearbeitet || (modellspalten = this.mBaureihen.get(i).getModellspalten()) == null || modellspalten.isEmpty()) continue;
                aResult.addAll(this.getDatenZeilenSortiertNachMarkt(modellspalten, bFzg));
                bModellspaltenAbgearbeitet = true;
            }
        }
        return aResult;
    }

    private Vector<GenericRow> getDatenZeilenSortiertNachMarkt(List<Modellspalte> pModellspalten, boolean bFzg) {
        String isoPrimaerMarkt = null;
        Markt selPrioMarkt = this.getMarktDaten().getSelPrimaerMarkt();
        if (selPrioMarkt != null) {
            isoPrimaerMarkt = selPrioMarkt.getKuerzel();
        }
        Vector<GenericRow> datenZeilenPrimaerMarkt = new Vector<GenericRow>();
        Vector<DatenZeile> datenZeilenNoMarkt = new Vector<DatenZeile>();
        Vector<DatenZeile> datenZeilenWeitererMarkt = new Vector<DatenZeile>();
        for (Modellspalte modellspalte : pModellspalten) {
            String sMarktIso = modellspalte.getMarkt();
            DatenZeile oZeile = this.getModellspaltenZeile(modellspalte, bFzg);
            if (sMarktIso == null || sMarktIso.length() == 0) {
                datenZeilenNoMarkt.add(oZeile);
                continue;
            }
            if ((isoPrimaerMarkt == null || isoPrimaerMarkt.length() < 1) && this.getMarktDaten().getIndicesSelSonstigeMaerkte().length == 0) {
                datenZeilenWeitererMarkt.add(oZeile);
                continue;
            }
            if (sMarktIso.equals(isoPrimaerMarkt)) {
                datenZeilenPrimaerMarkt.add(oZeile);
                continue;
            }
            if (!this.getMarktDaten().containSelSonstigeMaerkteMarktIso(sMarktIso)) continue;
            datenZeilenWeitererMarkt.add(oZeile);
        }
        datenZeilenPrimaerMarkt.addAll(datenZeilenNoMarkt);
        datenZeilenPrimaerMarkt.addAll(datenZeilenWeitererMarkt);
        return datenZeilenPrimaerMarkt;
    }

    private AufzuklappZeile getBaureihenZeile(int ind) {
        Baureihe baureihe = this.mBaureihen.get(ind);
        return new AufzuklappZeile(baureihe.getExpandiert(), baureihe.getBenennung());
    }

    private DatenZeile getModellspaltenZeile(Modellspalte pModellspalte, boolean pFzg) {
        String sBaureihe = pModellspalte.getBaureiheID();
        String sBaureiheExt = pModellspalte.getBaureihe();
        String sKarosserie = null;
        String sKarosserieExt = null;
        String sBauart = null;
        if (pFzg) {
            sKarosserie = pModellspalte.getBauartKarosserieID();
            sKarosserieExt = pModellspalte.getKarosserie();
        } else {
            sBauart = pModellspalte.getBauartKarosserieID();
        }
        String sModell = pModellspalte.getModell();
        String sRegion = pModellspalte.getRegion();
        String sBtNummer = pModellspalte.getBTNummer();
        String sBtUeberschrift = pModellspalte.getBTUeberschrift();
        boolean bHasBtInfo = pModellspalte.hasBtInfo();
        String sMarktIso = pModellspalte.getMarkt();
        if (sMarktIso == null) {
            sMarktIso = "";
        }
        if (pFzg) {
            return new DatenZeile(bHasBtInfo, sBtNummer, sBtUeberschrift, sBaureihe, sBaureiheExt, sModell, sKarosserie, sKarosserieExt, sRegion, sMarktIso, null);
        }
        return new DatenZeile(bHasBtInfo, sBtNummer, sBtUeberschrift, sBauart, sBaureihe, sBaureiheExt, sModell, sRegion, sMarktIso, null);
    }

    public TrfHashMap getAnzeigedatenTNR() {
        return this.moAnzeigedatenTNR;
    }

    public void resetAnzeigedatenTNR() {
        this.moAnzeigedatenTNR = null;
    }

    public void storeAnzeigedatenTNR(TrfHashMap oTrfAnzeigedaten) {
        this.moAnzeigedatenTNR = oTrfAnzeigedaten;
    }

    @Override
    public void setMarke(String sMarke) {
        super.setMarke(sMarke);
        this.mbMarkeChanged = true;
    }

    public boolean hasMarkeChanged() {
        return this.mbMarkeChanged;
    }

    public void resetMarkeChangedFlag() {
        this.mbMarkeChanged = false;
    }

    public String getProduktart() {
        return this.msProduktart;
    }

    public boolean isPKW() {
        return this.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
    }

    public void setProduktart(String sProduktart) {
        this.msProduktart = sProduktart;
    }

    public String getKatalogumfang() {
        return this.msKatalogumfang;
    }

    public void setKatalogumfang(String sKatalogumfang) {
        this.msKatalogumfang = sKatalogumfang;
    }

    public String getSachnummer() {
        return this.msSachnummer;
    }

    public void setSachnummerGesucht(String sSachnummerGesucht) {
        this.msSachnummerGesucht = sSachnummerGesucht;
    }

    public String getSachnummerGesucht() {
        return this.msSachnummerGesucht;
    }

    public void setSachnummerGesuchtInfo(String sSachnummerGesuchtInfo) {
        this.msSachnummerGesuchtInfo = sSachnummerGesuchtInfo;
    }

    public String getSachnummerGesuchtInfo() {
        return this.msSachnummerGesuchtInfo;
    }

    public void resetSucheInfo() {
        this.msSachnummerGesucht = null;
        this.msSachnummerGesuchtInfo = null;
    }

    public String getExitAction() {
        return this.msExitAction;
    }

    public void setExitAction(String sExitAction) {
        this.msExitAction = sExitAction;
    }

    public void setCurrentBTE(CurrentBTE oCurrentBTE) {
        this.moCurrentBTE = oCurrentBTE;
    }

    public CurrentBTE getCurrentBTE() {
        return this.moCurrentBTE;
    }

    public void storeTeilenummernBen(Collection<SearchBTETeile.PartOrBTE> trfTeilenummern) {
        this.moTeilenummernBen = trfTeilenummern;
    }

    public String getDialogTitel() {
        return this.msDialogTitel;
    }

    public Collection<String> getSelSachnummern() {
        return this.moSelSachnummern;
    }

    public void setSelSachnummern(Collection<String> oSelSachnummern) {
        this.moSelSachnummern = oSelSachnummern;
    }

    public String getSelTNRBen() {
        return this.msSelTNRBen;
    }

    public void setSelTNRBen(String oSelTNRBen) {
        this.msSelTNRBen = oSelTNRBen;
    }

    public int getAnzTeilenummernBen() {
        return this.moTeilenummernBen == null ? 0 : this.moTeilenummernBen.size();
    }

    public Collection<SearchBTETeile.PartOrBTE> getTeilenummernBen() {
        return this.moTeilenummernBen;
    }

    public MarktDaten getMarktDaten() {
        return this.mMarktDaten;
    }
}

