/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.teileverwendung.tvnachfahrzeug;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.teileverwendung.tvnachfahrzeug.TVNachFahrzeugModel;
import webetk.javaclient.dialog.teileverwendung.tvnachfahrzeug.TVNachFahrzeugView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class TVNachFahrzeugController
extends AbstractDlgMitTLController {
    private static Logger log = Logger.getLogger(TVNachFahrzeugController.class);
    private TVNachFahrzeugView view = new TVNachFahrzeugView();
    private TVNachFahrzeugModel model = new TVNachFahrzeugModel();

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        super.init(this.model);
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    protected void loadHauptgruppen() {
        log.debug((Object)"Performing Search Teileverwendung nach Fahrzeug (Hauptgruppen)");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfHgs = new TrfHashMap(null);
        trfHgs.setValue("hgvon", this.model.getHgVon());
        trfHgs.setValue("hgbis", this.model.getHgBis());
        trfHgs.setValue("modellspaltenids", this.model.getModellspaltenIDs());
        trfHgs.setValue("lenkung", this.model.getLenkung());
        trfHgs.setValue("tag", this.model.getDatumAbTag());
        trfHgs.setValue("monat", this.model.getDatumAbMonat());
        trfHgs.setValue("jahr", this.model.getDatumAbJahr());
        trfHgs.setValue("nurinselfzg", this.model.nurInSelFzgString());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHgs, Command.LOAD_TEILEVERWENDUNGFZG_HGS);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfHgs.getError() != null) {
            if (trfHgs.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Daten gefunden!", (Throwable)trfHgs.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfHgs.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfHgs.getError().getMessage(), Resource.getInstance().getSuchergTeileverwendungNachFahrzeug(), 0);
            return;
        }
        this.model.storeHauptgruppen((List)trfHgs.getValue("hgs"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void performSearch(String sHg) {
        log.debug((Object)"Performing Search Teileverwendung nach Fahrzeug");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTeileverwendung = new TrfHashMap(null);
        trfTeileverwendung.setValue("hg", sHg);
        trfTeileverwendung.setValue("modellspaltenids", this.model.getModellspaltenIDs());
        trfTeileverwendung.setValue("lenkung", this.model.getLenkung());
        trfTeileverwendung.setValue("tag", this.model.getDatumAbTag());
        trfTeileverwendung.setValue("monat", this.model.getDatumAbMonat());
        trfTeileverwendung.setValue("jahr", this.model.getDatumAbJahr());
        trfTeileverwendung.setValue("nurinselfzg", this.model.nurInSelFzgString());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTeileverwendung, Command.LOAD_TEILEVERWENDUNGFZG_ZU_HG);
        }
        catch (CommunicationException ex) {
            log.error((Object)("TeileersetzungController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTeileverwendung.getError() != null) {
            if (trfTeileverwendung.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Daten gefunden!", (Throwable)trfTeileverwendung.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getSuchergebnisseTeileersetzung(), 1);
                return;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTeileverwendung.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfTeileverwendung.getError().getMessage(), Resource.getInstance().getSuchergebnisseTeileersetzung(), 0);
            return;
        }
        this.model.storeAnzeigedaten((List)trfTeileverwendung.getValue("teileverwendung_teile"));
        this.model.storeHgAkt((String)trfTeileverwendung.getValue("hg"));
        Collection cButtons = (Collection)trfTeileverwendung.getValue("buttons");
        this.model.storeButtonInfo(cButtons);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void getTeileAnIndex(int nIndex) {
        log.debug((Object)"Performing get Teile Teileverwendung nach Fahrzeug (At Index) ");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTeileverwendung = new TrfHashMap(null);
        String sIndex = Integer.toString(nIndex);
        trfTeileverwendung.setValue("index", sIndex);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTeileverwendung, Command.LOAD_TEILEVERWENDUNGFZG_ZU_HG_AT_INDEX);
        }
        catch (CommunicationException ex) {
            log.error((Object)("TeileersetzungController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTeileverwendung.getError() != null) {
            if (trfTeileverwendung.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Daten gefunden!", (Throwable)trfTeileverwendung.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getSuchergebnisseTeileersetzung(), 1);
                return;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTeileverwendung.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfTeileverwendung.getError().getMessage(), Resource.getInstance().getSuchergebnisseTeileersetzung(), 0);
            return;
        }
        this.model.storeAnzeigedaten((List)trfTeileverwendung.getValue("teileverwendung_teile"));
        Collection cButtons = (Collection)trfTeileverwendung.getValue("buttons");
        this.model.storeButtonInfo(cButtons);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

