/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.teileverwendung.tvnachfahrzeug;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import webetk.app.BlaetternButton;
import webetk.app.GenericTeil;
import webetk.app.teilevwdgfzg.Teil;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.fzgumfang.DlgFzgUmfangDetailliert;
import webetk.javaclient.dialog.teileverwendung.tvnachfahrzeug.TVNachFahrzeugController;
import webetk.javaclient.dialog.teileverwendung.tvnachfahrzeug.TVNachFahrzeugModel;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemEinzelteile;
import webetk.javaclient.menuitem.MenuItemInterpretation;
import webetk.javaclient.menuitem.MenuItemSteckerAnschlagteile;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.javaclient.menuitem.MenuItemVisualisierungTeil;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class TVNachFahrzeugView
extends AbstractDlgMitTLView {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(TVNachFahrzeugView.class);
    private TVNachFahrzeugController controller = null;
    private TVNachFahrzeugModel model = null;
    private JScrollPane scrollpanTable = null;
    private GenericTableModel tableModel = null;
    private GenericTable table = null;
    private JPanel panHeader = null;
    private JPanel panErgebnis = null;
    private JPanel panErgebnisBlaetternButton = null;
    private JButtonEx buttonFzgUmfangAnzeigen = null;
    private JButtonEx buttonHgNext = null;
    private JButtonEx buttonHgPrev = null;
    private JButtonEx buttonInHgFirst = null;
    private JButtonEx buttonInHgNext = null;
    private JButtonEx buttonInHg1 = null;
    private JButtonEx buttonInHg2 = null;
    private JButtonEx buttonInHg3 = null;
    private JButtonEx buttonInHg4 = null;
    private JButtonEx buttonInHg5 = null;
    private JButtonEx buttonInHgPrev = null;
    private JButtonEx buttonInHgLast = null;
    private JLabel labHinweis = null;
    private JPopupMenu menuPopup = null;
    private JMenuItem menuitemTeileinformation = null;
    private JMenuItem menuitemTeileverwendungTeil = null;
    private JMenuItem menuitemVisualisierungTeil = null;
    private JMenuItem menuitemInterpretation = null;
    private JMenuItem menuitemEinzelteile = null;
    private JMenuItem menuitemCopySachnummer = null;
    private JMenuItem menuitemSteckerAnschlagteile = null;
    private boolean bUpdateTeilelisten = true;
    private int nIndexHg = -1;
    private ButtonInHgIndexData mButtonInHgIndexData = new ButtonInHgIndexData();

    @Override
    protected void initComponents() {
        super.initComponents();
        String sFzgUmfangStringFuerHeader = this.model.getFzgUmfang().getFzgUmfangStringFuerHeader(70);
        String sUeberschriftZeile2 = "";
        if (this.model.getDatumAb() != null) {
            sUeberschriftZeile2 = Resource.getInstance().getSeit() + " " + this.model.getDatumAb() + " ";
        }
        sUeberschriftZeile2 = sUeberschriftZeile2 + (this.model.nurInSelFzg() ? Resource.getInstance().getAusschlieszlichInKlein() + " " + sFzgUmfangStringFuerHeader : Resource.getInstance().getAuchInKlein() + " " + sFzgUmfangStringFuerHeader);
        this.panHeader = new HeaderPanel(Resource.getInstance().getSuchergTeileverwendungNachFahrzeug(), sUeberschriftZeile2, ImageCache.getInstance().getHeaderIcon("tese"));
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachFahrzeugView.this.uebernehmenInTeileliste();
            }
        });
        this.buttonFzgUmfangAnzeigen = new JButtonEx("", ImageCache.getInstance().getIcon("fzgumfang_detail.jpg"));
        this.buttonFzgUmfangAnzeigen.setToolTipText(Resource.getInstance().getDefinierterFahrzeugumfang());
        this.buttonFzgUmfangAnzeigen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachFahrzeugView.this.showFzgUmfangDetailliert();
            }
        });
        this.buttonHgNext = new JButtonEx(Resource.getInstance().getHg(), ImageCache.getInstance().getIcon("scrollend.gif"));
        this.buttonHgNext.setHorizontalTextPosition(2);
        this.buttonHgNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachFahrzeugView.this.searchTeileverwendungFzgNext();
                TVNachFahrzeugView.this.updateBlaetternInHgButton();
                TVNachFahrzeugView.this.update();
            }
        });
        this.buttonHgPrev = new JButtonEx(Resource.getInstance().getHg(), ImageCache.getInstance().getIcon("scrollhome.gif"));
        this.buttonHgPrev.setHorizontalTextPosition(4);
        this.buttonHgPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachFahrzeugView.this.searchTeileverwendungFzgPrev();
                TVNachFahrzeugView.this.updateBlaetternInHgButton();
                TVNachFahrzeugView.this.update();
            }
        });
        this.buttonInHgFirst = new JButtonEx("<<");
        this.buttonInHgFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachFahrzeugView.this.getTeileAnIndex(((TVNachFahrzeugView)TVNachFahrzeugView.this).mButtonInHgIndexData.mnButtonInHgFirst);
                TVNachFahrzeugView.this.update();
            }
        });
        this.buttonInHgPrev = new JButtonEx("<");
        this.buttonInHgPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachFahrzeugView.this.getTeileAnIndex(((TVNachFahrzeugView)TVNachFahrzeugView.this).mButtonInHgIndexData.mnButtonInHgPrev);
                TVNachFahrzeugView.this.update();
            }
        });
        this.buttonInHg1 = new JButtonEx("Button1");
        this.buttonInHg1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachFahrzeugView.this.getTeileAnIndex(((TVNachFahrzeugView)TVNachFahrzeugView.this).mButtonInHgIndexData.mnButtonInHg1);
                TVNachFahrzeugView.this.update();
            }
        });
        this.buttonInHg2 = new JButtonEx("Button2");
        this.buttonInHg2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachFahrzeugView.this.getTeileAnIndex(((TVNachFahrzeugView)TVNachFahrzeugView.this).mButtonInHgIndexData.mnButtonInHg2);
                TVNachFahrzeugView.this.update();
            }
        });
        this.buttonInHg3 = new JButtonEx("Button3");
        this.buttonInHg3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachFahrzeugView.this.getTeileAnIndex(((TVNachFahrzeugView)TVNachFahrzeugView.this).mButtonInHgIndexData.mnButtonInHg3);
                TVNachFahrzeugView.this.update();
            }
        });
        this.buttonInHg4 = new JButtonEx("Button4");
        this.buttonInHg4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachFahrzeugView.this.getTeileAnIndex(((TVNachFahrzeugView)TVNachFahrzeugView.this).mButtonInHgIndexData.mnButtonInHg4);
                TVNachFahrzeugView.this.update();
            }
        });
        this.buttonInHg5 = new JButtonEx("Button5");
        this.buttonInHg5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachFahrzeugView.this.getTeileAnIndex(((TVNachFahrzeugView)TVNachFahrzeugView.this).mButtonInHgIndexData.mnButtonInHg5);
                TVNachFahrzeugView.this.update();
            }
        });
        this.buttonInHgNext = new JButtonEx(">");
        this.buttonInHgNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachFahrzeugView.this.getTeileAnIndex(((TVNachFahrzeugView)TVNachFahrzeugView.this).mButtonInHgIndexData.mnButtonInHgNext);
                TVNachFahrzeugView.this.update();
            }
        });
        this.buttonInHgLast = new JButtonEx(">>");
        this.buttonInHgLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TVNachFahrzeugView.this.getTeileAnIndex(((TVNachFahrzeugView)TVNachFahrzeugView.this).mButtonInHgIndexData.mnButtonInHgLast);
                TVNachFahrzeugView.this.update();
            }
        });
        this.labHinweis = new JLabel();
        this.createLayout();
    }

    @Override
    public void initMenus() {
        this.menuPopup = new JPopupMenu();
        this.menuitemTeileinformation = new MenuItemTeileinformation(this);
        this.menuPopup.add(this.menuitemTeileinformation);
        this.menuitemTeileverwendungTeil = new MenuItemTeileverwendungTeil("teileverwendung_FZG", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemTeileverwendungTeil);
        this.menuitemVisualisierungTeil = new MenuItemVisualisierungTeil(this);
        this.menuPopup.add(this.menuitemVisualisierungTeil);
        this.menuitemInterpretation = new MenuItemInterpretation("teileverwendung_FZG", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemInterpretation);
        this.menuitemEinzelteile = new MenuItemEinzelteile("teileverwendung_FZG", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemEinzelteile);
        this.menuPopup.addSeparator();
        this.menuitemCopySachnummer = new MenuItemCopySachnummer(this);
        this.menuPopup.add(this.menuitemCopySachnummer);
        this.menuitemSteckerAnschlagteile = new MenuItemSteckerAnschlagteile(this);
        this.menuPopup.add(this.menuitemSteckerAnschlagteile);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        this.panErgebnis = this.createErgebnisPanel();
        JScrollPane content = new JScrollPane(this.panErgebnis);
        this.add((Component)content, "Center");
    }

    protected JPanel createErgebnisPanel() {
        TitledPanel p = new TitledPanel(Resource.getInstance().getErgebnisTeilenummern());
        int[] w = new int[]{10, 0, 20, 0, 20, 0, 20, 0, 20, 0, 20, -14, 5, -12, 10};
        int[] h = new int[]{10, 0, 5, 0, 5, 0, 5, 0, 0, 10};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(9, 1);
        hl.setRowWeight(9, 1);
        HIGConstraints c = new HIGConstraints();
        p.setLayout(hl);
        if (this.model.getAnzeigedaten() == null) {
            String sHinweis = Resource.getInstance().getSuchanfrageKeineDaten();
            this.labHinweis.setText(sHinweis);
            p.add((Component)this.labHinweis, c.rcwh(2, 2, 13, 1, "tl"));
        } else {
            p.add((Component)this.labTeileliste, c.rc(2, 2, "l"));
            p.add((Component)this.comboTeileliste, c.rc(2, 4, "l"));
            p.add((Component)this.buttonUebernehmen, c.rc(2, 6, "l"));
            p.add((Component)this.buttonUeberpruefen, c.rc(2, 8, "l"));
            p.add((Component)this.buttonFzgUmfangAnzeigen, c.rc(2, 10, "r"));
            p.add((Component)this.buttonHgPrev, c.rc(2, 12));
            p.add((Component)this.buttonHgNext, c.rc(2, 14));
            this.panErgebnisBlaetternButton = this.createInHgBlaetterPanel();
            p.add((Component)this.panErgebnisBlaetternButton, c.rcwh(4, 2, 13, 1, "tr"));
            String sHinweis = Resource.getInstance().getHgNotOnlyInFzg();
            sHinweis = StringUtils.substituteStringStraight(sHinweis, "{0}", this.model.getHgAkt());
            this.labHinweis = new JLabel(sHinweis);
            p.add((Component)this.labHinweis, c.rcwh(9, 2, 13, 1, "tl"));
            this.scrollpanTable = this.createTabelle();
            this.scrollpanTable.setPreferredSize(new Dimension(100, 50));
            p.add((Component)this.scrollpanTable, c.rcwh(9, 2, 13, 1));
        }
        return p;
    }

    protected JPanel createInHgBlaetterPanel() {
        JPanel p = new JPanel();
        int[] w = new int[]{0, 5, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 5, 0};
        int[] h = new int[]{10, 0, 10};
        HIGLayout hl = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        p.setLayout(hl);
        p.add((Component)this.buttonInHgFirst, c.rc(2, 1));
        p.add((Component)this.buttonInHgPrev, c.rc(2, 3));
        p.add((Component)this.buttonInHg1, c.rc(2, 5));
        p.add((Component)this.buttonInHg2, c.rc(2, 7));
        p.add((Component)this.buttonInHg3, c.rc(2, 9));
        p.add((Component)this.buttonInHg4, c.rc(2, 11));
        p.add((Component)this.buttonInHg5, c.rc(2, 13));
        p.add((Component)this.buttonInHgNext, c.rc(2, 15));
        p.add((Component)this.buttonInHgLast, c.rc(2, 17));
        return p;
    }

    protected JScrollPane createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
        tableConfig.addIconColumn("auto.gif", Resource.getInstance().getTeileverwendung());
        tableConfig.addIconColumn("visualisierung.gif", Resource.getInstance().getVisualisierungDesTeils());
        tableConfig.addColumn(Resource.getInstance().getTeilenummerAlt(), 0, false, "11 00 7 516 422");
        tableConfig.addColumn(Resource.getInstance().getNueAt(), 0, false, "01");
        tableConfig.setHeaderTooltip(4, Resource.getInstance().getAustauschkennzeichen());
        tableConfig.addColumn(Resource.getInstance().getTeilenummerNeu(), 0, false, "11 11 1 743 118");
        tableConfig.addColumn(Resource.getInstance().getTeilebenennungNeu(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn(Resource.getInstance().getZusatzNeu(), 2, true, "XXXXXXXXXXXXXXXYYYY");
        tableConfig.addColumn(Resource.getInstance().getZi(), 0, false, "I");
        tableConfig.setHeaderTooltip(8, Resource.getInstance().getZusatzinformation());
        tableConfig.setUsePrototypeIcons(true);
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getTable().setSelectionMode(2);
        GenericTableMouseEventListener listenerTeileinfo = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                ((MenuItemTeileinformation)TVNachFahrzeugView.this.menuitemTeileinformation).showTeileinfo();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerTeileinfo, 0);
        GenericTableMouseEventListener listenerTeileverwendung = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                ((MenuItemTeileverwendungTeil)TVNachFahrzeugView.this.menuitemTeileverwendungTeil).showTeileverwendungTeil();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerTeileverwendung, 1);
        GenericTableMouseEventListener listenerVisualisierung = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                ((MenuItemVisualisierungTeil)TVNachFahrzeugView.this.menuitemVisualisierungTeil).showVisualisierungTeil();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerVisualisierung, 2);
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (TVNachFahrzeugView.this.table.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                TVNachFahrzeugView.this.menuitemTeileverwendungTeil.setEnabled(true);
                TVNachFahrzeugView.this.menuitemEinzelteile.setEnabled(((MenuItemEinzelteile)TVNachFahrzeugView.this.menuitemEinzelteile).hatEinzelteile());
                TVNachFahrzeugView.this.menuitemInterpretation.setEnabled(((MenuItemInterpretation)TVNachFahrzeugView.this.menuitemInterpretation).hatInterpretation());
                TVNachFahrzeugView.this.menuPopup.show(TVNachFahrzeugView.this.table.getTable(), evt.getX(), evt.getY());
            }
        });
        JScrollPane scrollPane = this.table.getScrollPane();
        return scrollPane;
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        log.debug((Object)"init");
        super.init(oDlgModel, oDlgController);
        this.model = (TVNachFahrzeugModel)oDlgModel;
        this.controller = (TVNachFahrzeugController)oDlgController;
        this.loadTeilelistenIDs();
        this.loadHauptgruppen();
        this.initComponents();
        this.initMenus();
        this.updateBlaetternInHgButton();
        this.update();
    }

    @Override
    public void update() {
        List<Teil> oAnzeigedaten;
        if (this.tableModel != null) {
            this.tableModel.removeAllRows();
        }
        if ((oAnzeigedaten = this.model.getAnzeigedaten()) == null) {
            return;
        }
        List<String> oHauptgruppen = this.model.getHauptgruppen();
        if (oHauptgruppen == null || oHauptgruppen.isEmpty()) {
            return;
        }
        this.buttonHgNext.setEnabled(this.nIndexHg + 1 < oHauptgruppen.size());
        this.buttonHgPrev.setEnabled(this.nIndexHg - 1 >= 0);
        if (this.model.isEmptyAnzeigedaten()) {
            this.labHinweis.setVisible(true);
            this.scrollpanTable.setVisible(false);
            String sHinweis = Resource.getInstance().getHgNotOnlyInFzg();
            sHinweis = StringUtils.substituteStringStraight(sHinweis, "{0}", this.model.getHgAkt());
            this.labHinweis.setText(sHinweis);
            this.labHinweis.repaint();
        } else {
            this.labHinweis.setVisible(false);
            this.scrollpanTable.setVisible(true);
            for (Teil teil : oAnzeigedaten) {
                this.tableModel.addRow(new AbstractRow(new Object[]{null, null, null, teil.getTeilenummerAlt(), teil.getKzAT(), teil.getTeilenummer(), teil.getBenennung(), teil.getZusatz(), teil.getZI()}));
            }
        }
        if (this.bUpdateTeilelisten) {
            this.updateTeilelisten();
            this.bUpdateTeilelisten = false;
        }
        this.panErgebnis.repaint();
    }

    private void uebernehmenInTeileliste() {
        Vector<GenericTeil> cTeile = new Vector<GenericTeil>();
        GenericTable jTable = this.table.getTable();
        int nCountSelectedRows = jTable.getSelectedRowCount();
        if (nCountSelectedRows == 0) {
            return;
        }
        int[] selectedRows = jTable.getSelectedRows();
        for (int i = 0; i < nCountSelectedRows; ++i) {
            int nRow = selectedRows[i];
            GenericTeil t = new GenericTeil();
            String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 5);
            String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
            String HGUG = sTeilenummer.trim().replaceAll(" +", "").substring(0, 4);
            t.setHG(HGUG.substring(0, 2));
            t.setUG(HGUG.substring(2, 4));
            t.setSachnummer(sSachnummer);
            t.setBenennung((String)this.tableModel.getValueAt(nRow, 6));
            cTeile.add(t);
        }
        this.uebernehmenInTeileListe(cTeile, false);
    }

    private void loadHauptgruppen() {
        this.model.resetAnzeigedaten();
        this.model.resetHauptgruppen();
        this.controller.loadHauptgruppen();
        this.nIndexHg = 0;
        List<String> oHauptgruppen = this.model.getHauptgruppen();
        if (oHauptgruppen == null || oHauptgruppen.isEmpty()) {
            return;
        }
        this.searchTeileverwendungFzg(oHauptgruppen.get(this.nIndexHg));
    }

    void loadTeilelistenIDs() {
        this.controller.loadTeilelistenIDs();
        this.bUpdateTeilelisten = true;
    }

    void searchTeileverwendungFzg(String sHg) {
        this.model.resetAnzeigedaten();
        this.controller.performSearch(sHg);
    }

    private void searchTeileverwendungFzgNext() {
        ++this.nIndexHg;
        this.searchTeileverwendungFzg();
    }

    private void searchTeileverwendungFzgPrev() {
        --this.nIndexHg;
        this.searchTeileverwendungFzg();
    }

    private void searchTeileverwendungFzg() {
        List<String> oHauptgruppen = this.model.getHauptgruppen();
        if (oHauptgruppen == null || oHauptgruppen.isEmpty()) {
            return;
        }
        this.searchTeileverwendungFzg(oHauptgruppen.get(this.nIndexHg));
    }

    private void showFzgUmfangDetailliert() {
        new DlgFzgUmfangDetailliert(this.model.getFzgUmfang());
    }

    private void getTeileAnIndex(int nIndex) {
        this.model.resetAnzeigedaten();
        this.controller.getTeileAnIndex(nIndex);
        this.updateBlaetternInHgButton();
    }

    private void updateBlaetternInHgButton() {
        Collection<BlaetternButton> cButtonInfo = this.model.getButtonInfo();
        this.mButtonInHgIndexData.reset();
        this.buttonInHg1.setVisible(false);
        this.buttonInHg2.setVisible(false);
        this.buttonInHg3.setVisible(false);
        this.buttonInHg4.setVisible(false);
        this.buttonInHg5.setVisible(false);
        if (this.panErgebnisBlaetternButton == null) {
            return;
        }
        HIGLayout hl = (HIGLayout)this.panErgebnisBlaetternButton.getLayout();
        if (cButtonInfo == null || cButtonInfo.size() == 0) {
            this.panErgebnisBlaetternButton.setVisible(false);
        } else {
            this.panErgebnisBlaetternButton.setVisible(true);
        }
        hl.setColumnWidth(6, 0);
        hl.setColumnWidth(8, 0);
        hl.setColumnWidth(10, 0);
        hl.setColumnWidth(12, 0);
        if (cButtonInfo != null) {
            for (BlaetternButton oButton : cButtonInfo) {
                if (oButton.getAction() == 1) {
                    this.mButtonInHgIndexData.mnButtonInHgFirst = oButton.getIndex();
                    this.buttonInHgFirst.setEnabled(oButton.isSensitiv());
                    continue;
                }
                if (oButton.getAction() == 2) {
                    this.mButtonInHgIndexData.mnButtonInHgPrev = oButton.getIndex();
                    this.buttonInHgPrev.setEnabled(oButton.isSensitiv());
                    continue;
                }
                if (oButton.getAction() == 3) {
                    this.mButtonInHgIndexData.mnButtonInHg1 = oButton.getIndex();
                    this.buttonInHg1.setVisible(true);
                    this.buttonInHg1.setText(oButton.getAb() + " - " + oButton.getBis());
                    continue;
                }
                if (oButton.getAction() == 4) {
                    this.mButtonInHgIndexData.mnButtonInHg2 = oButton.getIndex();
                    this.buttonInHg2.setVisible(true);
                    this.buttonInHg2.setText(oButton.getAb() + " - " + oButton.getBis());
                    hl.setColumnWidth(6, 5);
                    continue;
                }
                if (oButton.getAction() == 5) {
                    this.mButtonInHgIndexData.mnButtonInHg3 = oButton.getIndex();
                    this.buttonInHg3.setVisible(true);
                    this.buttonInHg3.setText(oButton.getAb() + " - " + oButton.getBis());
                    hl.setColumnWidth(8, 5);
                    continue;
                }
                if (oButton.getAction() == 6) {
                    this.mButtonInHgIndexData.mnButtonInHg4 = oButton.getIndex();
                    this.buttonInHg4.setVisible(true);
                    this.buttonInHg4.setText(oButton.getAb() + " - " + oButton.getBis());
                    hl.setColumnWidth(10, 5);
                    continue;
                }
                if (oButton.getAction() == 7) {
                    this.mButtonInHgIndexData.mnButtonInHg5 = oButton.getIndex();
                    this.buttonInHg5.setVisible(true);
                    this.buttonInHg5.setText(oButton.getAb() + " - " + oButton.getBis());
                    hl.setColumnWidth(12, 5);
                    continue;
                }
                if (oButton.getAction() == 8) {
                    this.mButtonInHgIndexData.mnButtonInHgNext = oButton.getIndex();
                    this.buttonInHgNext.setEnabled(oButton.isSensitiv());
                    continue;
                }
                if (oButton.getAction() != 9) continue;
                this.mButtonInHgIndexData.mnButtonInHgLast = oButton.getIndex();
                this.buttonInHgLast.setEnabled(oButton.isSensitiv());
            }
        }
        this.panErgebnisBlaetternButton.revalidate();
        this.panErgebnisBlaetternButton.validate();
        this.panErgebnisBlaetternButton.repaint();
        this.panErgebnis.repaint();
    }

    public void copySachnummerIntoClipboard(int nRow) {
        String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 5);
        String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
        GlobalObjects.getInstance().getEtkData().copySachnummerIntoClipboard(sSachnummer);
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        int nRow = this.table.getTable().getSelectedRow();
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 5);
        String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
        String sBenennungZusatz = (String)this.tableModel.getValueAt(nRow, 6);
        String sZusatz = (String)this.tableModel.getValueAt(nRow, 7);
        if (sZusatz != null && !sZusatz.equals("")) {
            sBenennungZusatz = sBenennungZusatz + "/" + sZusatz;
        }
        String sMarke = this.model.getMarke();
        String sProduktart = this.model.getProduktart();
        String sKatalogumang = this.model.getKatalogumfang();
        String sMospIDs = this.model.getModellspaltenIDs();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennungZusatz);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumang);
        oHashMap.put("modellspaltenids", sMospIDs);
        return oHashMap;
    }

    private static class ButtonInHgIndexData {
        public int mnButtonInHgFirst = -1;
        public int mnButtonInHgPrev = -1;
        public int mnButtonInHg1 = -1;
        public int mnButtonInHg2 = -1;
        public int mnButtonInHg3 = -1;
        public int mnButtonInHg4 = -1;
        public int mnButtonInHg5 = -1;
        public int mnButtonInHgNext = -1;
        public int mnButtonInHgLast = -1;

        private ButtonInHgIndexData() {
        }

        public void reset() {
            this.mnButtonInHgFirst = -1;
            this.mnButtonInHgPrev = -1;
            this.mnButtonInHg1 = -1;
            this.mnButtonInHg2 = -1;
            this.mnButtonInHg3 = -1;
            this.mnButtonInHg4 = -1;
            this.mnButtonInHg5 = -1;
            this.mnButtonInHgNext = -1;
            this.mnButtonInHgLast = -1;
        }
    }
}

