/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.teileverwendung.tvnachteilen;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.InvalidInitializationException;
import webetk.NoDataFoundException;
import webetk.app.GenericTeil;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.teileverwendung.tvnachteilen.DatenZeile;
import webetk.javaclient.dialog.teileverwendung.tvnachteilen.TVNachTeilenModel;
import webetk.javaclient.dialog.teileverwendung.tvnachteilen.TVNachTeilenView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class TVNachTeilenController
extends AbstractDlgMitTLController {
    private static Logger log = Logger.getLogger(TVNachTeilenController.class);
    private TVNachTeilenView view = new TVNachTeilenView();
    private TVNachTeilenModel model = new TVNachTeilenModel();

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        super.init(this.model);
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("exitaction", this.model.getExitAction());
        exitData.setWert("sachnummer", this.model.getSachnummer().toUpperCase());
        exitData.setWert("marke", this.model.getMarke());
        exitData.setWert("produktart", this.model.getProduktart());
        exitData.setWert("katalogumfang", this.model.getKatalogumfang());
        if (this.model.getExitAction().equals("anzeige_bt")) {
            exitData.setWert("currentbte", this.model.getCurrentBTE());
            exitData.setWert("sachnummersuch", this.model.getTeilGesucht().getSachnummer());
        }
        return exitData;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    protected boolean checkSachnummer(String sSachnummer) {
        log.debug((Object)"Performing Check Sachnummer (Teileverwendung)");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfCheckSachnummer = new TrfHashMap(null);
        trfCheckSachnummer.setValue("sachnummer", sSachnummer);
        trfCheckSachnummer.setValue("marke", this.model.getMarke());
        trfCheckSachnummer.setValue("produktart", this.model.getProduktart());
        trfCheckSachnummer.setValue("katalogumfang", this.model.getKatalogumfang());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfCheckSachnummer, Command.CHECK_TEILEVERWENDUNGTEIL);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfCheckSachnummer.getError() != null) {
            if (trfCheckSachnummer.getError() instanceof InvalidInitializationException) {
                log.warn((Object)"Teil nicht im Teilestamm enthalten (ggf. wegen 'falscher' Marke)!", (Throwable)trfCheckSachnummer.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
                return false;
            }
            if (trfCheckSachnummer.getError() instanceof NoDataFoundException) {
                log.warn((Object)"Teil nicht im Teilestamm enthalten", (Throwable)trfCheckSachnummer.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getTeilNichtImTeilestamm(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
                return false;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfCheckSachnummer.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfCheckSachnummer.getError().getMessage(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
            return false;
        }
        GenericTeil t = (GenericTeil)trfCheckSachnummer.getValue("genericteil");
        this.model.setTeilGesucht(t);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    protected void performSearch(String sSachnummer, String sBaureihe) {
        log.debug((Object)"Performing Search Teileverwendung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTeileverwendung = new TrfHashMap(null);
        trfTeileverwendung.setValue("marke", this.model.getMarke());
        trfTeileverwendung.setValue("produktart", this.model.getProduktart());
        trfTeileverwendung.setValue("katalogumfang", this.model.getKatalogumfang());
        trfTeileverwendung.setValue("sachnummer", sSachnummer);
        trfTeileverwendung.setValue("baureihe_string", sBaureihe);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTeileverwendung, Command.LOAD_TEILEVERWENDUNGTEIL);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTeileverwendung.getError() != null) {
            if (trfTeileverwendung.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Teileverwendung gefunden!", (Throwable)trfTeileverwendung.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
                return;
            }
            if (trfTeileverwendung.getError() instanceof InvalidInitializationException) {
                log.error((Object)"Teil nicht im Teilestamm enthalten (ggf. wegen 'falscher' Marke)!", (Throwable)trfTeileverwendung.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
                return;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTeileverwendung.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfTeileverwendung.getError().getMessage(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
            return;
        }
        this.model.storeAnzeigedaten((List)trfTeileverwendung.getValue("baureihenListe"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected CurrentBTE showBildtafel(DatenZeile oZeile) {
        log.debug((Object)"Performing Anzeige Teileverwendung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfBildtafel = new TrfHashMap(null);
        trfBildtafel.setValue("btnummer", oZeile.getBtNummer());
        trfBildtafel.setValue("marke", this.model.getMarke());
        trfBildtafel.setValue("produktart", this.model.getProduktart());
        trfBildtafel.setValue("katalogumfang", this.model.getKatalogumfang());
        trfBildtafel.setValue("baureihe", oZeile.getBaureihe());
        trfBildtafel.setValue("region", oZeile.getRegion());
        trfBildtafel.setValue("modell", oZeile.getModell());
        if (this.model.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            trfBildtafel.setValue("karosserie", oZeile.getKarosserie());
        } else {
            trfBildtafel.setValue("bauart", oZeile.getBauart());
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfBildtafel, Command.BT_SHOW_TV_TEIL);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        if (trfBildtafel.getError() != null) {
            if (trfBildtafel.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Teileverwendung gefunden!", (Throwable)trfBildtafel.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
                return null;
            }
            if (trfBildtafel.getError() instanceof InvalidInitializationException) {
                log.error((Object)"Teil nicht im Teilestamm enthalten (ggf. wegen 'falscher' Marke)!", (Throwable)trfBildtafel.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
                return null;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfBildtafel.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfBildtafel.getError().getMessage(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
            return null;
        }
        JavaFzgIdInfo oFzgIdInfo = (JavaFzgIdInfo)trfBildtafel.getValue("fzgidinfo_java");
        GlobalObjects.getInstance().setFzgIdInfo(oFzgIdInfo);
        JavaFzgSucheInfo oFzgSucheInfo = (JavaFzgSucheInfo)trfBildtafel.getValue("fzgsucheinfo_java");
        GlobalObjects.getInstance().getEtkData().setSucheInfo(oFzgSucheInfo);
        CurrentBTE oCurrentBTE = (CurrentBTE)trfBildtafel.getValue("currentbte");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        ComboTeilelisteItem item = GlobalObjects.getInstance().getSessionInfo().getAktuelleTeileliste();
        if (item != null && !this.model.getMarke().equals(item.getMarke())) {
            GlobalObjects.getInstance().getSessionInfo().setAktuelleTeileliste(null);
        }
        return oCurrentBTE;
    }

    public static class ExitActions {
        public static final String ANZEIGE_BT = "anzeige_bt";
    }
}

