/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.teileverwendung.tvreduziert;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import webetk.InvalidInitializationException;
import webetk.NoDataFoundException;
import webetk.app.teilevwdgteil.Baureihe;
import webetk.app.teilevwdgteil.Modellspalte;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.teileverwendung.tvnachteilen.DatenZeile;
import webetk.javaclient.dialog.teileverwendung.tvreduziert.AufzuklappZeile;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class TVReduziert
extends JDialog {
    private static final long serialVersionUID = 1L;
    Logger log = Logger.getLogger(TVReduziert.class);
    private List<Baureihe> mBaureihen = null;
    private String mUeberschrift = null;
    private JPanel panContent = null;
    private GenericTableModel tableModel = null;
    private GenericTable table = null;
    private JScrollPane scrollPaneTable = null;
    private String msMarke = null;
    private String msProduktart = null;
    private String msKatalogumfang = null;
    private String msSachnummer = null;
    private String msModellspaltenIDs = null;

    public TVReduziert(JFrame oFrame, String sMarke, String sProduktart, String sKatalogumfang, String sSachnummer, String sModellspaltenIDs) {
        super((Frame)oFrame, true);
        this.msMarke = sMarke;
        this.msProduktart = sProduktart;
        this.msKatalogumfang = sKatalogumfang;
        this.msSachnummer = sSachnummer;
        this.msModellspaltenIDs = sModellspaltenIDs;
        this.setTitle(Resource.getInstance().getTeileverwendung());
        this.searchTeileverwendung(null);
        this.initComponents();
        this.update();
    }

    void initComponents() {
        if (this.getAnzeigedaten() == null) {
            return;
        }
        HeaderPanel panHeader = new HeaderPanel(Resource.getInstance().getTeileverwendung(), this.mUeberschrift, null);
        this.panContent = new JPanel(new BorderLayout(0, 0));
        int[] w = new int[]{10, 0, 10};
        int[] h = new int[]{10, 0, 10};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(2, 1);
        hl.setRowWeight(2, 1);
        HIGConstraints c = new HIGConstraints();
        this.panContent.setLayout(hl);
        this.panContent.add((Component)this.createTabelle(), c.rc(2, 2));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panHeader, "North");
        this.getContentPane().add((Component)this.panContent, "Center");
        this.setSize(950, 400);
    }

    protected JScrollPane createTabelle() {
        boolean bFzg = this.isFzg();
        AufzuklappZeile.resetRenderer();
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn("", 0, JLabel.class, false, AufzuklappZeile.getAufklappenRenderer());
        String sBaureiheProtoyp = bFzg ? "3' E21" : "XXXXXXXXXXXXXXXXXXXX";
        tableConfig.addColumn(Resource.getInstance().getBaureihe(), 0, true, sBaureiheProtoyp);
        tableConfig.addColumn(Resource.getInstance().getModell(), 0, true, "XXXXXXXXXXXX");
        if (bFzg) {
            tableConfig.addColumn(Resource.getInstance().getKarosserie(), 0, false, "XXXXXXXXXX");
        }
        tableConfig.addColumn(Resource.getInstance().getNueKR(), 0, false, "ECE");
        int nRowCount = tableConfig.getColumnCount();
        tableConfig.setHeaderTooltip(nRowCount - 1, Resource.getInstance().getKatalogausfuehrungRegion());
        tableConfig.addColumn(Resource.getInstance().getBtNummer(), 0, false, "51_1169");
        tableConfig.addColumn(Resource.getInstance().getBtUeberschrift(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn(Resource.getInstance().getMenge(), 0, false, "XX");
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setWidth(20);
        GenericTableMouseEventListener listenerPlusMinus = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                TVReduziert.this.doClickOnExpandCollapse(e.getRow());
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerPlusMinus, 0);
        this.scrollPaneTable = this.table.getScrollPane();
        return this.scrollPaneTable;
    }

    private void doClickOnExpandCollapse(int nRow) {
        if (!(this.tableModel.getRow(nRow) instanceof AufzuklappZeile)) {
            return;
        }
        AufzuklappZeile oZeile = (AufzuklappZeile)this.tableModel.getRow(nRow);
        if (oZeile.isExpanded()) {
            this.searchTeileverwendung(null);
        } else {
            this.searchTeileverwendung(this.mBaureihen.get(nRow).getID());
        }
        this.update();
    }

    public void update() {
        if (this.tableModel != null) {
            this.tableModel.removeAllRows();
        }
        if (this.mBaureihen == null || this.mBaureihen.isEmpty()) {
            return;
        }
        for (Baureihe baureihe : this.mBaureihen) {
            this.tableModel.addRow(new webetk.javaclient.dialog.teileverwendung.tvnachteilen.AufzuklappZeile(baureihe.getExpandiert(), baureihe.getBenennung()));
            for (Modellspalte modellspalte : baureihe.getModellspalten()) {
                String sBaureihe = modellspalte.getBaureiheID();
                String sKarosserie = null;
                String sKarosserieExt = null;
                String sBauart = null;
                if (this.isFzg()) {
                    sKarosserie = modellspalte.getBauartKarosserieID();
                    sKarosserieExt = modellspalte.getKarosserie();
                } else {
                    sBauart = modellspalte.getBauartKarosserieID();
                }
                String sModell = modellspalte.getModell();
                String sRegion = modellspalte.getRegion();
                String sBtNummer = modellspalte.getBTNummer();
                String sBtUeberschrift = modellspalte.getBTUeberschrift();
                String sMenge = modellspalte.getMenge();
                boolean hasBTInfo = modellspalte.hasBtInfo();
                if (this.isFzg()) {
                    this.tableModel.addRow(new DatenZeile(hasBTInfo, sBtNummer, sBtUeberschrift, sMenge, sBaureihe, baureihe.getBenennung(), sModell, sKarosserie, sKarosserieExt, sRegion));
                    continue;
                }
                this.tableModel.addRow(new DatenZeile(hasBTInfo, sBtNummer, sBtUeberschrift, sMenge, sBauart, sBaureihe, baureihe.getBenennung(), sModell, sRegion));
            }
        }
        this.panContent.repaint();
    }

    private boolean isFzg() {
        if (this.msProduktart == null) {
            return true;
        }
        return this.msProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
    }

    public List<Baureihe> getAnzeigedaten() {
        return this.mBaureihen;
    }

    public void resetAnzeigedaten() {
        this.mBaureihen = null;
    }

    public void storeAnzeigedaten(List<Baureihe> pBaureihen) {
        this.mBaureihen = pBaureihen;
    }

    public void setUeberschrift(String pUeberschrift) {
        this.mUeberschrift = pUeberschrift;
    }

    void searchTeileverwendung(String sBaureihe) {
        this.resetAnzeigedaten();
        this.performSearch(this.msSachnummer, this.msModellspaltenIDs, sBaureihe);
    }

    protected void performSearch(String sSachnummer, String sModesllspaltenIDs, String sBaureihe) {
        this.log.debug((Object)"Performing Search Teileverwendung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTeileverwendung = new TrfHashMap(null);
        trfTeileverwendung.setValue("marke", this.msMarke);
        trfTeileverwendung.setValue("produktart", this.msProduktart);
        trfTeileverwendung.setValue("katalogumfang", this.msKatalogumfang);
        trfTeileverwendung.setValue("sachnummer", sSachnummer);
        trfTeileverwendung.setValue("modellspaltenids", sModesllspaltenIDs);
        trfTeileverwendung.setValue("baureihe_string", sBaureihe);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTeileverwendung, Command.LOAD_TEILEVERWENDUNGTEIL);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTeileverwendung.getError() != null) {
            if (trfTeileverwendung.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Teileverwendung gefunden!", (Throwable)trfTeileverwendung.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
                return;
            }
            if (trfTeileverwendung.getError() instanceof InvalidInitializationException) {
                this.log.error((Object)"Teil nicht im Teilestamm enthalten (ggf. wegen 'falscher' Marke)!", (Throwable)trfTeileverwendung.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
                return;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTeileverwendung.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfTeileverwendung.getError().getMessage(), Resource.getInstance().getTeileverwendungNachTeilen(), 0);
            return;
        }
        this.storeAnzeigedaten((List)trfTeileverwendung.getValue("baureihenListe"));
        this.setUeberschrift((String)trfTeileverwendung.getValue("ueberschrift"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

