/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.erstbevorratung;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.zusatzinfo.erstbevorratung.ErstbevorratungModel;
import webetk.javaclient.dialog.zusatzinfo.erstbevorratung.ErstbevorratungView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class ErstbevorratungController
extends AbstractDlgMitTLController {
    Logger log = Logger.getLogger(ErstbevorratungController.class);
    ErstbevorratungView view = new ErstbevorratungView();
    ErstbevorratungModel model = new ErstbevorratungModel();

    @Override
    public DialogView getDialogView() {
        this.log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.log.debug((Object)"init");
        super.init(this.model);
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    protected void loadHauptgruppen() {
        this.log.debug((Object)"Performing Search Erstbevorratung (Hauptgruppen)");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfHgs = new TrfHashMap(null);
        trfHgs.setValue("hgvon", this.model.getHgVon());
        trfHgs.setValue("hgbis", this.model.getHgBis());
        trfHgs.setValue("modellspaltenids", this.model.getModellspaltenIDs());
        trfHgs.setValue("lenkung", this.model.getLenkung());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHgs, Command.LOAD_ERSTBEVORRATUNG_HGS);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfHgs.getError() != null) {
            if (trfHgs.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Daten gefunden!", (Throwable)trfHgs.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfHgs.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfHgs.getError().getMessage(), Resource.getInstance().getVorschlagZurErstbevorratung(), 0);
            return;
        }
        this.model.storeHauptgruppen((List)trfHgs.getValue("hgs"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void performSearch(String sHg) {
        this.log.debug((Object)"Performing Search Erstbevorratung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfErstbevorratung = new TrfHashMap(null);
        trfErstbevorratung.setValue("hg", sHg);
        trfErstbevorratung.setValue("modellspaltenids", this.model.getModellspaltenIDs());
        trfErstbevorratung.setValue("lenkung", this.model.getLenkung());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfErstbevorratung, Command.LOAD_ERSTBEVORRATUNG_ZU_HG);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("ErstbevorratungController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfErstbevorratung.getError() != null) {
            if (trfErstbevorratung.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Daten gefunden!", (Throwable)trfErstbevorratung.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getVorschlagZurErstbevorratung(), 1);
                return;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfErstbevorratung.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfErstbevorratung.getError().getMessage(), Resource.getInstance().getVorschlagZurErstbevorratung(), 0);
            return;
        }
        this.model.storeAnzeigedaten((List)trfErstbevorratung.getValue("genericteile"));
        this.model.storeHgAkt((String)trfErstbevorratung.getValue("hg"));
        Collection cButtons = (Collection)trfErstbevorratung.getValue("buttons");
        this.model.storeButtonInfo(cButtons);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void getTeileIndex(int nIndex) {
        this.log.debug((Object)"Performing get Teile Erstvevorratung nach Fahrzeug (At Index) ");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfErstbevorratung = new TrfHashMap(null);
        String sIndex = Integer.toString(nIndex);
        trfErstbevorratung.setValue("index", sIndex);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfErstbevorratung, Command.LOAD_ERSTBEVORRATUNG_ZU_HG_AT_INDEX);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("ErstbevorratungController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfErstbevorratung.getError() != null) {
            if (trfErstbevorratung.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Daten gefunden!", (Throwable)trfErstbevorratung.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getVorschlagZurErstbevorratung(), 1);
                return;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfErstbevorratung.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfErstbevorratung.getError().getMessage(), Resource.getInstance().getVorschlagZurErstbevorratung(), 0);
            return;
        }
        this.model.storeAnzeigedaten((List)trfErstbevorratung.getValue("genericteile"));
        Collection cButtons = (Collection)trfErstbevorratung.getValue("buttons");
        this.model.storeButtonInfo(cButtons);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

