/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.fuellmengen;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import webetk.app.fuellmengen.FMZeile;
import webetk.communication.JavaFzgSucheInfo;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.zusatzinfo.fuellmengen.DlgFuellmengenController;
import webetk.javaclient.dialog.zusatzinfo.fuellmengen.DlgFuellmengenModel;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;

public class DlgFuellmengenView
extends AbstractDialogView {
    private static final long serialVersionUID = 1L;
    public static int ART_TYP = 0;
    public static int ART_FM = 1;
    private static Logger log = Logger.getLogger(DlgFuellmengenView.class);
    DlgFuellmengenModel model;
    DlgFuellmengenController controller;
    private JPanel panHeader;
    private JPanel panErgebnis;
    private JLabel txtHinweis;
    protected Color textColor = new Color(14, 8, 104);

    @Override
    public void initMenus() {
    }

    private void initComponents() {
        JavaFzgSucheInfo oFzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        if (oFzgSucheInfo == null) {
            log.error((Object)"oFzgSucheInfo == null");
            return;
        }
        String sFzgIdString = oFzgSucheInfo.getFzgIdString();
        this.panHeader = new HeaderPanel(Resource.getInstance().getFuellmengen(), sFzgIdString, ImageCache.getInstance().getHeaderIcon("fuell"));
        this.panErgebnis = new TitledPanel(Resource.getInstance().getAnzeigeFuellmengen());
        this.txtHinweis = new JLabel(Resource.getInstance().getFuellmengenHinweisWechselmengen());
        this.createLayout();
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        JScrollPane panContent = new JScrollPane(this.createContent());
        this.add((Component)panContent, "Center");
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        log.debug((Object)"init");
        this.model = (DlgFuellmengenModel)oDlgModel;
        this.controller = (DlgFuellmengenController)oDlgController;
        this.initComponents();
    }

    @Override
    public void update() {
    }

    private JPanel createContent() {
        JPanel contentPanel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(1, 1);
        HIGConstraints c = new HIGConstraints();
        contentPanel.setLayout(hl);
        contentPanel.add((Component)this.createContentErgebnis(), c.rc(1, 1));
        return contentPanel;
    }

    private JPanel createContentErgebnis() {
        int nAnzahlTypen = this.model.getAnzahlTypen();
        int[] w_ergebnis = new int[]{10, 0, 0, 10};
        int nCountZeilen = 3 + 10 * nAnzahlTypen;
        int[] h_ergebnis = new int[nCountZeilen];
        h_ergebnis[0] = 10;
        h_ergebnis[1] = 0;
        h_ergebnis[2] = 10;
        for (int i = 0; i < nAnzahlTypen; ++i) {
            h_ergebnis[i * 10 + 3] = 0;
            h_ergebnis[i * 10 + 4] = 0;
            h_ergebnis[i * 10 + 5] = 0;
            h_ergebnis[i * 10 + 6] = 0;
            h_ergebnis[i * 10 + 7] = 0;
        }
        HIGLayout layoutErgebnis = new HIGLayout(w_ergebnis, h_ergebnis);
        layoutErgebnis.setColumnWeight(3, 1);
        layoutErgebnis.setRowWeight(nCountZeilen, 1);
        HIGConstraints c = new HIGConstraints();
        this.panErgebnis.setLayout(new BoxLayout(this.panErgebnis, 1));
        this.panErgebnis.add(this.txtHinweis);
        this.panErgebnis.add(Box.createRigidArea(new Dimension(0, 25)));
        for (int i = 0; i < nAnzahlTypen; ++i) {
            JTable table = this.createTabelleART_TYPE(i);
            table.setAutoResizeMode(0);
            table.getTableHeader().setBackground(UIHelper.getBigTitleColor());
            table.getColumnModel().getColumn(0).setMaxWidth(200);
            table.getColumnModel().getColumn(1).setMaxWidth(200);
            table.getColumnModel().getColumn(2).setMaxWidth(200);
            this.panErgebnis.add(table.getTableHeader());
            this.panErgebnis.add(table);
            this.panErgebnis.add(Box.createRigidArea(new Dimension(0, 5)));
            this.panErgebnis.add(this.createTabelleART_FM(i));
            this.panErgebnis.add(Box.createRigidArea(new Dimension(0, 10)));
            this.panErgebnis.add(this.createTabelleART_Hinweis(i));
            this.panErgebnis.add(Box.createRigidArea(new Dimension(0, 25)));
        }
        return this.panErgebnis;
    }

    private JTable createTabelleART_TYPE(int nIndexHashMap) {
        String sMotor;
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getTyp(), 0, false, "XXXXYYY");
        tableConfig.addColumn(Resource.getInstance().getGetriebe(), 0, true, "XXXXXXXXYY");
        tableConfig.addColumn(Resource.getInstance().getMotor(), 0, true, "XXXXXXYY");
        GenericTableModel tableModel = new GenericTableModel(tableConfig);
        List<FMZeile> fuellmengenZeilen = this.model.getFuellmengen();
        FMZeile currentZeile = fuellmengenZeilen.get(nIndexHashMap);
        String sTyp = currentZeile.getTyp();
        String sGetriebe = currentZeile.getGetriebe();
        if (sGetriebe == null) {
            sGetriebe = "";
        }
        if ((sMotor = currentZeile.getMotor()) == null) {
            sMotor = "";
        }
        tableModel.addRow(new AbstractRow(new Object[]{sTyp, sGetriebe, sMotor}));
        GenericTable table = new GenericTable(tableModel);
        table.getTable().validate();
        return table.getTable();
    }

    private JComponent createTabelleART_FM(int nIndexHashMap) {
        String sHinweis;
        String sFMBremse;
        String sFMKuelmittelOhneKA;
        String sFMKuelmittelMitKA;
        String sFMHinterachse;
        String sFMGetriebe;
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn("beschreibung", 2, true, "YYY");
        tableConfig.addColumn("werte", 0, true, "YYY");
        GenericTableModel tableModel = new GenericTableModel(tableConfig);
        List<FMZeile> fuellmengenZeilen = this.model.getFuellmengen();
        FMZeile currentZeile = fuellmengenZeilen.get(nIndexHashMap);
        String sFMMotor = currentZeile.getFMMotor();
        if (sFMMotor == null) {
            sFMMotor = "";
        }
        if ((sFMGetriebe = currentZeile.getFMGetriebe()) == null) {
            sFMGetriebe = "";
        }
        if ((sFMHinterachse = currentZeile.getFMHinterachse()) == null) {
            sFMHinterachse = "";
        }
        if ((sFMKuelmittelMitKA = currentZeile.getFMKuehlmittelMitAC()) == null) {
            sFMKuelmittelMitKA = "";
        }
        if ((sFMKuelmittelOhneKA = currentZeile.getFMKuehlmittelOhneAC()) == null) {
            sFMKuelmittelOhneKA = "";
        }
        if ((sFMBremse = currentZeile.getFMBremse()) == null) {
            sFMBremse = "";
        }
        if ((sHinweis = currentZeile.getHinweis()) == null) {
            sHinweis = "";
        }
        sFMMotor = this.formatValue(sFMMotor);
        sFMGetriebe = this.formatValue(sFMGetriebe);
        sFMHinterachse = this.formatValue(sFMHinterachse);
        sFMKuelmittelMitKA = this.formatValue(sFMKuelmittelMitKA);
        sFMKuelmittelOhneKA = this.formatValue(sFMKuelmittelOhneKA);
        sFMBremse = this.formatValue(sFMBremse);
        tableModel.addRow(new AbstractRow(new Object[]{Resource.getInstance().getMotor(), sFMMotor}));
        tableModel.addRow(new AbstractRow(new Object[]{Resource.getInstance().getGetriebe(), sFMGetriebe}));
        tableModel.addRow(new AbstractRow(new Object[]{Resource.getInstance().getNueHa(), sFMHinterachse}));
        tableModel.addRow(new AbstractRow(new Object[]{Resource.getInstance().getNueKmMitKa(), sFMKuelmittelMitKA}));
        tableModel.addRow(new AbstractRow(new Object[]{Resource.getInstance().getNueKmOhneKa(), sFMKuelmittelOhneKA}));
        tableModel.addRow(new AbstractRow(new Object[]{Resource.getInstance().getBremse(), sFMBremse}));
        GenericTable table = new GenericTable(tableModel);
        table.getColumnModel().getColumn(0).setMaxWidth(250);
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();
        cellRenderer.setBackground(UIHelper.getBrighterBackground());
        table.getColumnModel().getColumn(0).setCellRenderer(cellRenderer);
        table.getColumnModel().getColumn(1).setMaxWidth(100);
        return table;
    }

    private JComponent createTabelleART_Hinweis(int nIndexHashMap) {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn("hinweis", 2, true, "YYY");
        tableConfig.addColumn("wert", 0, true, "YYY");
        GenericTableModel tableModel = new GenericTableModel(tableConfig);
        List<FMZeile> fuellmengenZeilen = this.model.getFuellmengen();
        FMZeile currentZeile = fuellmengenZeilen.get(nIndexHashMap);
        String sHinweis = currentZeile.getHinweis();
        if (sHinweis == null) {
            sHinweis = "";
        }
        tableModel.addRow(new AbstractRow(new Object[]{Resource.getInstance().getHinweis(), sHinweis}));
        GenericTable table = new GenericTable(tableModel);
        table.getColumnModel().getColumn(0).setMaxWidth(100);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setBackground(UIHelper.getBrighterBackground());
        table.getColumnModel().getColumn(0).setCellRenderer(defaultTableCellRenderer);
        table.getColumnModel().getColumn(1).setCellRenderer(new TableCellTextRenderer());
        return table;
    }

    private String formatValue(String doubleValue) {
        String format;
        try {
            DecimalFormat df = new DecimalFormat("#,###,###,##0.00");
            format = df.format(new Double(doubleValue));
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return doubleValue;
        }
        return format;
    }

    protected JLabel createValue(String s) {
        JLabel label = new JLabel(s);
        label.setForeground(this.textColor);
        return label;
    }

    public class TableCellTextRenderer
    extends JTextArea
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setWrapStyleWord(true);
            this.setLineWrap(true);
            this.setText((String)value);
            this.setSize(table.getColumnModel().getColumn(column).getWidth(), this.getPreferredSize().height);
            if (table.getRowHeight(row) != this.getPreferredSize().height) {
                table.setRowHeight(row, this.getPreferredSize().height);
            }
            return this;
        }
    }
}

