/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.interpretation;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.DMSException;
import webetk.InvalidInitializationException;
import webetk.NoDataFoundException;
import webetk.app.interpretation.Interpretation;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.zusatzinfo.interpretation.DlgInterpretationModel;
import webetk.javaclient.dialog.zusatzinfo.interpretation.DlgInterpretationView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.utils.DmsUtils;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgInterpretationController
extends AbstractDlgMitTLController {
    Logger log = Logger.getLogger(DlgInterpretationController.class);
    DlgInterpretationView view = new DlgInterpretationView();
    DlgInterpretationModel model = new DlgInterpretationModel();

    @Override
    public DialogView getDialogView() {
        this.log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.log.debug((Object)"init");
        super.init(this.model);
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = null;
        if (this.model.getExitAction() != null) {
            exitData = new WorkflowStateData();
            exitData.setWert("exitaction", this.model.getExitAction());
        }
        return exitData;
    }

    protected boolean performSearch(String sSachnummer, JComponent cTextfield) {
        this.log.debug((Object)"Performing Search Interpretation");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        if (cTextfield != null) {
            cTextfield.setCursor(Cursor.getPredefinedCursor(3));
        }
        TrfHashMap trfInterpretation = new TrfHashMap(null);
        trfInterpretation.setValue("sachnummer", sSachnummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfInterpretation, Command.LOAD_INTERPRETATION);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgInterpretationController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            if (cTextfield != null) {
                cTextfield.setCursor(Cursor.getPredefinedCursor(2));
            }
            return false;
        }
        this.model.setDmsBestandsabfrageImplementiert(true);
        Integer nStatus = (Integer)trfInterpretation.getValue("returncodes");
        if (nStatus != null && nStatus == 1708) {
            this.model.setDmsBestandsabfrageImplementiert(false);
            nStatus = 0;
        }
        DmsUtils.showMsgTxt((String)trfInterpretation.getValue("msgtxt"), nStatus);
        if (trfInterpretation.getError() != null) {
            if (trfInterpretation.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Interpretationskette gefunden!", (Throwable)trfInterpretation.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                if (cTextfield != null) {
                    cTextfield.setCursor(Cursor.getPredefinedCursor(2));
                }
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getInterpretationKeineGefunden(), Resource.getInstance().getInterpretation(), 0);
                return false;
            }
            if (trfInterpretation.getError() instanceof InvalidInitializationException) {
                this.log.error((Object)"Teil nicht im Teilestamm enthalten (ggf. wegen 'falscher' Marke)!", (Throwable)trfInterpretation.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                if (cTextfield != null) {
                    cTextfield.setCursor(Cursor.getPredefinedCursor(2));
                }
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getInterpretation(), 0);
                return false;
            }
            if (trfInterpretation.getError() instanceof DMSException) {
                if (cTextfield != null) {
                    cTextfield.setCursor(Cursor.getPredefinedCursor(2));
                }
            } else {
                this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfInterpretation.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                if (cTextfield != null) {
                    cTextfield.setCursor(Cursor.getPredefinedCursor(2));
                }
                JOptionPane.showMessageDialog(MainView.getInstance(), trfInterpretation.getError().getMessage(), Resource.getInstance().getInterpretation(), 0);
                return false;
            }
        }
        Interpretation oInterpretation = (Interpretation)trfInterpretation.getValue("interpretation");
        this.model.storeInterpretation(oInterpretation);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (cTextfield != null) {
            cTextfield.setCursor(Cursor.getPredefinedCursor(2));
        }
        return trfInterpretation != null;
    }

    public static boolean hatInterpretation(String sSachnummer) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfInterpretation = new TrfHashMap(null);
        trfInterpretation.setValue("sachnummer", sSachnummer);
        trfInterpretation.setValue("bestaende", "N");
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfInterpretation, Command.LOAD_INTERPRETATION);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfInterpretation.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return trfInterpretation != null;
    }
}

