/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.lagerzeitbeschraenkung;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import webetk.app.BlaetternButton;
import webetk.app.GenericTeil;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.zusatzinfo.lagerzeitbeschraenkung.DlgLagerzeitbeschraenkungController;
import webetk.javaclient.dialog.zusatzinfo.lagerzeitbeschraenkung.DlgLagerzeitbeschraenkungModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemEinzelteile;
import webetk.javaclient.menuitem.MenuItemInterpretation;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class DlgLagerzeitbeschraenkungView
extends AbstractDlgMitTLView {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DlgLagerzeitbeschraenkungView.class);
    private DlgLagerzeitbeschraenkungController controller = null;
    private DlgLagerzeitbeschraenkungModel model = null;
    private GenericTableModel tableModel = null;
    private GenericTable table = null;
    private JPanel panHeader = null;
    private JPanel panSuchen = null;
    private JPanel panErgebnis = null;
    private JPanel panErgebnisBlaetternButton = null;
    private JLabel labHgVon = null;
    private JLabel labHgBis = null;
    private JTextField tfHgVon = null;
    private JTextField tfHgBis = null;
    private JButtonEx buttonAusfuehren = null;
    private JButtonEx buttonHgNext = null;
    private JButtonEx buttonHgPrev = null;
    private JButtonEx buttonInHgFirst = null;
    private JButtonEx buttonInHgNext = null;
    private JButtonEx buttonInHg1 = null;
    private JButtonEx buttonInHg2 = null;
    private JButtonEx buttonInHg3 = null;
    private JButtonEx buttonInHg4 = null;
    private JButtonEx buttonInHg5 = null;
    private JButtonEx buttonInHgPrev = null;
    private JButtonEx buttonInHgLast = null;
    private JPopupMenu menuPopup = null;
    private JMenuItem menuitemTeileinformation = null;
    private JMenuItem menuitemTeileverwendungTeil = null;
    private JMenuItem menuitemInterpretation = null;
    private JMenuItem menuitemEinzelteile = null;
    private JMenuItem menuitemCopySachnummer = null;
    private boolean bUpdateTeilelisten = true;
    private int nIndexHg = -1;
    private ButtonInHgIndexData mButtonInHgIndexData = new ButtonInHgIndexData();

    @Override
    protected void initComponents() {
        super.initComponents();
        this.panHeader = new HeaderPanel(Resource.getInstance().getTeileMitLagerzeitbeschraenkung(), ImageCache.getInstance().getHeaderIcon("lzb"));
        this.panSuchen = new TitledPanel(Resource.getInstance().getTeileumfangFestlegen());
        this.panErgebnis = new TitledPanel(Resource.getInstance().getErgebnisTeilenummern());
        this.labHgVon = new JLabel(Resource.getInstance().getVonHg());
        this.labHgBis = new JLabel(Resource.getInstance().getBisHg());
        this.tfHgVon = new JTextField(2);
        this.tfHgVon.setDocument(new EnhancedTextDocument(2, 1));
        this.tfHgVon.setText("11");
        this.tfHgVon.addActionListener(new SuchenButtonActionListener());
        this.tfHgBis = new JTextField(2);
        this.tfHgBis.setDocument(new EnhancedTextDocument(2, 1));
        this.tfHgBis.addActionListener(new SuchenButtonActionListener());
        this.buttonAusfuehren = new JButtonEx(ImageCache.getInstance().getIcon("arrw04_10b.gif"));
        this.buttonAusfuehren.addActionListener(new SuchenButtonActionListener());
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgLagerzeitbeschraenkungView.this.uebernehmenInTeileliste();
            }
        });
        this.buttonHgNext = new JButtonEx(Resource.getInstance().getHg(), ImageCache.getInstance().getIcon("scrollend.gif"));
        this.buttonHgNext.setHorizontalTextPosition(2);
        this.buttonHgNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgLagerzeitbeschraenkungView.this.searchLagerzeitNext();
                DlgLagerzeitbeschraenkungView.this.updateBlaetternInHgButton();
                DlgLagerzeitbeschraenkungView.this.update();
            }
        });
        this.buttonHgPrev = new JButtonEx(Resource.getInstance().getHg(), ImageCache.getInstance().getIcon("scrollhome.gif"));
        this.buttonHgPrev.setHorizontalTextPosition(4);
        this.buttonHgPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgLagerzeitbeschraenkungView.this.searchLagerzeitPrev();
                DlgLagerzeitbeschraenkungView.this.updateBlaetternInHgButton();
                DlgLagerzeitbeschraenkungView.this.update();
            }
        });
        this.buttonInHgFirst = new JButtonEx("<<");
        this.buttonInHgFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgLagerzeitbeschraenkungView.this.getTeileAnIndex(((DlgLagerzeitbeschraenkungView)DlgLagerzeitbeschraenkungView.this).mButtonInHgIndexData.mnButtonInHgFirst);
                DlgLagerzeitbeschraenkungView.this.update();
            }
        });
        this.buttonInHgPrev = new JButtonEx("<");
        this.buttonInHgPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgLagerzeitbeschraenkungView.this.getTeileAnIndex(((DlgLagerzeitbeschraenkungView)DlgLagerzeitbeschraenkungView.this).mButtonInHgIndexData.mnButtonInHgPrev);
                DlgLagerzeitbeschraenkungView.this.update();
            }
        });
        this.buttonInHg1 = new JButtonEx("Button1");
        this.buttonInHg1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgLagerzeitbeschraenkungView.this.getTeileAnIndex(((DlgLagerzeitbeschraenkungView)DlgLagerzeitbeschraenkungView.this).mButtonInHgIndexData.mnButtonInHg1);
                DlgLagerzeitbeschraenkungView.this.update();
            }
        });
        this.buttonInHg2 = new JButtonEx("Button2");
        this.buttonInHg2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgLagerzeitbeschraenkungView.this.getTeileAnIndex(((DlgLagerzeitbeschraenkungView)DlgLagerzeitbeschraenkungView.this).mButtonInHgIndexData.mnButtonInHg2);
                DlgLagerzeitbeschraenkungView.this.update();
            }
        });
        this.buttonInHg3 = new JButtonEx("Button3");
        this.buttonInHg3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgLagerzeitbeschraenkungView.this.getTeileAnIndex(((DlgLagerzeitbeschraenkungView)DlgLagerzeitbeschraenkungView.this).mButtonInHgIndexData.mnButtonInHg3);
                DlgLagerzeitbeschraenkungView.this.update();
            }
        });
        this.buttonInHg4 = new JButtonEx("Button4");
        this.buttonInHg4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgLagerzeitbeschraenkungView.this.getTeileAnIndex(((DlgLagerzeitbeschraenkungView)DlgLagerzeitbeschraenkungView.this).mButtonInHgIndexData.mnButtonInHg4);
                DlgLagerzeitbeschraenkungView.this.update();
            }
        });
        this.buttonInHg5 = new JButtonEx("Button5");
        this.buttonInHg5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgLagerzeitbeschraenkungView.this.getTeileAnIndex(((DlgLagerzeitbeschraenkungView)DlgLagerzeitbeschraenkungView.this).mButtonInHgIndexData.mnButtonInHg5);
                DlgLagerzeitbeschraenkungView.this.update();
            }
        });
        this.buttonInHgNext = new JButtonEx(">");
        this.buttonInHgNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgLagerzeitbeschraenkungView.this.getTeileAnIndex(((DlgLagerzeitbeschraenkungView)DlgLagerzeitbeschraenkungView.this).mButtonInHgIndexData.mnButtonInHgNext);
                DlgLagerzeitbeschraenkungView.this.update();
            }
        });
        this.buttonInHgLast = new JButtonEx(">>");
        this.buttonInHgLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgLagerzeitbeschraenkungView.this.getTeileAnIndex(((DlgLagerzeitbeschraenkungView)DlgLagerzeitbeschraenkungView.this).mButtonInHgIndexData.mnButtonInHgLast);
                DlgLagerzeitbeschraenkungView.this.update();
            }
        });
        this.createLayout();
    }

    @Override
    public void initMenus() {
        this.menuPopup = new JPopupMenu();
        this.menuitemTeileinformation = new MenuItemTeileinformation(this);
        this.menuPopup.add(this.menuitemTeileinformation);
        this.menuitemTeileverwendungTeil = new MenuItemTeileverwendungTeil("lagerzeitbeschraenkung", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemTeileverwendungTeil);
        this.menuitemInterpretation = new MenuItemInterpretation("lagerzeitbeschraenkung", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemInterpretation);
        this.menuitemEinzelteile = new MenuItemEinzelteile("lagerzeitbeschraenkung", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemEinzelteile);
        this.menuPopup.addSeparator();
        this.menuitemCopySachnummer = new MenuItemCopySachnummer(this);
        this.menuPopup.add(this.menuitemCopySachnummer);
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        JScrollPane content = new JScrollPane(this.createContent());
        this.add((Component)content, "Center");
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        log.debug((Object)"init");
        super.init(oDlgModel, oDlgController);
        this.model = (DlgLagerzeitbeschraenkungModel)oDlgModel;
        this.controller = (DlgLagerzeitbeschraenkungController)oDlgController;
        this.initComponents();
        this.initMenus();
        this.loadTeilelistenIDs();
        this.update();
    }

    @Override
    public void setFocus() {
        if (this.tfHgVon != null) {
            this.tfHgVon.requestFocus();
        }
    }

    @Override
    public void update() {
        if (this.tableModel != null) {
            this.tableModel.removeAllRows();
        }
        this.panErgebnis.setVisible(this.model.getAnzeigedaten() != null);
        List<GenericTeil> oAnzeigedaten = this.model.getAnzeigedaten();
        if (oAnzeigedaten == null) {
            return;
        }
        List<String> oHauptgruppen = this.model.getHauptgruppen();
        if (this.model.getHauptgruppen() == null) {
            return;
        }
        this.buttonHgNext.setEnabled(this.nIndexHg + 1 < oHauptgruppen.size());
        this.buttonHgPrev.setEnabled(this.nIndexHg - 1 >= 0);
        for (GenericTeil genericTeil : oAnzeigedaten) {
            this.tableModel.addRow(new AbstractRow(new Object[]{null, genericTeil.getTeilenummer(), genericTeil.getBenennung(), genericTeil.getZusatz(), genericTeil.getZI()}));
        }
        if (this.bUpdateTeilelisten) {
            this.updateTeilelisten();
            this.bUpdateTeilelisten = false;
        }
        this.panErgebnis.repaint();
    }

    private JPanel createContent() {
        JPanel contentPanel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 10, 0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        contentPanel.setLayout(hl);
        contentPanel.add((Component)this.createSuchenPanel(), c.rc(1, 1));
        contentPanel.add((Component)this.createErgebnisPanel(), c.rc(3, 1));
        return contentPanel;
    }

    private JPanel createSuchenPanel() {
        int[] w_suchen = new int[]{10, 0, 10, 0, 20, 0, 10, 0, 60, 0};
        int[] h_suchen = new int[]{0, 10};
        HIGLayout layoutSuchen = new HIGLayout(w_suchen, h_suchen);
        HIGConstraints c = new HIGConstraints();
        this.panSuchen.setLayout(layoutSuchen);
        this.panSuchen.add((Component)this.labHgVon, c.rc(1, 2));
        this.panSuchen.add((Component)this.tfHgVon, c.rc(1, 4, "lr"));
        this.panSuchen.add((Component)this.labHgBis, c.rc(1, 6));
        this.panSuchen.add((Component)this.tfHgBis, c.rc(1, 8, "lr"));
        this.panSuchen.add((Component)this.buttonAusfuehren, c.rc(1, 10));
        return this.panSuchen;
    }

    private JPanel createErgebnisPanel() {
        int[] w_ergebnis = new int[]{10, 0, 20, 0, 20, 0, 20, 0, 20, -12, 5, -10, 10};
        int[] h_ergebnis = new int[]{10, 0, 5, 0, 5, 0, 5};
        HIGLayout layoutErgebnis = new HIGLayout(w_ergebnis, h_ergebnis);
        layoutErgebnis.setColumnWeight(9, 1);
        layoutErgebnis.setRowWeight(6, 1);
        HIGConstraints c = new HIGConstraints();
        this.panErgebnis.setLayout(layoutErgebnis);
        this.panErgebnis.add((Component)this.labTeileliste, c.rc(2, 2, "l"));
        this.panErgebnis.add((Component)this.comboTeileliste, c.rc(2, 4, "l"));
        this.panErgebnis.add((Component)this.buttonUebernehmen, c.rc(2, 6, "l"));
        this.panErgebnis.add((Component)this.buttonUeberpruefen, c.rc(2, 8, "l"));
        this.panErgebnis.add((Component)this.buttonHgPrev, c.rc(2, 10));
        this.panErgebnis.add((Component)this.buttonHgNext, c.rc(2, 12));
        this.panErgebnisBlaetternButton = this.createInHgBlaetterPanel();
        this.panErgebnis.add((Component)this.panErgebnisBlaetternButton, c.rcwh(4, 2, 11, 1, "tr"));
        this.panErgebnis.add((Component)this.createTabelle(), c.rcwh(6, 2, 11, 1));
        return this.panErgebnis;
    }

    private JPanel createInHgBlaetterPanel() {
        JPanel p = new JPanel();
        int[] w = new int[]{0, 5, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 5, 0};
        int[] h = new int[]{10, 0, 10};
        HIGLayout hl = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        p.setLayout(hl);
        p.add((Component)this.buttonInHgFirst, c.rc(2, 1));
        p.add((Component)this.buttonInHgPrev, c.rc(2, 3));
        p.add((Component)this.buttonInHg1, c.rc(2, 5));
        p.add((Component)this.buttonInHg2, c.rc(2, 7));
        p.add((Component)this.buttonInHg3, c.rc(2, 9));
        p.add((Component)this.buttonInHg4, c.rc(2, 11));
        p.add((Component)this.buttonInHg5, c.rc(2, 13));
        p.add((Component)this.buttonInHgNext, c.rc(2, 15));
        p.add((Component)this.buttonInHgLast, c.rc(2, 17));
        return p;
    }

    private JComponent createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "11 11 1 743 118");
        tableConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXXYYYY");
        tableConfig.addColumn(Resource.getInstance().getZi(), 0, false, "XXX");
        tableConfig.setHeaderTooltip(4, Resource.getInstance().getZusatzinformation());
        tableConfig.setUsePrototypeIcons(true);
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getTable().setSelectionMode(2);
        this.table.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setWidth(20);
        GenericTableMouseEventListener listenerTeileinfo = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                ((MenuItemTeileinformation)DlgLagerzeitbeschraenkungView.this.menuitemTeileinformation).showTeileinfo();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerTeileinfo, 0);
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (DlgLagerzeitbeschraenkungView.this.table.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                DlgLagerzeitbeschraenkungView.this.menuitemTeileverwendungTeil.setEnabled(true);
                DlgLagerzeitbeschraenkungView.this.menuitemEinzelteile.setEnabled(((MenuItemEinzelteile)DlgLagerzeitbeschraenkungView.this.menuitemEinzelteile).hatEinzelteile());
                DlgLagerzeitbeschraenkungView.this.menuitemInterpretation.setEnabled(((MenuItemInterpretation)DlgLagerzeitbeschraenkungView.this.menuitemInterpretation).hatInterpretation());
                DlgLagerzeitbeschraenkungView.this.menuPopup.show(DlgLagerzeitbeschraenkungView.this.table.getTable(), evt.getX(), evt.getY());
            }
        });
        this.table.setAllowSizingSmallerThanMinimumWidth(false);
        return this.table.getScrollPane();
    }

    private void uebernehmenInTeileliste() {
        Vector<GenericTeil> cTeile = new Vector<GenericTeil>();
        GenericTable jTable = this.table.getTable();
        int nCountSelectedRows = jTable.getSelectedRowCount();
        if (nCountSelectedRows == 0) {
            return;
        }
        int[] selectedRows = jTable.getSelectedRows();
        for (int i = 0; i < nCountSelectedRows; ++i) {
            int nRow = selectedRows[i];
            GenericTeil t = new GenericTeil();
            String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 1);
            String sBenennung = (String)this.tableModel.getValueAt(nRow, 2);
            String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
            t.setSachnummer(sSachnummer);
            String HGUG = sTeilenummer.trim().replaceAll(" +", "").substring(0, 4);
            t.setHG(HGUG.substring(0, 2));
            t.setUG(HGUG.substring(2, 4));
            t.setBenennung(sBenennung);
            cTeile.add(t);
        }
        this.uebernehmenInTeileliste(cTeile, false);
    }

    private void loadHauptgruppen(String sHgVon, String sHgBis) {
        this.model.resetAnzeigedaten();
        this.model.resetHauptgruppen();
        this.update();
        if (sHgVon != null && !sHgVon.equals("") && sHgVon.length() != 2 || sHgBis != null && !sHgBis.equals("") && sHgBis.length() != 2) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgUnvollstaendigeHg(), Resource.getInstance().getLagerzeitbeschraenkung(), 1);
            if (sHgVon != null && !sHgVon.equals("") && sHgVon.length() != 2) {
                this.tfHgVon.requestFocus();
            } else {
                this.tfHgBis.requestFocus();
            }
            return;
        }
        if (sHgVon != null && !sHgVon.equals("") && sHgBis != null && !sHgBis.equals("") && sHgVon.compareTo(sHgBis) > 0) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgVonBisHg(), Resource.getInstance().getLagerzeitbeschraenkung(), 1);
            this.tfHgBis.requestFocus();
            return;
        }
        this.controller.loadHauptgruppen(sHgVon, sHgBis);
        this.nIndexHg = 0;
        if (this.model.getHauptgruppen() == null) {
            return;
        }
        String sHg = this.model.getHauptgruppen().get(this.nIndexHg);
        this.searchLagerzeit(sHg);
        this.update();
    }

    private void loadTeilelistenIDs() {
        this.controller.loadTeilelistenIDs();
        this.bUpdateTeilelisten = true;
    }

    private void searchLagerzeit(String sHg) {
        this.model.resetAnzeigedaten();
        this.update();
        this.controller.performSearch(sHg);
    }

    private void searchLagerzeitNext() {
        ++this.nIndexHg;
        this.searchLagerzeit();
    }

    private void searchLagerzeitPrev() {
        --this.nIndexHg;
        this.searchLagerzeit();
    }

    private void searchLagerzeit() {
        if (this.model.getHauptgruppen() == null) {
            return;
        }
        String sHg = this.model.getHauptgruppen().get(this.nIndexHg);
        this.searchLagerzeit(sHg);
    }

    private void getTeileAnIndex(int nIndex) {
        this.model.resetAnzeigedaten();
        this.controller.getTeileAnIndex(nIndex);
        this.updateBlaetternInHgButton();
    }

    private void updateBlaetternInHgButton() {
        Collection<BlaetternButton> cButtonInfo = this.model.getButtonInfo();
        this.mButtonInHgIndexData.reset();
        this.buttonInHg1.setVisible(false);
        this.buttonInHg2.setVisible(false);
        this.buttonInHg3.setVisible(false);
        this.buttonInHg4.setVisible(false);
        this.buttonInHg5.setVisible(false);
        if (this.panErgebnisBlaetternButton == null) {
            return;
        }
        HIGLayout hl = (HIGLayout)this.panErgebnisBlaetternButton.getLayout();
        if (cButtonInfo == null || cButtonInfo.size() == 0) {
            this.panErgebnisBlaetternButton.setVisible(false);
        } else {
            this.panErgebnisBlaetternButton.setVisible(true);
        }
        hl.setColumnWidth(6, 0);
        hl.setColumnWidth(8, 0);
        hl.setColumnWidth(10, 0);
        hl.setColumnWidth(12, 0);
        if (cButtonInfo == null) {
            return;
        }
        for (BlaetternButton oButton : cButtonInfo) {
            if (oButton.getAction() == 1) {
                this.mButtonInHgIndexData.mnButtonInHgFirst = oButton.getIndex();
                this.buttonInHgFirst.setEnabled(oButton.isSensitiv());
                continue;
            }
            if (oButton.getAction() == 2) {
                this.mButtonInHgIndexData.mnButtonInHgPrev = oButton.getIndex();
                this.buttonInHgPrev.setEnabled(oButton.isSensitiv());
                continue;
            }
            if (oButton.getAction() == 3) {
                this.mButtonInHgIndexData.mnButtonInHg1 = oButton.getIndex();
                this.buttonInHg1.setVisible(true);
                this.buttonInHg1.setText(oButton.getAb() + " - " + oButton.getBis());
                continue;
            }
            if (oButton.getAction() == 4) {
                this.mButtonInHgIndexData.mnButtonInHg2 = oButton.getIndex();
                this.buttonInHg2.setVisible(true);
                this.buttonInHg2.setText(oButton.getAb() + " - " + oButton.getBis());
                hl.setColumnWidth(6, 5);
                continue;
            }
            if (oButton.getAction() == 5) {
                this.mButtonInHgIndexData.mnButtonInHg3 = oButton.getIndex();
                this.buttonInHg3.setVisible(true);
                this.buttonInHg3.setText(oButton.getAb() + " - " + oButton.getBis());
                hl.setColumnWidth(8, 5);
                continue;
            }
            if (oButton.getAction() == 6) {
                this.mButtonInHgIndexData.mnButtonInHg4 = oButton.getIndex();
                this.buttonInHg4.setVisible(true);
                this.buttonInHg4.setText(oButton.getAb() + " - " + oButton.getBis());
                hl.setColumnWidth(10, 5);
                continue;
            }
            if (oButton.getAction() == 7) {
                this.mButtonInHgIndexData.mnButtonInHg5 = oButton.getIndex();
                this.buttonInHg5.setVisible(true);
                this.buttonInHg5.setText(oButton.getAb() + " - " + oButton.getBis());
                hl.setColumnWidth(12, 5);
                continue;
            }
            if (oButton.getAction() == 8) {
                this.mButtonInHgIndexData.mnButtonInHgNext = oButton.getIndex();
                this.buttonInHgNext.setEnabled(oButton.isSensitiv());
                continue;
            }
            if (oButton.getAction() != 9) continue;
            this.mButtonInHgIndexData.mnButtonInHgLast = oButton.getIndex();
            this.buttonInHgLast.setEnabled(oButton.isSensitiv());
        }
        this.panErgebnisBlaetternButton.revalidate();
        this.panErgebnisBlaetternButton.validate();
        this.panErgebnisBlaetternButton.repaint();
        this.panErgebnis.repaint();
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        int nRow = this.table.getTable().getSelectedRow();
        String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 1);
        String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
        String sBenennungZusatz = (String)this.tableModel.getValueAt(nRow, 2);
        String sZusatz = (String)this.tableModel.getValueAt(nRow, 3);
        if (sZusatz != null && !sZusatz.equals("")) {
            sBenennungZusatz = sBenennungZusatz + "/" + sZusatz;
        }
        String sMarke = this.model.getMarke();
        String sProduktart = this.model.getProduktart();
        String sKatalogumfang = this.model.getKatalogumfang();
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennungZusatz);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumfang);
        return oHashMap;
    }

    private static class ButtonInHgIndexData {
        public int mnButtonInHgFirst = -1;
        public int mnButtonInHgPrev = -1;
        public int mnButtonInHg1 = -1;
        public int mnButtonInHg2 = -1;
        public int mnButtonInHg3 = -1;
        public int mnButtonInHg4 = -1;
        public int mnButtonInHg5 = -1;
        public int mnButtonInHgNext = -1;
        public int mnButtonInHgLast = -1;

        private ButtonInHgIndexData() {
        }

        public void reset() {
            this.mnButtonInHgFirst = -1;
            this.mnButtonInHgPrev = -1;
            this.mnButtonInHg1 = -1;
            this.mnButtonInHg2 = -1;
            this.mnButtonInHg3 = -1;
            this.mnButtonInHg4 = -1;
            this.mnButtonInHg5 = -1;
            this.mnButtonInHgNext = -1;
            this.mnButtonInHgLast = -1;
        }
    }

    protected class SuchenButtonActionListener
    implements ActionListener {
        protected SuchenButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            DlgLagerzeitbeschraenkungView.this.loadHauptgruppen(DlgLagerzeitbeschraenkungView.this.tfHgVon.getText(), DlgLagerzeitbeschraenkungView.this.tfHgBis.getText());
            DlgLagerzeitbeschraenkungView.this.updateBlaetternInHgButton();
        }
    }
}

