/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.normteile;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.DialogViewController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import webetk.app.GenericTeil;
import webetk.app.normteile.NormteilTO;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.zusatzinfo.normteile.DlgNormteileErgebnisseController;
import webetk.javaclient.dialog.zusatzinfo.normteile.DlgNormteileErgebnisseModel;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemEinzelteile;
import webetk.javaclient.menuitem.MenuItemInterpretation;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class DlgNormteileErgebnisseView
extends AbstractDlgMitTLView {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DlgNormteileErgebnisseView.class);
    private DlgNormteileErgebnisseController controller;
    private DlgNormteileErgebnisseModel model;
    private GenericTableModel tableModel;
    private GenericTable table;
    private JPanel panHeader;
    private JPanel panErgebnis;
    private JPopupMenu menuPopup = null;
    private JMenuItem menuitemTeileinformation = null;
    private JMenuItem menuitemTeileverwendungTeil = null;
    private JMenuItem menuitemInterpretation = null;
    private JMenuItem menuitemEinzelteile = null;
    private JMenuItem menuitemCopySachnummer = null;

    @Override
    protected void initComponents() {
        super.initComponents();
        this.panHeader = new HeaderPanel(Resource.getInstance().getNormteile(), ImageCache.getInstance().getHeaderIcon("normse"));
        this.panErgebnis = new TitledPanel(Resource.getInstance().getSuchergebnis());
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgNormteileErgebnisseView.this.uebernehmenInTeileliste();
            }
        });
        this.createLayout();
    }

    @Override
    public void initMenus() {
        this.menuPopup = new JPopupMenu();
        this.menuitemTeileinformation = new MenuItemTeileinformation(this);
        this.menuPopup.add(this.menuitemTeileinformation);
        this.menuitemTeileverwendungTeil = new MenuItemTeileverwendungTeil("normteile", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemTeileverwendungTeil);
        this.menuitemInterpretation = new MenuItemInterpretation("normteile", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemInterpretation);
        this.menuitemEinzelteile = new MenuItemEinzelteile("normteile", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemEinzelteile);
        this.menuPopup.addSeparator();
        this.menuitemCopySachnummer = new MenuItemCopySachnummer(this);
        this.menuPopup.add(this.menuitemCopySachnummer);
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        JScrollPane content = new JScrollPane(this.createContent());
        this.add((Component)content, "Center");
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        log.debug((Object)"init");
        super.init(oDlgModel, oDlgController);
        this.model = (DlgNormteileErgebnisseModel)oDlgModel;
        this.controller = (DlgNormteileErgebnisseController)oDlgController;
        this.initComponents();
        this.initMenus();
        this.loadTeilelistenIDs();
        this.update();
    }

    @Override
    public void update() {
        this.tableModel.removeAllRows();
        this.panErgebnis.setVisible(this.model.getAnzeigedaten() != null);
        List<NormteilTO> oAnzeigedaten = this.model.getAnzeigedaten();
        if (oAnzeigedaten == null || oAnzeigedaten.isEmpty()) {
            return;
        }
        for (NormteilTO normteilTO : oAnzeigedaten) {
            this.tableModel.addRow(new AbstractRow(new Object[]{null, null, normteilTO.getBenennung(), normteilTO.getZusatz(), normteilTO.getNormart(), normteilTO.getNormanummer(), normteilTO.getTeilenummer()}));
        }
        this.updateTeilelisten();
        this.panErgebnis.repaint();
    }

    private JPanel createContent() {
        JPanel contentPanel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(1, 1);
        HIGConstraints c = new HIGConstraints();
        contentPanel.setLayout(hl);
        contentPanel.add((Component)this.createErgebnisPanel(), c.rc(1, 1));
        return contentPanel;
    }

    private JPanel createErgebnisPanel() {
        int[] w_ergebnis = new int[]{10, 0, 20, 0, 20, 0, 20, 0, 10};
        int[] h_ergebnis = new int[]{10, 0, 5, 0, 5};
        HIGLayout layoutErgebnis = new HIGLayout(w_ergebnis, h_ergebnis);
        layoutErgebnis.setColumnWeight(8, 1);
        layoutErgebnis.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.panErgebnis.setLayout(layoutErgebnis);
        this.panErgebnis.add((Component)this.labTeileliste, c.rc(2, 2, "l"));
        this.panErgebnis.add((Component)this.comboTeileliste, c.rc(2, 4, "l"));
        this.panErgebnis.add((Component)this.buttonUebernehmen, c.rc(2, 6, "l"));
        this.panErgebnis.add((Component)this.buttonUeberpruefen, c.rc(2, 8, "l"));
        this.panErgebnis.add((Component)this.createTabelle(), c.rcwh(4, 2, 7, 1));
        return this.panErgebnis;
    }

    private JComponent createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
        tableConfig.addIconColumn("auto.gif", Resource.getInstance().getTeileverwendung());
        tableConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXXYYYY");
        tableConfig.addColumn(Resource.getInstance().getNormart(), 2, false, "XXXXXXYY");
        tableConfig.addColumn(Resource.getInstance().getNormnummer(), 2, false, "XXXXXXXXYY");
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "XX XX X XXX XXX");
        tableConfig.setUsePrototypeIcons(true);
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setWidth(20);
        GenericTableMouseEventListener listenerTeileinfo = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                ((MenuItemTeileinformation)DlgNormteileErgebnisseView.this.menuitemTeileinformation).showTeileinfo();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerTeileinfo, 0);
        GenericTableMouseEventListener listenerTeileverwendung = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                ((MenuItemTeileverwendungTeil)DlgNormteileErgebnisseView.this.menuitemTeileverwendungTeil).showTeileverwendungTeil();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerTeileverwendung, 1);
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (DlgNormteileErgebnisseView.this.table.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                DlgNormteileErgebnisseView.this.menuitemTeileverwendungTeil.setEnabled(true);
                DlgNormteileErgebnisseView.this.menuitemEinzelteile.setEnabled(((MenuItemEinzelteile)DlgNormteileErgebnisseView.this.menuitemEinzelteile).hatEinzelteile());
                DlgNormteileErgebnisseView.this.menuitemInterpretation.setEnabled(((MenuItemInterpretation)DlgNormteileErgebnisseView.this.menuitemInterpretation).hatInterpretation());
                DlgNormteileErgebnisseView.this.menuPopup.show(DlgNormteileErgebnisseView.this.table.getTable(), evt.getX(), evt.getY());
            }
        });
        this.table.setAllowSizingSmallerThanMinimumWidth(false);
        return this.table.getScrollPane();
    }

    private void uebernehmenInTeileliste() {
        Vector<GenericTeil> cTeile = new Vector<GenericTeil>();
        GenericTable jTable = this.table.getTable();
        int nCountSelectedRows = jTable.getSelectedRowCount();
        if (nCountSelectedRows == 0) {
            return;
        }
        int[] selectedRows = jTable.getSelectedRows();
        for (int i = 0; i < nCountSelectedRows; ++i) {
            int nRow = selectedRows[i];
            GenericTeil t = new GenericTeil();
            String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 6);
            String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
            String HGUG = sTeilenummer.trim().replaceAll(" +", "").substring(0, 4);
            t.setSachnummer(sSachnummer);
            t.setHG(HGUG.substring(0, 2));
            t.setUG(HGUG.substring(2, 4));
            t.setBenennung((String)this.tableModel.getValueAt(nRow, 2));
            cTeile.add(t);
        }
        this.uebernehmenInTeileliste(cTeile, false);
    }

    void loadTeilelistenIDs() {
        this.controller.loadTeilelistenIDs();
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        int nRow = this.table.getTable().getSelectedRow();
        String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 6);
        String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
        String sBenennungZusatz = (String)this.tableModel.getValueAt(nRow, 2);
        String sZusatz = (String)this.tableModel.getValueAt(nRow, 3);
        if (sZusatz != null && !sZusatz.equals("")) {
            sBenennungZusatz = sBenennungZusatz + "/" + sZusatz;
        }
        String sMarke = this.model.getMarke();
        String sProduktart = this.model.getProduktart();
        String sKatalogumang = this.model.getKatalogumfang();
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennungZusatz);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumang);
        return oHashMap;
    }
}

