/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.normteile;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import rasterviewer.imageloaders.ImageLoader;
import webetk.NoDataFoundException;
import webetk.app.normteile.NormteilBenennung;
import webetk.app.normteile.NormteilBildTO;
import webetk.javaclient.dialog.GrafikDisplay;
import webetk.javaclient.dialog.GrafikDisplayEvent;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.zusatzinfo.normteile.DlgNormteileSucheController;
import webetk.javaclient.dialog.zusatzinfo.normteile.DlgNormteileSucheModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;

public class DlgNormteileSucheView
extends AbstractDialogView {
    private static final long serialVersionUID = 1L;
    Logger log = Logger.getLogger(DlgNormteileSucheView.class);
    DlgNormteileSucheController controller;
    DlgNormteileSucheModel model;
    private GenericTableModel tableModel;
    private GenericTable table;
    JPanel panHeaderPanel;
    JPanel panSucheNormnummer;
    JTextField tfNormnummer;
    JLabel labNormnummer;
    JButtonEx buttonSucheNormnummer;
    JPanel panSucheGrafiken;
    GrafikDisplay dispGrafik;
    JScrollPane scrollpanDispGrafik;
    JPanel panSucheBenennung;
    private boolean initialUpdate = false;

    @Override
    public void initMenus() {
    }

    private void initComponents() {
        String sHeader2 = null;
        this.panHeaderPanel = new HeaderPanel(Resource.getInstance().getAuswahlNormteile(), sHeader2, ImageCache.getInstance().getHeaderIcon("norm"));
        this.panSucheNormnummer = this.createSucheNormNummerPanel();
        this.panSucheGrafiken = this.createSucheGrafikPanel();
        this.panSucheBenennung = this.createSucheBenennungPanel();
        int[] w = new int[]{0, 10, 0, 0, 0};
        int[] h = new int[]{0, 5, 0, 0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setRowWeight(4, 1);
        hl.setColumnWeight(5, 1);
        this.setLayout(hl);
        HIGConstraints c = new HIGConstraints();
        this.add((Component)this.panHeaderPanel, c.rcwh(1, 1, 5, 1, "tlbr"));
        this.add((Component)this.panSucheNormnummer, c.rc(3, 1, "tlrb"));
        this.add((Component)this.panSucheGrafiken, c.rc(4, 1, "tlbr"));
        this.add((Component)this.panSucheBenennung, c.rcwh(3, 3, 1, 2, "tlbr"));
    }

    private JPanel createSucheGrafikPanel() {
        TitledPanel panel = new TitledPanel(Resource.getInstance().getSucheUeberGrafik(), new BorderLayout());
        this.dispGrafik = new GrafikDisplay(3);
        this.dispGrafik.setShowMouseOver(true);
        this.dispGrafik.setBorder(UIHelper.getLightBorder());
        this.dispGrafik.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt instanceof GrafikDisplayEvent) {
                    int nGrafikIndex;
                    GrafikDisplayEvent e = (GrafikDisplayEvent)evt;
                    List<NormteilBildTO> oGrafiken = DlgNormteileSucheView.this.model.getGrafiken();
                    NormteilBildTO normteilBildTO = oGrafiken.get(nGrafikIndex = e.getClickedIndex());
                    if ("NNG".equals(normteilBildTO.getArt())) {
                        String sNormnummergruppe = normteilBildTO.getGrafik().getNummer();
                        DlgNormteileSucheView.this.loadGrafiken(sNormnummergruppe);
                        DlgNormteileSucheView.this.update();
                    } else {
                        String sNormnummer = normteilBildTO.getGrafik().getNummer();
                        DlgNormteileSucheView.this.searchNormteileByNormnummer(sNormnummer);
                    }
                }
            }
        });
        this.scrollpanDispGrafik = new JScrollPane(this.dispGrafik);
        panel.add(this.scrollpanDispGrafik);
        return panel;
    }

    private JPanel createSucheBenennungPanel() {
        TitledPanel panel = new TitledPanel(Resource.getInstance().getSucheUeberBenennung(), new BorderLayout());
        int[] w = new int[]{5, 0, 5};
        int[] h = new int[]{5, 0, 5};
        HIGLayout layout = new HIGLayout(w, h);
        layout.setColumnWeight(2, 1);
        layout.setRowWeight(2, 1);
        HIGConstraints c = new HIGConstraints();
        panel.setLayout(layout);
        panel.add((Component)this.createTabelle(), c.rc(2, 2, "lrtb"));
        return panel;
    }

    private JPanel createSucheNormNummerPanel() {
        TitledPanel panel = new TitledPanel(Resource.getInstance().getSucheUeberNormnummer());
        this.labNormnummer = new JLabel(Resource.getInstance().getNormnummer());
        this.tfNormnummer = new JTextField(8);
        this.tfNormnummer.setDocument(new EnhancedTextDocument(8, 0));
        this.buttonSucheNormnummer = new JButtonEx(Resource.getInstance().getSuchen(), ImageCache.getInstance().getIcon("search.gif"));
        this.tfNormnummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String sNormnummer = DlgNormteileSucheView.this.tfNormnummer.getText();
                DlgNormteileSucheView.this.searchNormteileByNormnummer(sNormnummer);
            }
        });
        this.buttonSucheNormnummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sNormnummer = DlgNormteileSucheView.this.tfNormnummer.getText();
                DlgNormteileSucheView.this.searchNormteileByNormnummer(sNormnummer);
            }
        });
        int[] w = new int[]{10, 0, 5, 0, 20, 0, 10};
        int[] h = new int[]{10, 0, 10};
        HIGLayout layout = new HIGLayout(w, h);
        layout.setColumnWeight(7, 1);
        HIGConstraints c = new HIGConstraints();
        panel.setLayout(layout);
        panel.add((Component)this.labNormnummer, c.rc(2, 2));
        panel.add((Component)this.tfNormnummer, c.rc(2, 4, "l"));
        panel.add((Component)this.buttonSucheNormnummer, c.rc(2, 6));
        return panel;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Iterator<JComponent> getMenus() {
        return null;
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        this.model = (DlgNormteileSucheModel)oDlgModel;
        this.controller = (DlgNormteileSucheController)oDlgController;
        this.initComponents();
        this.loadGrafiken(null);
        this.loadNormteilbenennungen();
        this.initialUpdate = true;
        this.update();
        this.initialUpdate = false;
    }

    private JComponent createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn(Resource.getInstance().getNormteilbenennung(), 2, false, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        GenericTableMouseEventListener listener = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                List<NormteilBenennung> oBenennungen = DlgNormteileSucheView.this.model.getNormteilbenennungen();
                String sBenennungId = oBenennungen.get(e.getRow()).getId();
                DlgNormteileSucheView.this.searchNormteileByBennung(sBenennungId);
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listener, 0);
        this.table.getTable().setSelectionMode(0);
        this.table.setAllowSizingSmallerThanMinimumWidth(false);
        return this.table.getScrollPane();
    }

    @Override
    public void setFocus() {
        this.tfNormnummer.requestFocus();
    }

    @Override
    public void update() {
        this.tableModel.removeAllRows();
        this.panSucheBenennung.setVisible(this.model.getNormteilbenennungen() != null && !this.model.getNormteilbenennungen().isEmpty());
        List<NormteilBenennung> oNormteilbenennungen = this.model.getNormteilbenennungen();
        if (oNormteilbenennungen == null) {
            return;
        }
        for (NormteilBenennung normteilBenennung : oNormteilbenennungen) {
            this.tableModel.addRow(new AbstractRow(new Object[]{normteilBenennung.getBenennung()}));
        }
        this.dispGrafik.removeAllGraphics();
        this.panSucheGrafiken.setVisible(this.model.getGrafiken() != null);
        List<NormteilBildTO> oGrafiken = this.model.getGrafiken();
        if (oGrafiken == null) {
            return;
        }
        ImageLoader loader = new ImageLoader();
        for (NormteilBildTO normteilBildTO : oGrafiken) {
            this.dispGrafik.addGrafik(loader.loadImage(normteilBildTO.getData(), 2, 0), normteilBildTO.getGrafik().getAltText(), null);
        }
        if (this.initialUpdate) {
            this.log.debug((Object)("initialUpdate: Setting PreferredSize isEventDispThread " + SwingUtilities.isEventDispatchThread()));
            Dimension d = this.dispGrafik.getPreferredSize();
            int scrollBarWidth = UIManager.getInt("ScrollBar.width");
            if (scrollBarWidth <= 0) {
                scrollBarWidth = 16;
            }
            d.width += scrollBarWidth + 5;
            this.scrollpanDispGrafik.setPreferredSize(d);
            this.scrollpanDispGrafik.revalidate();
        }
    }

    void loadGrafiken(String sNormnummergruppe) {
        this.model.resetGrafiken();
        this.update();
        this.controller.performLoadGrafiken(sNormnummergruppe);
    }

    void loadNormteilbenennungen() {
        this.model.resetNormteilbenennungen();
        this.update();
        this.controller.performLoadNormteilbenennungen();
    }

    void searchNormteileByNormnummer(String sNormnummer) {
        try {
            this.controller.performSearchByNormnummer(sNormnummer, this.tfNormnummer);
        }
        catch (NoDataFoundException e) {
            this.log.error((Object)"keine Ergebnisdaten gefunden!");
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getNormteile(), 1);
            return;
        }
        this.controller.notifyAllExitListeners();
    }

    void searchNormteileByBennung(String sBenennnungID) {
        try {
            this.controller.performSearchByBenennung(sBenennnungID);
        }
        catch (NoDataFoundException e) {
            this.log.error((Object)"keine Ergebnisdaten gefunden!");
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSucheNoResult(), Resource.getInstance().getNormteile(), 1);
            return;
        }
        this.controller.notifyAllExitListeners();
    }

    ByteArrayInputStream getAsStream(byte[] data) {
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }
}

