/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.notizuebersicht;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.zusatzinfo.notizuebersicht.DlgNotizUebersichtModel;
import webetk.javaclient.dialog.zusatzinfo.notizuebersicht.DlgNotizUebersichtView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgNotizUebersichtController
extends AbstractDialogViewController {
    Logger log = Logger.getLogger(DlgNotizUebersichtController.class);
    DlgNotizUebersichtView view = new DlgNotizUebersichtView();
    DlgNotizUebersichtModel model = new DlgNotizUebersichtModel();

    @Override
    public DialogView getDialogView() {
        this.log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    public boolean loadNotizen(String sHg, boolean bInit) {
        this.log.debug((Object)"Performing Load Notizuebersicht");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNotizen = new TrfHashMap(null);
        trfNotizen.setValue("hg", sHg);
        if (bInit) {
            trfNotizen.setValue("isinit", "isinit");
        }
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNotizen, Command.LOAD_NOTIZEN);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("DlgNotizUebersichtController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfNotizen.getError() != null) {
            if (trfNotizen.getError() instanceof NoDataFoundException) {
                this.log.error((Object)"keine Daten gefunden!", (Throwable)trfNotizen.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getNotizUebersicht(), 0);
                return false;
            }
            this.log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNotizen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfNotizen.getError().getMessage(), Resource.getInstance().getNotizUebersicht(), 0);
            return false;
        }
        this.model.storeAnzeigedaten((List)trfNotizen.getValue("teilenotiz"));
        String sCount = (String)trfNotizen.getValue("count");
        this.model.storeNotizenCount(Integer.parseInt(sCount));
        this.model.storeHgMin((String)trfNotizen.getValue("hgvon"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }
}

