/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.notizuebersicht;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import de.esg.commonclient.dialog.LimitedNumberField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import webetk.app.notizuebersicht.Teil;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.extras.teileinfo.Teilenotiz;
import webetk.javaclient.dialog.zusatzinfo.notizuebersicht.DlgNotizUebersichtController;
import webetk.javaclient.dialog.zusatzinfo.notizuebersicht.DlgNotizUebersichtModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemEinzelteile;
import webetk.javaclient.menuitem.MenuItemInterpretation;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class DlgNotizUebersichtView
extends AbstractDialogView {
    private static final long serialVersionUID = 1L;
    Logger log = Logger.getLogger(DlgNotizUebersichtView.class);
    DlgNotizUebersichtController controller;
    DlgNotizUebersichtModel model;
    GenericTableModel tableModel;
    GenericTable table;
    JScrollPane tableScrollpane;
    private JPanel panHeader;
    private JPanel panErgebnis;
    private JTextArea txtHinweis;
    private JLabel labHg;
    private JButtonEx buttonAnzeigen;
    private JButtonEx buttonAlleAnzeigen;
    private JTextField tfHg;
    private JPopupMenu menuPopup = null;
    private JMenuItem menuitemTeileinformation = null;
    private JMenuItem menuitemTeileverwendungTeil = null;
    private JMenuItem menuitemInterpretation = null;
    private JMenuItem menuitemEinzelteile = null;
    private JMenuItem menuitemTeilenotiz = null;
    private JMenuItem menuitemCopySachnummer = null;

    private void initComponents() {
        this.panHeader = new HeaderPanel(Resource.getInstance().getNotizUebersicht(), ImageCache.getInstance().getHeaderIcon("notizall"));
        this.panErgebnis = new TitledPanel(Resource.getInstance().getVorhandeneNotizen());
        this.txtHinweis = new JTextArea();
        this.txtHinweis.setEditable(false);
        this.txtHinweis.setLineWrap(true);
        this.txtHinweis.setWrapStyleWord(true);
        this.txtHinweis.setBackground(this.getBackground());
        this.labHg = new JLabel(Resource.getInstance().getHg());
        this.tfHg = new LimitedNumberField(2);
        this.tfHg.setDocument(new EnhancedTextDocument(2, 1));
        this.buttonAnzeigen = new JButtonEx(Resource.getInstance().getAnzeigen());
        this.buttonAlleAnzeigen = new JButtonEx(Resource.getInstance().getAlleAnzeigen());
        this.tfHg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgNotizUebersichtView.this.loadNotizen(DlgNotizUebersichtView.this.tfHg.getText(), false);
                DlgNotizUebersichtView.this.update();
            }
        });
        this.buttonAnzeigen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNotizUebersichtView.this.loadNotizen(DlgNotizUebersichtView.this.tfHg.getText(), false);
                DlgNotizUebersichtView.this.update();
            }
        });
        this.buttonAlleAnzeigen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNotizUebersichtView.this.loadNotizen(null, false);
                DlgNotizUebersichtView.this.update();
            }
        });
        this.createLayout();
    }

    @Override
    public void initMenus() {
        this.menuPopup = new JPopupMenu();
        this.menuitemTeileinformation = new MenuItemTeileinformation(this);
        this.menuPopup.add(this.menuitemTeileinformation);
        this.menuitemTeileverwendungTeil = new MenuItemTeileverwendungTeil("notizuebersicht", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemTeileverwendungTeil);
        this.menuitemInterpretation = new MenuItemInterpretation("notizuebersicht", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemInterpretation);
        this.menuitemEinzelteile = new MenuItemEinzelteile("notizuebersicht", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemEinzelteile);
        this.menuitemTeilenotiz = new JMenuItem(Resource.getInstance().getDetaillierteNotizansicht());
        this.menuPopup.add(this.menuitemTeilenotiz);
        this.menuPopup.addSeparator();
        this.menuitemCopySachnummer = new MenuItemCopySachnummer(this);
        this.menuPopup.add(this.menuitemCopySachnummer);
        this.menuitemTeilenotiz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNotizUebersichtView.this.showTeilenotiz(DlgNotizUebersichtView.this.table.getTable().getSelectedRow());
            }
        });
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        JScrollPane content = new JScrollPane(this.createContent());
        this.add((Component)content, "Center");
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        this.log.debug((Object)"init");
        this.model = (DlgNotizUebersichtModel)oDlgModel;
        this.controller = (DlgNotizUebersichtController)oDlgController;
        this.initComponents();
        this.initMenus();
        this.update();
    }

    @Override
    public void update() {
        if (this.panErgebnis == null) {
            return;
        }
        this.tableModel.removeAllRows();
        this.tableScrollpane.setVisible(this.model.getTeile() != null && !this.model.getTeile().isEmpty());
        List<Teil> teile = this.model.getTeile();
        if (teile == null || teile.isEmpty()) {
            return;
        }
        int nCount = this.model.getNotizenCount();
        if ((long)nCount > 50L) {
            String sCount = Integer.toString(nCount);
            String sString = Resource.getInstance().getSatzZuVieleNotizen();
            sString = StringUtils.substituteStringStraight(sString, "{0,number,integer}", sCount);
            String sHgMin = this.model.getHgMin();
            sString = StringUtils.substituteStringStraight(sString, "{1}", sHgMin);
            this.txtHinweis.setText(sString);
        }
        for (Teil teil : teile) {
            this.tableModel.addRow(new AbstractRow(new Object[]{null, null, teil.getTeilenummer(), teil.getBenennung(), teil.getGueltigBis()}));
        }
        this.panErgebnis.repaint();
    }

    private JPanel createContent() {
        JPanel contentPanel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(1, 1);
        HIGConstraints c = new HIGConstraints();
        contentPanel.setLayout(hl);
        contentPanel.add((Component)this.createpanErgebnis(), c.rc(1, 1));
        return contentPanel;
    }

    private JPanel createpanErgebnis() {
        int[] w_ergebnis = new int[]{10, 0, 10, 0, 10, -8, 10, -6, 0, 10};
        int[] h_ergebnis = new int[]{10, 0, 5, 0, 10, 0, 10};
        HIGLayout layoutErgebnis = new HIGLayout(w_ergebnis, h_ergebnis);
        layoutErgebnis.setColumnWeight(9, 1);
        layoutErgebnis.setRowWeight(6, 1);
        HIGConstraints c = new HIGConstraints();
        this.panErgebnis.setLayout(layoutErgebnis);
        if ((long)this.model.getNotizenCount() > 50L) {
            this.panErgebnis.add((Component)this.txtHinweis, c.rcwh(2, 2, 8, 1, "ltbr"));
            this.panErgebnis.add((Component)this.labHg, c.rc(4, 2, "lr"));
            this.panErgebnis.add((Component)this.tfHg, c.rc(4, 4, "lr"));
            this.panErgebnis.add((Component)this.buttonAnzeigen, c.rc(4, 6, "lr"));
            this.panErgebnis.add((Component)this.buttonAlleAnzeigen, c.rc(4, 8, "lr"));
        } else {
            layoutErgebnis.setRowHeight(3, 0);
            layoutErgebnis.setRowHeight(5, 0);
        }
        this.panErgebnis.add((Component)this.createTabelle(), c.rcwh(6, 2, 8, 1, "ltbr"));
        return this.panErgebnis;
    }

    private JComponent createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
        tableConfig.addIconColumn("notiz.gif", Resource.getInstance().getTeilenotiz());
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "XX XX X XXX XXXXX");
        tableConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn(Resource.getInstance().getGueltigBis(), 2, true, "SEPTEMBER 2003XXXXX");
        tableConfig.setUsePrototypeIcons(true);
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(1).setWidth(20);
        GenericTableMouseEventListener listenerTeileinfo = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                ((MenuItemTeileinformation)DlgNotizUebersichtView.this.menuitemTeileinformation).showTeileinfo();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerTeileinfo, 0);
        GenericTableMouseEventListener listenerTeilenotiz = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                DlgNotizUebersichtView.this.showTeilenotiz(e.getRow());
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerTeilenotiz, 1);
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (DlgNotizUebersichtView.this.table.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                DlgNotizUebersichtView.this.menuitemTeileverwendungTeil.setEnabled(true);
                DlgNotizUebersichtView.this.menuitemEinzelteile.setEnabled(((MenuItemEinzelteile)DlgNotizUebersichtView.this.menuitemEinzelteile).hatEinzelteile());
                DlgNotizUebersichtView.this.menuitemInterpretation.setEnabled(((MenuItemInterpretation)DlgNotizUebersichtView.this.menuitemInterpretation).hatInterpretation());
                DlgNotizUebersichtView.this.menuPopup.show(DlgNotizUebersichtView.this.table.getTable(), evt.getX(), evt.getY());
            }
        });
        this.table.setAllowSizingSmallerThanMinimumWidth(false);
        this.tableScrollpane = this.table.getScrollPane();
        return this.tableScrollpane;
    }

    private void showTeilenotiz(int nRow) {
        String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 2);
        Teilenotiz dlgHinweis = new Teilenotiz(MainView.getInstance(), sTeilenummer);
        dlgHinweis.setVisible(true);
    }

    boolean loadNotizen(String sHg, boolean bInit) {
        if (sHg != null && sHg.length() != 2) {
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getMsgUnvollstaendigeHg(), Resource.getInstance().getNotizUebersicht(), 1);
            this.tfHg.requestFocus();
            return false;
        }
        this.model.resetAnzeigedaten();
        return this.controller.loadNotizen(sHg, bInit);
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        int nRow = this.table.getTable().getSelectedRow();
        String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 2);
        String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
        String sBenennungZusatz = (String)this.tableModel.getValueAt(nRow, 3);
        String sZusatz = (String)this.tableModel.getValueAt(nRow, 4);
        if (sZusatz != null && !sZusatz.equals("")) {
            sBenennungZusatz = sBenennungZusatz + "/" + sZusatz;
        }
        String sMarke = GlobalObjects.getInstance().getSessionInfo().getSettings().getMarke();
        String sProduktart = GlobalObjects.getInstance().getSessionInfo().getSettings().getProduktart();
        String sKatalogumfang = GlobalObjects.getInstance().getSessionInfo().getSettings().getKatalogumfang();
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennungZusatz);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumfang);
        return oHashMap;
    }
}

