/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.einzelteile;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.einzelteile.EinzelteileSatzModel;
import webetk.javaclient.dialog.zusatzinfo.satzeinzelteile.einzelteile.EinzelteileSatzView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class EinzelteileSatzController
extends AbstractDlgMitTLController {
    private static Logger log = Logger.getLogger(EinzelteileSatzController.class);
    private EinzelteileSatzView view = new EinzelteileSatzView();
    private EinzelteileSatzModel model = new EinzelteileSatzModel();

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        super.init(this.model);
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    protected void performLoad(String sSachnummer) {
        log.debug((Object)"Performing Load Einzelteile ");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfEinzelteile = new TrfHashMap(null);
        trfEinzelteile.setValue("sachnummer", sSachnummer);
        trfEinzelteile.setValue("marke", this.model.getMarke());
        trfEinzelteile.setValue("produktart", this.model.getProduktart());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfEinzelteile, Command.LOAD_SATZEINZEL_EINZELTEILE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("EinzelteileSatzController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfEinzelteile.getError() != null) {
            if (trfEinzelteile.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Einzelteile gefunden!", (Throwable)trfEinzelteile.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getSatzEinzelteile(), 0);
                return;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfEinzelteile.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfEinzelteile.getError().getMessage(), Resource.getInstance().getSatzEinzelteile(), 0);
            return;
        }
        this.model.storeAnzeigedaten((List)trfEinzelteile.getValue("zusatz_infos"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    public static boolean hatEinzelteile(String sSachnummer) {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfEinzelteile = new TrfHashMap(null);
        trfEinzelteile.setValue("sachnummer", sSachnummer);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfEinzelteile, Command.LOAD_SATZEINZEL_EINZELTEILE);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfEinzelteile.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return trfEinzelteile != null;
    }
}

