/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.technischeliteratur;

import com.bmw.tetis.psi.common.PsiCommunicationException;
import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.DialogViewController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.communication.asap.AsapAppletComCtrl;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.zusatzinfo.technischeliteratur.DatenZeile;
import webetk.javaclient.dialog.zusatzinfo.technischeliteratur.DlgTechnischeLiteraturErgebnisseController;
import webetk.javaclient.dialog.zusatzinfo.technischeliteratur.DlgTechnischeLiteraturErgebnisseModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.WebETKTheme;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemEinzelteile;
import webetk.javaclient.menuitem.MenuItemInterpretation;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class DlgTechnischeLiteraturErgebnisseView
extends AbstractDlgMitTLView {
    private static final long serialVersionUID = 1L;
    private DlgTechnischeLiteraturErgebnisseController controller;
    private DlgTechnischeLiteraturErgebnisseModel model;
    private GenericTableModel tableModel;
    private GenericTable table;
    private JPanel panHeader;
    private JPanel panErgebnis;
    private JPopupMenu menuPopup = null;
    private JMenuItem menuitemTeileinformation = null;
    private JMenuItem menuitemTeileverwendungTeil = null;
    private JMenuItem menuitemInterpretation = null;
    private JMenuItem menuitemEinzelteile = null;
    private JMenuItem menuitemCopySachnummer = null;
    private ArrayList<JComponent> menuCollection = new ArrayList();

    @Override
    protected void initComponents() {
        super.initComponents();
        String sHeader2 = Resource.getInstance().getKeinFahrzeugIdentifiziert();
        if (GlobalObjects.getInstance().getEtkData().getFzgSucheInfo() != null) {
            sHeader2 = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo().getFzgIdString();
        }
        this.panHeader = new HeaderPanel(Resource.getInstance().getSuchergebnisseTechnischeLiteratur(), sHeader2, ImageCache.getInstance().getHeaderIcon("techlitse"));
        this.panErgebnis = new TitledPanel(Resource.getInstance().getErgebnisseTechnischerLiteratur());
        this.buttonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgTechnischeLiteraturErgebnisseView.this.uebernehmenInTeileliste();
            }
        });
        this.createLayout();
    }

    @Override
    public void initMenus() {
        this.menuPopup = new JPopupMenu();
        this.menuitemTeileinformation = new MenuItemTeileinformation(this);
        this.menuPopup.add(this.menuitemTeileinformation);
        this.menuitemTeileverwendungTeil = new MenuItemTeileverwendungTeil("technische_literatur", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemTeileverwendungTeil);
        this.menuitemInterpretation = new MenuItemInterpretation("technische_literatur", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemInterpretation);
        this.menuitemEinzelteile = new MenuItemEinzelteile("technische_literatur", this.controller, this.model, this);
        this.menuPopup.add(this.menuitemEinzelteile);
        this.menuPopup.addSeparator();
        this.menuitemCopySachnummer = new MenuItemCopySachnummer(this);
        this.menuPopup.add(this.menuitemCopySachnummer);
        ImageIcon icon = ImageCache.getInstance().getIcon("A_a_16x32.jpg");
        JButton buttonSchriftart = new JButton(icon);
        buttonSchriftart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean bSmallFont = DlgTechnischeLiteraturErgebnisseView.this.model.getSmallFont();
                bSmallFont = !bSmallFont;
                DlgTechnischeLiteraturErgebnisseView.this.model.setSmallFont(bSmallFont);
                WebETKTheme.useGrosseSchriftart(!bSmallFont);
                DlgTechnischeLiteraturErgebnisseView.this.controller.reinit();
            }
        });
        buttonSchriftart.setToolTipText(Resource.getInstance().getSchriftgroesseUmschalten());
        this.menuCollection.add(buttonSchriftart);
    }

    @Override
    public Iterator<JComponent> getMenus() {
        return this.menuCollection.iterator();
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        JScrollPane content = new JScrollPane(this.createContent());
        this.add((Component)content, "Center");
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        super.init(oDlgModel, oDlgController);
        this.model = (DlgTechnischeLiteraturErgebnisseModel)oDlgModel;
        this.controller = (DlgTechnischeLiteraturErgebnisseController)oDlgController;
        this.initComponents();
        this.initMenus();
        this.loadTeilelistenIDs();
        this.update();
    }

    @Override
    public void update() {
        this.tableModel.removeAllRows();
        this.panErgebnis.setVisible(this.model.getAnzeigedaten() != null);
        TrfHashMap oAnzeigedaten = this.model.getAnzeigedaten();
        if (oAnzeigedaten == null) {
            return;
        }
        int i = 1;
        while (oAnzeigedaten.getValue(i + "benennung") != null) {
            String sTeilenummer = (String)oAnzeigedaten.getValue(i + "teilenummer");
            String sBenennung = (String)oAnzeigedaten.getValue(i + "benennung");
            String sKommentar = (String)oAnzeigedaten.getValue(i + "kommentar");
            String sZusatz = (String)oAnzeigedaten.getValue(i + "zusatz");
            String sEinsatzdatum = (String)oAnzeigedaten.getValue(i + "einsatzdatum");
            String sAuslaufdatum = (String)oAnzeigedaten.getValue(i + "auslaufdatum");
            String sMAM = (String)oAnzeigedaten.getValue(i + "mam");
            String sIsEBA = (String)oAnzeigedaten.getValue(i + "iseba");
            boolean bIsEBA = sIsEBA.equals("true");
            this.tableModel.addRow(new DatenZeile(sTeilenummer, sBenennung, sKommentar, sZusatz, sEinsatzdatum, sAuslaufdatum, sMAM, bIsEBA));
            ++i;
        }
        this.updateTeilelisten();
        this.panErgebnis.repaint();
    }

    private JPanel createContent() {
        JPanel contentPanel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(1, 1);
        HIGConstraints c = new HIGConstraints();
        contentPanel.setLayout(hl);
        contentPanel.add((Component)this.createErgebnisPanel(), c.rc(1, 1));
        return contentPanel;
    }

    private JPanel createErgebnisPanel() {
        int[] w_ergebnis = new int[]{10, 0, 20, 0, 20, 0, 20, 0, 10};
        int[] h_ergebnis = new int[]{10, 0, 5, 0, 5};
        HIGLayout layoutErgebnis = new HIGLayout(w_ergebnis, h_ergebnis);
        layoutErgebnis.setColumnWeight(8, 1);
        layoutErgebnis.setRowWeight(4, 1);
        HIGConstraints c = new HIGConstraints();
        this.panErgebnis.setLayout(layoutErgebnis);
        this.panErgebnis.add((Component)this.labTeileliste, c.rc(2, 2, "l"));
        this.panErgebnis.add((Component)this.comboTeileliste, c.rc(2, 4, "l"));
        this.panErgebnis.add((Component)this.buttonUebernehmen, c.rc(2, 6, "l"));
        this.panErgebnis.add((Component)this.buttonUeberpruefen, c.rc(2, 8, "l"));
        this.panErgebnis.add((Component)this.createTabelle(), c.rcwh(4, 2, 7, 1));
        return this.panErgebnis;
    }

    private JComponent createTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addIconColumn("info.gif", Resource.getInstance().getTeileinformation());
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "11 11 1 743 118");
        tableConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXY");
        tableConfig.addColumn(Resource.getInstance().getKommentar(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXY");
        tableConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXXYY");
        tableConfig.addColumn(Resource.getInstance().getNueVon(), 0, false, "05/99");
        tableConfig.setHeaderTooltip(5, Resource.getInstance().getEinsatzdatumTooltip());
        tableConfig.addColumn(Resource.getInstance().getNueBis(), 0, false, "05/99");
        tableConfig.setHeaderTooltip(6, Resource.getInstance().getAuslaufdatumTooltip());
        tableConfig.addColumn(Resource.getInstance().getNueMam(), 0, false, "000");
        tableConfig.setHeaderTooltip(7, Resource.getInstance().getMindestabgabemenge());
        tableConfig.setUsePrototypeIcons(true);
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getTable().getColumnModel().getColumn(0).setMinWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getTable().getColumnModel().getColumn(0).setWidth(20);
        GenericTableMouseEventListener listenerTeileinfo = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                ((MenuItemTeileinformation)DlgTechnischeLiteraturErgebnisseView.this.menuitemTeileinformation).showTeileinfo();
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerTeileinfo, 0);
        GenericTableMouseEventListener listenerTeilenummer = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                DlgTechnischeLiteraturErgebnisseView.this.showEBA(e.getRow());
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerTeilenummer, 1);
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (DlgTechnischeLiteraturErgebnisseView.this.table.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                DlgTechnischeLiteraturErgebnisseView.this.menuitemTeileverwendungTeil.setEnabled(true);
                DlgTechnischeLiteraturErgebnisseView.this.menuitemEinzelteile.setEnabled(((MenuItemEinzelteile)DlgTechnischeLiteraturErgebnisseView.this.menuitemEinzelteile).hatEinzelteile());
                DlgTechnischeLiteraturErgebnisseView.this.menuitemInterpretation.setEnabled(((MenuItemInterpretation)DlgTechnischeLiteraturErgebnisseView.this.menuitemInterpretation).hatInterpretation());
                DlgTechnischeLiteraturErgebnisseView.this.menuPopup.show(DlgTechnischeLiteraturErgebnisseView.this.table.getTable(), evt.getX(), evt.getY());
            }
        });
        this.table.setAllowSizingSmallerThanMinimumWidth(false);
        return this.table.getScrollPane();
    }

    void loadTeilelistenIDs() {
        this.controller.loadTeilelistenIDs();
    }

    private void uebernehmenInTeileliste() {
        Vector<String> cTeile = new Vector<String>();
        GenericTable jTable = this.table.getTable();
        int nCountSelectedRows = jTable.getSelectedRowCount();
        if (nCountSelectedRows == 0) {
            return;
        }
        int[] selectedRows = jTable.getSelectedRows();
        for (int i = 0; i < nCountSelectedRows; ++i) {
            int nRow = selectedRows[i];
            String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 1);
            String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
            cTeile.add(sSachnummer);
        }
        this.uebernehmenInTeileliste(cTeile, false);
    }

    private void showEBA(int nRow) {
        if (!((DatenZeile)this.tableModel.getRow(nRow)).isEBA()) {
            return;
        }
        String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 1);
        String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
        try {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            AsapAppletComCtrl.getInstance().invokeEba(sSachnummer);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (PsiCommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerVerbindungAsap(), Resource.getInstance().getTechnischeLiteratur(), 0);
        }
    }

    @Override
    public void onExit() {
        this.controller.onExit();
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        int nRow = this.table.getTable().getSelectedRow();
        String sTeilenummer = (String)this.tableModel.getValueAt(nRow, 1);
        String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
        String sBenennungZusatz = (String)this.tableModel.getValueAt(nRow, 2);
        String sZusatz = (String)this.tableModel.getValueAt(nRow, 4);
        if (sZusatz != null && !sZusatz.equals("")) {
            sBenennungZusatz = sBenennungZusatz + "/" + sZusatz;
        }
        String sMarke = this.model.getMarke();
        String sProduktart = this.model.getProduktart();
        String sKatalogumfang = this.model.getKatalogumfang();
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennungZusatz);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        oHashMap.put("katalogumfang", sKatalogumfang);
        return oHashMap;
    }
}

