/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.technischeliteratur;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.zusatzinfo.technischeliteratur.DlgTechnischeLiteraturSucheModel;
import webetk.javaclient.dialog.zusatzinfo.technischeliteratur.DlgTechnischeLiteraturSucheView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgTechnischeLiteraturSucheController
extends AbstractDialogViewController {
    private static Logger log = Logger.getLogger(DlgTechnischeLiteraturSucheController.class);
    private DlgTechnischeLiteraturSucheView view = new DlgTechnischeLiteraturSucheView();
    private DlgTechnischeLiteraturSucheModel model = new DlgTechnischeLiteraturSucheModel();

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData exitData = new WorkflowStateData();
        exitData.setWert("exitaction", this.model.getExitAction());
        exitData.setWert("daten", this.model.getTechnischeLiteratur());
        return exitData;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    void loadSprachen() {
        log.debug((Object)"Performing Load TL-Sprachen");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfSprachen = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfSprachen, Command.LOAD_TECHLIT_SPRACHEN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgTechnischeLiteraturSucheController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfSprachen.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfSprachen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfSprachen.getError().getMessage(), Resource.getInstance().getTechnischeLiteratur(), 0);
            return;
        }
        this.model.storeSprachen(trfSprachen);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    void loadFgs() {
        log.debug((Object)"Performing Load FGs");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfAnzeigdaten = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfAnzeigdaten, Command.LOAD_TECHLIT_FGS);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgTechnischeLiteraturSucheController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfAnzeigdaten.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfAnzeigdaten.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfAnzeigdaten.getError().getMessage(), Resource.getInstance().getTechnischeLiteratur(), 0);
            return;
        }
        this.model.storeAnzeigedaten(trfAnzeigdaten);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    void loadTechnischeLiteratur(String sFg, String sSpracheTL) throws NoDataFoundException {
        log.debug((Object)"Performing Load Technische Literatur");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTechnischeLiteratur = new TrfHashMap(null);
        trfTechnischeLiteratur.setValue("fg", sFg);
        trfTechnischeLiteratur.setValue("sprache_tl", sSpracheTL);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTechnischeLiteratur, Command.LOAD_TECHLIT_ERGEBNIS);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgTechnischeLiteraturSucheController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTechnischeLiteratur.getError() != null) {
            Exception e = trfTechnischeLiteratur.getError();
            if (e instanceof NoDataFoundException) {
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                throw new NoDataFoundException("keine Ergebnisdaten gefunden!");
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTechnischeLiteratur.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getTechnischeLiteratur(), 0);
            return;
        }
        this.model.storeTechnischeLiteratur(trfTechnischeLiteratur);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

