/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.teileersetzung;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import java.awt.Cursor;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.zusatzinfo.teileersetzung.TeileersetzungModel;
import webetk.javaclient.dialog.zusatzinfo.teileersetzung.TeileersetzungView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class TeileersetzungController
extends AbstractDlgMitTLController {
    private static Logger log = Logger.getLogger(TeileersetzungController.class);
    private TeileersetzungView view = new TeileersetzungView();
    private TeileersetzungModel model = new TeileersetzungModel();

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        super.init(this.model);
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    protected void loadHauptgruppen() {
        log.debug((Object)"Performing Search Teileersetzung (Hauptgruppen)");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfHgs = new TrfHashMap(null);
        trfHgs.setValue("hgvon", this.model.getHgVon());
        trfHgs.setValue("hgbis", this.model.getHgBis());
        trfHgs.setValue("modellspaltenids", this.model.getModellspaltenIDs());
        trfHgs.setValue("lenkung", this.model.getLenkung());
        trfHgs.setValue("tag", this.model.getDatumAbTag());
        trfHgs.setValue("monat", this.model.getDatumAbMonat());
        trfHgs.setValue("jahr", this.model.getDatumAbJahr());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHgs, Command.LOAD_TEILEERSETZUNG_HGS);
        }
        catch (CommunicationException ex) {
            log.error((Object)GlobalObjects.getInstance().getServerUrl(), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfHgs.getError() != null) {
            if (trfHgs.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Daten gefunden!", (Throwable)trfHgs.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfHgs.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfHgs.getError().getMessage(), Resource.getInstance().getSuchergebnisseTeileersetzung(), 0);
            return;
        }
        this.model.storeHauptgruppen((List)trfHgs.getValue("hgs"));
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void performSearch(String sHg) {
        log.debug((Object)"Performing Search Teileersetzung");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTeileersetzung = new TrfHashMap(null);
        trfTeileersetzung.setValue("hg", sHg);
        trfTeileersetzung.setValue("modellspaltenids", this.model.getModellspaltenIDs());
        trfTeileersetzung.setValue("lenkung", this.model.getLenkung());
        trfTeileersetzung.setValue("tag", this.model.getDatumAbTag());
        trfTeileersetzung.setValue("monat", this.model.getDatumAbMonat());
        trfTeileersetzung.setValue("jahr", this.model.getDatumAbJahr());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTeileersetzung, Command.LOAD_TEILEERSETZUNG_ZU_HG);
        }
        catch (CommunicationException ex) {
            log.error((Object)("TeileersetzungController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTeileersetzung.getError() != null) {
            if (trfTeileersetzung.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Daten gefunden!", (Throwable)trfTeileersetzung.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getSuchergebnisseTeileersetzung(), 1);
                return;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTeileersetzung.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfTeileersetzung.getError().getMessage(), Resource.getInstance().getSuchergebnisseTeileersetzung(), 0);
            return;
        }
        this.model.storeAnzeigedaten((List)trfTeileersetzung.getValue("teilersetzung_teile"));
        this.model.storeHgAkt((String)trfTeileersetzung.getValue("hg"));
        Collection cButtons = (Collection)trfTeileersetzung.getValue("buttons");
        this.model.storeButtonInfo(cButtons);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void getTeileAnIndex(int nIndex) {
        log.debug((Object)"Performing get Teile Teileersetzung (At Index) ");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfTeileersetzung = new TrfHashMap(null);
        String sIndex = Integer.toString(nIndex);
        trfTeileersetzung.setValue("index", sIndex);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfTeileersetzung, Command.LOAD_TEILEERSETZUNG_ZU_HG_AT_INDEX);
        }
        catch (CommunicationException ex) {
            log.error((Object)("TeileersetzungController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfTeileersetzung.getError() != null) {
            if (trfTeileersetzung.getError() instanceof NoDataFoundException) {
                log.error((Object)"keine Daten gefunden!", (Throwable)trfTeileersetzung.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getSuchergebnisseTeileersetzung(), 1);
                return;
            }
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfTeileersetzung.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfTeileersetzung.getError().getMessage(), Resource.getInstance().getSuchergebnisseTeileersetzung(), 0);
            return;
        }
        this.model.storeAnzeigedaten((List)trfTeileersetzung.getValue("teilersetzung_teile"));
        Collection cButtons = (Collection)trfTeileersetzung.getValue("buttons");
        this.model.storeButtonInfo(cButtons);
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

