/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.valueline;

import de.esg.commonclient.GlobalObjects;
import java.util.Collection;
import java.util.HashMap;
import webetk.app.SearchBTETeile;
import webetk.app.teilevwdgteil.Baureihe;
import webetk.app.teilevwdgteil.Modellspalte;
import webetk.app.valueline.Hg;
import webetk.app.valueline.ValueLineSatz;
import webetk.javaclient.dialog.AbstractDlgMitTLModel;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.mrkprd.Produkte;
import webetk.utils.StringUtils;

public class ValueLineModel
extends AbstractDlgMitTLModel {
    private String msUmfang = null;
    public static final String SUCHART_SAETZE = "saetze";
    public static final String SUCHART_BIDTAFELN = "bildtafeln";
    public static final String SUCHART_TEILENUMMERN = "teilenummern";
    private String msProduktart = null;
    private Collection<Hg> mHgs;
    private String mExpandedHg = null;
    private HashMap<String, Collection<ValueLineSatz>> mSaetze = new HashMap();
    private Collection<Baureihe> mBaureihen;
    private String mExpandedBaureihe = null;
    private HashMap<String, Collection<Modellspalte>> mBildtafeln = new HashMap();
    private Collection<SearchBTETeile.PartOrBTE> mTeilenummern;

    @Override
    public void init(WorkflowStateData oWFStateData) {
        super.init(oWFStateData);
        String sMarke = (String)oWFStateData.getWert("satz_marke");
        if (sMarke == null) {
            sMarke = GlobalObjects.getInstance().getSessionInfo().getMarke();
        }
        this.setMarke(sMarke);
        this.msProduktart = (String)oWFStateData.getWert("satz_produktart");
        if (this.msProduktart == null) {
            this.msProduktart = GlobalObjects.getInstance().getSessionInfo().getProdukart();
        }
    }

    public String getProduktart() {
        return this.msProduktart;
    }

    public boolean isPKW() {
        return this.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
    }

    public void setProduktart(String sProduktart) {
        this.msProduktart = sProduktart;
    }

    public String getUmfang() {
        return this.msUmfang;
    }

    public void setUmfang(String sUmfang) {
        this.msUmfang = sUmfang;
    }

    public Collection<Hg> getHgs() {
        return this.mHgs;
    }

    public void setHgs(Collection<Hg> hgs) {
        this.mHgs = hgs;
    }

    public Collection<ValueLineSatz> getSaetze(String hg) {
        if (this.mSaetze == null) {
            return null;
        }
        return this.mSaetze.get(hg);
    }

    public void putSaetze(String hg, Collection<ValueLineSatz> saetze) {
        this.mSaetze.put(hg, saetze);
    }

    public String getExpandedHg() {
        return this.mExpandedHg;
    }

    public void setExpandedHg(String expandedHg) {
        this.mExpandedHg = expandedHg;
    }

    public Collection<Baureihe> getBaureihen() {
        return this.mBaureihen;
    }

    public void setBaureihen(Collection<Baureihe> baureihen) {
        this.mBaureihen = baureihen;
    }

    public String getExpandedBaureihe() {
        return this.mExpandedBaureihe;
    }

    public void setExpandedBaureihe(String expandedBaureihe) {
        this.mExpandedBaureihe = expandedBaureihe;
    }

    public Collection<Modellspalte> getBildtafeln(String baureihe) {
        if (this.mBildtafeln == null) {
            return null;
        }
        return this.mBildtafeln.get(baureihe);
    }

    public void putBildtafeln(String baureihe, Collection<Modellspalte> bildtafeln) {
        this.mBildtafeln.put(baureihe, bildtafeln);
    }

    public Collection<SearchBTETeile.PartOrBTE> getTeilenummern() {
        return this.mTeilenummern;
    }

    public void setTeilenummern(Collection<SearchBTETeile.PartOrBTE> teilenummern) {
        this.mTeilenummern = teilenummern;
    }

    public Hg ermittleHgZuIndex(int indGesucht) {
        if (this.mHgs == null) {
            return null;
        }
        int indAktuell = -1;
        for (Hg hg : this.mHgs) {
            if (++indAktuell == indGesucht) {
                return hg;
            }
            if (hg.getHg().equals(this.mExpandedHg)) {
                indAktuell += this.getSaetze(hg.getHg()).size();
            }
            if (indAktuell < indGesucht) continue;
            return null;
        }
        return null;
    }

    public ValueLineSatz ermittleSatzZuIndex(int indGesucht) {
        if (this.mHgs == null) {
            return null;
        }
        int indAktuell = -1;
        for (Hg hg : this.mHgs) {
            if (++indAktuell == indGesucht) {
                return null;
            }
            if (!hg.getHg().equals(this.mExpandedHg)) continue;
            for (ValueLineSatz satz : this.getSaetze(hg.getHg())) {
                if (++indAktuell != indGesucht) continue;
                return satz;
            }
            return null;
        }
        return null;
    }

    public Baureihe ermittleBaureiheZuIndex(int indGesucht) {
        if (this.mBaureihen == null) {
            return null;
        }
        int indAktuell = -1;
        for (Baureihe baureihe : this.mBaureihen) {
            if (++indAktuell == indGesucht) {
                return baureihe;
            }
            if (baureihe.getID().equals(this.mExpandedBaureihe)) {
                indAktuell += this.getBildtafeln(baureihe.getID()).size();
            }
            if (indAktuell < indGesucht) continue;
            return null;
        }
        return null;
    }

    public Modellspalte ermittleBildtafelZuIndex(int indGesucht) {
        if (this.mBaureihen == null) {
            return null;
        }
        int indAktuell = -1;
        for (Baureihe baureihe : this.mBaureihen) {
            if (++indAktuell == indGesucht) {
                return null;
            }
            if (!baureihe.getID().equals(this.mExpandedBaureihe)) continue;
            for (Modellspalte mosp : this.getBildtafeln(baureihe.getID())) {
                if (++indAktuell != indGesucht) continue;
                return mosp;
            }
            return null;
        }
        return null;
    }

    public SearchBTETeile.PartOrBTE ermittleTeilZuIndex(int indGesucht) {
        if (this.mTeilenummern == null) {
            return null;
        }
        int indAktuell = -1;
        for (SearchBTETeile.PartOrBTE teil : this.mTeilenummern) {
            if (++indAktuell != indGesucht) continue;
            return teil;
        }
        return null;
    }

    public String ermittleSachnummerZuIndex(int indGesucht) {
        if (this.getUmfang() == null) {
            return null;
        }
        if (this.getUmfang().equals(SUCHART_SAETZE)) {
            ValueLineSatz satz = this.ermittleSatzZuIndex(indGesucht);
            if (satz == null) {
                return null;
            }
            return satz.getSachnummer();
        }
        if (this.getUmfang().equals(SUCHART_TEILENUMMERN)) {
            SearchBTETeile.PartOrBTE teil = this.ermittleTeilZuIndex(indGesucht);
            if (teil == null) {
                return null;
            }
            String sTeilenummer = teil.getIdNummer();
            String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
            return sSachnummer;
        }
        return null;
    }

    public HashMap<String, Object> getSachnummerInfoZurZeile(int nRow) {
        String sTeilenummer = null;
        String sBenennungZusatz = null;
        String sZusatz = null;
        if (this.getUmfang().equals(SUCHART_SAETZE)) {
            ValueLineSatz satz = this.ermittleSatzZuIndex(nRow);
            if (satz == null) {
                return null;
            }
            sTeilenummer = satz.getTeilenummer();
            sBenennungZusatz = satz.getBenennung();
            sZusatz = satz.getZusatz();
        } else if (this.getUmfang().equals(SUCHART_TEILENUMMERN)) {
            SearchBTETeile.PartOrBTE teil = this.ermittleTeilZuIndex(nRow);
            sTeilenummer = teil.getIdNummer();
            sBenennungZusatz = teil.getBenennung();
            sZusatz = teil.getZusatz();
        } else {
            return null;
        }
        String sSachnummer = StringUtils.substituteStringStraight(sTeilenummer, " ", "").substring(4);
        if (sZusatz != null && !sZusatz.equals("")) {
            sBenennungZusatz = sBenennungZusatz + "/" + sZusatz;
        }
        String sMarke = this.getMarke();
        String sProduktart = this.getProduktart();
        HashMap<String, Object> oHashMap = new HashMap<String, Object>();
        oHashMap.put("sachnummer", sSachnummer);
        oHashMap.put("teilenummer", sTeilenummer);
        oHashMap.put("benennung_zusatz", sBenennungZusatz);
        oHashMap.put("marke", sMarke);
        oHashMap.put("produktart", sProduktart);
        String sKatalogumfang = GlobalObjects.getInstance().getSessionInfo().getSettings().getKatalogumfang();
        oHashMap.put("katalogumfang", sKatalogumfang);
        return oHashMap;
    }
}

