/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.zusatzinfo.valueline;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import webetk.WebetkUtils;
import webetk.app.GenericTeil;
import webetk.app.SearchBTETeile;
import webetk.app.teilevwdgteil.Baureihe;
import webetk.app.teilevwdgteil.Modellspalte;
import webetk.app.valueline.Hg;
import webetk.app.valueline.ValueLineSatz;
import webetk.javaclient.dialog.AbstractDlgMitTLView;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.MarkeProduktKatalogUmfangVLAuswahl;
import webetk.javaclient.dialog.MarkeProduktKatalogUmfangVLPanelSet;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.zusatzinfo.valueline.ValueLineController;
import webetk.javaclient.dialog.zusatzinfo.valueline.ValueLineModel;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericRow;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.IconCellRenderer;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.javaclient.menuitem.MenuItemAnzeigeBildtafel;
import webetk.javaclient.menuitem.MenuItemCopySachnummer;
import webetk.javaclient.menuitem.MenuItemEinzelteile;
import webetk.javaclient.menuitem.MenuItemInterpretation;
import webetk.javaclient.menuitem.MenuItemTeileinformation;
import webetk.javaclient.menuitem.MenuItemTeileverwendungTeil;
import webetk.resources.Resource;

public class ValueLineView
extends AbstractDlgMitTLView {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ValueLineView.class);
    private ValueLineModel model;
    private ValueLineController controller;
    private JPanel mainPanel = null;
    private JPanel suchePanel = null;
    private GenericTable table;
    private GenericTableModel tableModel;
    private static final IconCellRenderer aufklappenIconRenderer = new IconCellRenderer(UIHelper.getPlusIcon(), Resource.getInstance().getAufklappen());
    private static final IconCellRenderer zuklappenIconRenderer = new IconCellRenderer(UIHelper.getMinusIcon(), Resource.getInstance().getZuklappen());
    private static final IconCellRenderer teileinfoIconRenderer = new IconCellRenderer((Icon)ImageCache.getInstance().getIcon("info.gif"), Resource.getInstance().getTeileinfo());
    private static final IconCellRenderer btInfoIconRenderer = new IconCellRenderer((Icon)ImageCache.getInstance().getIcon("info.gif"), Resource.getInstance().getBildtafelinformation());
    private static final IconCellRenderer btNoInfoIconRenderer = new IconCellRenderer((Icon)ImageCache.getInstance().getIcon("info_insensitiv.jpg"), "");
    private static final IconCellRenderer teileverwendungIconRenderer = new IconCellRenderer((Icon)ImageCache.getInstance().getIcon("auto.gif"), Resource.getInstance().getTeileverwendung());
    private static final IconCellRenderer btAnzeigenIconRenderer = new IconCellRenderer((Icon)ImageCache.getInstance().getIcon("visualisierung.gif"), Resource.getInstance().getAnzeigeBildtafel());
    private MenuItemAnzeigeBildtafel menuitemBildtafelAnzeigen = null;
    private MarkeProduktKatalogUmfangVLAuswahl mpkAuswahl;

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oController) {
        super.init(oDlgModel, oController);
        this.model = (ValueLineModel)oDlgModel;
        this.controller = (ValueLineController)oController;
        this.menuitemBildtafelAnzeigen = new MenuItemAnzeigeBildtafel("value_line", this.controller, this.model, this);
        this.initComponents();
        this.update();
    }

    @Override
    public void initMenus() {
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.mainPanel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout lo = new HIGLayout(w, h);
        lo.setColumnWeight(1, 1);
        lo.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.mainPanel.setLayout(lo);
        HeaderPanel headerPanel = new HeaderPanel(Resource.getInstance().getValueLine(), ImageCache.getInstance().getHeaderIcon("sesatz"));
        this.mainPanel.add((Component)headerPanel, c.rc(1, 1, "tlbr"));
        JPanel panelAuswahl = this.createAuswahlPanel();
        this.mainPanel.add((Component)panelAuswahl, c.rc(2, 1, "tlbr"));
        this.model.setUmfang("saetze");
        this.controller.search();
        this.controller.loadTeilelistenIDs();
        JScrollPane sc = new JScrollPane(this.mainPanel);
        this.setLayout(new BorderLayout());
        this.add(sc);
    }

    private JPanel createAuswahlPanel() {
        MarkeProduktKatalogUmfangVLPanelSet panel = null;
        this.mpkAuswahl = new MarkeProduktKatalogUmfangVLAuswahl(Resource.getInstance().getMarkeProdartUmfang(), true, this.model.getMarke(), this.model.getProduktart(), null, false, true);
        panel = this.mpkAuswahl.getMpkPanelSet();
        this.mpkAuswahl.addPropertyChangeListener("Marke", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ValueLineView.this.controller.changeToMarke((String)evt.getNewValue());
            }
        });
        this.mpkAuswahl.addPropertyChangeListener("Produktart", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ValueLineView.this.controller.changeToProduktart((String)evt.getNewValue());
            }
        });
        this.mpkAuswahl.addPropertyChangeListener("UMFANGVL", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ValueLineView.this.controller.changeToUmfang((String)evt.getNewValue());
            }
        });
        return panel;
    }

    private JPanel layoutErgebnis(String suchart) {
        if (suchart == null) {
            log.error((Object)"Keine Suchart ubergeben!");
            suchart = "saetze";
        }
        String title = "";
        TitledPanel panel = new TitledPanel(title);
        int[] w = new int[]{10, 0, 20, 0, 20, 0, 20, 0, 10, 0, 10};
        int[] h = new int[]{10, 0, 5, 0, 0, 10};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(9, 1);
        hl.setRowWeight(4, 1);
        panel.setLayout(hl);
        HIGConstraints c = new HIGConstraints();
        if (!suchart.equals("bildtafeln")) {
            this.buttonUebernehmen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ValueLineView.this.uebernehmenInTeileliste();
                }
            });
            panel.add((Component)this.labTeileliste, c.rc(2, 2, "l"));
            this.updateTeilelisten();
            panel.add((Component)this.comboTeileliste, c.rc(2, 4, "l"));
            panel.add((Component)this.buttonUebernehmen, c.rc(2, 6, "l"));
            panel.add((Component)this.buttonUeberpruefen, c.rc(2, 8, "l"));
        }
        if (suchart.equals("bildtafeln")) {
            JButtonEx buttonWeiter = new JButtonEx(null, ImageCache.getInstance().getIcon("arrw04_10b.gif"));
            buttonWeiter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ValueLineView.this.menuitemBildtafelAnzeigen.showBildtafel();
                }
            });
            panel.add((Component)buttonWeiter, c.rc(2, 10, "r"));
        }
        JScrollPane sc = null;
        if (suchart.equals("bildtafeln")) {
            sc = this.createBildtafelnTabelle();
            this.updateBildtafelnTabellenInhalt();
        } else if (suchart.equals("teilenummern")) {
            sc = this.createTeilenummernTabelle();
            this.updateTeilenummernTabellenInhalt();
        } else {
            sc = this.createSaetzeTabelle();
            this.updateSaetzeTabellenInhalt();
        }
        panel.add((Component)sc, c.rcwh(4, 2, 10, 1));
        return panel;
    }

    private JScrollPane createSaetzeTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn("", 0, JLabel.class, false, aufklappenIconRenderer);
        tableConfig.addColumn("", 0, JLabel.class, false, teileinfoIconRenderer);
        tableConfig.addColumn("", 0, JLabel.class, false, teileverwendungIconRenderer);
        tableConfig.addColumn(Resource.getInstance().getHg(), 0, false, "XX");
        tableConfig.setHeaderTooltip(3, Resource.getInstance().getHauptgruppe());
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "11 41 1 730 475");
        tableConfig.addColumn(Resource.getInstance().getBenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXXYYYY");
        tableConfig.addColumn(Resource.getInstance().getNueZi(), 0, false, "I");
        tableConfig.setHeaderTooltip(7, Resource.getInstance().getZusatzinformation());
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getColumnModel().getColumn(0).setMinWidth(20);
        this.table.getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getColumnModel().getColumn(0).setWidth(20);
        this.table.getColumnModel().getColumn(1).setMinWidth(20);
        this.table.getColumnModel().getColumn(1).setMaxWidth(20);
        this.table.getColumnModel().getColumn(1).setWidth(20);
        this.createSaetzeTabelleHandler();
        JScrollPane scrollPane = this.table.getScrollPane();
        return scrollPane;
    }

    private void createSaetzeTabelleHandler() {
        final JPopupMenu menuPopup = new JPopupMenu();
        final MenuItemTeileinformation menuitemTeileinformation = new MenuItemTeileinformation(this);
        menuPopup.add(menuitemTeileinformation);
        final MenuItemTeileverwendungTeil menuitemTeileverwendungTeil = new MenuItemTeileverwendungTeil("value_line", this.controller, this.model, this);
        menuPopup.add(menuitemTeileverwendungTeil);
        final MenuItemInterpretation menuitemInterpretation = new MenuItemInterpretation("interpretation", this.controller, this.model, this);
        menuPopup.add(menuitemInterpretation);
        final MenuItemEinzelteile menuitemEinzelteile = new MenuItemEinzelteile("satz_einzelteile_satz", this.controller, this.model, this);
        menuPopup.add(menuitemEinzelteile);
        menuPopup.addSeparator();
        MenuItemCopySachnummer menuitemCopySachnummer = new MenuItemCopySachnummer(this);
        menuPopup.add(menuitemCopySachnummer);
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (ValueLineView.this.table.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                int nSelectedRow = ValueLineView.this.table.getSelectedRow();
                GenericRow selRow = ValueLineView.this.tableModel.getRow(nSelectedRow);
                Object cellObj = selRow.get(0);
                if (cellObj != null) {
                    return;
                }
                menuitemTeileverwendungTeil.setEnabled(true);
                menuitemInterpretation.setEnabled(((MenuItemInterpretation)menuitemInterpretation).hatInterpretation());
                menuPopup.show(ValueLineView.this.table.getTable(), evt.getX(), evt.getY());
            }
        });
        GenericTableMouseEventAdapter listenerPlusMinus = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent ev) {
                ValueLineView.this.doExpandCollapseHg(ev.getRow());
            }
        };
        this.table.addMouseListener(listenerPlusMinus, 0);
        GenericTableMouseEventAdapter listenerTeileinfo = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent ev) {
                menuitemTeileinformation.showTeileinfo();
            }
        };
        this.table.addMouseListener(listenerTeileinfo, 1);
        GenericTableMouseEventAdapter listenerTeileverwendung = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent ev) {
                menuitemTeileverwendungTeil.showTeileverwendungTeil();
            }
        };
        this.table.addMouseListener(listenerTeileverwendung, 2);
        GenericTableMouseEventAdapter listener = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent ev) {
                menuitemEinzelteile.showEinzelteile();
            }
        };
        this.table.addMouseListener(listener, 4);
        this.table.addMouseListener(listener, 5);
    }

    private void updateSaetzeTabellenInhalt() {
        this.tableModel.removeAllRows();
        if (this.model.getHgs() != null) {
            for (Hg hg : this.model.getHgs()) {
                IconCellRenderer hgAufZu = null;
                hgAufZu = hg.getHg().equals(this.model.getExpandedHg()) ? zuklappenIconRenderer : aufklappenIconRenderer;
                AbstractRow newRow = new AbstractRow(new Object[]{hgAufZu, null, null, hg.getHg(), null, hg.getBenennung(), null, null});
                this.tableModel.addRow(newRow);
                if (this.model.getSaetze(hg.getHg()) == null || !hg.getHg().equals(this.model.getExpandedHg())) continue;
                for (ValueLineSatz satz : this.model.getSaetze(hg.getHg())) {
                    newRow = new AbstractRow(new Object[]{null, teileinfoIconRenderer, teileverwendungIconRenderer, null, satz.getTeilenummer(), satz.getBenennung(), satz.getZusatz(), satz.getZI()});
                    this.tableModel.addRow(newRow);
                }
            }
        }
    }

    private void doExpandCollapseHg(int nRow) {
        Hg oHg = this.model.ermittleHgZuIndex(nRow);
        if (oHg == null) {
            return;
        }
        String sHg = oHg.getHg();
        if (sHg.equals(this.model.getExpandedHg())) {
            this.model.setExpandedHg(null);
            this.updateSaetzeTabellenInhalt();
        } else {
            this.model.setExpandedHg(sHg);
            this.controller.loadSaetze(sHg);
            this.updateSaetzeTabellenInhalt();
        }
    }

    private void doExpandCollapseBaureihe(int nRow) {
        Baureihe baureihe = this.model.ermittleBaureiheZuIndex(nRow);
        if (baureihe == null) {
            return;
        }
        String id = baureihe.getID();
        if (id.equals(this.model.getExpandedBaureihe())) {
            this.model.setExpandedBaureihe(null);
            this.updateBildtafelnTabellenInhalt();
        } else {
            this.model.setExpandedBaureihe(id);
            this.controller.loadBildtafeln(id);
            this.updateBildtafelnTabellenInhalt();
        }
    }

    private JScrollPane createBildtafelnTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn("", 0, JLabel.class, false, btInfoIconRenderer);
        tableConfig.addColumn("", 0, JLabel.class, false, btAnzeigenIconRenderer);
        tableConfig.addColumn("", 0, JLabel.class, false, aufklappenIconRenderer);
        String sBaureiheProtoyp = null;
        sBaureiheProtoyp = this.model.isPKW() ? "Rolls-Royce RR1X" : "XXXXXXXXXXXXXXXXXXXX";
        tableConfig.addColumn(Resource.getInstance().getBaureihe(), 2, true, sBaureiheProtoyp);
        tableConfig.addColumn(Resource.getInstance().getModell(), 2, true, "XXXXXXXXXXXX");
        if (this.model.isPKW()) {
            tableConfig.addColumn(Resource.getInstance().getKarosserie(), 2, false, "XXXXXXXXXX");
        }
        tableConfig.addColumn(Resource.getInstance().getNueKR(), 0, false, "ECE");
        int nRowCount = tableConfig.getColumnCount();
        tableConfig.setHeaderTooltip(nRowCount - 1, Resource.getInstance().getKatalogausfuehrungRegion());
        tableConfig.addColumn(Resource.getInstance().getBtNummer(), 0, false, "51_1169");
        tableConfig.addColumn(Resource.getInstance().getBtUeberschrift(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getColumnModel().getColumn(0).setMinWidth(20);
        this.table.getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getColumnModel().getColumn(0).setWidth(20);
        this.table.getColumnModel().getColumn(1).setMinWidth(20);
        this.table.getColumnModel().getColumn(1).setMaxWidth(20);
        this.table.getColumnModel().getColumn(1).setWidth(20);
        this.table.getColumnModel().getColumn(2).setMinWidth(20);
        this.table.getColumnModel().getColumn(2).setMaxWidth(20);
        this.table.getColumnModel().getColumn(2).setWidth(20);
        this.table.getSelectionModel().setSelectionMode(0);
        this.createBildtafelnTabelleHandler();
        JScrollPane scrollPane = this.table.getScrollPane();
        return scrollPane;
    }

    private void createBildtafelnTabelleHandler() {
        final JPopupMenu menuPopup = new JPopupMenu();
        final JMenuItem menuitemBildtafelinformation = new JMenuItem(Resource.getInstance().getBildtafelinformation());
        menuPopup.add(menuitemBildtafelinformation);
        menuPopup.add(this.menuitemBildtafelAnzeigen);
        GenericTableMouseEventAdapter listenerBildtafelinfo = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                ValueLineView.this.controller.showBildtafelinfo(e.getRow());
            }
        };
        this.table.addMouseListener(listenerBildtafelinfo, 0);
        GenericTableMouseEventAdapter listenerBildtafelAnzeigen = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                ValueLineView.this.menuitemBildtafelAnzeigen.showBildtafel();
            }
        };
        this.table.addMouseListener(listenerBildtafelAnzeigen, 1);
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (ValueLineView.this.table.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                int nSelectedRow = ValueLineView.this.table.getTable().getSelectedRow();
                GenericRow selRow = ValueLineView.this.tableModel.getRow(nSelectedRow);
                Object cellObj = selRow.get(0);
                if (cellObj == null) {
                    return;
                }
                Modellspalte bte = ValueLineView.this.model.ermittleBildtafelZuIndex(nSelectedRow);
                boolean zeileHatInfo = bte != null && bte.hasBtInfo();
                menuitemBildtafelinformation.setEnabled(zeileHatInfo);
                menuPopup.show(ValueLineView.this.table.getTable(), evt.getX(), evt.getY());
            }
        });
        GenericTableMouseEventAdapter listenerPlusMinus = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent ev) {
                ValueLineView.this.doExpandCollapseBaureihe(ev.getRow());
            }
        };
        this.table.addMouseListener(listenerPlusMinus, 2);
    }

    private void updateBildtafelnTabellenInhalt() {
        this.tableModel.removeAllRows();
        if (this.model.getBaureihen() != null) {
            for (Baureihe baureihe : this.model.getBaureihen()) {
                IconCellRenderer hgAufZu = null;
                hgAufZu = baureihe.getID().equals(this.model.getExpandedBaureihe()) ? zuklappenIconRenderer : aufklappenIconRenderer;
                AbstractRow newRow = null;
                newRow = this.model.isPKW() ? new AbstractRow(new Object[]{null, null, hgAufZu, baureihe.getBenennung(), null, null, null, null, null}) : new AbstractRow(new Object[]{null, null, hgAufZu, baureihe.getBenennung(), null, null, null, null});
                this.tableModel.addRow(newRow);
                if (this.model.getBildtafeln(baureihe.getID()) == null || !baureihe.getID().equals(this.model.getExpandedBaureihe())) continue;
                for (Modellspalte bte : this.model.getBildtafeln(baureihe.getID())) {
                    IconCellRenderer btinfo = null;
                    btinfo = bte.hasBtInfo() ? btInfoIconRenderer : btNoInfoIconRenderer;
                    newRow = this.model.isPKW() ? new AbstractRow(new Object[]{btinfo, btAnzeigenIconRenderer, null, baureihe.getBenennung(), bte.getModell(), bte.getKarosserie(), bte.getRegion(), bte.getBTNummer(), bte.getBTUeberschrift()}) : new AbstractRow(new Object[]{btinfo, btAnzeigenIconRenderer, null, baureihe.getBenennung(), bte.getModell(), bte.getRegion(), bte.getBTNummer(), bte.getBTUeberschrift()});
                    this.tableModel.addRow(newRow);
                }
            }
        }
    }

    private JScrollPane createTeilenummernTabelle() {
        TableConfiguration tableConfig = new TableConfiguration();
        tableConfig.addColumn("", 0, JLabel.class, false, teileinfoIconRenderer);
        tableConfig.addColumn("", 0, JLabel.class, false, btAnzeigenIconRenderer);
        tableConfig.addColumn(Resource.getInstance().getTeilenummer(), 0, false, "52 10 1 942 724YY");
        tableConfig.addColumn(Resource.getInstance().getTeilebenennung(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXYYYYY");
        tableConfig.addColumn(Resource.getInstance().getZusatz(), 2, true, "XXXXXXXXXXXXXXXYYYY");
        tableConfig.addColumn(Resource.getInstance().getKommentar(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.tableModel = new GenericTableModel(tableConfig);
        this.table = new GenericTable(this.tableModel);
        this.table.getColumnModel().getColumn(0).setMinWidth(20);
        this.table.getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getColumnModel().getColumn(0).setWidth(20);
        this.table.getColumnModel().getColumn(1).setMinWidth(20);
        this.table.getColumnModel().getColumn(1).setMaxWidth(20);
        this.table.getColumnModel().getColumn(1).setWidth(20);
        this.createTeilenummernTabelleHandler();
        JScrollPane scrollPane = this.table.getScrollPane();
        return scrollPane;
    }

    private void createTeilenummernTabelleHandler() {
        final JPopupMenu menuPopup = new JPopupMenu();
        final MenuItemTeileinformation menuitemTeileinformation = new MenuItemTeileinformation(this);
        menuPopup.add(menuitemTeileinformation);
        final MenuItemTeileverwendungTeil menuitemTeileverwendungTeil = new MenuItemTeileverwendungTeil("value_line", this.controller, this.model, this);
        menuPopup.add(menuitemTeileverwendungTeil);
        menuPopup.addSeparator();
        MenuItemCopySachnummer menuitemCopySachnummer = new MenuItemCopySachnummer(this);
        menuPopup.add(menuitemCopySachnummer);
        GenericTableMouseEventAdapter listenerTeileInfo = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
                menuitemTeileinformation.showTeileinfo();
            }
        };
        this.table.addMouseListener(listenerTeileInfo, 0);
        GenericTableMouseEventAdapter listenerTeileverwendung = new GenericTableMouseEventAdapter(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent ev) {
                menuitemTeileverwendungTeil.showTeileverwendungTeil();
            }
        };
        this.table.addMouseListener(listenerTeileverwendung, 1);
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (ValueLineView.this.table.getTable().getSelectedRowCount() != 1) {
                    return;
                }
                menuPopup.show(ValueLineView.this.table.getTable(), evt.getX(), evt.getY());
            }
        });
    }

    private void updateTeilenummernTabellenInhalt() {
        this.tableModel.removeAllRows();
        if (this.model.getTeilenummern() != null) {
            for (SearchBTETeile.PartOrBTE teil : this.model.getTeilenummern()) {
                String nr = teil.getIdNummer();
                String nrFormatiert = WebetkUtils.formatiereTeilenummer(nr);
                AbstractRow newRow = new AbstractRow(new Object[]{teileinfoIconRenderer, teileverwendungIconRenderer, nrFormatiert, teil.getBenennung(), teil.getZusatz(), teil.getBenennungKommentar()});
                this.tableModel.addRow(newRow);
            }
        }
    }

    @Override
    public void update() {
        if (this.suchePanel != null) {
            this.mainPanel.remove(this.suchePanel);
        }
        this.suchePanel = this.layoutErgebnis(this.model.getUmfang());
        HIGConstraints hc = new HIGConstraints();
        this.mainPanel.add((Component)this.suchePanel, hc.rc(3, 1, "tlbr"));
        this.mainPanel.invalidate();
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    private void uebernehmenInTeileliste() {
        Vector<GenericTeil> cTeile = new Vector<GenericTeil>();
        int nCountSelectedRows = this.table.getSelectedRowCount();
        if (nCountSelectedRows == 0) {
            return;
        }
        int[] selectedRows = this.table.getSelectedRows();
        for (int ii = 0; ii < nCountSelectedRows; ++ii) {
            int nRow = selectedRows[ii];
            GenericTeil t = new GenericTeil();
            String sSachnummer = this.model.ermittleSachnummerZuIndex(nRow);
            if (sSachnummer == null) continue;
            GenericRow oZeile = this.tableModel.getRow(nRow);
            String sTeilenummer = (String)oZeile.get(4);
            t.setSachnummer(sSachnummer);
            String HGUG = sTeilenummer.trim().replaceAll(" +", "").substring(0, 4);
            t.setHG(HGUG.substring(0, 2));
            t.setUG(HGUG.substring(2, 4));
            t.setBenennung((String)oZeile.get(5));
            cTeile.add(t);
        }
        this.uebernehmenInTeileliste(cTeile, false);
    }

    @Override
    public HashMap<String, Object> getInfoZurSachnummer() {
        int nRow = this.table.getTable().getSelectedRow();
        return this.model.getSachnummerInfoZurZeile(nRow);
    }

    @Override
    public HashMap<String, Object> getInfoZurBildtafel() {
        int nSelectedRow = this.table.getTable().getSelectedRow();
        return this.controller.getInfoZurBildtafel(nSelectedRow);
    }
}

