/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.framework;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.Login;
import de.esg.commonclient.SplashScreen;
import de.esg.commonclient.browser.HelpViewer;
import de.esg.commonclient.dialog.DialogView;
import de.esg.commonclient.dialog.DialogViewController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.border.LineBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.log4j.Logger;
import webetk.communication.LoginInfo;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.bte.BTEView;
import webetk.javaclient.dialog.defaultdialog.DlgDefaultView;
import webetk.javaclient.dialog.extras.kommunikation.AskProperties;
import webetk.javaclient.dialog.extras.teileinfo.DlgTeileinfoController;
import webetk.javaclient.dialog.extras.teileliste.DlgBestelllisteController;
import webetk.javaclient.dialog.extras.teileliste.DlgSapRrListeController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteView;
import webetk.javaclient.dialog.extras.teileliste.TeilelistenUebersichtController;
import webetk.javaclient.dialog.extras.verbautesala.DlgAusstattung;
import webetk.javaclient.dialog.hilfe.abkuerzungen.Abkuerzungen;
import webetk.javaclient.dialog.hilfe.polstercode.PolsterCode;
import webetk.javaclient.dialog.hilfe.sonderausstattung.Sonderausstattungen;
import webetk.javaclient.dialog.hilfe.tfattribute.TFAttribute;
import webetk.javaclient.dialog.hilfe.version.Version;
import webetk.javaclient.dialog.zusatzinfo.valueline.ValueLineController;
import webetk.javaclient.framework.MainGlassPane;
import webetk.javaclient.framework.MainViewController;
import webetk.javaclient.framework.TeilesucheZubehoer;
import webetk.javaclient.lookandfeel.WebETKTheme;
import webetk.javaclient.utils.ScreenshotPrinter;
import webetk.javaclient.workflow.MainWorkflowsteuerung;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.mrkprd.Marken;
import webetk.mrkprd.Produkte;
import webetk.resources.Resource;

public class MainView
extends JFrame {
    private static final long serialVersionUID = -8316497479184260269L;
    protected ArrayList<Object> permanentMenus = new ArrayList();
    protected JMenuBar menuBar = new JMenuBar();
    protected JMenu menuTeilesuche = new JMenu(Resource.getInstance().getTeilesuche());
    protected JMenu menuTeileverwendung = new JMenu(Resource.getInstance().getTeileverwendung());
    protected JMenu menuZusatzinfo = new JMenu(Resource.getInstance().getZusatzinfo());
    protected JMenu menuExtras = new JMenu(Resource.getInstance().getExtras());
    protected JMenu menuAdministration = new JMenu(Resource.getInstance().getAdministration());
    protected JMenu menuHilfe = new JMenu(Resource.getInstance().getHilfe());
    protected JMenu menuDrucken = new JMenu(Resource.getInstance().getDrucken());
    protected JMenuItem menuExtrasEinstellungen = null;
    protected JMenuItem menuExtrasLoginZurBmwAg = null;
    protected JMenuItem menuExtrasProxy = null;
    protected JMenuItem menuExtrasTeilelistenUebersicht = null;
    protected JMenuItem menuExtrasBestelllisten = null;
    protected JMenuItem menuExtrasSapRrListe = null;
    protected JMenuItem menuExtrasFILoeschen = null;
    protected static final int dialogMenuIndex = 4;
    protected boolean hidden = false;
    protected boolean mIsis = false;
    private static Logger log = Logger.getLogger(MainView.class);
    private static MainView instance;

    protected MainView() {
        this.setIconImage(ImageCache.getInstance().getImage("ai_etk.jpg"));
        MainGlassPane glassPane = new MainGlassPane(this);
        super.setGlassPane(glassPane);
    }

    @Override
    public void setVisible(boolean visible) {
        this.hidden = !visible;
        super.setVisible(visible);
    }

    public void displayDialogView(DialogView oDlgView) {
        this.addDialogMenus(oDlgView);
        Container c = this.getContentPane();
        for (int ii = 0; ii < c.getComponentCount(); ++ii) {
            Component oldComponent = c.getComponent(ii);
            if (oldComponent instanceof DialogView) {
                DialogView oldView = (DialogView)((Object)oldComponent);
                oldView.onExit();
            }
            if (!(oldComponent instanceof DlgDefaultView)) continue;
            GlobalObjects.getInstance().getEtkData().interruptTickerThread();
        }
        c.removeAll();
        c.add((Component)oDlgView.getComponent(), "Center");
        this.validate();
        oDlgView.setFocus();
        if (oDlgView instanceof DlgTeilelisteView) {
            oDlgView.update();
        }
        this.repaint();
        if (oDlgView instanceof BTEView) {
            BTEView dlgBTEView = (BTEView)oDlgView;
            dlgBTEView.initETKTexte();
        }
    }

    public void init(MainViewController oFrameController, int nThreadID, boolean bScore, boolean bIsis) throws Exception {
        this.setTitle("ETK");
        this.setSize(1024, 738);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.mIsis = bIsis;
        this.initMenus();
        this.setVisible(true);
        if (bScore) {
            this.setDefaultCloseOperation(1);
        } else {
            this.setDefaultCloseOperation(3);
        }
        SplashScreen.hide(nThreadID);
        this.addWindowListener(new MainViewWindowListener());
        if (bScore) {
            this.setVisible(false);
            this.hidden = true;
        }
    }

    public void initMenus() {
        boolean bScore = GlobalObjects.isScore();
        boolean bUserVorhanden = GlobalObjects.getInstance().getSessionInfo().getLogin() != null;
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        this.menuBar.removeAll();
        this.menuTeilesuche.removeAll();
        this.menuTeileverwendung.removeAll();
        this.menuZusatzinfo.removeAll();
        this.menuExtras.removeAll();
        this.menuAdministration.removeAll();
        this.menuHilfe.removeAll();
        this.menuDrucken.removeAll();
        this.menuTeilesuche.setText(Resource.getInstance().getTeilesuche());
        this.menuTeileverwendung.setText(Resource.getInstance().getTeileverwendung());
        this.menuZusatzinfo.setText(Resource.getInstance().getZusatzinfo());
        this.menuExtras.setText(Resource.getInstance().getExtras());
        this.menuAdministration.setText(Resource.getInstance().getAdministration());
        this.menuHilfe.setText(Resource.getInstance().getHilfe());
        this.menuDrucken.setText(Resource.getInstance().getDrucken());
        if (!bScore || !GlobalObjects.getInstance().getEtkData().isScoreTeilesuche()) {
            this.menuBar.add(this.menuTeilesuche);
        }
        if (!bScore) {
            this.menuBar.add(this.menuTeileverwendung);
            this.menuBar.add(this.menuZusatzinfo);
        }
        if (!bScore || !GlobalObjects.getInstance().getEtkData().isScoreTeilesuche()) {
            this.menuBar.add(this.menuExtras);
        }
        if (!bScore) {
            this.menuBar.add(this.menuAdministration);
        }
        ImageIcon icon = ImageCache.getInstance().getIcon("del_16x32.jpg");
        JButton buttonFILoeschen = new JButton(icon);
        buttonFILoeschen.setToolTipText(Resource.getInstance().getFahrzeugIdLoeschen());
        buttonFILoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWorkflowsteuerung.getInstance().startWorkflow("WfFILoeschen");
                MainWorkflowsteuerung.getInstance().startWorkflow("WfTeilesucheFzg");
            }
        });
        bUserVorhanden = GlobalObjects.getInstance().getSessionInfo().getLogin() != null;
        boolean bSettingsSaved = true;
        if (bUserVorhanden && GlobalObjects.getInstance().getSessionInfo().getEinstellungenDisharmonie() || bUserVorhanden && GlobalObjects.getInstance().getSessionInfo().getMarke() == null || bUserVorhanden && GlobalObjects.getInstance().getSessionInfo().getMarke().equals("")) {
            bSettingsSaved = false;
        }
        buttonFILoeschen.setEnabled(bUserVorhanden && bSettingsSaved);
        JSeparator separator = new JSeparator();
        separator.setOrientation(1);
        separator.setBorder(new LineBorder(WebETKTheme.getETKDefaultBackgroundColor(), 5));
        if (!bScore) {
            this.menuBar.add(this.menuHilfe);
            this.menuBar.add(this.menuDrucken);
            this.menuBar.add(separator);
            this.menuBar.add(buttonFILoeschen);
        }
        this.menuTeilesuche.setEnabled(bUserVorhanden);
        JMenu menuTeilesucheSpezifisch = new JMenu(Resource.getInstance().getSpezifische());
        this.menuTeileverwendung.setEnabled(bUserVorhanden);
        this.menuTeilesuche.add(menuTeilesucheSpezifisch);
        menuTeilesucheSpezifisch.add(this.createMenuEntry(Resource.getInstance().getFahrzeugteile(), "WfTeilesucheFzg"));
        menuTeilesucheSpezifisch.add(this.createMenuEntry(Resource.getInstance().getZubehoerAccessoires(), "WfTeilesucheAcc"));
        menuTeilesucheSpezifisch.add(this.createMenuEntry(Resource.getInstance().getValueLine(), "WfTeilesucheVL"));
        final JMenuItem menuTeilesucheSpezifischFedertabelle = this.createMenuEntry(Resource.getInstance().getFedertabelle(), "WfFedertabellen");
        menuTeilesucheSpezifisch.add(menuTeilesucheSpezifischFedertabelle);
        menuTeilesucheSpezifisch.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean bShowFedertabelle;
                LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
                boolean bl = bShowFedertabelle = oLoginInfo.getUserProdukte().size() != 1 || !oLoginInfo.getUserProdukte().contains(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung());
                if (menuTeilesucheSpezifischFedertabelle != null) {
                    menuTeilesucheSpezifischFedertabelle.setVisible(bShowFedertabelle);
                }
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        JMenu menuTeilesucheGrafisch = new JMenu(Resource.getInstance().getGrafische());
        this.menuTeilesuche.add(menuTeilesucheGrafisch);
        menuTeilesucheGrafisch.add(this.createMenuEntry(Resource.getInstance().getFahrzeugteile(), "WfTeilesucheFzgGrafisch"));
        menuTeilesucheGrafisch.add(this.createMenuEntry(Resource.getInstance().getZubehoerAccessoires(), "WfTeilesucheAccGrafisch"));
        boolean isUs = true;
        if (this.mIsis) {
            isUs = GlobalObjects.getInstance().getIsoCountryCode().equals("US") || GlobalObjects.getInstance().getIsoCountryCode().equals("");
            Collection<String> produkte = oLoginInfo.getUserProdukte();
            if (produkte != null && (produkte.size() > 1 || produkte.contains(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()))) {
                isUs = false;
            }
        } else {
            int[] result = oLoginInfo.getUserMaerkte();
            if (result == null) {
                isUs = false;
            } else {
                log.info((Object)("result[0]: " + result[0]));
                log.info((Object)("result[1]: " + result[1]));
                if (result[0] == 211 || result[0] == 2) {
                    if (result[1] == 1) {
                        log.info((Object)"isUs = true");
                        isUs = true;
                    } else {
                        isUs = false;
                    }
                } else {
                    isUs = false;
                }
            }
        }
        log.info((Object)("isUs " + isUs));
        if (!isUs) {
            // empty if block
        }
        this.menuTeileverwendung.setEnabled(bUserVorhanden);
        final JMenuItem menuTeileverwendungTeil = this.createMenuEntry(Resource.getInstance().getNachTeilen(), "WfTeileverwendungTeil");
        this.menuTeileverwendung.add(menuTeileverwendungTeil);
        final JMenuItem menuTeileverwendungFzg = this.createMenuEntry(Resource.getInstance().getNachFahrzeug(), "WfTeileverwendungFzg");
        this.menuTeileverwendung.add(menuTeileverwendungFzg);
        final JMenuItem menuTeileverwendungBen = this.createMenuEntry(Resource.getInstance().getNachBenennung(), "WfTeileverwendungBen");
        this.menuTeileverwendung.add(menuTeileverwendungBen);
        this.menuTeileverwendung.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean bShowTVBen;
                boolean bShowTVFzg;
                boolean bShowTVTeil;
                LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
                boolean bl = bShowTVTeil = oLoginInfo.hatRecht("R_WEBETK_TEILEVERWENDUNG_TEIL");
                if (menuTeileverwendungTeil != null) {
                    menuTeileverwendungTeil.setVisible(bShowTVTeil);
                }
                boolean bl2 = bShowTVFzg = oLoginInfo.hatRecht("R_WEBETK_TEILEVERWENDUNG_FZG");
                if (menuTeileverwendungFzg != null) {
                    menuTeileverwendungFzg.setVisible(bShowTVFzg);
                }
                boolean bl3 = bShowTVBen = oLoginInfo.hatRecht("R_WEBETK_TEILEVERWENDUNG_FZG");
                if (menuTeileverwendungBen != null) {
                    menuTeileverwendungBen.setVisible(bShowTVBen);
                }
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        this.menuZusatzinfo.setEnabled(bUserVorhanden);
        final JMenuItem menuZusatzinfoTeileinfo = this.createMenuEntryForDialog(Resource.getInstance().getTeileinformation(), DlgTeileinfoController.class);
        this.menuZusatzinfo.add(menuZusatzinfoTeileinfo);
        final JMenuItem menuZusatzinfoInterpretation = this.createMenuEntry(Resource.getInstance().getInterpretation(), "WfInterpretation");
        this.menuZusatzinfo.add(menuZusatzinfoInterpretation);
        final JMenuItem menuZusatzinfoTeileersetzung = this.createMenuEntry(Resource.getInstance().getTeileersetzung(), "WfTeileersetzung");
        this.menuZusatzinfo.add(menuZusatzinfoTeileersetzung);
        final JMenuItem menuZusatzinfoErstbevorratung = this.createMenuEntry(Resource.getInstance().getErstbevorratung(), "WfErstbevorratung");
        this.menuZusatzinfo.add(menuZusatzinfoErstbevorratung);
        final JMenuItem menuZusatzinfoLagerzeitbeschraenkung = this.createMenuEntry(Resource.getInstance().getLagerzeitbeschraenkung(), "WfLagerzeitbeschraenkung");
        this.menuZusatzinfo.add(menuZusatzinfoLagerzeitbeschraenkung);
        final JMenuItem menuZusatzinfoSatzEinzelteile = this.createMenuEntry(Resource.getInstance().getSatzEinzelteile(), "WfSatzEinzelteile");
        this.menuZusatzinfo.add(menuZusatzinfoSatzEinzelteile);
        JMenuItem menuZusatzinfoValueLine = this.createMenuEntryForDialog(Resource.getInstance().getValueLine(), ValueLineController.class);
        this.menuZusatzinfo.add(menuZusatzinfoValueLine);
        final JMenuItem menuZusatzinfoNormteile = this.createMenuEntry(Resource.getInstance().getNormteile(), "WfNormteile");
        this.menuZusatzinfo.add(menuZusatzinfoNormteile);
        final JMenuItem menuZusatzinfoTechnischeLiteratur = this.createMenuEntry(Resource.getInstance().getTechnischeLiteratur(), "WfTechnischeLiteratur");
        this.menuZusatzinfo.add(this.createMenuEntry(Resource.getInstance().getNotizUebersicht(), "WfNotizuebersicht"));
        final JMenuItem menuZusatzinfoFuellmengen = this.createMenuEntry(Resource.getInstance().getFuellmengen(), "WfFuellmengen");
        this.menuZusatzinfo.add(menuZusatzinfoFuellmengen);
        this.menuZusatzinfo.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean bShowFuellmengen;
                LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
                if (menuZusatzinfoInterpretation != null) {
                    menuZusatzinfoInterpretation.setVisible(oLoginInfo.hatRecht("R_WEBETK_INTERPRETATION"));
                }
                if (menuZusatzinfoTeileersetzung != null) {
                    menuZusatzinfoTeileersetzung.setVisible(oLoginInfo.hatRecht("R_WEBETK_TEILEERSETZUNG"));
                }
                if (menuZusatzinfoErstbevorratung != null) {
                    menuZusatzinfoErstbevorratung.setVisible(oLoginInfo.hatRecht("R_WEBETK_ERSTBEVORRATUNG"));
                }
                if (menuZusatzinfoLagerzeitbeschraenkung != null) {
                    menuZusatzinfoLagerzeitbeschraenkung.setVisible(oLoginInfo.hatRecht("R_WEBETK_LAGERZEIT"));
                }
                if (menuZusatzinfoSatzEinzelteile != null) {
                    menuZusatzinfoSatzEinzelteile.setVisible(oLoginInfo.hatRecht("R_WEBETK_SATZ_EINZELTEILE"));
                }
                if (menuZusatzinfoNormteile != null) {
                    menuZusatzinfoNormteile.setVisible(oLoginInfo.hatRecht("R_WEBETK_NORMTEILE"));
                }
                if (menuZusatzinfoTechnischeLiteratur != null) {
                    menuZusatzinfoTechnischeLiteratur.setVisible(oLoginInfo.hatRecht("R_WEBETK_TECHNISCHE_LITERATUR"));
                }
                boolean bl = bShowFuellmengen = oLoginInfo.hatRecht("R_WEBETK_FUELLMENGEN") && (oLoginInfo.getUserProdukte().size() != 1 || !oLoginInfo.getUserProdukte().contains(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()));
                if (menuZusatzinfoFuellmengen != null) {
                    menuZusatzinfoFuellmengen.setVisible(bShowFuellmengen);
                }
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        if (!bScore) {
            this.menuExtras.add(this.createMenuEntry(Resource.getInstance().getLogin(), "WfLogin"));
            this.menuExtras.addSeparator();
            this.menuExtras.add(this.createMenuEntryExit(Resource.getInstance().getEtkBeenden()));
            this.menuExtras.addSeparator();
            this.menuExtrasEinstellungen = this.createMenuEntry(Resource.getInstance().getEinstellungen(), "WfEinstellungen");
            this.menuExtras.add(this.menuExtrasEinstellungen);
        }
        if (!bScore) {
            if (System.getProperty("debugETK") != null && System.getProperty("debugETK").equals("true")) {
                this.menuExtrasLoginZurBmwAg = this.createMenuEntry(Resource.getInstance().getLoginZurBMWaG() + "...", "WfLoginZurBMWaG");
                this.menuExtras.add(this.menuExtrasLoginZurBmwAg);
            }
            this.menuExtrasProxy = this.createMenuEntry(Resource.getInstance().getProxy() + "...", "WfProxy");
            this.menuExtras.add(this.menuExtrasProxy);
            if (GlobalObjects.getInstance().getEtkData().getBmwNetzeInfos().isAsapRequired()) {
                if (System.getProperty("debugETK") != null && System.getProperty("debugETK").equals("true")) {
                    this.menuExtrasLoginZurBmwAg.setEnabled(true);
                }
                this.menuExtrasProxy.setEnabled(true);
            } else {
                if (System.getProperty("debugETK") != null && System.getProperty("debugETK").equals("true")) {
                    this.menuExtrasLoginZurBmwAg.setEnabled(false);
                }
                this.menuExtrasProxy.setEnabled(false);
            }
        }
        if (!bScore) {
            if (!GlobalObjects.getInstance().getIstStandalone()) {
                JMenuItem menuExtrasSchnittstellen = this.createSchnittstellenMenuEntry(Resource.getInstance().getSchnittstellen() + "...");
                this.menuExtras.add(menuExtrasSchnittstellen);
            }
            this.menuExtrasTeilelistenUebersicht = this.createMenuEntryForDialog(Resource.getInstance().getTeilelistenUebersicht(), TeilelistenUebersichtController.class);
            this.menuExtras.add(this.menuExtrasTeilelistenUebersicht);
        }
        final JMenuItem menuExtrasTeilelisten = this.createMenuEntryForDialog(Resource.getInstance().getTeileliste(), DlgTeilelisteController.class);
        this.menuExtras.add(menuExtrasTeilelisten);
        if (!bScore) {
            this.menuExtrasBestelllisten = this.createMenuEntryForDialog(Resource.getInstance().getBestelllistenAnzeigen(), DlgBestelllisteController.class);
            this.menuExtras.add(this.menuExtrasBestelllisten);
            this.menuExtrasSapRrListe = this.createMenuEntryForDialog(Resource.getInstance().getRrSap(), DlgSapRrListeController.class);
            this.menuExtras.add(this.menuExtrasSapRrListe);
        }
        this.menuExtras.addSeparator();
        final JMenuItem menuExtrasVerbauteSA = this.createAusstattungDialog(Resource.getInstance().getAusstattung());
        this.menuExtras.add(menuExtrasVerbauteSA);
        if (!bScore) {
            this.menuExtrasFILoeschen = this.createMenuEntry(Resource.getInstance().getFahrzeugIdLoeschen(), "WfFILoeschen");
            this.menuExtras.add(this.menuExtrasFILoeschen);
        }
        this.menuExtras.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean bScore;
                boolean bUserVorhanden = GlobalObjects.getInstance().getSessionInfo().getLogin() != null;
                boolean bSettingsSaved = true;
                if (bUserVorhanden && GlobalObjects.getInstance().getSessionInfo().getEinstellungenDisharmonie() || bUserVorhanden && GlobalObjects.getInstance().getSessionInfo().getMarke() == null || bUserVorhanden && GlobalObjects.getInstance().getSessionInfo().getMarke().equals("")) {
                    bSettingsSaved = false;
                }
                if (!(bScore = GlobalObjects.isScore())) {
                    MainView.this.menuExtrasEinstellungen.setEnabled(bUserVorhanden && bSettingsSaved);
                    menuZusatzinfoTeileinfo.setEnabled(bUserVorhanden && bSettingsSaved);
                    MainView.this.menuExtrasTeilelistenUebersicht.setEnabled(bUserVorhanden && bSettingsSaved);
                }
                menuExtrasTeilelisten.setEnabled(bUserVorhanden && bSettingsSaved);
                if (!bScore) {
                    if (!GlobalObjects.getInstance().getSessionInfo().getDMSVerwenden()) {
                        MainView.this.menuExtrasBestelllisten.setVisible(false);
                    } else {
                        MainView.this.menuExtrasBestelllisten.setVisible(true);
                        MainView.this.menuExtrasBestelllisten.setEnabled(bUserVorhanden && bSettingsSaved);
                    }
                    MainView.this.menuExtrasFILoeschen.setEnabled(bUserVorhanden && bSettingsSaved);
                    LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
                    MainView.this.menuExtrasSapRrListe.setVisible(bUserVorhanden && bSettingsSaved && GlobalObjects.getInstance().getSessionInfo().getUserMarken().contains(Marken.getInstance().getMarke("RR").getBerechtigung()) && oLoginInfo.hatRecht("R_WEBETK_RR_ORDER_LIST"));
                }
                if (!(GlobalObjects.getInstance().isKeyReaderAktiv() || GlobalObjects.getInstance().isVINSpecAktiv() || GlobalObjects.getInstance().isIGDOMAktiv())) {
                    menuExtrasVerbauteSA.setVisible(false);
                } else {
                    menuExtrasVerbauteSA.setVisible(true);
                    if (bUserVorhanden && bSettingsSaved) {
                        boolean bEnable = DlgAusstattung.hatAusstattung();
                        menuExtrasVerbauteSA.setEnabled(bEnable);
                    } else {
                        menuExtrasVerbauteSA.setEnabled(false);
                    }
                }
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        boolean bHatRechtKonfiguration = !bUserVorhanden ? false : oLoginInfo.hatRecht("R_WEBETK_KONFIGURATION");
        boolean bHatRechtFilialverwaltung = !bUserVorhanden ? false : oLoginInfo.hatRecht("R_WEBETK_FIRMA_ADMIN");
        boolean bHatRechtNutzerverwaltung = !bUserVorhanden ? false : oLoginInfo.hatRecht("R_WEBETK_NUTZER_ADMIN");
        this.menuAdministration.setVisible(bHatRechtKonfiguration || bHatRechtFilialverwaltung || bHatRechtNutzerverwaltung);
        final JMenuItem menuAdministrationKonfiguration = this.createMenuEntry(Resource.getInstance().getKonfiguration(), "WfKonfiguration");
        this.menuAdministration.add(menuAdministrationKonfiguration);
        final JMenuItem menuAdministrationFilialverwaltung = this.createMenuEntry(Resource.getInstance().getFilialverwaltung(), "WfFirmeneinstellungen");
        this.menuAdministration.add(menuAdministrationFilialverwaltung);
        final JMenuItem menuAdministrationBenutzerverwaltung = this.createMenuEntry(Resource.getInstance().getBenutzerverwaltung(), "WfNutzereinstellungen");
        this.menuAdministration.add(menuAdministrationBenutzerverwaltung);
        JMenuItem menuAdministrationAuswertung = this.createMenuEntry(Resource.getInstance().getAuswertungen(), "WfAuswertungen");
        this.menuAdministration.add(menuAdministrationAuswertung);
        this.menuAdministration.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
                menuAdministrationKonfiguration.setVisible(oLoginInfo.hatRecht("R_WEBETK_KONFIGURATION"));
                menuAdministrationFilialverwaltung.setVisible(oLoginInfo.hatRecht("R_WEBETK_FIRMA_ADMIN"));
                menuAdministrationBenutzerverwaltung.setVisible(oLoginInfo.hatRecht("R_WEBETK_NUTZER_ADMIN"));
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        this.menuHilfe.add(this.createHelpMenuEntry(Resource.getInstance().getOnlineHilfe()));
        final JMenuItem menuHilfeVersion = this.createVersionDialog(Resource.getInstance().getVersion());
        this.menuHilfe.add(menuHilfeVersion);
        final JMenuItem menuHilfeCDInfo = this.createCDInfoMenuEntry(Resource.getInstance().getEtkInfo());
        this.menuHilfe.add(menuHilfeCDInfo);
        this.menuHilfe.addSeparator();
        final JMenuItem menuHilfeSonderausstattungen = this.createSonderausstattungenDialog(Resource.getInstance().getSonderausstattungen());
        this.menuHilfe.add(menuHilfeSonderausstattungen);
        final JMenuItem menuHilfeAbkuerzungen = this.createAbkuerzungenDialog(Resource.getInstance().getAbkuerzungen());
        this.menuHilfe.add(menuHilfeAbkuerzungen);
        final JMenuItem menuHilfePolstercode = this.createPolsterCodeDialog(Resource.getInstance().getPolstercode());
        this.menuHilfe.add(menuHilfePolstercode);
        final JMenuItem menuHilfeIndividual = this.createIndividualMenuEntry(Resource.getInstance().getIndividual());
        this.menuHilfe.add(menuHilfeIndividual);
        final JMenuItem menuHilfeTFAttribute = this.createTFAttributeDialog(Resource.getInstance().getTeileart());
        this.menuHilfe.add(menuHilfeTFAttribute);
        this.menuHilfe.addSeparator();
        JMenuItem menuHilfeTippsTricks = this.createTippsTricksDialog(Resource.getInstance().getTippsTricks());
        this.menuHilfe.add(menuHilfeTippsTricks);
        this.menuHilfe.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean bUserVorhanden = GlobalObjects.getInstance().getSessionInfo().getLogin() != null;
                menuHilfeVersion.setEnabled(bUserVorhanden);
                menuHilfeCDInfo.setEnabled(bUserVorhanden);
                menuHilfeSonderausstattungen.setEnabled(bUserVorhanden);
                menuHilfeAbkuerzungen.setEnabled(bUserVorhanden);
                menuHilfePolstercode.setEnabled(bUserVorhanden);
                menuHilfeIndividual.setEnabled(bUserVorhanden);
                menuHilfeTFAttribute.setEnabled(bUserVorhanden);
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        this.menuDrucken.add(this.printScreenshot(Resource.getInstance().getAktuellenBildschirm()));
        this.setJMenuBar(this.menuBar);
        this.permanentMenus.clear();
        if (!bScore || !GlobalObjects.getInstance().getEtkData().isScoreTeilesuche()) {
            this.permanentMenus.add(this.menuTeilesuche);
        }
        if (!bScore) {
            this.permanentMenus.add(this.menuTeileverwendung);
            this.permanentMenus.add(this.menuZusatzinfo);
        }
        if (!bScore || !GlobalObjects.getInstance().getEtkData().isScoreTeilesuche()) {
            this.permanentMenus.add(this.menuExtras);
        }
        if (!bScore) {
            this.permanentMenus.add(this.menuAdministration);
            this.permanentMenus.add(this.menuHilfe);
            this.permanentMenus.add(this.menuDrucken);
            this.permanentMenus.add(separator);
            this.permanentMenus.add(buttonFILoeschen);
        }
        if (GlobalObjects.getInstance().getSessionInfo().getEinstellungenDisharmonie()) {
            this.menuTeilesuche.setEnabled(false);
            this.menuTeileverwendung.setEnabled(false);
            this.menuZusatzinfo.setEnabled(false);
            this.menuAdministration.setEnabled(false);
        } else {
            this.menuTeilesuche.setEnabled(true);
            this.menuTeileverwendung.setEnabled(true);
            this.menuZusatzinfo.setEnabled(true);
            this.menuAdministration.setEnabled(true);
        }
        if (!oLoginInfo.hatRecht("R_WEBETK_TEILEVERWENDUNG_TEIL") && !oLoginInfo.hatRecht("R_WEBETK_TEILEVERWENDUNG_FZG")) {
            this.menuTeileverwendung.setVisible(false);
        } else {
            this.menuTeileverwendung.setVisible(true);
        }
    }

    protected boolean checkMenuPermanency(Object menu) {
        return this.permanentMenus.contains(menu);
    }

    protected void addDialogMenus(DialogView oDlgView) {
        JComponent element;
        int nAnzPermanenteButtons = 0;
        for (int i = 0; i < this.getJMenuBar().getMenuCount(); ++i) {
            Component m = this.getJMenuBar().getComponent(i);
            if (m == null) continue;
            if (!this.checkMenuPermanency(m)) {
                if (m instanceof JMenu) {
                    this.getJMenuBar().remove((JMenu)m);
                } else if (m instanceof JButton) {
                    this.getJMenuBar().remove((JButton)m);
                }
                log.debug((Object)("menu " + --i + " wurde entfernt."));
                continue;
            }
            if (!(m instanceof JButton)) continue;
            ++nAnzPermanenteButtons;
        }
        Iterator<JComponent> it = oDlgView.getMenus();
        if (it != null) {
            int position = 4;
            while (it.hasNext()) {
                element = it.next();
                if (!(element instanceof JMenu)) continue;
                if (!GlobalObjects.isScore()) {
                    this.getJMenuBar().add((Component)((JMenu)element), position++);
                    continue;
                }
                this.getJMenuBar().add((JMenu)element);
            }
        }
        if ((it = oDlgView.getMenus()) != null) {
            int position = this.getJMenuBar().getMenuCount() - nAnzPermanenteButtons;
            while (it.hasNext()) {
                element = it.next();
                if (!(element instanceof JButton)) continue;
                this.getJMenuBar().add((Component)((JButton)element), position++);
            }
        }
    }

    public static MainView getInstance() {
        if (instance == null) {
            instance = new MainView();
        }
        return instance;
    }

    public void showDlg(Class<? extends DialogViewController> dlgClass, WorkflowStateData data) {
        try {
            DialogViewController controller = dlgClass.newInstance();
            if (data != null) {
                controller.init(data);
            } else {
                controller.init(new WorkflowStateData());
            }
            DialogView view = controller.getDialogView();
            this.displayDialogView(view);
        }
        catch (IllegalAccessException iae) {
            log.fatal((Object)"Error creating DialogViewController", (Throwable)iae);
        }
        catch (InstantiationException ine) {
            log.fatal((Object)"Error creating DialogViewController", (Throwable)ine);
        }
    }

    private void onExit() {
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        if (oLoginInfo != null) {
            Login.deleteLoginName("ETK", oLoginInfo.getLogin());
        }
    }

    private JMenuItem createMenuEntryForDialog(String title, Class<? extends DialogViewController> dlgClass) {
        return this.createMenuEntryForDialog(title, dlgClass, null);
    }

    private JMenuItem createMenuEntryForDialog(final String title, final Class<? extends DialogViewController> dlgClass, final WorkflowStateData data) {
        AbstractAction showTeileinfoDlg = new AbstractAction(title){
            private static final long serialVersionUID = -3801977101565588975L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalObjects.getInstance().getEtkData().resetZurueckDialoge();
                log.debug((Object)(title + " actionPerformed"));
                MainView.this.showDlg(dlgClass, data);
            }
        };
        JMenuItem miTeileinfo = new JMenuItem(showTeileinfoDlg);
        return miTeileinfo;
    }

    protected JMenuItem createMenuEntry(final String sMenuItem, final String sWorkflow) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = 8061911969461618403L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.setCursor(Cursor.getPredefinedCursor(3));
                if (!MainWorkflowsteuerung.getInstance().startWorkflow(sWorkflow)) {
                    log.error((Object)("No valid workflow: " + sWorkflow));
                }
                if (sWorkflow.equals("WfFILoeschen") && !MainWorkflowsteuerung.getInstance().startWorkflow("WfTeilesucheFzg")) {
                    log.error((Object)"No valid workflow: WfTeilesucheFzg");
                }
                log.debug((Object)(sMenuItem + " actionPerformed"));
                MainView.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createMenuEntryExit(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = 5565720865837529173L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.onExit();
                System.exit(0);
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createHelpMenuEntry(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = 6242308413626437976L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpViewer.showHelp();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createIndividualMenuEntry(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = -8059115542489292024L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpViewer.showIndividual();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createCDInfoMenuEntry(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = -3104793275763984213L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpViewer.showCDInfo();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createPolsterCodeDialog(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = -954545782085282273L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PolsterCode.getInstance().show();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createSonderausstattungenDialog(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = 8313828845669408270L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Sonderausstattungen.getInstance().show();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createAbkuerzungenDialog(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = -2564838851478073805L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Abkuerzungen.getInstance().show();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createTFAttributeDialog(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = -2533074419568669608L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TFAttribute.getInstance().show();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createTippsTricksDialog(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = -4568444130503773808L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalObjects.getInstance().getEtkData().anzeigenTippsTricksUebersicht();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createVersionDialog(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = -8706010707735275398L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Version.getInstance().show();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createAusstattungDialog(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = 7644830790410221962L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgAusstattung.getInstance().show();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem printScreenshot(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = -4887565864193189999L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenshotPrinter.getInstance().printScreenshot();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createSchnittstellenMenuEntry(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = -5238887519804725826L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogView oDlgView = null;
                Container c = MainView.this.getContentPane();
                for (int ii = 0; ii < c.getComponentCount(); ++ii) {
                    Component oldComponent = c.getComponent(ii);
                    if (!(oldComponent instanceof DialogView)) continue;
                    oDlgView = (DialogView)((Object)oldComponent);
                    break;
                }
                AskProperties dlg = new AskProperties(oDlgView);
                dlg.setVisible(true);
                MainView.this.repaint();
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    protected JMenuItem createMenuEntryTeilesucheZubehoer(String sMenuItem) {
        AbstractAction handleMenuItem = new AbstractAction(sMenuItem){
            private static final long serialVersionUID = -1001455633334414175L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView mainView = MainView.getInstance();
                if (mainView == null) {
                    return;
                }
                TeilesucheZubehoer.callIpac(mainView, null);
            }
        };
        return new JMenuItem(handleMenuItem);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isIsis() {
        return this.mIsis;
    }

    public void activate() {
        this.deactivateGlassPane();
    }

    public void deactivate() {
        this.activateGlassPane();
    }

    private void activateGlassPane() {
        JRootPane oRootPane = super.getRootPane();
        if (oRootPane == null) {
            return;
        }
        Component oGlassPane = oRootPane.getGlassPane();
        if (oGlassPane == null) {
            return;
        }
        if (oGlassPane instanceof MainGlassPane) {
            MainGlassPane glassPane = (MainGlassPane)oGlassPane;
            glassPane.activate();
        }
    }

    private void deactivateGlassPane() {
        JRootPane oRootPane = super.getRootPane();
        if (oRootPane == null) {
            return;
        }
        Component oGlassPane = oRootPane.getGlassPane();
        if (oGlassPane == null) {
            return;
        }
        if (oGlassPane instanceof MainGlassPane) {
            MainGlassPane glassPane = (MainGlassPane)oGlassPane;
            glassPane.deactivate();
        }
    }

    protected class MainViewWindowListener
    extends WindowAdapter {
        protected MainViewWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            log.debug((Object)"windowClosing");
            MainView.this.hidden = true;
            Container c = MainView.this.getContentPane();
            for (int ii = 0; ii < c.getComponentCount(); ++ii) {
                Component oldComponent = c.getComponent(ii);
                if (!(oldComponent instanceof DialogView)) continue;
                DialogView oldView = (DialogView)((Object)oldComponent);
                oldView.onExit();
            }
            MainView.this.onExit();
        }
    }
}

