/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.generictable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import webetk.javaclient.dialog.bte.TeilenummernZeile;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.DreieckLabel;
import webetk.javaclient.generictable.DreieckTextAndTooltip;
import webetk.javaclient.generictable.GenericRow;
import webetk.javaclient.generictable.GenericTableModel;

public class DreieckCellRenderer
extends DreieckLabel
implements TableCellRenderer,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private Color unselectedForeground;
    private Color unselectedBackground;
    private int horizontalSpacing = 10;

    public DreieckCellRenderer() {
        this.setOpaque(true);
        this.setBorder(DreieckCellRenderer.getNoFocusBorder());
        this.setHorizontalAlignment(0);
    }

    public DreieckCellRenderer(String text, String tooltip) {
        this.setOpaque(true);
        this.setBorder(DreieckCellRenderer.getNoFocusBorder());
        this.setHorizontalAlignment(0);
        this.setText(text);
        this.setToolTipText(tooltip);
    }

    public void setValue(Object value) {
        if (value == null) {
            this.setText(null);
            this.setToolTipText(null);
        } else if (value instanceof DreieckTextAndTooltip) {
            DreieckTextAndTooltip oDreieckTextAndTooltip = (DreieckTextAndTooltip)value;
            this.setText(oDreieckTextAndTooltip.getText());
            this.setToolTipText(oDreieckTextAndTooltip.getTooltip());
        } else {
            this.setText(value == null ? "" : value.toString());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width += 2 * this.horizontalSpacing;
        return d;
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int pHorizontalSpacing) {
        this.horizontalSpacing = pHorizontalSpacing;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(border);
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    super.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    super.setBackground(col);
                }
            }
        } else {
            this.setBorder(DreieckCellRenderer.getNoFocusBorder());
        }
        this.setValue(value);
        this.setCorner(false);
        TableModel model = table.getModel();
        if (!isSelected) {
            this.setBackground(Color.white);
        }
        if (model instanceof GenericTableModel) {
            GenericTableModel genmodel = (GenericTableModel)model;
            if (row >= 0 && row < genmodel.getRowCount()) {
                TeilenummernZeile oTeileNrZeile;
                AbstractRow abstractrow;
                Color color;
                GenericRow modelrow = genmodel.getRow(row);
                if (modelrow instanceof AbstractRow && (color = (abstractrow = (AbstractRow)modelrow).getBackColor()) != null) {
                    this.setBackground(color);
                }
                if (modelrow instanceof TeilenummernZeile && (oTeileNrZeile = (TeilenummernZeile)modelrow).getTooltipBenennungskommentar() != null && !oTeileNrZeile.getTooltipBenennungskommentar().equals("")) {
                    this.setCorner(true);
                }
            }
        }
        return this;
    }

    private static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return noFocusBorder;
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

