/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.generictable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import webetk.javaclient.dialog.bte.KommentarZeile;
import webetk.javaclient.dialog.spezifteilesuche.suchergebnisse.BildtafelnZeile;
import webetk.javaclient.generictable.AbstractRow;
import webetk.javaclient.generictable.GenericRow;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.lookandfeel.UIHelper;

public class ETKDefaultTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private DefaultTableCellRenderer dr = new DefaultTableCellRenderer();
    private int horizontalSpacing = 0;
    private int alignment = 2;
    private Font stdFont;
    private Font boldFont;

    public ETKDefaultTableCellRenderer() {
        this.setLayout(null);
        this.stdFont = UIHelper.getNormalFont();
        this.boldFont = this.stdFont.deriveFont(1);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = this.dr.getPreferredSize();
        d.width += 2 * this.horizontalSpacing;
        return d;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableModel model;
        this.remove(this.dr);
        Component c = this.dr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.add(c);
        this.dr.setForeground(Color.black);
        if (!isSelected) {
            this.dr.setBackground(Color.white);
        }
        if ((model = table.getModel()) instanceof GenericTableModel) {
            GenericTableModel genmodel = (GenericTableModel)model;
            if (row >= 0 && row < genmodel.getRowCount()) {
                JLabel l;
                GenericRow modelrow = genmodel.getRow(row);
                if (modelrow instanceof AbstractRow) {
                    AbstractRow abstarctrow = (AbstractRow)modelrow;
                    Color color = abstarctrow.getForeColor();
                    if (color != null) {
                        this.dr.setForeground(color);
                    }
                    if (!isSelected && (color = abstarctrow.getBackColor()) != null) {
                        this.dr.setBackground(color);
                    }
                }
                if (modelrow instanceof BildtafelnZeile) {
                    BildtafelnZeile ZeileBTE = (BildtafelnZeile)modelrow;
                    if (c instanceof JLabel) {
                        l = (JLabel)c;
                        if (ZeileBTE.isMarkRed()) {
                            l.setForeground(Color.red);
                        }
                    }
                }
                if (modelrow instanceof KommentarZeile) {
                    KommentarZeile ZeileK = (KommentarZeile)modelrow;
                    if (c instanceof JLabel) {
                        l = (JLabel)c;
                        if (ZeileK.isBold()) {
                            l.setFont(this.boldFont);
                        } else {
                            l.setFont(this.stdFont);
                        }
                    }
                }
            }
        }
        this.setBackground(this.dr.getBackground());
        return this;
    }

    public void setHorizontalAlignment(int value) {
        if (value != 0 && value != 2 && value != 4) {
            throw new IllegalArgumentException("setHorizontalAlignment must be JLabel.CENTER or JLabel.LEFT or JLabel.RIGHT");
        }
        this.alignment = value;
    }

    @Override
    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        Dimension contentSize = this.dr.getPreferredSize();
        int offsetY = (height - contentSize.height) / 2;
        switch (this.alignment) {
            case 2: {
                int maxWidthDirectRenderer = width - 2 * this.horizontalSpacing;
                int directRendererWidth = Math.min(maxWidthDirectRenderer, contentSize.width);
                this.dr.setBounds(this.horizontalSpacing, offsetY, directRendererWidth, contentSize.height);
                break;
            }
            case 0: {
                int offsetX = Math.max(width - contentSize.width, 0) / 2;
                int directRendererWidth = Math.min(contentSize.width, width);
                this.dr.setBounds(offsetX, offsetY, directRendererWidth, contentSize.height);
                break;
            }
            case 4: {
                int maxWidthDirectRenderer = width - 2 * this.horizontalSpacing;
                int directRendererWidth = Math.min(maxWidthDirectRenderer, contentSize.width);
                this.dr.setBounds(width - directRendererWidth - this.horizontalSpacing, offsetY, directRendererWidth, contentSize.height);
                break;
            }
        }
    }

    public DefaultTableCellRenderer getOriginalRenderer() {
        return this.dr;
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        this.horizontalSpacing = horizontalSpacing;
    }
}

