/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.generictable;

import de.esg.commonclient.dialog.JButtonEx;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import webetk.javaclient.dialog.ImageCache;

public class TableConfiguration {
    public static final int LEFT = 2;
    public static final int CENTER = 0;
    public static final int RIGHT = 4;
    private int columnCount;
    private ArrayList<ColumnData> columns = new ArrayList();
    private boolean bHasButons = false;
    private boolean usePrototypeIcons = false;

    public TableConfiguration addColumn(String columnName, int columnAlignment, Class<?> columnClass, Object prototype) {
        ++this.columnCount;
        this.columns.add(new ColumnData(columnName, columnAlignment, columnClass, false, prototype));
        return this;
    }

    public TableConfiguration addColumn(String columnName, int columnAlignment, Class<?> columnClass, boolean resizeable, Object prototype) {
        ++this.columnCount;
        this.columns.add(new ColumnData(columnName, columnAlignment, columnClass, resizeable, prototype));
        return this;
    }

    public TableConfiguration addColumn(String columnName, int columnAlignment, boolean resizeable, String prototype) {
        ++this.columnCount;
        this.columns.add(new ColumnData(columnName, columnAlignment, String.class, resizeable, prototype));
        return this;
    }

    public TableConfiguration addIconColumn(String icon) {
        ++this.columnCount;
        this.columns.add(new ColumnData("", 0, Icon.class, false, ImageCache.getInstance().getIcon(icon)));
        return this;
    }

    public TableConfiguration addIconColumn(String icon, String tooltip) {
        ++this.columnCount;
        this.columns.add(new ColumnData("", 0, Icon.class, false, ImageCache.getInstance().getIcon(icon), tooltip));
        return this;
    }

    public TableConfiguration addIconColumn(String iconname, String title, String tooltip) {
        ++this.columnCount;
        ImageIcon icon = null;
        if (iconname != null) {
            icon = ImageCache.getInstance().getIcon(iconname);
        }
        this.columns.add(new ColumnData(title, 0, Icon.class, false, icon, tooltip));
        return this;
    }

    public int getAlignment(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnCount) {
            throw new IllegalArgumentException("Illegal columnIndex in getAlignment. index=" + columnIndex + " number of colums=" + this.columnCount);
        }
        ColumnData data = this.columns.get(columnIndex);
        return data.columnAlignment;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnCount) {
            throw new IllegalArgumentException("Illegal columnIndex in getAlignment. index=" + columnIndex + " number of colums=" + this.columnCount);
        }
        ColumnData data = this.columns.get(columnIndex);
        return data.columnName;
    }

    public Object getPrototype(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnCount) {
            throw new IllegalArgumentException("Illegal columnIndex in getAlignment. index=" + columnIndex + " number of colums=" + this.columnCount);
        }
        ColumnData data = this.columns.get(columnIndex);
        return data.prototype;
    }

    public boolean isResizeable(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnCount) {
            throw new IllegalArgumentException("Illegal columnIndex in getAlignment. index=" + columnIndex + " number of colums=" + this.columnCount);
        }
        ColumnData data = this.columns.get(columnIndex);
        return data.resizeable;
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnCount) {
            throw new IllegalArgumentException("Illegal columnIndex in getAlignment. index=" + columnIndex + " number of colums=" + this.columnCount);
        }
        ColumnData data = this.columns.get(columnIndex);
        return data.columnClass;
    }

    public TableCellEditor getEditor(int columnIndex) {
        ColumnData data = this.columns.get(columnIndex);
        return data.editor;
    }

    public void setEditor(int columnIndex, TableCellEditor editor) {
        ColumnData data = this.columns.get(columnIndex);
        data.editor = editor;
    }

    public boolean setEditor(String columnName, TableCellEditor editor) {
        int idx = this.getColumnIndex(columnName);
        if (idx != -1) {
            this.setEditor(idx, editor);
            return true;
        }
        return false;
    }

    public TableCellRenderer getRenderer(int columnIndex) {
        ColumnData data = this.columns.get(columnIndex);
        return data.renderer;
    }

    public void setRenderer(int columnIndex, TableCellRenderer renderer) {
        ColumnData data = this.columns.get(columnIndex);
        data.renderer = renderer;
    }

    public boolean setRenderer(String columnName, TableCellRenderer renderer) {
        int idx = this.getColumnIndex(columnName);
        if (idx != -1) {
            this.setRenderer(idx, renderer);
            return true;
        }
        return false;
    }

    public String getTooltip(int columnIndex) {
        ColumnData data = this.columns.get(columnIndex);
        return data.tooltip;
    }

    public void setTooltip(int columnIndex, String tooltip) {
        ColumnData data = this.columns.get(columnIndex);
        data.tooltip = tooltip;
    }

    public String getHeaderTooltip(int columnIndex) {
        ColumnData data = this.columns.get(columnIndex);
        return data.headerTooltip;
    }

    public JButtonEx getHeaderButtonLeft(int columnIndex) {
        ColumnData data = this.columns.get(columnIndex);
        return data.headerButtonLeft;
    }

    public JButtonEx getHeaderButtonRight(int columnIndex) {
        ColumnData data = this.columns.get(columnIndex);
        return data.headerButtonRight;
    }

    public void setHeaderTooltip(int columnIndex, String tooltip) {
        ColumnData data = this.columns.get(columnIndex);
        data.headerTooltip = tooltip;
    }

    public void setHeaderButtonLeft(int columnIndex, JButtonEx button) {
        ColumnData data = this.columns.get(columnIndex);
        data.headerButtonLeft = button;
    }

    public void setHeaderButtonRight(int columnIndex, JButtonEx button) {
        ColumnData data = this.columns.get(columnIndex);
        data.headerButtonRight = button;
    }

    public boolean setHeaderTooltip(String columnName, String tooltip) {
        int idx = this.getColumnIndex(columnName);
        if (idx != -1) {
            this.setHeaderTooltip(idx, tooltip);
            return true;
        }
        return false;
    }

    protected int getColumnIndex(String columnName) {
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnData data = this.columns.get(i);
            if (data.columnName == null || !data.columnName.equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setUsePrototypeIcons(boolean val) {
        this.usePrototypeIcons = val;
    }

    public boolean getUsePrototypeIcons() {
        return this.usePrototypeIcons;
    }

    public boolean getHasButtons() {
        return this.bHasButons;
    }

    public void setHasButtons(boolean bHasButons) {
        this.bHasButons = bHasButons;
    }

    private static class ColumnData {
        String columnName;
        int columnAlignment;
        Class<?> columnClass;
        Object prototype;
        boolean resizeable;
        String tooltip;
        String headerTooltip;
        JButtonEx headerButtonLeft;
        JButtonEx headerButtonRight;
        TableCellEditor editor;
        TableCellRenderer renderer;

        public ColumnData(String columnName, int columnAlignment, Class<?> columnClass, boolean resizeable, Object prototype) {
            this.columnName = columnName;
            this.columnAlignment = columnAlignment;
            this.columnClass = columnClass;
            this.prototype = prototype;
            this.resizeable = resizeable;
            this.tooltip = null;
        }

        public ColumnData(String columnName, int columnAlignment, Class<?> columnClass, boolean resizeable, Object prototype, String tooltip) {
            this.columnName = columnName;
            this.columnAlignment = columnAlignment;
            this.columnClass = columnClass;
            this.prototype = prototype;
            this.resizeable = resizeable;
            this.tooltip = tooltip;
        }
    }
}

