/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.infotool;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;
import webetk.app.infotool.InfoObject;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.generictable.GenericTableModel;
import webetk.javaclient.generictable.GenericTableMouseEvent;
import webetk.javaclient.generictable.GenericTableMouseEventAdapter;
import webetk.javaclient.generictable.GenericTableMouseEventListener;
import webetk.javaclient.generictable.TableConfiguration;
import webetk.javaclient.infotool.TippsTricksDlg;
import webetk.javaclient.infotool.Zeile;
import webetk.javaclient.infotool.ZeileRenderer;
import webetk.resources.Resource;

public class TippsTricksUebersichtDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private GenericTableModel tableModel;
    private GenericTable table;
    protected JPanel panHeader;
    protected JPanel panTippsTricks;
    private JPopupMenu menuPopup = null;
    private JMenuItem menuitemDetail = null;
    private Collection<InfoObject> maTippsTricksWichtig = null;
    private Collection<InfoObject> maTippsTricksNormal = null;

    public TippsTricksUebersichtDlg(JFrame oFrame) {
        super((Frame)oFrame, true);
        this.setTitle(Resource.getInstance().getTippsTricks() + ": " + Resource.getInstance().getUebersicht());
        this.setSize(800, 480);
        this.setLocation(50, 50);
        this.initComponents();
        this.initMenus();
        this.maTippsTricksWichtig = GlobalObjects.getInstance().getEtkData().ladenTippsTricks(true, false);
        this.maTippsTricksNormal = GlobalObjects.getInstance().getEtkData().ladenTippsTricks(false, false);
        if (this.maTippsTricksWichtig.size() == 0 && this.maTippsTricksNormal.size() == 0) {
            this.dispose();
            return;
        }
        this.update();
    }

    public void initComponents() {
        this.panHeader = new HeaderPanel(Resource.getInstance().getTippsTricks() + ": " + Resource.getInstance().getUebersicht(), null);
        this.panTippsTricks = new TitledPanel("");
        TableConfiguration config = new TableConfiguration();
        config.addColumn(Resource.getInstance().getNueNr(), 2, true, "XXXXXXX");
        config.setHeaderTooltip(0, Resource.getInstance().getNummer());
        config.addColumn(Resource.getInstance().getUeberschrift(), 2, true, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        config.addColumn(Resource.getInstance().getGelesen(), 0, true, "X");
        ZeileRenderer renderer = new ZeileRenderer();
        config.setRenderer(0, (TableCellRenderer)renderer);
        config.setRenderer(1, (TableCellRenderer)renderer);
        this.tableModel = new GenericTableModel(config);
        this.table = new GenericTable(this.tableModel);
        this.table.addMouseListener(new GenericTableMouseEventAdapter(){

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
                if (TippsTricksUebersichtDlg.this.table.getTable().getSelectedRowCount() >= 1 && TippsTricksUebersichtDlg.this.menuPopup != null) {
                    TippsTricksUebersichtDlg.this.menuPopup.show(TippsTricksUebersichtDlg.this.table.getTable(), evt.getX(), evt.getY());
                }
            }
        });
        GenericTableMouseEventListener listenerTable = new GenericTableMouseEventListener(){

            @Override
            public void clickedOnCell(GenericTableMouseEvent e) {
            }

            @Override
            public void clickedOnCellDouble(GenericTableMouseEvent evt) {
                TippsTricksUebersichtDlg.this.showTippsTricksDetail();
            }

            @Override
            public void popupOnCell(GenericTableMouseEvent evt) {
            }
        };
        this.table.addMouseListener(listenerTable, 0);
        this.table.addMouseListener(listenerTable, 1);
        this.table.addMouseListener(listenerTable, 2);
        this.layoutAll();
    }

    public void initMenus() {
        this.menuPopup = new JPopupMenu();
        this.menuitemDetail = new JMenuItem(Resource.getInstance().getTippsTricksAnzeigenErsteZeile() + " " + Resource.getInstance().getTippsTricksAnzeigenZweiteZeile());
        this.menuitemDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TippsTricksUebersichtDlg.this.showTippsTricksDetail();
            }
        });
        this.menuPopup.add(this.menuitemDetail);
    }

    protected void layoutAll() {
        Container panContent = this.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        panContent.setLayout(l);
        panContent.add((Component)this.panHeader, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        panContent.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    public JPanel createContent() {
        JPanel p = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(1, 1);
        l.setRowWeight(2, 1);
        p.setLayout(l);
        p.add((Component)this.createTippsTricksPanel(), c.rc(2, 1));
        return p;
    }

    public JPanel createTippsTricksPanel() {
        int[] w = new int[]{10, 0, 10};
        int[] h = new int[]{10, 0, 10};
        HIGLayout l = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        l.setColumnWeight(2, 1);
        l.setRowWeight(2, 1);
        this.panTippsTricks.setLayout(l);
        this.panTippsTricks.add((Component)this.table.getScrollPane(), c.rc(2, 2));
        return this.panTippsTricks;
    }

    private void update() {
        this.tableModel.removeAllRows();
        for (InfoObject oInfoObject : this.maTippsTricksWichtig) {
            this.tableModel.addRow(new Zeile(oInfoObject));
        }
        for (InfoObject oInfoObject : this.maTippsTricksNormal) {
            this.tableModel.addRow(new Zeile(oInfoObject));
        }
    }

    private void showTippsTricksDetail() {
        List<InfoObject> cTippTrick = this.getSelectedTippsTricks();
        if (cTippTrick.size() == 0) {
            return;
        }
        int nIndex = -1;
        if (cTippTrick.size() == 1) {
            cTippTrick = this.getAlleTippsTricks();
            nIndex = this.getFirstSelectedTippTrick();
        } else {
            nIndex = -1;
        }
        TippsTricksDlg dlg = new TippsTricksDlg(MainView.getInstance(), cTippTrick, nIndex, 3);
        dlg.setVisible(true);
        List<InfoObject> cErgebnis = dlg.getExitData();
        this.uebernehmenGelesenFlag(cErgebnis);
        this.update();
    }

    private List<InfoObject> getSelectedTippsTricks() {
        ArrayList<InfoObject> cSelectedItems = new ArrayList<InfoObject>();
        int[] aRows = this.table.getTable().getSelectedRows();
        for (int ii = 0; ii < aRows.length; ++ii) {
            Zeile oRow = (Zeile)this.tableModel.getRow(aRows[ii]);
            cSelectedItems.add(oRow.getObject());
        }
        return cSelectedItems;
    }

    private List<InfoObject> getAlleTippsTricks() {
        ArrayList<InfoObject> cAllItems = new ArrayList<InfoObject>();
        for (InfoObject oObj : this.maTippsTricksWichtig) {
            cAllItems.add(oObj);
        }
        for (InfoObject oObj : this.maTippsTricksNormal) {
            cAllItems.add(oObj);
        }
        return cAllItems;
    }

    private int getFirstSelectedTippTrick() {
        int[] aRows = this.table.getTable().getSelectedRows();
        if (aRows.length > 0) {
            return aRows[0];
        }
        return -1;
    }

    private void uebernehmenGelesenFlag(List<InfoObject> cErgebnis) {
        for (InfoObject oObj1 : cErgebnis) {
            String sId2;
            String sId1 = oObj1.getId();
            for (InfoObject oObj2 : this.maTippsTricksWichtig) {
                sId2 = oObj2.getId();
                if (!sId1.equals(sId2)) continue;
                oObj2.isGelesen(oObj1.isGelesen());
            }
            for (InfoObject oObj2 : this.maTippsTricksNormal) {
                sId2 = oObj2.getId();
                if (!sId1.equals(sId2)) continue;
                oObj2.isGelesen(oObj1.isGelesen());
            }
        }
    }
}

