/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.lookandfeel;

import de.esg.commonclient.GlobalObjects;
import java.awt.Color;
import java.awt.Font;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.log4j.Logger;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.lookandfeel.UIHelper;

public class WebETKTheme
extends DefaultMetalTheme {
    private static Logger log = Logger.getLogger(WebETKTheme.class);
    private static final int CONTROL_TEXT_FONT = 0;
    private static final int SYSTEM_TEXT_FONT = 1;
    private static final int USER_TEXT_FONT = 2;
    private static final int MENU_TEXT_FONT = 3;
    private static final int WINDOW_TITLE_FONT = 4;
    private static final int SUB_TEXT_FONT = 5;
    private static final int BIG_TITLE_FONT = 6;
    private static final int SMALL_TITLE_FONT = 7;
    private static final int PRINT_TITLE_FONT = 8;
    private static final int PRINT_FONT = 9;
    private static final int FAX_BIG_TITLE_FONT = 10;
    private static final int FAX_SMALL_TITLE_FONT = 11;
    private static final int FAX_FONT = 12;
    private static final int SPRACHEN_CB_UNICODE_FONT = 13;
    private static final int ANZAHL_FONTS = 14;
    private static final int[] latinFontStyles = new int[]{0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0};
    private static final int[] unicodeFontStyles = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String[] latinFontNames = new String[]{"Arial", "Arial", "Arial", "Arial", "Arial", "Arial", "Arial", "Arial", "Arial", "Arial", "Arial", "Arial", "Arial", "Arial Unicode MS"};
    private static final String[] unicodeFontNames = new String[]{"Arial Unicode MS", "Arial Unicode MS", "Arial Unicode MS", "Arial Unicode MS", "Arial Unicode MS", "Arial Unicode MS", "Arial Unicode MS", "Arial Unicode MS", "Arial Unicode MS", "Arial Unicode MS", "Arial Unicode MS", "Arial Unicode MS", "Arial Unicode MS", "Arial Unicode MS"};
    private static final String[] thaiFontNames = new String[]{"Lucida Sans", "Lucida Sans", "Lucida Sans", "Lucida Sans", "Lucida Sans", "Lucida Sans", "Lucida Sans", "Lucida Sans", "Lucida Sans", "Lucida Sans", "Lucida Sans", "Lucida Sans", "Lucida Sans", "Arial Unicode MS"};
    private static final int[] bigFontSizes = new int[]{14, 18, 14, 14, 14, 23, 22, 16, 12, 10, 16, 8, 8, 14};
    private static final int[] smallFontSizes = new int[]{11, 15, 11, 11, 11, 20, 22, 16, 12, 10, 16, 8, 8, 11};
    private static int[] fontStyles = latinFontStyles;
    private static String[] fontNames = latinFontNames;
    private static int[] fontSizes = bigFontSizes;
    private static MyFontDelegate fontDelegate = new MyFontDelegate();
    private static final ColorUIResource primary1 = new ColorUIResource(102, 102, 153);
    private static final ColorUIResource primary2 = new ColorUIResource(123, 156, 210);
    private static final ColorUIResource primary3 = new ColorUIResource(204, 204, 255);
    private static final ColorUIResource secondary1 = new ColorUIResource(102, 102, 102);
    private static final ColorUIResource secondary2 = new ColorUIResource(0.632f, 0.64000005f, 0.71999997f);
    private static final ColorUIResource secondary3 = new ColorUIResource(213, 222, 229);

    public WebETKTheme() {
        WebETKTheme.useWebETKFont();
    }

    @Override
    public String getName() {
        return "WebETKTheme";
    }

    @Override
    public FontUIResource getControlTextFont() {
        return WebETKTheme.getFont(0);
    }

    @Override
    public FontUIResource getSystemTextFont() {
        return WebETKTheme.getFont(1);
    }

    @Override
    public FontUIResource getUserTextFont() {
        return WebETKTheme.getFont(2);
    }

    @Override
    public FontUIResource getMenuTextFont() {
        return WebETKTheme.getFont(3);
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        return WebETKTheme.getFont(4);
    }

    @Override
    public FontUIResource getSubTextFont() {
        return WebETKTheme.getFont(5);
    }

    private static FontUIResource getFont(int key) {
        return fontDelegate.getFont(key);
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return primary1;
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return primary2;
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return primary3;
    }

    @Override
    protected ColorUIResource getSecondary1() {
        return secondary1;
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return secondary2;
    }

    @Override
    protected ColorUIResource getSecondary3() {
        return secondary3;
    }

    public static ColorUIResource getETKDefaultBackgroundColor() {
        return secondary3;
    }

    @Override
    public void addCustomEntriesToTable(UIDefaults table) {
        super.addCustomEntriesToTable(table);
        log.debug((Object)"addCustomEntriesToTable");
        table.put("Table.font", WebETKTheme.getFont(0));
        table.put("Label.foreground", this.getControlTextColor());
        table.put("TitledBorder.titleColor", this.getControlTextColor());
        Color foreground = Color.black;
        Color background = new Color(186, 210, 255);
        table.put("MenuItem.selectionBackground", background);
        table.put("Menu.selectionBackground", background);
        table.put("ComboBox.selectionBackground", new Color(255, 255, 125));
        table.put("MenuItem.selectionForeground", foreground);
        table.put("Menu.selectionForeground", foreground);
        table.put("ComboBox.selectionForeground", foreground);
        table.put("Table.selectionForeground", Color.black);
        table.put("Table.selectionBackground", new Color(255, 255, 125));
        table.put("List.selectionForeground", Color.black);
        table.put("List.selectionBackground", new Color(255, 255, 125));
        table.put("Tree.selectionForeground", Color.black);
        table.put("Tree.selectionBackground", new Color(255, 255, 125));
        table.put("Tree.collapsedIcon", UIHelper.getPlusIcon());
        table.put("Tree.expandedIcon", UIHelper.getMinusIcon());
        table.put("Tree.font", UIHelper.getNormalFont());
        table.put("Table.font", UIHelper.getNormalFont());
        table.put("List.font", UIHelper.getNormalFont());
        table.put("TabbedPane.background", secondary3);
        table.put("TabbedPane.selected", UIHelper.getBrighterBackground());
        table.put("TabbedPane.hightlight", UIHelper.getBrighterBackground());
        InsetsUIResource tabbedPaneContentBorderInsets = new InsetsUIResource(0, 1, 2, 2);
        table.put("TabbedPane.contentBorderInsets", tabbedPaneContentBorderInsets);
        table.put("TextPane.selectionBackground", new Color(255, 255, 125));
        table.put("TextField.selectionBackground", new Color(255, 255, 125));
        table.put("TextArea.selectionBackground", new Color(255, 255, 125));
        table.put("ToolTip.font", UIHelper.getNormalFont());
        table.put("ToolTip.background", new Color(255, 255, 125));
        table.put("ScrollBar.foreground", Color.red);
        table.put("ScrollBar.background", Color.green);
        table.put("ScrollBar.thumb", secondary3);
        table.put("ScrollBar.thumbHighlight", this.getControlHighlight());
        table.put("ScrollBar.thumbDarkShadow", this.getControlDarkShadow().darker());
        table.put("ScrollBar.thumbShadow", this.getControlShadow());
        table.put("ScrollBar.track", Color.cyan);
        table.put("ScrollBar.trackHighlight", Color.yellow);
        table.put("ScrollBarUI", "webetk.javaclient.lookandfeel.ETKScrollBarUI");
        table.put("Table.focusCellHighlightBorder", new EmptyBorder(1, 1, 1, 1));
    }

    public static void useGrosseSchriftart(boolean val) {
        fontDelegate = new MyFontDelegate();
        fontSizes = val ? bigFontSizes : smallFontSizes;
        try {
            MainView mv;
            UIManager.setLookAndFeel(new MetalLookAndFeel());
            if (!GlobalObjects.getInstance().getIstStandalone()) {
                UIManager.getLookAndFeelDefaults().put("ClassLoader", MainView.getInstance().getClass().getClassLoader());
            }
            if ((mv = MainView.getInstance()) != null) {
                log.debug((Object)"*** MainView ist nicht null");
                SwingUtilities.updateComponentTreeUI(mv);
                mv.invalidate();
                mv.validate();
                mv.repaint();
            } else {
                log.debug((Object)"*** MainView ist angeblich null");
            }
        }
        catch (UnsupportedLookAndFeelException e) {
            log.error((Object)e.getMessage());
        }
    }

    protected static void useWebETKFont() {
        log.debug((Object)"Changing Font to Arial");
        fontNames = latinFontNames;
        fontStyles = latinFontStyles;
    }

    public static void changeFont(String sISO) {
        fontDelegate = new MyFontDelegate();
        boolean bIstExotenSprache = WebETKTheme.testeExotensprache(sISO);
        if (sISO.equals("th")) {
            fontNames = thaiFontNames;
            fontStyles = latinFontStyles;
        } else if (bIstExotenSprache) {
            fontNames = unicodeFontNames;
            fontStyles = unicodeFontStyles;
        } else {
            fontNames = latinFontNames;
            fontStyles = latinFontStyles;
        }
        try {
            MainView mv;
            UIManager.setLookAndFeel(new MetalLookAndFeel());
            if (!GlobalObjects.getInstance().getIstStandalone()) {
                UIManager.getLookAndFeelDefaults().put("ClassLoader", MainView.getInstance().getClass().getClassLoader());
            }
            if ((mv = MainView.getInstance()) != null) {
                log.debug((Object)"*** MainView ist nicht null");
                SwingUtilities.updateComponentTreeUI(mv);
                mv.invalidate();
                mv.validate();
                mv.repaint();
            } else {
                log.debug((Object)"*** MainView ist angeblich null");
            }
        }
        catch (UnsupportedLookAndFeelException e) {
            log.error((Object)e.getMessage());
        }
    }

    public static boolean testeExotensprache(String sISO) {
        if (sISO == null) {
            return false;
        }
        return sISO.equals("ja") || sISO.equals("ko") || sISO.equals("th") || sISO.equals("zh");
    }

    public static Font getBigTitleFont() {
        return WebETKTheme.getFont(6);
    }

    public static Font getSmallTitleFont() {
        return WebETKTheme.getFont(7);
    }

    public static Font getPrintTitleFont() {
        return WebETKTheme.getFont(8);
    }

    public static Font getPrintFont() {
        return WebETKTheme.getFont(9);
    }

    public static Font getFaxBigTitleFont() {
        return WebETKTheme.getFont(10);
    }

    public static Font getFaxSmallTitleFont() {
        return WebETKTheme.getFont(11);
    }

    public static Font getFaxFont() {
        return WebETKTheme.getFont(12);
    }

    public static Font getSprachenCbUnicodeFont() {
        return WebETKTheme.getFont(13);
    }

    private static class MyFontDelegate {
        FontUIResource[] fonts = new FontUIResource[14];

        public FontUIResource getFont(int type) {
            if (this.fonts[type] == null) {
                Font f = new Font(fontNames[type], fontStyles[type], fontSizes[type]);
                this.fonts[type] = new FontUIResource(f);
            }
            return this.fonts[type];
        }
    }
}

