/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.utils;

import de.esg.commonclient.dialog.JButtonEx;
import de.esg.tools.win32.registry.WindowsRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import webetk.javaclient.dialog.ImageCache;
import webetk.resources.Resource;

public class DirectoryChooserDialog
extends JDialog
implements TreeWillExpandListener {
    private static final long serialVersionUID = 1L;
    protected JButtonEx approveButton;
    protected JButtonEx cancelButton;
    protected InnerJTree tree;
    protected DefaultTreeModel treeModel;
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeCellRenderer renderer;
    protected boolean treeExpanding;
    protected LinkedList<DefaultMutableTreeNode> expandedNodes;
    protected File selectedFolder;
    protected JTextField pathTextField;
    protected static File rootDirectory = File.listRoots()[0];
    protected JScrollPane scrollPane;
    protected int returnVal;
    protected FileSystemView fsv;
    protected boolean showFiles;

    public DirectoryChooserDialog(JFrame owner, String sHeader, String sPath, boolean bShowFiles) {
        super((Frame)owner, true);
        this.showFiles = bShowFiles;
        this.setTitle(sHeader);
        this.treeExpanding = false;
        this.expandedNodes = new LinkedList();
        this.fsv = new JFileChooser().getFileSystemView();
        this.approveButton = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.approveButton.addActionListener(new OkButtonActionListener());
        this.cancelButton = new JButtonEx(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryChooserDialog.this.returnVal = 2;
                DirectoryChooserDialog.this.dispose();
            }
        });
        this.rootNode = new DefaultMutableTreeNode(this.fsv.getHomeDirectory());
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new InnerJTree(this.treeModel);
        this.renderer = new DefaultTreeCellRenderer();
        this.tree.setCellRenderer(this.renderer);
        this.tree.addTreeWillExpandListener(this);
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addKeyListener(new EnterKeyListener());
        this.scrollPane = new JScrollPane(this.tree);
        JLabel pathLabel = null;
        pathLabel = bShowFiles ? new JLabel(Resource.getInstance().getPfadUndDatei() + ":") : new JLabel(Resource.getInstance().getPfad() + ":");
        this.pathTextField = new JTextField();
        this.pathTextField.addActionListener(new OkButtonActionListener());
        JPanel pathPanel = new JPanel();
        GridBagLayout pathLayout = new GridBagLayout();
        pathPanel.setLayout(pathLayout);
        pathLayout.addLayoutComponent(pathLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        pathLayout.addLayoutComponent(this.pathTextField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        pathPanel.add(pathLabel);
        pathPanel.add(this.pathTextField);
        JPanel buttonPanel = new JPanel();
        GridBagLayout buttonLayout = new GridBagLayout();
        buttonPanel.setLayout(buttonLayout);
        buttonLayout.addLayoutComponent(this.approveButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        buttonLayout.addLayoutComponent(this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        buttonPanel.add(this.approveButton);
        buttonPanel.add(this.cancelButton);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)pathPanel, "North");
        c.add((Component)this.scrollPane, "Center");
        c.add((Component)buttonPanel, "South");
        this.pack();
        this.addWindowListener(new InnerWindowAdapter());
        this.setSize(500, 400);
        this.setPosition();
        this.rescan();
        this.selectedFolder = null;
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)DirectoryChooserDialog.this.tree.getLastSelectedPathComponent();
                if (node != null) {
                    DirectoryChooserDialog.this.pathTextField.setText(DirectoryChooserDialog.this.getPath());
                }
            }
        });
        this.gotoNode(sPath);
        this.pathTextField.setText(sPath);
        owner.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setPosition() {
        int width = Toolkit.getDefaultToolkit().getScreenSize().width;
        int height = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.setLocation((width - this.getWidth()) / 2, (height - this.getHeight()) / 2);
    }

    public File getSelectedFolder() {
        return this.selectedFolder;
    }

    protected File[] getInnerFolders(File expandThis) {
        int ii;
        File[] fileContents = FileSystemView.getFileSystemView().getFiles(expandThis, false);
        if (fileContents == null || fileContents.length == 0 || this.fsv.isFileSystemRoot(fileContents[0])) {
            return fileContents;
        }
        ArrayList<File> folders = new ArrayList<File>();
        for (int ii2 = 0; ii2 < fileContents.length; ++ii2) {
            if (!fileContents[ii2].isDirectory() || fileContents[ii2].isHidden()) continue;
            folders.add(fileContents[ii2]);
        }
        ArrayList<File> files = new ArrayList<File>();
        if (this.showFiles) {
            for (int ii3 = 0; ii3 < fileContents.length; ++ii3) {
                if (fileContents[ii3].isDirectory() || fileContents[ii3].isHidden()) continue;
                files.add(fileContents[ii3]);
            }
        }
        Collections.sort(folders);
        Collections.sort(files);
        File[] returnArray = new File[folders.size() + files.size()];
        for (ii = 0; ii < folders.size(); ++ii) {
            returnArray[ii] = (File)folders.get(ii);
        }
        for (ii = 0; ii < files.size(); ++ii) {
            returnArray[ii + folders.size()] = (File)files.get(ii);
        }
        return returnArray;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        if (this.treeExpanding) {
            this.treeExpanding = false;
            return;
        }
        TreePath selectedPath = e.getPath();
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
        if (!this.expandNode(currentNode)) {
            throw new ExpandVetoException(e);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    public boolean expandNode(DefaultMutableTreeNode currentNode) {
        ListIterator iterator = this.expandedNodes.listIterator();
        while (iterator.hasNext()) {
            if (iterator.next() != currentNode) continue;
            return true;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        File[] folders = this.getInnerFolders((File)currentNode.getUserObject());
        if (folders == null || folders.length == 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        currentNode.removeAllChildren();
        for (int ii = 0; ii < folders.length; ++ii) {
            DefaultMutableTreeNode innerNode = new DefaultMutableTreeNode(folders[ii]);
            currentNode.add(innerNode);
            if (!folders[ii].isDirectory()) continue;
            innerNode.add(new DefaultMutableTreeNode(null));
        }
        this.treeExpanding = true;
        this.treeModel.reload(currentNode);
        this.tree.expandPath(new TreePath(currentNode.getPath()));
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.treeExpanding = false;
        this.expandedNodes.add(currentNode);
        return true;
    }

    public void rescan() {
        this.expandedNodes.clear();
        this.treeModel.reload();
        this.expandNode(this.rootNode);
    }

    public int getRetVal() {
        return this.returnVal;
    }

    public String getDirectory() {
        return this.pathTextField.getText();
    }

    private String getPath() {
        File selectedFolder = (File)((DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent()).getUserObject();
        if (selectedFolder != null) {
            return selectedFolder.toString();
        }
        return "";
    }

    private void gotoNode(String sPath) {
        if (sPath == null) {
            return;
        }
        ArrayList<String> folders = new ArrayList<String>();
        boolean expandTree = false;
        while (sPath.indexOf(File.separator, 0) != -1) {
            folders.add(sPath.substring(0, sPath.indexOf(File.separator, 0)));
            sPath = sPath.substring(sPath.indexOf(File.separator, 0) + 1, sPath.length());
            expandTree = true;
        }
        if (sPath.length() > 0) {
            folders.add(sPath);
        }
        if (expandTree) {
            boolean bFound = false;
            String sArbeitsplatzName = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}";
            if (DirectoryChooserDialog.isMSWindowsNT()) {
                sArbeitsplatzName = WindowsRegistry.getValueAsString("HKEY_CLASSES_ROOT\\CLSID\\{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "");
            }
            for (int ii = 1; ii <= this.tree.getRowCount(); ++ii) {
                File file;
                DefaultMutableTreeNode node;
                TreePath treepath = this.tree.getPathForRow(ii);
                if (treepath == null || (node = (DefaultMutableTreeNode)treepath.getLastPathComponent()) == null || !(file = (File)node.getUserObject()).getName().equals(sArbeitsplatzName)) continue;
                this.expandNode(node);
                bFound = true;
                break;
            }
            if (!bFound) {
                this.expandNode((DefaultMutableTreeNode)this.tree.getPathForRow(1).getLastPathComponent());
            }
        }
        int currentIndex = 0;
        block2: for (int i = 0; i < folders.size(); ++i) {
            String folder = (String)folders.get(i);
            folder = folder.toUpperCase();
            for (int j = currentIndex; j < this.tree.getRowCount(); ++j) {
                String path = this.tree.getPathForRow(j).toString();
                if (!(path = path.toUpperCase()).endsWith(folder + File.separator + "]") && !path.endsWith(folder + "]")) continue;
                this.expandNode((DefaultMutableTreeNode)this.tree.getPathForRow(j).getLastPathComponent());
                currentIndex = ++j;
                continue block2;
            }
        }
        this.tree.scrollRowToVisible(--currentIndex + 10);
        this.tree.setSelectionRow(currentIndex);
    }

    public static boolean isMSWindowsNT() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return false;
        }
        return os.equalsIgnoreCase("Windows NT");
    }

    protected void doOkButtonAction() {
        if (this.tree.getSelectionPath() == null) {
            return;
        }
        this.selectedFolder = (File)((DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent()).getUserObject();
        if (this.selectedFolder.getName().indexOf("ShellFolder:") > -1) {
            this.selectedFolder = null;
            return;
        }
        this.returnVal = 0;
        this.dispose();
    }

    public static class InnerJTree
    extends JTree {
        private static final long serialVersionUID = 1L;
        protected FileSystemView fileSystemView = null;

        public InnerJTree(DefaultTreeModel treeModel) {
            super(treeModel);
        }

        @Override
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return this.getFileSystemView().getSystemDisplayName((File)((DefaultMutableTreeNode)value).getUserObject());
        }

        public FileSystemView getFileSystemView() {
            if (this.fileSystemView == null) {
                this.fileSystemView = FileSystemView.getFileSystemView();
            }
            return this.fileSystemView;
        }
    }

    public class InnerWindowAdapter
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent e) {
            DirectoryChooserDialog.this.returnVal = 64;
        }
    }

    protected class EnterKeyListener
    extends KeyAdapter {
        protected EnterKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if (ev.getKeyCode() == 10) {
                DirectoryChooserDialog.this.doOkButtonAction();
            }
        }
    }

    protected class OkButtonActionListener
    implements ActionListener {
        protected OkButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (DirectoryChooserDialog.this.approveButton.isEnabled()) {
                DirectoryChooserDialog.this.doOkButtonAction();
            }
        }
    }
}

