/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.ImageIcon;
import webetk.javaclient.framework.MainView;

public class ScreenshotPrinter
implements Printable {
    private ImageIcon screenshot;
    private static ScreenshotPrinter instance;

    private ScreenshotPrinter() {
    }

    public static ScreenshotPrinter getInstance() {
        if (instance == null) {
            instance = new ScreenshotPrinter();
        }
        return instance;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= 1) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        if (this.screenshot != null) {
            try {
                double scaleX = pageFormat.getImageableWidth() / (double)this.screenshot.getIconWidth();
                double scaleY = pageFormat.getImageableHeight() / (double)this.screenshot.getIconHeight();
                double scale = Math.min(scaleX, scaleY);
                g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                g2.scale(scale, scale);
                g2.translate(-pageFormat.getImageableX(), -pageFormat.getImageableY());
                g2.drawImage(this.screenshot.getImage(), (int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), this.screenshot.getImageObserver());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }

    public void printScreenshot() {
        MainView mainView = MainView.getInstance();
        Point mainViewLocation = mainView.getLocation();
        Rectangle rect = new Rectangle((int)mainViewLocation.getX(), (int)mainViewLocation.getY(), mainView.getWidth(), mainView.getHeight());
        try {
            Robot r = new Robot();
            BufferedImage i = r.createScreenCapture(rect);
            this.screenshot = new ImageIcon(i);
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = printerJob.defaultPage();
            pageFormat.setOrientation(0);
            printerJob.setPrintable(this, pageFormat);
            printerJob.print();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

