/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.workflow;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.DialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.ExitEventListener;
import org.apache.log4j.Logger;
import webetk.javaclient.dialog.defaultdialog.DlgDefaultController;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.framework.MainViewController;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.javaclient.workflow.Workflowsteuerung;

public class MainWorkflowsteuerung
implements ExitEventListener {
    private static Logger log = Logger.getLogger(MainWorkflowsteuerung.class);
    private Workflowsteuerung currentWorkflow;
    private DialogViewController defaultWorkflow;
    private boolean mbZurueckZurFI;
    private static MainWorkflowsteuerung MainWorkflowsteuerungInstance;

    public void init() {
        this.displayDefaultDialog();
    }

    @Override
    public void exitDialog() {
        this.getCurrentWorkflow().removeExitEventListener(this);
        this.setCurrentWorkflow(null);
        log.debug((Object)"Workflow has finished!");
        this.displayDefaultDialog();
    }

    public static synchronized MainWorkflowsteuerung getInstance() {
        if (MainWorkflowsteuerungInstance == null) {
            MainWorkflowsteuerungInstance = new MainWorkflowsteuerung();
        }
        return MainWorkflowsteuerungInstance;
    }

    public boolean startWorkflow(String sWfName) {
        GlobalObjects.getInstance().getEtkData().interruptTickerThread();
        return this.startWorkflow(sWfName, null);
    }

    public boolean startWorkflow(String sWfName, WorkflowStateData oWsd) {
        GlobalObjects.getInstance().getEtkData().resetZurueckDialoge();
        GlobalObjects.getInstance().resetETKTexte();
        GlobalObjects.getInstance().setAktuelleHG(null);
        try {
            if (this.getCurrentWorkflow() != null) {
                this.getCurrentWorkflow().terminateDialog();
                this.setCurrentWorkflow(null);
            }
            Class<?> objClass = Class.forName("webetk.javaclient.workflow." + sWfName);
            Workflowsteuerung objWorkflow = (Workflowsteuerung)objClass.newInstance();
            this.setCurrentWorkflow(objWorkflow);
            objWorkflow.init(this);
            if (!objWorkflow.start(oWsd)) {
                log.debug((Object)("Workflow " + sWfName + " has finished. No visualization was needed."));
            } else {
                log.debug((Object)("Workflow " + sWfName + " has started."));
            }
            return true;
        }
        catch (ClassNotFoundException ex) {
            log.error((Object)("Could not find class for workflow: " + sWfName));
            return false;
        }
        catch (IllegalAccessException ex) {
            log.error((Object)("Could not access class for workflow: " + sWfName));
            return false;
        }
        catch (InstantiationException ex) {
            log.error((Object)("Could not instantiate class for workflow: " + sWfName));
            return false;
        }
        catch (Throwable th) {
            log.error((Object)("Some error: " + th));
            throw th;
        }
    }

    public Workflowsteuerung getCurrentWorkflow() {
        return this.currentWorkflow;
    }

    public void setCurrentWorkflow(Workflowsteuerung wf) {
        if (wf == null) {
            GlobalObjects.getInstance().getEtkData().resetZurueckDialoge();
        }
        this.currentWorkflow = wf;
    }

    public void displayDefaultDialog() {
        if (this.defaultWorkflow == null) {
            this.defaultWorkflow = new DlgDefaultController();
        }
        this.defaultWorkflow.init(null);
        DialogView dlgView = this.defaultWorkflow.getDialogView();
        MainView.getInstance().initMenus();
        if (dlgView != null) {
            log.debug((Object)"Displaying default dialog.");
            MainViewController.getInstance().displayDialogView(dlgView);
        } else {
            log.fatal((Object)"Could not display default dialog!");
        }
    }

    public void zurueckZurFI(boolean bZurueckZurFI) {
        this.mbZurueckZurFI = bZurueckZurFI;
    }

    public boolean zurueckZurFI() {
        return this.mbZurueckZurFI;
    }
}

