/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.workflow;

import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import de.esg.commonclient.dialog.ExitEventListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.javaclient.framework.MainViewController;
import webetk.javaclient.workflow.WorkflowStateData;

public abstract class Workflowsteuerung
implements ExitEventListener {
    private int Zustand = 0;
    public static final int START = 0;
    private static Logger log = Logger.getLogger(Workflowsteuerung.class);
    private Vector<ExitEventListener> exitEventListeners = new Vector();
    private AbstractDialogViewController CurrentDialogController;

    public void init(ExitEventListener oMainWFControl) {
        this.addExitEventListener(oMainWFControl);
        log.debug((Object)"Initialized.");
    }

    protected AbstractDialogViewController nextWorkflowState(WorkflowStateData oWFStateData) {
        AbstractDialogViewController dlg = this.calcNextDialog(this.getZustand(), oWFStateData);
        this.terminateDialog();
        if (dlg == null) {
            this.notifyAllExitListeners();
            return null;
        }
        this.prepareDialog(dlg, oWFStateData);
        if (dlg.skipToNextState()) {
            return this.nextWorkflowState(dlg.getExitData());
        }
        return dlg;
    }

    public void addExitEventListener(ExitEventListener listener) {
        this.exitEventListeners.add(listener);
        log.debug((Object)("Exiteventlistener added: " + listener.toString()));
    }

    public void removeExitEventListener(ExitEventListener listener) {
        this.exitEventListeners.remove(listener);
        log.debug((Object)("Exiteventlistener removed: " + listener.toString()));
    }

    public boolean start(WorkflowStateData oWsd) {
        log.debug((Object)"Starting ...");
        this.setZustand(0);
        log.debug((Object)"Checking start dialog ...");
        if (oWsd == null) {
            oWsd = new WorkflowStateData();
        }
        if (this.nextWorkflowState(oWsd) == null) {
            return false;
        }
        if (this.getCurrentDialogController() != null) {
            this.displayDialog(this.getCurrentDialogController());
        }
        return true;
    }

    @Override
    public void exitDialog() {
        WorkflowStateData ExitData = this.getCurrentDialogController().getExitData();
        this.finalizeDialog(ExitData);
        AbstractDialogViewController newDlg = this.nextWorkflowState(ExitData);
        if (newDlg != null) {
            this.displayDialog(newDlg);
        }
    }

    protected AbstractDialogViewController getCurrentDialogController() {
        return this.CurrentDialogController;
    }

    protected void setCurrentDialogController(AbstractDialogViewController aCurrentDialogController) {
        this.CurrentDialogController = aCurrentDialogController;
    }

    protected int getZustand() {
        return this.Zustand;
    }

    protected void setZustand(int aZustand) {
        this.Zustand = aZustand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyAllExitListeners() {
        ArrayList<ExitEventListener> listeners = new ArrayList<ExitEventListener>(this.exitEventListeners.size());
        Vector<ExitEventListener> vector = this.exitEventListeners;
        synchronized (vector) {
            Iterator<ExitEventListener> iterListeners = this.exitEventListeners.iterator();
            while (iterListeners.hasNext()) {
                listeners.add(iterListeners.next());
            }
        }
        Iterator iterListeners = listeners.iterator();
        while (iterListeners.hasNext()) {
            ((ExitEventListener)iterListeners.next()).exitDialog();
        }
    }

    protected void terminateDialog() {
        if (this.getCurrentDialogController() == null) {
            return;
        }
        this.getCurrentDialogController().removeExitEventListener(this);
        this.setCurrentDialogController(null);
    }

    protected abstract AbstractDialogViewController getStartDialog();

    protected abstract void finalizeDialog(WorkflowStateData var1);

    protected void prepareDialog(AbstractDialogViewController dlg, WorkflowStateData data) {
        this.setCurrentDialogController(dlg);
        this.getCurrentDialogController().addExitEventListener(this);
        try {
            this.getCurrentDialogController().init(data);
        }
        catch (Exception e) {
            log.error((Object)"Diesen Fehler suchen wir: ", (Throwable)e);
        }
    }

    protected abstract AbstractDialogViewController calcNextDialog(int var1, WorkflowStateData var2);

    protected void displayDialog(AbstractDialogViewController dlg) {
        DialogView dlgView = dlg.getDialogView();
        if (dlgView != null) {
            log.info((Object)"Displaying dialog.");
            MainViewController.getInstance().displayDialogView(dlgView);
        } else {
            log.fatal((Object)"Invalid workflow start! Could not find start dialog!");
        }
    }
}

