/*
 * Decompiled with CFR 0.152.
 */
package webetk.mrkprd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.mrkprd.InvalidPropertieException;
import webetk.mrkprd.Produkt;
import webetk.mrkprd.ProdukteProperties;

public class Produkte {
    private static Logger log = Logger.getLogger(Produkte.class);
    private static Produkte instance = null;
    private List<Produkt> lProdukte = new ArrayList<Produkt>();

    private Produkte() {
        this.load();
    }

    public static Produkte getInstance() {
        if (instance == null) {
            instance = new Produkte();
        }
        return instance;
    }

    private void load() {
        ProdukteProperties prdProps = new ProdukteProperties();
        Properties props = prdProps.getProduktProperties();
        if (props.isEmpty()) {
            try {
                throw new InvalidPropertieException("### Keine Produkt-Informationen/-Properties vorhanden! ###");
            }
            catch (InvalidPropertieException e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
                log.fatal((Object)e.getMessage(), (Throwable)e);
                System.exit(-999);
            }
        }
        log.debug((Object)("### Produkt Properties: " + props.toString()));
        ArrayList<String> sProdukte = new ArrayList<String>();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String sKey = (String)e.nextElement();
            String[] sKeyParts = sKey.split("\\.");
            if (sProdukte.contains(sKeyParts[0])) continue;
            sProdukte.add(sKeyParts[0]);
        }
        log.debug((Object)("### Produkte Keys: " + sProdukte.toString()));
        for (String sProdukt : sProdukte) {
            Produkt oProdukt = new Produkt(sProdukt);
            Enumeration<Object> e2 = props.keys();
            while (e2.hasMoreElements()) {
                String sKey = (String)e2.nextElement();
                String[] sKeyParts = sKey.split("\\.");
                if (!sProdukt.equals(sKeyParts[0])) continue;
                String sProduktKey = sKey.replaceFirst(sKeyParts[0] + ".", "");
                String sProduktValue = props.getProperty(sKey);
                oProdukt.getProperties().setProperty(sProduktKey, sProduktValue);
            }
            this.lProdukte.add(oProdukt);
        }
        log.debug((Object)this.toString());
    }

    public Produkt getProdukt(String sProdukt) {
        Produkt oProduktGesucht = null;
        for (Produkt oProdukt : this.lProdukte) {
            if (!sProdukt.equals(oProdukt.getProdukt())) continue;
            oProduktGesucht = oProdukt;
        }
        return oProduktGesucht;
    }

    public Produkt getProduktZurProduktBerechtigung(String sProduktBerechtigung) {
        Produkt oProduktGesucht = null;
        for (Produkt oProdukt : this.lProdukte) {
            if (!sProduktBerechtigung.equals(oProdukt.getBerechtigung())) continue;
            oProduktGesucht = oProdukt;
        }
        return oProduktGesucht;
    }

    public String getProduktEigenschaft(String keySource, String valueSource, String keyTarget) {
        Produkt oProdukt;
        String sTest;
        String sValueTarget = null;
        Iterator<Produkt> i$ = this.lProdukte.iterator();
        while (i$.hasNext() && (sTest = (oProdukt = i$.next()).getProperties().getProperty(keySource)) != null) {
            if (!sTest.equals(valueSource)) continue;
            sValueTarget = oProdukt.getProperties().getProperty(keyTarget, null);
            break;
        }
        return sValueTarget;
    }

    public String getProduktEigenschaft(String keySource, String valueSource, String keyTarget, String defaultValue) {
        String sValueTarget = this.getProduktEigenschaft(keySource, valueSource, keyTarget);
        if (sValueTarget == null) {
            sValueTarget = defaultValue;
        }
        return sValueTarget;
    }

    public String getProduktEigenschaft(String sProdukt, String sKey) {
        return this.getProdukt(sProdukt) != null ? this.getProdukt(sProdukt).getProperties().getProperty(sKey, null) : null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("### Produkte und Eigenschaften - Anfang ###");
        sb.append("\n");
        for (Produkt oProdukt : this.lProdukte) {
            sb.append("### Produkt: " + oProdukt.getProdukt());
            sb.append("\n");
            Enumeration<Object> e = oProdukt.getProperties().keys();
            while (e.hasMoreElements()) {
                String sKey = (String)e.nextElement();
                sb.append("### - " + sKey + " = " + oProdukt.getProperties().getProperty(sKey, ""));
                sb.append("\n");
            }
        }
        sb.append("### Produkte und Eigenschaften - Ende ###");
        return sb.toString();
    }

    public ArrayList<String> getEigenschaften(String sKey) {
        ArrayList<String> sCol = new ArrayList<String>();
        for (Produkt oProdukt : this.lProdukte) {
            String sValue = oProdukt.getProperties().getProperty(sKey, null);
            if (sValue == null || sValue.length() <= 0) continue;
            sCol.add(sValue);
        }
        return !sCol.isEmpty() ? sCol : null;
    }

    public static Collection<String> mapProdukt(String psProdukt) {
        Vector<String> produkte = new Vector<String>();
        if (psProdukt != null && psProdukt.length() > 0) {
            if (psProdukt.equals(Produkte.getInstance().getProdukt("ALLE").getDbValue()) || psProdukt.equals(Produkte.getInstance().getProdukt("ALLE").getArt())) {
                produkte.add(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
                produkte.add(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung());
            } else if (psProdukt.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung()) || psProdukt.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                produkte.add(psProdukt);
            }
        } else {
            produkte.add(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
            produkte.add(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung());
        }
        return produkte.isEmpty() ? null : produkte;
    }
}

