/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.tetis.dms.model;

import com.bmw.tetis.dms.model.DmsUserConfig;

public class DmsSessionInfo {
    private DmsUserConfig dmsUserConfig;

    public String getServerPort() {
        return System.getProperty("tetis.server.port");
    }

    public String getServerName() {
        return System.getProperty("tetis.server.name");
    }

    public String getDmsUserId() {
        if (this.dmsUserConfig != null) {
            return this.dmsUserConfig.getDmsUserId();
        }
        return null;
    }

    public String getDmsServerUrl() {
        if (this.dmsUserConfig != null) {
            return this.dmsUserConfig.getDmsServerUrl();
        }
        return null;
    }

    public String getDmsExtension() {
        if (this.dmsUserConfig != null) {
            return this.dmsUserConfig.getDmsExtension();
        }
        return null;
    }

    public boolean isDmsDirect() {
        if (this.dmsUserConfig != null) {
            return this.dmsUserConfig.isDmsDirect();
        }
        return false;
    }

    public String getDmsAuthenticator() {
        if (this.dmsUserConfig != null) {
            return this.dmsUserConfig.getDmsUserAuthenticator();
        }
        return null;
    }

    public String getDmsDealerNo() {
        if (this.dmsUserConfig != null) {
            return this.dmsUserConfig.getDmsDealerNo();
        }
        return null;
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<DMS_ACCESS>");
        this.addTag(sb, "SERVER_PORT", this.getServerPort());
        this.addTag(sb, "SERVER_NAME", this.getServerName());
        this.addTag(sb, "DMS_USER_ID", this.getDmsUserId());
        this.addTag(sb, "DMS_AUTHENTICATOR", this.getDmsAuthenticator());
        this.addTag(sb, "DMS_SERVER_URL", this.getDmsServerUrl());
        this.addTag(sb, "DMS_SERVER_EXT", this.getDmsExtension());
        this.addTag(sb, "DMS_DIRECT_DMS", new Boolean(this.isDmsDirect()).toString());
        this.addTag(sb, "DMS_DEALER_NO", this.getDmsDealerNo());
        sb.append("</DMS_ACCESS>");
        return sb.toString();
    }

    private void addTag(StringBuffer sb, String tag, String content) {
        if (content != null && content.length() > 0) {
            sb.append("<" + tag + ">");
            sb.append("<![CDATA[");
            sb.append(content);
            sb.append("]]>");
            sb.append("</" + tag + ">");
        }
    }

    public void setDmsUserConfig(DmsUserConfig dmsUserCfg) {
        this.dmsUserConfig = dmsUserCfg;
    }
}

