/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.tetis.eba.psi;

import com.bmw.tetis.eba.psi.DmsOverloadException;
import com.bmw.tetis.eba.psi.DmsServiceException;
import com.bmw.tetis.eba.psi.DmsStoppedException;
import com.bmw.tetis.eba.psi.DmsTimeoutException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

public class DmsService
implements Serializable {
    private String serverPort;
    private String serverName;
    private String psiCallUrl;
    private String dmsUserId;
    private String dmsAuthenticator;
    private String appName;
    private String portalSessionId;
    private String dmsUrl;
    private boolean directDmsCall;
    private String dmsUrlExt;
    private String dmsDealerNo;

    public String getJavaScriptUrl() {
        return "http://" + this.getServerName() + ":" + this.getServerPort() + "/tetis/dms/asapdms.jsp";
    }

    public String getAppletUrl() {
        return "http://" + this.getServerName() + ":" + this.getServerPort() + "/tetis/dms/dmsapplet.jsp";
    }

    public String getExternalUrl() {
        return this.psiCallUrl;
    }

    public String createTxId() {
        String dmsTxId = String.valueOf(System.currentTimeMillis());
        return dmsTxId;
    }

    public String doDmsService(String dmsTxId, String command, String dmsMessage) throws DmsServiceException, DmsTimeoutException, DmsOverloadException, DmsStoppedException {
        return this.doDmsService(dmsTxId, command, dmsMessage, -1L);
    }

    public String doDmsService(String dmsTxId, String command, String dmsMessage, long timeout) throws DmsServiceException, DmsTimeoutException, DmsOverloadException, DmsStoppedException {
        try {
            int i;
            URL url = null;
            url = this.directDmsCall ? (this.dmsUrlExt != null ? new URL(this.dmsUrl + command + this.dmsUrlExt) : new URL(this.dmsUrl + command)) : new URL("http://" + this.getServerName() + ":" + this.getServerPort() + "/tetis/DmsServerAccess");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            if (!this.directDmsCall) {
                con.setRequestProperty("dmsTxId", dmsTxId);
            }
            if (timeout > 0L) {
                con.setRequestProperty("dmsTimeout", String.valueOf(timeout));
            }
            con.setRequestProperty("command", command);
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setUseCaches(false);
            OutputStreamWriter pw = new OutputStreamWriter(con.getOutputStream(), "UTF-8");
            pw.write(dmsMessage);
            pw.flush();
            pw.close();
            if (!this.directDmsCall) {
                String returnCode = con.getHeaderField("dmsReturnCode");
                if (returnCode.equals("ERROR")) {
                    throw new DmsServiceException("SA returned with error (Runtime Exception or STOP command)");
                }
                if (returnCode.equals("STOP")) {
                    throw new DmsStoppedException();
                }
                if (returnCode.equals("TIMEOUT")) {
                    throw new DmsTimeoutException();
                }
                if (returnCode.equals("MAX_TX")) {
                    throw new DmsOverloadException();
                }
            }
            BufferedInputStream in = new BufferedInputStream(con.getInputStream());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((i = ((InputStream)in).read()) != -1) {
                os.write(i);
            }
            ((InputStream)in).close();
            os.close();
            con.disconnect();
            return os.toString("UTF-8");
        }
        catch (MalformedURLException e) {
            throw new DmsServiceException("MalformedURLException: " + e.getMessage());
        }
        catch (ProtocolException e) {
            throw new DmsServiceException("ProtocolException: " + e.getMessage());
        }
        catch (IOException e) {
            throw new DmsServiceException("IOException: " + e.getMessage());
        }
    }

    public void stopTx(String dmsTxId) throws DmsServiceException, DmsTimeoutException, DmsOverloadException {
        try {
            this.doDmsService(dmsTxId, "STOP", "");
        }
        catch (DmsStoppedException dmsStoppedException) {
            // empty catch block
        }
    }

    public String getDmsAuthenticator() {
        return this.dmsAuthenticator;
    }

    public String getDmsUserId() {
        return this.dmsUserId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    void setDmsAuthenticator(String string) {
        this.dmsAuthenticator = string;
    }

    void setPsiCallUrl(String url) {
        if (url != null) {
            if (url.startsWith("http")) {
                int firstSlash = url.indexOf(47);
                int secondSlash = url.indexOf(47, firstSlash + 1);
                int thirdSlash = url.indexOf(47, secondSlash + 1);
                this.psiCallUrl = url.substring(0, thirdSlash);
            } else {
                this.psiCallUrl = "";
            }
        }
    }

    void setDmsUserId(String string) {
        this.dmsUserId = string;
    }

    protected void setServerName(String string) {
        this.serverName = string;
    }

    protected void setServerPort(String string) {
        this.serverPort = string;
    }

    public String getAppName() {
        return this.appName;
    }

    void setAppName(String appName) {
        this.appName = appName;
    }

    public String getPortalSessionId() {
        return this.portalSessionId;
    }

    void setPortalSessionId(String portalSessionId) {
        this.portalSessionId = portalSessionId;
    }

    public String getDmsUrl() {
        return this.dmsUrl;
    }

    void setDmsUrlInternal(String string) {
        this.dmsUrl = string;
        this.setDmsDirectInternal(this.dmsUrl != null);
    }

    public boolean isDirectDmsCall() {
        return this.directDmsCall;
    }

    public String getDmsUrlExt() {
        return this.dmsUrlExt;
    }

    void setDmsUrlExtInternal(String content) {
        if ("null".equals(content)) {
            content = null;
        }
        this.dmsUrlExt = content;
    }

    void setDmsDirectInternal(boolean b) {
        this.directDmsCall = b;
    }

    void setDmsDirectInternal(String content) {
        this.setDmsDirectInternal(content != null && (content.trim().equals("1") || content.trim().equalsIgnoreCase("true")));
    }

    public String getDmsDealerNo() {
        return this.dmsDealerNo;
    }

    public void setDmsDealerNo(String dmsDealerNo) {
        this.dmsDealerNo = dmsDealerNo;
    }

    public void setDmsUrl(String url) {
        this.setDmsUrlInternal(url);
    }

    public void setDmsUrlExt(String ext) {
        this.setDmsUrlExtInternal(ext);
    }

    public void setDirectDmsCall(boolean directCall) {
        this.setDmsDirectInternal(directCall);
    }
}

