/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.tetis.eba.psi;

import com.bmw.tetis.eba.psi.AppEntry;
import com.bmw.tetis.eba.psi.DmsService;
import com.bmw.tetis.eba.psi.PsiException;
import com.bmw.tetis.eba.psi.PsiUser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class PsiParser {
    private InputStream inStream;
    private String appName;
    private String portalSessionId;
    private String psiInfoUrl;
    private String psiCallUrl;
    private String xmlStream;
    private PsiUser user;
    private DmsService dmsService;
    private Collection userRoles = new ArrayList();
    private Hashtable connections = new Hashtable();
    private Collection userPermissions = new ArrayList();
    private Collection allBrands = new ArrayList();

    public PsiParser() {
    }

    public PsiParser(String xmlString) {
        this.inStream = new ByteArrayInputStream(xmlString.getBytes());
    }

    public PsiParser(InputStream inStream) {
        this.inStream = inStream;
    }

    public void parse() throws PsiException {
        try {
            this.parsePsiInfo(this.inStream);
        }
        catch (Exception e) {
            throw new PsiException(e.getMessage());
        }
    }

    public void parse(InputStream stream) throws PsiException {
        try {
            this.parsePsiInfo(stream);
        }
        catch (Exception e) {
            throw new PsiException(e.getMessage());
        }
    }

    public PsiUser getUser() {
        return this.user;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    void setPortalSessionId(String portalSessionId) {
        this.portalSessionId = portalSessionId;
    }

    public String getPortalSessionId() {
        return this.portalSessionId;
    }

    void setPsiInfoUrl(String psiInfoUrl) {
        this.psiInfoUrl = psiInfoUrl;
    }

    public String getPsiInfoUrl() {
        return this.psiInfoUrl;
    }

    public void setPsiCallUrl(String psiCallUrl) {
        this.psiCallUrl = psiCallUrl;
    }

    public String getPsiCallUrl() {
        return this.psiCallUrl;
    }

    public String getPsiCallString() {
        return this.getPsiCallUrl() + "?APP=" + this.getAppName();
    }

    public AppEntry[] getAppEntries(String connectionId) {
        String appConnId = connectionId;
        if (!appConnId.startsWith(this.getAppName())) {
            appConnId = this.getAppName() + "_" + connectionId;
        }
        AppEntry[] entries = null;
        Vector entriesVector = (Vector)this.connections.get(appConnId);
        if (entriesVector != null) {
            entries = new AppEntry[entriesVector.size()];
            for (int i = 0; i < entriesVector.size(); ++i) {
                entries[i] = (AppEntry)entriesVector.elementAt(i);
            }
        }
        return entries;
    }

    public DmsService getDmsService() {
        return this.dmsService;
    }

    private void parsePsiInfo(InputStream inputStream) throws SAXException, IOException, IOException, PsiException {
        XMLReader parser = XMLReaderFactory.createXMLReader();
        PsiBuilder builder = new PsiBuilder();
        parser.setContentHandler(builder);
        parser.parse(new InputSource(inputStream));
        if (builder.psiException != null) {
            throw builder.psiException;
        }
    }

    public void parseDMSService(InputStream inputStream) throws PsiException {
        try {
            this.parsePsiInfo(inputStream);
        }
        catch (Exception e) {
            throw new PsiException("parse exception while getting DMSService data");
        }
    }

    public void parseUserRoles(InputStream inputStream) throws PsiException {
        try {
            this.parsePsiInfo(inputStream);
        }
        catch (Exception e) {
            throw new PsiException("parse exception while getting user roles");
        }
    }

    public void parseUserPermissions(InputStream inputStream) throws PsiException {
        try {
            this.parsePsiInfo(inputStream);
        }
        catch (Exception e) {
            throw new PsiException("parse exception while getting user permissions");
        }
    }

    public void parseAllBrands(InputStream inputStream) throws PsiException {
        try {
            this.parsePsiInfo(inputStream);
        }
        catch (Exception e) {
            throw new PsiException("parse exception while getting all brands");
        }
    }

    public String toXml() {
        return this.xmlStream;
    }

    public Collection getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(Collection userRoles) {
        this.userRoles = userRoles;
    }

    public Collection getUserPermissions() {
        return this.userPermissions;
    }

    public Collection getAllBrands() {
        return this.allBrands;
    }

    private class PsiBuilder
    implements ContentHandler {
        private String messageText;
        public PsiException psiException;
        private String content;
        private String connectionId;
        private AppEntry appEntry;
        private Vector entries;
        boolean isChannelsAndBranches;
        private String channel;
        private String branch;

        private PsiBuilder() {
        }

        public void startElement(String tag, Attributes atts) {
            this.content = "";
            if (tag.equalsIgnoreCase("CONNECTION")) {
                this.connectionId = atts.getValue("ID");
                this.entries = new Vector();
            } else if (tag.equalsIgnoreCase("ENTRY")) {
                this.appEntry = new AppEntry(PsiParser.this);
            } else if (!tag.equalsIgnoreCase("ENTRY_NAME") && !tag.equalsIgnoreCase("LINK_NAME")) {
                if (tag.equalsIgnoreCase("USER")) {
                    PsiParser.this.user = new PsiUser();
                } else if (tag.equalsIgnoreCase("DMS_ACCESS")) {
                    PsiParser.this.dmsService = new DmsService();
                    PsiParser.this.dmsService.setAppName(PsiParser.this.getAppName());
                    PsiParser.this.dmsService.setPortalSessionId(PsiParser.this.getPortalSessionId());
                    PsiParser.this.dmsService.setPsiCallUrl(PsiParser.this.getPsiCallUrl());
                } else if (tag.equalsIgnoreCase("GROUP")) {
                    if (PsiParser.this.user != null) {
                        PsiParser.this.user.setDomain(atts.getValue("DOMAIN"));
                    }
                } else if (tag.equalsIgnoreCase("CHANNELS_AND_BRANCHES")) {
                    this.isChannelsAndBranches = true;
                }
            }
        }

        public void endElement(String tag) {
            if (tag.equalsIgnoreCase("CONNECTION")) {
                PsiParser.this.connections.put(this.connectionId, this.entries);
            } else if (tag.equalsIgnoreCase("ENTRY")) {
                this.entries.addElement(this.appEntry);
            } else if (tag.equalsIgnoreCase("ENTRY_NAME")) {
                this.appEntry.setEntryName(this.content);
            } else if (tag.equalsIgnoreCase("LINK_NAME")) {
                this.appEntry.setLinkName(this.content);
            } else if (tag.equalsIgnoreCase("MESSAGE")) {
                this.messageText = this.content;
            } else if (tag.equalsIgnoreCase("ERROR")) {
                if (this.messageText == null || this.messageText.length() == 0) {
                    this.messageText = "Error detected by PSI";
                }
                this.psiException = new PsiException(this.messageText);
            } else if (tag.equalsIgnoreCase("USER_ID")) {
                PsiParser.this.user.setUserId(this.content);
            } else if (tag.equalsIgnoreCase("USER_NAME")) {
                PsiParser.this.user.setUserName(this.content);
            } else if (tag.equalsIgnoreCase("LANG_ISO")) {
                PsiParser.this.user.setLangIso(this.content);
            } else if (tag.equalsIgnoreCase("LANG_REGISO")) {
                PsiParser.this.user.setLangRegIso(this.content);
            } else if (tag.equalsIgnoreCase("SUBS_ID")) {
                PsiParser.this.user.setSubsidaryId(this.content);
            } else if (tag.equalsIgnoreCase("MARKET_ISO_CODE")) {
                PsiParser.this.user.setMarketIsoCode(this.content);
            } else if (tag.equalsIgnoreCase("MARKET_HST_CODE")) {
                PsiParser.this.user.setMarketHSTCode(this.content);
            } else if (tag.equalsIgnoreCase("DEALER_ID")) {
                PsiParser.this.user.setDealerId(this.content);
            } else if (tag.equalsIgnoreCase("DOMESTIC_DEALER_NO")) {
                PsiParser.this.user.setDomesticDealerNo(this.content);
            } else if (tag.equalsIgnoreCase("SUB_ID")) {
                PsiParser.this.user.setEmployeeId(this.content);
            } else if (tag.equalsIgnoreCase("DEALER_NAME")) {
                PsiParser.this.user.setDealerName(this.content);
            } else if (tag.equalsIgnoreCase("PHONE")) {
                PsiParser.this.user.setPhone(this.content);
            } else if (tag.equalsIgnoreCase("FAX")) {
                PsiParser.this.user.setFax(this.content);
            } else if (tag.equalsIgnoreCase("EMAIL")) {
                PsiParser.this.user.setEmail(this.content);
            } else if (tag.equalsIgnoreCase("GROUP")) {
                PsiParser.this.user.addGroup(this.content);
            } else if (tag.equalsIgnoreCase("FUNCTION")) {
                PsiParser.this.user.addFunction(this.content);
            } else if (tag.equalsIgnoreCase("BRAND")) {
                PsiParser.this.user.addBrand(this.content);
            } else if (tag.equalsIgnoreCase("VEHICLE_TYP")) {
                PsiParser.this.user.addVehicleTyp(this.content);
            } else if (tag.equalsIgnoreCase("ADMIN_MARKET")) {
                PsiParser.this.user.addAdminMarket(this.content);
            } else if (tag.equalsIgnoreCase("CATALOGUE_SCOPE")) {
                PsiParser.this.user.addCatalogueScope(this.content);
            } else if (tag.equalsIgnoreCase("VP_KLASSE")) {
                PsiParser.this.user.setVpKlasse(this.content);
            } else if (tag.equalsIgnoreCase("VP_ID")) {
                PsiParser.this.user.setVpId(this.content);
            } else if (tag.equalsIgnoreCase("SERVER_NAME")) {
                PsiParser.this.dmsService.setServerName(this.content);
            } else if (tag.equalsIgnoreCase("SERVER_PORT")) {
                PsiParser.this.dmsService.setServerPort(this.content);
            } else if (tag.equalsIgnoreCase("DMS_SERVER_URL")) {
                PsiParser.this.dmsService.setDmsUrlInternal(this.content);
            } else if (tag.equalsIgnoreCase("DMS_SERVER_EXT")) {
                PsiParser.this.dmsService.setDmsUrlExtInternal(this.content);
            } else if (tag.equalsIgnoreCase("DMS_DIRECT_DMS")) {
                PsiParser.this.dmsService.setDmsDirectInternal(this.content);
            } else if (tag.equalsIgnoreCase("DMS_USER_ID")) {
                PsiParser.this.dmsService.setDmsUserId(this.content);
            } else if (tag.equalsIgnoreCase("DMS_AUTHENTICATOR")) {
                PsiParser.this.dmsService.setDmsAuthenticator(this.content);
            } else if (tag.equalsIgnoreCase("DMS_DEALER_NO")) {
                PsiParser.this.dmsService.setDmsDealerNo(this.content);
            } else if (tag.equalsIgnoreCase("CHANNELS_AND_BRANCHES")) {
                this.isChannelsAndBranches = false;
            } else if (tag.equalsIgnoreCase("CHANNEL_AND_BRANCH")) {
                PsiParser.this.user.addChannelAndBranch(this.channel, this.branch);
            } else if (tag.equalsIgnoreCase("SALES_CHANNEL")) {
                if (this.isChannelsAndBranches) {
                    this.channel = this.content;
                } else {
                    PsiParser.this.user.addSalesChannel(this.content);
                }
            } else if (tag.equalsIgnoreCase("SALES_BRANCH")) {
                if (this.isChannelsAndBranches) {
                    this.branch = this.content;
                } else {
                    PsiParser.this.user.addSalesBranch(this.content);
                }
            } else if (tag.equalsIgnoreCase("USER_ROLE")) {
                PsiParser.this.userRoles.add(this.content);
            } else if (tag.equalsIgnoreCase("PERMISSION")) {
                PsiParser.this.userPermissions.add(this.content);
            }
        }

        public void characters(char[] p0, int start, int off) throws SAXException {
            if (this.content == null) {
                this.content = "";
            }
            this.content = this.content + new String(p0, start, off).trim();
        }

        public void endDocument() throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.endElement(qName);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.startElement(qName, atts);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }
    }
}

