/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class AbstractDialog
extends Observable {
    public static final String BUTTONS = "Buttons";
    protected JDialog mDialog = null;
    protected MarkenLayout mMarkenLayout;
    protected Dimension mDialogSize;
    protected JFrame mOwner;
    protected String mTitle;
    protected JLabelButton actionButton;
    protected JLabelButton cancelButton;
    protected JPanel mButtonPanel;
    protected Dimension buttonPanelSize;
    protected boolean isVisible;
    private static Logger log = Logger.getLogger(AbstractDialog.class);

    public AbstractDialog(JFrame owner, String title, MarkenLayout markenLayout, Dimension dialogSize) {
        this.mDialogSize = dialogSize;
        this.mMarkenLayout = markenLayout;
        this.mOwner = owner;
        this.mTitle = title;
        this.mDialog = new JDialog(this.mOwner, this.mTitle, false);
        this.mDialog.setLayout(new GridBagLayout());
        this.mDialog.setSize(this.mDialogSize);
        this.mDialog.setBackground(Constants.Layout.LIGHTGRAY_COLOR);
        this.mButtonPanel = new JPanel(new GridBagLayout());
        this.buttonPanelSize = new Dimension(this.mDialogSize.width, Constants.Layout.ZUB_BUTTON_DIMENSION.height + 20);
        this.mButtonPanel.setPreferredSize(this.buttonPanelSize);
        this.actionButton = new JLabelButton("", "saveAction", true, this.mMarkenLayout);
        this.cancelButton = new JLabelButton("", "saveCancel", true, this.mMarkenLayout);
        this.isVisible = false;
    }

    protected JPanel setButtonsPanel(String actionTitle, String cancelTitle, boolean isEnabled, int distance, int panelWidth) {
        this.createButtonPanel(actionTitle, cancelTitle, isEnabled, distance, panelWidth);
        return this.mButtonPanel;
    }

    protected JPanel setButtonsPanel(String actionTitle, String cancelTitle, boolean isEnabled, int distance) {
        this.createButtonPanel(actionTitle, cancelTitle, isEnabled, distance, this.mDialogSize.width);
        return this.mButtonPanel;
    }

    private void createButtonPanel(String actionTitle, String cancelTitle, boolean isEnabled, int distance, int panelWidth) {
        this.actionButton.setText(actionTitle);
        this.actionButton.setEnabled(isEnabled, this.mMarkenLayout);
        this.cancelButton.setText(cancelTitle);
        this.setButtonLayout();
        this.mButtonPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 0, 13, new Insets(10, 0, 10, distance));
        this.mButtonPanel.add((Component)this.actionButton, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 0, 17, new Insets(10, 0, 10, 0));
        this.mButtonPanel.add((Component)this.cancelButton, gbc);
        this.mButtonPanel.validate();
        this.setChanged();
        this.notifyObservers(BUTTONS);
        log.debug((Object)"Dialog wurde erstellt!");
    }

    public abstract void showDialog(MarkenLayout var1);

    public abstract void hideDialog();

    protected void setDialogLocation() {
        int xOwner = this.mOwner.getX();
        int yOwner = this.mOwner.getY();
        int wOwner = this.mOwner.getWidth();
        int hOwner = this.mOwner.getHeight();
        this.mDialog.setLocation(xOwner + wOwner / 2 - this.mDialog.getWidth() / 2, yOwner + hOwner / 2 - this.mDialog.getHeight() / 2);
    }

    public JDialog getAbstractDialog() {
        return this.mDialog;
    }

    public JLabelButton getActionButton() {
        return this.actionButton;
    }

    public JLabelButton getCancelButton() {
        return this.cancelButton;
    }

    public MarkenLayout getMarkenLayout() {
        return this.mMarkenLayout;
    }

    public boolean isActionButtonEnabled() {
        return this.actionButton.isEnabled();
    }

    public void setActionButtonEnabled(boolean actionButtonEnabled) {
        this.actionButton.setEnabled(actionButtonEnabled, this.mMarkenLayout);
        this.actionButton.validate();
    }

    protected void setButtonLayout() {
        this.mButtonPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.actionButton.setLayout(this.mMarkenLayout);
        this.cancelButton.setLayout(this.mMarkenLayout);
    }

    protected void setDialogSize(Dimension dim) {
        this.mDialog.setMinimumSize(dim);
        this.mDialog.setPreferredSize(dim);
        this.mDialog.setMaximumSize(dim);
    }

    public void changeActionButtonText(String text) {
        this.actionButton.setText(text);
        this.actionButton.validate();
        this.mButtonPanel.validate();
        this.mButtonPanel.updateUI();
    }
}

