/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.kalkulation.KalkulationDataLoader;
import de.esg.zub.configurator.content.kalkulation.KalkulationModel;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.content.marketing.FBIDataloader;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.configurator.navigation.ControllerNavigationPanel;
import de.esg.zub.configurator.workflow.AbstractState;
import de.esg.zub.configurator.workflow.WorkflowController;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.zub.marketing.MarketingProdukt;
import webetk.app.zub.technisch.TechnischesProdukt;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.app.zub.verwaltung.Konfiguration;
import webetk.app.zub.verwaltung.Vorgang;
import webetk.resources.Resource;

public class AnfrageHandler {
    private static AnfrageHandler mInstance = null;
    static Logger log = Logger.getLogger(AnfrageHandler.class);

    private AnfrageHandler() {
    }

    public static AnfrageHandler getInstance() {
        if (mInstance == null) {
            mInstance = new AnfrageHandler();
        }
        return mInstance;
    }

    public void createAnfrage(MarketingProdukt marketingprodukt, Fahrzeug fahrzeug, TechnischesProdukt technischesProdukt) {
        Anfrage anfrage = new Anfrage("TestAnfrage", GlobalObjects.getInstance().getSessionInfo().getMarke(), GlobalObjects.getInstance().getSessionInfo().getProdukart().charAt(0), GlobalObjects.getInstance().getSessionInfo().getUsername(), GlobalObjects.getInstance().getSessionInfo().getFirmaId(), GlobalObjects.getInstance().getSessionInfo().getFilialeId());
        if (GlobalObjects.getInstance().getIpacData().getKunde() != null) {
            anfrage.setKunde(GlobalObjects.getInstance().getIpacData().getKunde());
        }
        Vorgang vorgang = this.createVorgang(marketingprodukt, fahrzeug, anfrage);
        anfrage.setAnlageNutzerId(GlobalObjects.getInstance().getSessionInfo().getLogin());
        anfrage.setVorgang(vorgang);
        GlobalObjects.getInstance().getIpacData().setAnfrage(anfrage);
    }

    public Vorgang createVorgang(MarketingProdukt marketingprodukt, Fahrzeug fahrzeug, Anfrage anfrage) {
        int ukId;
        Vorgang vorgang = new Vorgang(marketingprodukt.getBteNr(), marketingprodukt.getBildPosNr(), marketingprodukt.getProduktName().trim().substring(0, Math.min(marketingprodukt.getProduktName().trim().length(), 100)), new Date());
        vorgang.setFahrzeug(fahrzeug);
        if (anfrage.getVorgangsId() == null) {
            anfrage.setVorgangsId(new ArrayList<Integer>());
        }
        anfrage.getVorgangsId().add(vorgang.getVorgangsId());
        if (anfrage.getVorgangsNamen() == null) {
            anfrage.setVorgangsNamen(new ArrayList<String>());
        }
        anfrage.getVorgangsNamen().add(vorgang.getProduktName());
        anfrage.setVorgang(vorgang);
        ClientKonfiguration konfiguration = this.createKonfiguration(marketingprodukt, anfrage);
        vorgang.setKonfiguration(konfiguration.getKonfiguration());
        vorgang.setHauptKategorie(WorkflowController.getInstance().getHauptKategorie());
        vorgang.setUnterKategorie(WorkflowController.getInstance().getUnterkategorie());
        int hkId = ControllerNavigationPanel.getInstance().getNavigationPanel().getNavModel().getIdToKategorieName(vorgang.getHauptKategorie().getName());
        if (hkId > -1) {
            vorgang.setHkId(hkId);
        }
        if ((ukId = ControllerNavigationPanel.getInstance().getNavigationPanel().getNavModel().getIdToUnterkategorieName(vorgang.getUnterKategorie().getName())) > -1) {
            vorgang.setUkId(ukId);
        }
        return vorgang;
    }

    public String setAnfrage(Anfrage anfrage) throws Exception {
        GlobalObjects.getInstance().getIpacData().setAnfrage(anfrage);
        ClientKonfiguration konfig = ClientKonfiguration.getClientKonfiguration();
        if (anfrage.getVorgang() == null) {
            Vorgang vorgang = KalkulationDataLoader.ladeVorgang(anfrage.getVorgangsId(0));
            anfrage.setVorgang(vorgang);
        }
        if (anfrage.getVorgang().getKonfiguration() != null) {
            GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().setKonfiguration(KalkulationDataLoader.ladeKonfiguration(anfrage.getVorgang().getKonfiguration().getKonfigurationsId()));
        }
        konfig.setKonfiguration(anfrage.getVorgang().getKonfiguration());
        konfig.setKalkulationSet(true);
        konfig.setSaved(true);
        if (anfrage.getVorgang().getFahrzeug() != null) {
            WorkflowController.getInstance().setFzBedIdentified(true);
        }
        boolean loadPreise = true;
        return this.refreshKonfiguration(anfrage, konfig, loadPreise);
    }

    public String ladeVorgang(int vorgangId) throws Exception {
        Anfrage anfrage = GlobalObjects.getInstance().getIpacData().getAnfrage();
        AbstractState activeState = WorkflowController.getInstance().getActiveState();
        if (WorkflowController.getInstance().isFzBedIdentified() && (activeState.getName().equals("TECHNIK") || activeState.getName().equals("MARKETING") || activeState.getName().equals("KALKULATION"))) {
            ClientKonfiguration.getClientKonfiguration().speichereKonfiguration(activeState.getName());
        }
        Fahrzeug fahrzeugAlt = anfrage.getVorgang().getFahrzeug();
        anfrage.getVorgang().setFahrzeug(null);
        Vorgang vorgang = KalkulationDataLoader.ladeVorgang(vorgangId);
        if (vorgang.getFahrzeug() != null && vorgang.getFahrzeug().getFahrgestellnummer() != null && vorgang.getFahrzeug().getFahrgestellnummer().length() > 0) {
            if (fahrzeugAlt == null || fahrzeugAlt.getFahrgestellnummer() == null || !fahrzeugAlt.getFahrgestellnummer().equals(vorgang.getFahrzeug().getFahrgestellnummer())) {
                FzgSucheInfo fzInfo = FBIDataloader.getFIByFahrgesellnummer(vorgang.getFahrzeug().getFahrgestellnummer());
                Fahrzeug fzNeu = new Fahrzeug();
                fzNeu.setFzgSucheInfo(fzInfo);
                anfrage.getVorgang().setFahrzeug(fzNeu);
            } else if (fahrzeugAlt.getFahrgestellnummer().equals(vorgang.getFahrzeug().getFahrgestellnummer())) {
                anfrage.getVorgang().setFahrzeug(fahrzeugAlt);
            }
        }
        anfrage.setVorgang(vorgang);
        GlobalObjects.getInstance().getIpacData().setAnfrage(anfrage);
        GlobalObjects.getInstance().getIpacData().getAnfrage().setVorgang(anfrage.getVorgang());
        GlobalObjects.getInstance().getIpacData().setSelectedBte(anfrage.getVorgang().getBtNummer());
        GlobalObjects.getInstance().getIpacData().setSelectedBnb(anfrage.getVorgang().getBildPos());
        WorkflowController.getInstance().setFzBedIdentified(true);
        if (ClientKonfiguration.getClientKonfiguration() == null || ClientKonfiguration.getClientKonfiguration().getKonfigurationsId() != vorgang.getKonfiguration().getKonfigurationsId()) {
            ClientKonfiguration.getClientKonfiguration().setKonfiguration(vorgang.getKonfiguration());
        }
        return null;
    }

    public String ladeKonfiguration(int konfigurationsId, boolean save, boolean loadPreise) throws Exception {
        WorkflowController workflow = WorkflowController.getInstance();
        AbstractState activeState = workflow.getActiveState();
        if (konfigurationsId == 0) {
            return activeState.getName();
        }
        int konfigId = ClientKonfiguration.getClientKonfiguration().getKonfigurationsId();
        if (workflow.isFzBedIdentified() && (activeState.getName().equals("TECHNIK") || activeState.getName().equals("MARKETING") || activeState.getName().equals("KALKULATION")) && save && konfigurationsId != konfigId) {
            ClientKonfiguration.getClientKonfiguration().speichereKonfiguration(activeState.getName());
        }
        if (konfigId == 0 && ClientKonfiguration.getClientKonfiguration().getKonfigurationsId() != 0 && MainController.getInstance().getMainFrame().getMainPanel().getConfigPanel().getKonfigurationenButtonHashtable().containsKey(konfigId) && save) {
            MainController.getInstance().getMainFrame().getMainPanel().getConfigPanel().updateNewKonfiguration(ClientKonfiguration.getClientKonfiguration().getKonfigurationsId());
        }
        Konfiguration konfiguration = KalkulationDataLoader.ladeKonfiguration(konfigurationsId);
        GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().setKonfiguration(konfiguration);
        ClientKonfiguration konfig = ClientKonfiguration.getClientKonfiguration();
        konfig.setKonfiguration(konfiguration);
        konfig.setKalkulationSet(true);
        konfig.setSaved(true);
        return this.refreshKonfiguration(GlobalObjects.getInstance().getIpacData().getAnfrage(), konfig, loadPreise);
    }

    public String refreshKonfiguration(Anfrage anfrage, ClientKonfiguration konfig, boolean loadPreise) throws CloneNotSupportedException, InterruptedException, InvocationTargetException {
        konfig.reset();
        KalkulationModel model = new KalkulationModel();
        model.setAnfrage(anfrage);
        if (anfrage != null && anfrage.getVorgang() != null && anfrage.getVorgang().getKonfiguration() != null && anfrage.getVorgang().getKonfiguration().getAngebot() != null) {
            konfig.setAngebot(anfrage.getVorgang().getKonfiguration().getAngebot());
        }
        String letzteSicht = konfig.getLetzteSicht();
        GlobalObjects.getInstance().getIpacData().setFahrzeug(GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getFahrzeug());
        boolean failure = konfig.setKalkulationModel(model, loadPreise);
        if (failure || !anfrage.isValid()) {
            return "failure";
        }
        WorkflowController.getInstance().setNewKonfiguration(false);
        model.updateTableData();
        ControllerMarketingPanel.getInstance().refreshMarketingPanel(konfig.getMarketingModel());
        ControllerTechnikPanel.getInstance().refreshTechnikPanel(konfig.getTechnikModel());
        konfig.synchronizeMiniPanels();
        return letzteSicht;
    }

    public ClientKonfiguration createKonfiguration(MarketingProdukt marketingprodukt, Anfrage anfrage) {
        ClientKonfiguration konfiguration = ClientKonfiguration.getClientKonfiguration();
        konfiguration.reset();
        konfiguration.setMarketingModel(ControllerMarketingPanel.getInstance().getModel());
        konfiguration.setTechnikModel(ControllerTechnikPanel.getInstance().getModel(), null);
        Vorgang vorgang = anfrage.getVorgang();
        konfiguration.setAnfrageId(anfrage.getAnfrageId());
        konfiguration.setVorgangsId(vorgang.getVorgangsId());
        konfiguration.setKonfigurationsId(0);
        if (marketingprodukt != null) {
            konfiguration.estimateModels(anfrage, true);
            StringBuilder bui = new StringBuilder();
            bui.append(Resource.getInstance().getKonfiguration());
            bui.append(" ");
            if (vorgang.getKonfigurationsId() == null) {
                vorgang.setKonfigurationsId(new ArrayList<Integer>());
            }
            if (vorgang.getKonfigurationsNamen() == null) {
                vorgang.setKonfigurationsNamen(new ArrayList<String>());
            }
            if (!vorgang.getKonfigurationsId().contains(konfiguration.getKonfigurationsId())) {
                int groessteNummer = this.getGroessteKonfigurationsNummer(vorgang.getKonfigurationsNamen());
                bui.append(groessteNummer + 1);
                konfiguration.setKonfigurationsName(bui.toString());
                vorgang.getKonfigurationsId().add(konfiguration.getKonfigurationsId());
                vorgang.getKonfigurationsNamen().add(konfiguration.getKonfigurationsName());
            }
        }
        return konfiguration;
    }

    private int getGroessteKonfigurationsNummer(List<String> konfigNamenList) {
        int nummer = 0;
        int nummerAusListe = 0;
        String dummyName2 = "";
        for (String dummyName2 : konfigNamenList) {
            nummerAusListe = Integer.parseInt(dummyName2.substring(dummyName2.indexOf(" ") + 1, dummyName2.length()));
            if (nummerAusListe <= nummer) continue;
            nummer = nummerAusListe;
        }
        return nummer;
    }
}

