/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.AbstractDialog;
import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Kunde;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class AnfrageSaveDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    public static final String LISTENELEMENT_ANFRAGEDIALOG = "AnfrageSaveListenElement";
    private JTextField mAnfrageNr;
    private JTextField mErstellungsdatum;
    private JTextField mAenderungsdatum;
    private JTextField mVorname;
    private JTextField mNachname;
    private JTextField mBemerkung;
    private Integer mKundenId;
    private JLabel mAnfrageNrText;
    private JLabel mErstellungsdatumText;
    private JLabel mAenderungsdatumText;
    private JLabel mVornameText;
    private JLabel mNachnameText;
    private JLabel mBemerkungText;
    private JLabel anfrageSuche;
    private JPanel contentPanel;
    private JPanel kundenPanel;
    private ArrayList<JLabel> mLabKunde;
    private SimpleDateFormat dateFormatter;
    private static final int distTop = 10;
    private static final int distBottom = 10;
    private static final int distLeft = 8;
    private static final int distRight = 8;
    private static final int HEIGHT_LISTE = 200;

    public AnfrageSaveDialog(JFrame owner, String title, MarkenLayout markenLayout, Dimension dialogSize) {
        super(owner, title, markenLayout, dialogSize);
        this.mDialog.setDefaultCloseOperation(2);
        this.dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2);
        this.mDialog.setModal(true);
        this.mDialog.setResizable(false);
        this.createLabels();
        this.setDialogLocation();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 18, new Insets(10, 8, 0, 8));
        this.mDialog.getContentPane().add((Component)this.createContentPanel(), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 1, 18, new Insets(10, 8, 0, 8));
        this.mDialog.getContentPane().add((Component)this.kundenPanel, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 0));
        this.mDialog.getContentPane().add((Component)this.setButtonsPanel(Resource.getInstance().getSpeichern(), Resource.getInstance().getAbbrechen(), true, 15, 200), gbc);
        this.setLayout();
        this.mDialog.validate();
    }

    private void createLabels() {
        this.kundenPanel = new JPanel(new GridBagLayout());
        this.mAnfrageNrText = new JLabel(Resource.getInstance().getAnfrageNr() + ":", 4);
        this.mErstellungsdatumText = new JLabel(Resource.getInstance().getErstanlagedatum() + ":", 4);
        this.mAenderungsdatumText = new JLabel(Resource.getInstance().getAenderungsdatum() + ":", 4);
        this.mVornameText = new JLabel(Resource.getInstance().getVorname() + ":", 4);
        this.mNachnameText = new JLabel(Resource.getInstance().getNachname() + ":", 4);
        this.mBemerkungText = new JLabel(Resource.getInstance().getBemerkung() + ":", 4);
        this.mAnfrageNr = new JTextField("", 20, 9);
        this.mAnfrageNr.setEnabled(false);
        this.mErstellungsdatum = new JTextField("", 20, 10);
        this.mErstellungsdatum.setEnabled(false);
        this.mAenderungsdatum = new JTextField("", 20, 10);
        this.mAenderungsdatum.setEnabled(false);
        this.mVorname = new JTextField("", 20, 20);
        this.mNachname = new JTextField("", 20, 20);
        this.mBemerkung = new JTextField("", 40, 56);
        this.anfrageSuche = new JLabel();
        this.anfrageSuche.setName("suchen");
        this.anfrageSuche.setCursor(Cursor.getPredefinedCursor(12));
    }

    private JPanel createContentPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel(new GridBagLayout());
        }
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 12, new Insets(10, 8, 0, 5));
        this.contentPanel.add((Component)this.mAnfrageNrText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 2, 18, new Insets(10, 0, 0, 5));
        this.contentPanel.add((Component)this.mAnfrageNr, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 0, 3, 1, 0.0, 0.0, 0, 18, new Insets(10, 0, 0, 5));
        this.contentPanel.add((Component)new JLabel(" "), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 12, new Insets(10, 8, 0, 5));
        this.contentPanel.add((Component)this.mErstellungsdatumText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 2, 18, new Insets(10, 0, 0, 5));
        this.contentPanel.add((Component)this.mErstellungsdatum, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(10, 0, 0, 5));
        this.contentPanel.add((Component)new JLabel(" "), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 0, 12, new Insets(10, 0, 0, 5));
        this.contentPanel.add((Component)this.mAenderungsdatumText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 2, 18, new Insets(10, 0, 0, 8));
        this.contentPanel.add((Component)this.mAenderungsdatum, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, 12, new Insets(10, 8, 0, 5));
        this.contentPanel.add((Component)this.mNachnameText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 2, 18, new Insets(10, 0, 0, 5));
        this.contentPanel.add((Component)this.mNachname, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 0, 18, new Insets(10, 0, 0, 5));
        this.contentPanel.add((Component)this.anfrageSuche, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 0, 12, new Insets(10, 0, 0, 5));
        this.contentPanel.add((Component)this.mVornameText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(4, 2, 1, 1, 1.0, 0.0, 2, 18, new Insets(10, 0, 0, 8));
        this.contentPanel.add((Component)this.mVorname, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 0, 12, new Insets(10, 8, 10, 5));
        this.contentPanel.add((Component)this.mBemerkungText, gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 3, 4, 1, 1.0, 0.0, 2, 18, new Insets(10, 0, 10, 8));
        this.contentPanel.add((Component)this.mBemerkung, gbc);
        this.contentPanel.validate();
        return this.contentPanel;
    }

    private void setLayout() {
        this.mDialog.getContentPane().setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mDialog.getContentPane().setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.anfrageSuche.setIcon(ImageCache.getInstance().getIcon(this.mMarkenLayout.getIconPath() + "suchen_aktiv.gif"));
        this.contentPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.contentPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getAttributeEingeben(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderTextColor()));
        this.kundenPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mAnfrageNrText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mAenderungsdatumText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mNachnameText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mVornameText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mErstellungsdatumText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mBemerkungText.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.setButtonLayout();
    }

    public void showKundenListe(ArrayList<Kunde> kundeListe) {
        if (this.kundenPanel != null) {
            this.kundenPanel.removeAll();
            GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(10, 8, 10, 8));
            int treffer = kundeListe.size();
            if (treffer > 1 && treffer <= 50) {
                this.kundenPanel.add((Component)this.getKundenListe(kundeListe), gbc);
                this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + 200));
                this.kundenPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getKundenauswahl(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderTextColor()));
            } else if (treffer == 0) {
                this.kundenPanel.add((Component)this.getInfotext(Resource.getInstance().getInfotextKeinTreffer()), gbc);
                this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + 200));
                this.kundenPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getKundenauswahl(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderTextColor()));
            } else if (treffer > 50) {
                String text = StringUtils.substituteStringStraight(Resource.getInstance().getInfotextZuVieleTreffer(), "{0}", Integer.toString(treffer));
                this.kundenPanel.add((Component)this.getInfotext(text), gbc);
                this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + 200));
                this.kundenPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getKundenauswahl(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderTextColor()));
            } else {
                this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height));
            }
            this.kundenPanel.validate();
            this.kundenPanel.updateUI();
            this.mDialog.validate();
        }
    }

    private JPanel getInfotext(String infoText) {
        JPanel panel = new JPanel();
        panel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        panel.setPreferredSize(new Dimension(this.mDialogSize.width - 16, 200));
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel lab = new JLabel("<html>" + infoText + "</html>", 0);
        lab.setForeground(this.mMarkenLayout.getPrimaryForeground());
        panel.add(lab);
        return panel;
    }

    private JScrollPane getKundenListe(ArrayList<Kunde> kundenListe) {
        JPanel panel = new JPanel();
        JScrollPane panelScroll = new JScrollPane(panel, 20, 31);
        panelScroll.setPreferredSize(new Dimension(this.mDialogSize.width - 30, 170));
        panelScroll.setBorder(BorderFactory.createEmptyBorder());
        panel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        panel.setLayout(new BoxLayout(panel, 1));
        this.mLabKunde = new ArrayList();
        for (int ii = 0; ii < kundenListe.size(); ++ii) {
            JLabel temp = new JLabel("   " + kundenListe.get(ii).toString(), 2);
            temp.setName(LISTENELEMENT_ANFRAGEDIALOG + ii);
            temp.setForeground(this.mMarkenLayout.getPrimaryForeground());
            temp.setCursor(Cursor.getPredefinedCursor(12));
            this.mLabKunde.add(ii, temp);
            panel.add(temp);
        }
        this.setChanged();
        this.notifyObservers(this.mLabKunde);
        return panelScroll;
    }

    @Override
    public void hideDialog() {
        if (this.mDialog.isVisible()) {
            this.mDialog.setVisible(false);
        }
    }

    private void init() {
        Anfrage anfrage = GlobalObjects.getInstance().getIpacData().getAnfrage();
        if (this.mAnfrageNr != null && anfrage != null) {
            this.mAnfrageNr.setText(Integer.valueOf(anfrage.getAnfrageId()).toString());
            anfrage.getAnlageDatum().toString();
            this.mErstellungsdatum.setText(this.dateFormatter.format(anfrage.getAnlageDatum()));
            this.mAenderungsdatum.setText(this.dateFormatter.format(anfrage.getAenderungsDatum()));
            if (anfrage.getKunde() != null && anfrage.getKunde().getName() != null) {
                this.mNachname.setText(anfrage.getKunde().getName());
            } else {
                this.mNachname.setText("");
            }
            if (anfrage.getKunde() != null && anfrage.getKunde().getVorname() != null) {
                this.mVorname.setText(anfrage.getKunde().getVorname());
            } else {
                this.mVorname.setText("");
            }
            if (anfrage.getBemerkung() != null) {
                this.mBemerkung.setText(anfrage.getBemerkung());
            } else {
                this.mBemerkung.setText("");
            }
            if (anfrage.getKunde() != null) {
                this.mKundenId = anfrage.getKunde().getKundenId();
            }
        }
        this.setLayout();
    }

    @Override
    public void showDialog(MarkenLayout markenLayout) {
        this.mMarkenLayout = markenLayout;
        this.mDialog.getContentPane().validate();
        this.setDialogLocation();
        this.hideKundenDialog();
        this.init();
        this.mDialog.setVisible(true);
        this.mDialog.validate();
    }

    public void hideKundenDialog() {
        this.kundenPanel.removeAll();
        this.kundenPanel.updateUI();
        this.kundenPanel.setBorder(BorderFactory.createEmptyBorder());
        this.mDialog.setSize(this.mDialogSize);
        this.mDialog.validate();
    }

    public JLabel getAnfrageSuche() {
        return this.anfrageSuche;
    }

    public String getKundenNachname() {
        return this.mNachname.getText();
    }

    public String getKundenVorname() {
        return this.mVorname.getText();
    }

    public JTextField getTfNachname() {
        return this.mNachname;
    }

    public JTextField getTfVorname() {
        return this.mVorname;
    }

    public void setNachname(String nachname) {
        this.mNachname.setText(nachname);
    }

    public void setVorname(String vorname) {
        this.mVorname.setText(vorname);
    }

    public void setKundenId(int kundenNummer) {
        this.mKundenId = kundenNummer;
    }

    public Integer getKundenId() {
        return this.mKundenId;
    }

    public String getBemerkung() {
        return this.mBemerkung.getText();
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public JPanel getKundenPanel() {
        return this.kundenPanel;
    }
}

