/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.DialogAgb;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JCheckBox;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.log4j.Logger;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfZubVerwaltung;
import webetk.utils.StringUtils;

public class ControllerAgbDialog
implements MouseListener,
ActionListener {
    private static Logger log = Logger.getLogger(ControllerAgbDialog.class);
    private static ControllerAgbDialog mInstance = null;
    private DialogAgb mDlg = null;
    private boolean mAgbBestaetigt = false;

    private ControllerAgbDialog() {
    }

    public static ControllerAgbDialog getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerAgbDialog();
        }
        return mInstance;
    }

    public void showAgb() {
        this.mDlg = new DialogAgb(1);
        HTMLEditorKit kit = (HTMLEditorKit)this.mDlg.getAgbPanel().getEditorKit();
        HTMLDocument doc = (HTMLDocument)this.mDlg.getAgbPanel().getDocument();
        try {
            doc.putProperty("IgnoreCharsetDirective", true);
            kit.read(this.getAgbFileAsStream(), (Document)doc, 0);
        }
        catch (IOException e) {
            log.error((Object)"AGB-Datei nicht gefunden", (Throwable)e);
        }
        catch (BadLocationException e) {
            log.error((Object)"", (Throwable)e);
        }
        this.mDlg.showDialog(WorkflowController.getInstance().getMarkenLayout());
    }

    public void checkAgbBestaetigt() {
        this.mAgbBestaetigt = this.hasAgbBestaetigt();
        if (!this.mAgbBestaetigt) {
            this.mDlg = new DialogAgb(2);
            HTMLEditorKit kit = (HTMLEditorKit)this.mDlg.getAgbPanel().getEditorKit();
            HTMLDocument doc = (HTMLDocument)this.mDlg.getAgbPanel().getDocument();
            try {
                doc.putProperty("IgnoreCharsetDirective", true);
                kit.read(this.getAgbFileAsStream(), (Document)doc, 0);
            }
            catch (NullPointerException e) {
                log.error((Object)"AGB-Datei nicht gefunden", (Throwable)e);
                return;
            }
            catch (IOException e) {
                log.error((Object)"AGB-Datei nicht gefunden", (Throwable)e);
                return;
            }
            catch (BadLocationException e) {
                log.error((Object)"", (Throwable)e);
                return;
            }
            this.mDlg.showDialog(WorkflowController.getInstance().getMarkenLayout());
        }
        if (!this.mAgbBestaetigt) {
            MainController.getInstance().exit(0);
        } else {
            this.setAgbBestaetigt();
        }
    }

    private InputStreamReader getAgbFileAsStream() throws NullPointerException, UnsupportedEncodingException {
        InputStreamReader in = null;
        String path = "/html/&language&/agb.html";
        String lang = GlobalObjects.getInstance().getSessionInfo().getLanguage();
        String langReg = GlobalObjects.getInstance().getSessionInfo().getLangRegion();
        if (lang == null || lang.length() == 0) {
            lang = GlobalObjects.getInstance().getLanguage();
        }
        if (lang != null && lang.length() > 0) {
            if (langReg != null) {
                lang = lang + langReg;
            }
            path = StringUtils.substituteString(path, "language", lang);
            InputStream is = this.getClass().getResourceAsStream(path);
            if (is != null) {
                in = new InputStreamReader(is, "UTF-8");
            }
        }
        if (in == null) {
            path = "/html/&language&/agb.html";
            path = StringUtils.substituteString(path, "language", "en");
            in = new InputStreamReader(this.getClass().getResourceAsStream(path), "UTF-8");
        }
        return in;
    }

    private boolean hasAgbBestaetigt() {
        boolean agbBestaetigt = false;
        TrfZubVerwaltung trf = new TrfZubVerwaltung(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.HAT_USER_AGB_BESTAETIGT);
            Boolean oAgbBestaetigt = (Boolean)trf.getValue("agbBestaetigt");
            if (oAgbBestaetigt != null) {
                agbBestaetigt = oAgbBestaetigt;
            }
        }
        catch (CommunicationException e) {
            log.error((Object)"Ermitteln der AGB-Best\u00e4tigung fehlgeschlagen", (Throwable)e);
        }
        return agbBestaetigt;
    }

    private void setAgbBestaetigt() {
        TrfZubVerwaltung trf = new TrfZubVerwaltung(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.SET_USER_AGB_BESTAETIGT);
        }
        catch (CommunicationException e) {
            log.error((Object)"Speichern der AGB-Best\u00e4tigung fehlgeschlagen", (Throwable)e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object source = e.getSource();
        if (source instanceof JLabelButton) {
            JLabelButton button = (JLabelButton)source;
            if ("ButtonOK".equals(button.getName())) {
                this.mAgbBestaetigt = this.mDlg.getCheckBoxBestaetigt().isSelected();
                this.mDlg.hideDialog();
            } else if ("ButtonAbbrechen".equals(button.getName())) {
                this.mDlg.hideDialog();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JCheckBox chkBox;
        Object source = e.getSource();
        if (source instanceof JCheckBox && "CheckBoxBestaetigt".equals((chkBox = (JCheckBox)source).getName())) {
            this.mDlg.getButtonOk().setEnabled(chkBox.isSelected(), WorkflowController.getInstance().getMarkenLayout());
        }
    }
}

