/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.AngebotSaveDialog;
import de.esg.zub.common.CommonDataLoader;
import de.esg.zub.common.ControllerDialogKunde;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.ControllerMainPanel;
import de.esg.zub.configurator.content.anfrage.ControllerAnfragenPanel;
import de.esg.zub.configurator.content.angebot.AngebotDataLoader;
import de.esg.zub.configurator.content.angebot.ControllerAngebotsPanel;
import de.esg.zub.configurator.content.kalkulation.ControllerKalkulationPanel;
import de.esg.zub.configurator.content.kalkulation.KalkulationDataLoader;
import de.esg.zub.configurator.navigation.miniatur.ControllerMiniaturansicht;
import de.esg.zub.configurator.navigation.suche.NavigationPanelDataLoader;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import de.esg.zub.configurator.workflow.ControllerStatusBar;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import webetk.DuplicateValueException;
import webetk.app.zub.verwaltung.Angebot;
import webetk.app.zub.verwaltung.Kunde;
import webetk.resources.Resource;

public class ControllerAngebotSave
implements Observer {
    private static Logger log = Logger.getLogger(ControllerAngebotSave.class);
    private final String FEHLER_ANGEBOT_SPEICHERN = "Das Angebot konnte nicht gespeichert werden.";
    private final String FEHLER_BEIM_SPEICHERN = "Fehler beim Speichern";
    private AngebotSaveDialog mAngebotSaveDialog;
    private ArrayList<Kunde> mKundenListe;
    private Kunde mKunde;
    private SaveDialogMouseListener sdml;

    public ControllerAngebotSave() {
        this.init();
        this.doVorbelegungen();
    }

    public void init() {
        log.debug((Object)"init");
        this.mAngebotSaveDialog = new AngebotSaveDialog(MainController.getInstance().getMainFrame(), Resource.getInstance().getSpeichernVerbindlichesAngebot(), WorkflowController.getInstance().getMarkenLayout(), new Dimension(700, 470));
        this.sdml = new SaveDialogMouseListener();
        this.mAngebotSaveDialog.getActionButton().addMouseListener(this.sdml);
        this.mAngebotSaveDialog.getCancelButton().addMouseListener(this.sdml);
        this.mAngebotSaveDialog.getAnfrageSuche().addMouseListener(this.sdml);
        this.mAngebotSaveDialog.getMDetails().addMouseListener(this.sdml);
        AngebotsKeyListener akl = new AngebotsKeyListener();
        this.mAngebotSaveDialog.getMKundenName().addKeyListener(akl);
        this.mAngebotSaveDialog.getMKundenNummer().addKeyListener(akl);
        this.mAngebotSaveDialog.getMKundenVorname().addKeyListener(akl);
        this.mAngebotSaveDialog.addObserver(this);
    }

    private void doVorbelegungen() {
        int bindeFrist = 0;
        if (ClientKonfiguration.getClientKonfiguration().getAngebot() == null || ClientKonfiguration.getClientKonfiguration().getAngebot().getAngebotsnummer() == 0) {
            int angebotsNummer = 0;
            try {
                angebotsNummer = AngebotDataLoader.ermittleNeueAngebotsnummer();
            }
            catch (Exception e) {
                Logger.getLogger(ControllerAngebotSave.class).error((Object)"Fehler beim Ermitteln der angebotsNummer");
                e.printStackTrace();
            }
            this.mAngebotSaveDialog.getMAngebotNr().setText(String.valueOf(angebotsNummer));
        }
        if (this.mAngebotSaveDialog.getMBindeFrist().getText() == null || this.mAngebotSaveDialog.getMBindeFrist().getText().length() == 0) {
            try {
                bindeFrist = AngebotDataLoader.ermittleBindeFrist();
            }
            catch (Exception e) {
                bindeFrist = 0;
            }
            this.mAngebotSaveDialog.getMBindeFrist().setText(String.valueOf(bindeFrist));
        }
        if (ClientKonfiguration.getClientKonfiguration().getAngebot() != null && ClientKonfiguration.getClientKonfiguration().getAngebot().getKunde() != null) {
            this.mAngebotSaveDialog.setKunde(ClientKonfiguration.getClientKonfiguration().getAngebot().getKunde());
        } else if (ControllerKalkulationPanel.getInstance().getModel() != null && ControllerKalkulationPanel.getInstance().getModel().getKunde() != null) {
            this.mAngebotSaveDialog.setKunde(ControllerKalkulationPanel.getInstance().getModel().getKunde());
        } else if (GlobalObjects.getInstance().getIpacData().getAnfrage().getKunde() != null) {
            this.mAngebotSaveDialog.setKunde(GlobalObjects.getInstance().getIpacData().getAnfrage().getKunde());
        }
    }

    private void sucheNachKundenNummer(String kundenNummer) {
        this.mKundenListe = NavigationPanelDataLoader.loadKundeZuNummer(kundenNummer);
        if (this.mKundenListe != null && this.mKundenListe.size() == 1) {
            this.mKunde = this.mKundenListe.get(0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ControllerAngebotSave.this.mAngebotSaveDialog.setKunde(ControllerAngebotSave.this.mKunde);
                }
            });
        } else {
            this.mKunde = null;
        }
        this.mAngebotSaveDialog.hideKundenDialog();
        this.mAngebotSaveDialog.showKundenListe(this.mKundenListe);
    }

    private void handleSaveEvent() {
        Angebot angebot = null;
        if (ClientKonfiguration.getClientKonfiguration().getAngebot() != null) {
            angebot = ClientKonfiguration.getClientKonfiguration().getAngebot();
        } else {
            angebot = new Angebot(GlobalObjects.getInstance().getSessionInfo().getLogin());
            angebot.setNeu(true);
        }
        if (this.mAngebotSaveDialog.getAngebotNr() == null) {
            angebot.setAngebotsnummer(0);
        } else {
            angebot.setAngebotsnummer(this.mAngebotSaveDialog.getAngebotNr());
        }
        angebot.setAngebotsName(this.mAngebotSaveDialog.getAngebotsName());
        angebot.setAnlageDatum(this.mAngebotSaveDialog.getAngebotsdatum());
        angebot.setAnlageNutzerId(this.mAngebotSaveDialog.getErsteller());
        angebot.setBindeFrist(this.mAngebotSaveDialog.getBindeFrist());
        angebot.setKunde(this.mAngebotSaveDialog.estimateKunde());
        if (this.mAngebotSaveDialog.getBemerkung() != null && !this.mAngebotSaveDialog.getBemerkung().equals("")) {
            angebot.setBemerkung(this.mAngebotSaveDialog.getBemerkung());
        }
        angebot.setStatus("AKTUELL");
        angebot.setStatusDatum(new Date());
        angebot.setGesamtPreisBrutto(ClientKonfiguration.getClientKonfiguration().getKalkulationModel().getGesamtPreis());
        angebot.setGesamtPreisNetto(ClientKonfiguration.getClientKonfiguration().getKalkulationModel().getNettoPreis());
        ClientKonfiguration.getClientKonfiguration().setAngebot(angebot);
        GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getKonfiguration().setAngebot(angebot);
        if (ControllerKalkulationPanel.getInstance().getModel() != null) {
            ControllerKalkulationPanel.getInstance().getModel().setAnfrage(GlobalObjects.getInstance().getIpacData().getAnfrage());
            ControllerKalkulationPanel.getInstance().getKalkulationView().update(ControllerKalkulationPanel.getInstance(), ControllerKalkulationPanel.getInstance().getModel().getKunde());
        }
        if (GlobalObjects.getInstance().getIpacData().isSpeicherKunde()) {
            this.speichereKunde(angebot.getKunde());
        }
        try {
            Angebot gespeichert = KalkulationDataLoader.speichereAngebot(angebot);
            ClientKonfiguration.getClientKonfiguration().setAngebot(gespeichert);
            ClientKonfiguration.getClientKonfiguration().speichereKonfiguration(WorkflowController.getInstance().getActiveState().getName());
            GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getKonfiguration().setAngebot(gespeichert);
            ControllerKalkulationPanel.getInstance().getKalkulationView().getPanAngebot().updateAngebotPanel(gespeichert);
            ControllerKalkulationPanel.getInstance().getKalkulationView().getPanFahrzeug().updateFahrzeugPanel(GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang());
            ControllerMenuBar.getInstance().setSpeichern();
            ControllerMenuBar.getInstance().getMenuBar().removeVorgaengePanel();
            ControllerMainPanel.getInstance().getMainPanel().getConfigPanel().removeAllConfigurations();
            MainController.getInstance().getMainFrame().getMainPanel().removeConfigPanel();
            ControllerAngebotsPanel.getInstance().setAngebotStatus(GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getFahrzeug());
            ControllerMiniaturansicht.getInstance().setAngebotsSicht(false);
            ControllerStatusBar.getInstance().getStatusBar().removeAllStatusFromIndex(1);
            if (GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgangsId().size() == 1 && GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().getKonfigurationsId().size() == 1) {
                ControllerAnfragenPanel.getInstance().checkInaktivAnfrageToDelete(GlobalObjects.getInstance().getIpacData().getAnfrage().getAnfrageId());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), "Das Angebot konnte nicht gespeichert werden.", "Fehler beim Speichern", 0);
            e.printStackTrace();
        }
    }

    private void speichereKunde(Kunde kunde) {
        try {
            this.mKunde = CommonDataLoader.speichereKunde(kunde);
        }
        catch (DuplicateValueException e) {
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), Resource.getInstance().getErrorMsgKundennummer(), Resource.getInstance().getSpeicherfehler(), 0);
            Logger.getLogger(ControllerDialogKunde.class).error((Object)"Fehler beim Speichern eines Kunden. ", (Throwable)e);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), Resource.getInstance().getFehlerBeimAnlegenAendernDesNutzers(), Resource.getInstance().getSpeicherfehler(), 0);
            Logger.getLogger(ControllerDialogKunde.class).error((Object)"Fehler beim Speichern eines Kunden. ", (Throwable)e);
        }
    }

    private void sucheNachKundenname(String kundenname) {
        this.mKundenListe = NavigationPanelDataLoader.loadKundeZuName(kundenname);
        if (this.mKundenListe != null && this.mKundenListe.size() == 1) {
            this.mKunde = this.mKundenListe.get(0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ControllerAngebotSave.this.mAngebotSaveDialog.setKunde(ControllerAngebotSave.this.mKunde);
                }
            });
        } else {
            this.mKunde = null;
        }
        this.mAngebotSaveDialog.hideKundenDialog();
        this.mAngebotSaveDialog.showKundenListe(this.mKundenListe);
    }

    private void handleKundenAuswahl(String listenElement) {
        String txtIndex = listenElement.substring("AngebotSaveListenElement".length());
        int index = Integer.parseInt(txtIndex);
        this.mKunde = this.mKundenListe.get(index);
        this.mAngebotSaveDialog.setKunde(this.mKunde);
        ArrayList<Kunde> kdListe = new ArrayList<Kunde>();
        kdListe.add(this.mKunde);
        this.mAngebotSaveDialog.showKundenListe(kdListe);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg.getClass().equals(ArrayList.class)) {
            ArrayList list = (ArrayList)arg;
            for (int i = 0; i < list.size(); ++i) {
                ((JLabel)list.get(i)).addMouseListener(this.sdml);
            }
        }
        if (arg.getClass().equals(String.class) && arg.equals("Buttons")) {
            this.mAngebotSaveDialog.getActionButton().addMouseListener(this.sdml);
            this.mAngebotSaveDialog.getCancelButton().addMouseListener(this.sdml);
        }
    }

    public AngebotSaveDialog getAngebotSavedialog() {
        return this.mAngebotSaveDialog;
    }

    private class AngebotsKeyListener
    extends KeyAdapter {
        private AngebotsKeyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyReleased(KeyEvent e) {
            block13: {
                try {
                    ((ControllerAngebotSave)ControllerAngebotSave.this).mAngebotSaveDialog.mDialog.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
                    MainController.getInstance().getMainFrame().setBusiCursor();
                    if (e.getKeyCode() == 10 && (e.getSource() == ControllerAngebotSave.this.mAngebotSaveDialog.getMKundenName() || e.getSource() == ControllerAngebotSave.this.mAngebotSaveDialog.getMKundenVorname())) {
                        try {
                            e.getComponent().setCursor(Cursor.getPredefinedCursor(3));
                            String kundenNachname = ControllerAngebotSave.this.mAngebotSaveDialog.getKundenName();
                            String vorname = ControllerAngebotSave.this.mAngebotSaveDialog.getKundenVorname();
                            StringBuffer buf = new StringBuffer(kundenNachname);
                            if (buf.length() > 0) {
                                buf.append(" ");
                            }
                            buf.append(vorname);
                            if (buf.length() > 0) {
                                ControllerAngebotSave.this.sucheNachKundenname(buf.toString());
                            }
                            break block13;
                        }
                        finally {
                            e.getComponent().setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                    if (e.getKeyCode() == 10 && e.getSource() == ControllerAngebotSave.this.mAngebotSaveDialog.getMKundenNummer()) {
                        try {
                            e.getComponent().setCursor(Cursor.getPredefinedCursor(3));
                            String kundenNummer = ControllerAngebotSave.this.mAngebotSaveDialog.getKundenNummer();
                            ControllerAngebotSave.this.sucheNachKundenNummer(kundenNummer);
                            break block13;
                        }
                        finally {
                            e.getComponent().setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                    super.keyReleased(e);
                }
                finally {
                    ((ControllerAngebotSave)ControllerAngebotSave.this).mAngebotSaveDialog.mDialog.getContentPane().setCursor(Cursor.getPredefinedCursor(0));
                    MainController.getInstance().getMainFrame().setDefaultCursor();
                }
            }
        }
    }

    private class SaveDialogMouseListener
    extends MouseAdapter {
        private SaveDialogMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e) {
            block22: {
                if (e.getComponent().getName().equals("saveCancel") && ControllerAngebotSave.this.mAngebotSaveDialog.getCancelButton().isEnabled()) {
                    ControllerAngebotSave.this.mAngebotSaveDialog.setKunde(null);
                    ControllerAngebotSave.this.mAngebotSaveDialog.reset();
                    ControllerAngebotSave.this.mAngebotSaveDialog.hideDialog();
                    break block22;
                }
                if (e.getComponent().getName().equals("saveAction") && ControllerAngebotSave.this.mAngebotSaveDialog.getActionButton().isEnabled()) {
                    try {
                        e.getComponent().setCursor(Cursor.getPredefinedCursor(3));
                        ControllerAngebotSave.this.mAngebotSaveDialog.clearErrors();
                        JComponent comp = ControllerAngebotSave.this.mAngebotSaveDialog.getChecker().validate();
                        if (comp != null) {
                            ControllerAngebotSave.this.mAngebotSaveDialog.setError(ControllerAngebotSave.this.mAngebotSaveDialog.getChecker().getErrorString());
                            comp.grabFocus();
                            return;
                        }
                        ControllerAngebotSave.this.handleSaveEvent();
                        ControllerAngebotSave.this.mAngebotSaveDialog.reset();
                        ControllerAngebotSave.this.mAngebotSaveDialog.hideDialog();
                        break block22;
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Das Angebot konnte nicht gespeichert werden.", "Fehler beim Speichern", 0);
                        break block22;
                    }
                    finally {
                        e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                    }
                }
                if (e.getComponent().getName().equals("suchen") && ControllerAngebotSave.this.mAngebotSaveDialog.isSuchenEnabled()) {
                    try {
                        e.getComponent().setCursor(Cursor.getPredefinedCursor(3));
                        String kundenNachname = ControllerAngebotSave.this.mAngebotSaveDialog.getKundenName();
                        String vorname = ControllerAngebotSave.this.mAngebotSaveDialog.getKundenVorname();
                        String kundenNummer = ControllerAngebotSave.this.mAngebotSaveDialog.getKundenNummer();
                        StringBuffer buf = new StringBuffer(kundenNachname);
                        if (buf.length() > 0) {
                            buf.append(" ");
                        }
                        buf.append(vorname);
                        if (buf.length() > 0) {
                            ControllerAngebotSave.this.sucheNachKundenname(buf.toString());
                        } else if (kundenNummer != null && kundenNummer.length() > 0) {
                            ControllerAngebotSave.this.sucheNachKundenNummer(kundenNummer);
                        }
                        break block22;
                    }
                    finally {
                        e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                    }
                }
                if (e.getComponent() == ControllerAngebotSave.this.mAngebotSaveDialog.getMDetails()) {
                    ControllerAngebotSave.this.mAngebotSaveDialog.hideKundenDialog();
                    ControllerAngebotSave.this.mAngebotSaveDialog.showKundenEingabePanel();
                } else if (e.getComponent().getName().startsWith("AngebotSaveListenElement")) {
                    ControllerAngebotSave.this.handleKundenAuswahl(e.getComponent().getName());
                }
            }
        }
    }
}

