/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.AnfrageSaveDialog;
import de.esg.zub.common.AngebotSaveDialog;
import de.esg.zub.common.ControllerAnfrageSave;
import de.esg.zub.common.ControllerAngebotSave;
import de.esg.zub.common.MainController;
import de.esg.zub.common.PrintDialog;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.admin.AdminDataLoader;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.configurator.content.technisch.TechnikModel;
import de.esg.zub.configurator.navigation.suche.NavigationPanelDataLoader;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.jasper.AnfrageFactory;
import de.esg.zub.jasper.EmailData;
import de.esg.zub.jasper.FaxDataSource;
import de.esg.zub.jasper.JasperPrintHelper;
import de.esg.zub.jasper.MarketingDataSource;
import de.esg.zub.jasper.TechnikDataSource;
import de.esg.zub.jasper.TechnikListenDataSource;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JCheckBox;
import de.esg.zub.utilities.viewcomp.JRadioButton;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Angebot;
import webetk.app.zub.verwaltung.Konfiguration;
import webetk.app.zub.verwaltung.Kunde;
import webetk.resources.Resource;

public class ControllerPrintDialog
implements Observer,
MouseListener,
ActionListener {
    private PrintDialog mPrintDialog;
    private static ControllerPrintDialog mInstance = null;
    private Konfiguration konfig;
    private static Logger log = Logger.getLogger(ControllerPrintDialog.class);
    private static final int MIN_KUNDENNAME_SUCHE = 4;
    public static final int LENGTH_KUNDENNUMMER = 7;
    public static final int MAX_LENGTH_KUNDENNAME = 40;
    private ArrayList<Kunde> mKundenListe;
    private Kunde mKunde;
    private String oldKundenname = "";
    private int oldKundennameDot = 0;
    boolean mNoSuchKunde = false;

    private ControllerPrintDialog() {
    }

    public static ControllerPrintDialog getInstance() {
        return ControllerPrintDialog.getInstance(ClientKonfiguration.getClientKonfiguration());
    }

    public static ControllerPrintDialog getInstance(Konfiguration konfig) {
        if (mInstance == null) {
            mInstance = new ControllerPrintDialog();
            mInstance.init();
        }
        ControllerPrintDialog.mInstance.konfig = konfig;
        mInstance.getPrintDialog().setKonfig(konfig);
        return mInstance;
    }

    public void init() {
        this.mPrintDialog = new PrintDialog(MainController.getInstance().getMainFrame(), Resource.getInstance().getDruckenFaxenSenden(), WorkflowController.getInstance().getMarkenLayout(), new Dimension(640, 240));
        this.mPrintDialog.addObserver(this);
        this.mPrintDialog.getActionButton().setEnabled(false);
        this.mPrintDialog.setActionButtonEnabled(false);
        for (JCheckBox box : this.mPrintDialog.getWhatToPrint()) {
            if (!box.isSelected()) continue;
            this.mPrintDialog.getActionButton().setEnabled(true);
            this.mPrintDialog.setActionButtonEnabled(true);
        }
        boolean mailServerEingestellt = false;
        try {
            mailServerEingestellt = AdminDataLoader.isMailServerEingestellt();
        }
        catch (Exception e) {
            log.warn((Object)"Cannot determine if Mailserver is active, so no mail will be sent");
        }
        this.mPrintDialog.setMailServerAktiv(mailServerEingestellt);
        log.debug((Object)"ControllerPrintdialog initialisiert");
    }

    @Override
    public void update(Observable o, Object arg) {
        if (((String)arg).equals("1. Wie")) {
            for (JRadioButton radio : this.mPrintDialog.getHowToPrint()) {
                if (radio.getActionListeners().length != 0) continue;
                radio.addActionListener(this);
            }
        }
        if (((String)arg).equals("3. Aktion")) {
            ArrayList<JRadioButton> radios = this.mPrintDialog.getActions();
            for (int i = 0; i < radios.size(); ++i) {
                if (radios.get(i).getActionListeners().length != 0) continue;
                radios.get(i).addActionListener(this);
            }
        }
        if (((String)arg).equals("2. Mit")) {
            ArrayList<JCheckBox> checks = this.mPrintDialog.getWhatToPrint();
            for (int i = 0; i < checks.size(); ++i) {
                if (checks.get(i).getActionListeners().length != 0) continue;
                checks.get(i).addActionListener(this);
            }
        }
        if (((String)arg).equals("Buttons")) {
            if (this.mPrintDialog.getActionButton().getMouseListeners().length == 0) {
                this.mPrintDialog.getActionButton().addMouseListener(this);
            }
            if (this.mPrintDialog.getCancelButton().getMouseListeners().length == 0) {
                this.mPrintDialog.getCancelButton().addMouseListener(this);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getComponent().getName().equals("saveCancel") && this.mPrintDialog.getCancelButton().isEnabled()) {
            this.mPrintDialog.getBetreffFaxField().setText("");
            this.mPrintDialog.hideDialog();
        }
        if (e.getComponent().getName().equals("saveAction") && this.mPrintDialog.getActionButton().isEnabled()) {
            JComponent comp = this.mPrintDialog.getChecker().validate();
            if (comp != null) {
                this.mPrintDialog.setError(this.mPrintDialog.getChecker().getErrorString());
                comp.grabFocus();
                return;
            }
            try {
                this.mPrintDialog.mDialog.setCursor(Cursor.getPredefinedCursor(3));
                this.mPrintDialog.getActionButton().setCursor(Cursor.getPredefinedCursor(3));
                this.generateReport();
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.mPrintDialog.getActionButton().setCursor(Cursor.getPredefinedCursor(12));
                this.mPrintDialog.mDialog.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.mPrintDialog.getBetreffFaxField().setText("");
            this.mPrintDialog.hideDialog();
        }
    }

    private void generateReport() {
        boolean printMarketingInfo = false;
        boolean printTechnischeInfo = false;
        boolean printKalkulation = false;
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        String path = this.getReportPath();
        ImageIcon icon = (ImageIcon)ImageCache.getInstance().getIcon("check_image.gif");
        Image image = icon.getImage();
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                if (rgb != Color.WHITE.getRGB()) {
                    return rgb | 0xFF000000;
                }
                return rgb | 0xFFFFFF;
            }
        };
        FilteredImageSource producer = new FilteredImageSource(image.getSource(), filter);
        Image checkImage = Toolkit.getDefaultToolkit().createImage(producer);
        new ImageIcon(checkImage);
        boolean onlyMarketing = false;
        Anfrage anfrage = GlobalObjects.getInstance().getIpacData().getAnfrage();
        if ((this.konfig == null || this.konfig.getKonfigurationsId() == 0 || WorkflowController.getInstance().isNewKonfiguration() || WorkflowController.getInstance().isAddKonfiguration()) && WorkflowController.getInstance().getActiveState().getName().equals("MARKETING")) {
            onlyMarketing = true;
        }
        for (JCheckBox box : this.mPrintDialog.getWhatToPrint()) {
            if (box.getName().equals(Resource.getInstance().getMarketinginfo()) && box.isSelected()) {
                printMarketingInfo = true;
                continue;
            }
            if (box.getName().equals(Resource.getInstance().getTechnischeinfo()) && box.isSelected()) {
                printTechnischeInfo = true;
                continue;
            }
            if (!box.getName().equals(Resource.getInstance().getKalkulationsinfo()) || !box.isSelected()) continue;
            printKalkulation = true;
        }
        boolean isAngebot = false;
        for (JRadioButton button : this.mPrintDialog.getHowToPrint()) {
            if (!button.getName().equals("als Angebot") || !button.isSelected()) continue;
            isAngebot = true;
        }
        if (!isAngebot && anfrage != null && !anfrage.isExplizitGespeichert()) {
            this.mPrintDialog.getAbstractDialog().setVisible(false);
            AnfrageSaveDialog save = ControllerAnfrageSave.getInstance().getAnfrageSavedialog();
            save.showDialog(WorkflowController.getInstance().getMarkenLayout());
            if (!GlobalObjects.getInstance().getIpacData().getAnfrage().isExplizitGespeichert()) {
                this.mPrintDialog.showDialog(WorkflowController.getInstance().getMarkenLayout());
                return;
            }
        } else if (isAngebot && (this.konfig.getAngebot() == null || this.konfig.getAngebot().getAngebotsnummer() == 0)) {
            this.mPrintDialog.getAbstractDialog().setVisible(false);
            ControllerAngebotSave saveCtrl = new ControllerAngebotSave();
            AngebotSaveDialog save = saveCtrl.getAngebotSavedialog();
            save.showDialog(WorkflowController.getInstance().getMarkenLayout());
            Angebot angebot = this.konfig.getAngebot();
            if (angebot == null || angebot.getAngebotsnummer() == 0) {
                this.mPrintDialog.showDialog(WorkflowController.getInstance().getMarkenLayout());
                return;
            }
        }
        parameterMap.put("SUBREPORT_DIR", path);
        parameterMap.put("CHECK_IMAGE", checkImage);
        if (printMarketingInfo) {
            parameterMap.put("BESTANDTEILDATASOURCE", AnfrageFactory.getBestandteilDataSource());
            parameterMap.put("ALTERNATIVENDATASOURCE", AnfrageFactory.getAlternativenDataSource());
            parameterMap.put("VARIANTENDATASOURCE", AnfrageFactory.getVariantenDataSource());
            parameterMap.put("ZUSATZPRODUKTDATASOURCE", AnfrageFactory.getZusatzProduktDataSource());
            parameterMap.put("ANFRAGE_KUNDE_DATUM_MARK", AnfrageFactory.getAnfrageKundeDatumSource(isAngebot));
            parameterMap.put("MARKETING_DATASOURCE", AnfrageFactory.getMarketingDataSource());
            parameterMap.put("FAHRZEUG_IDENTIFIZIERT", WorkflowController.getInstance().isFzBedIdentified());
            parameterMap.put("ANGEBOT_MARK", isAngebot);
            parameterMap.put("NUTZENDATASOURCE", AnfrageFactory.getNutzenDataSource());
        }
        String reportName = "";
        boolean isFax = false;
        boolean toEmail = false;
        for (JRadioButton button : this.mPrintDialog.getActions()) {
            if (button.getActionCommand().equals(Resource.getInstance().getAlsFaxDrucken()) && button.isSelected()) {
                isFax = true;
                continue;
            }
            if (!button.getActionCommand().equals(Resource.getInstance().getAlsEMailVersenden()) || !button.isSelected()) continue;
            toEmail = true;
        }
        MarketingDataSource marketingDataSource = AnfrageFactory.getMarketingDataSource();
        Object actualSource = new JREmptyDataSource();
        if (onlyMarketing && !isFax) {
            reportName = "Marketingbericht.jasper";
            actualSource = marketingDataSource;
        } else {
            parameterMap.put("ANGEBOT", isAngebot);
            if (printKalkulation) {
                parameterMap.put("SUBREPORT_DATASOURCE", AnfrageFactory.getKalkulationsPositionsSource(isAngebot));
                parameterMap.put("ANFRAGE_KUNDE_DATUM", AnfrageFactory.getAnfrageKundeDatumSource(isAngebot));
            } else {
                parameterMap.put("SUBREPORT_DATASOURCE", new JREmptyDataSource());
                parameterMap.put("ANFRAGE_KUNDE_DATUM", new JREmptyDataSource());
            }
            parameterMap.put("PRINT_MARKETING", printMarketingInfo);
            parameterMap.put("PRINT_TECHINFO", printTechnischeInfo);
            parameterMap.put("PRINT_KALKULATION", printKalkulation);
            parameterMap.put("Bearbeiter", GlobalObjects.getInstance().getSessionInfo().getLogin());
            parameterMap.put("PRINT_PAGENR", true);
            parameterMap.put("LOGO_FIRMA", null);
            if (printTechnischeInfo) {
                TechnikModel model = ControllerTechnikPanel.getInstance().getModel();
                parameterMap.put("ANFRAGE_KUNDE_DATUM_TECH", AnfrageFactory.getAnfrageKundeDatumSource(isAngebot));
                parameterMap.put("TECHNIK_DATASOURCE", new TechnikDataSource(model));
                parameterMap.put("KERNPRODUKTDATASOURCE", new TechnikListenDataSource(model.getKernProduktBnbs(), model.getArbeitKernprodukt(), 0));
                int vorgaenger = model.getKernProduktBnbs().size() + model.getArbeitKernprodukt().size();
                parameterMap.put("ZUBEHOERDATASOURCE", new TechnikListenDataSource(model.getZusatzProduktBnbs(), model.getArbeitZusatzprodukt(), vorgaenger));
                vorgaenger = vorgaenger + model.getZusatzProduktBnbs().size() + model.getArbeitZusatzprodukt().size();
                parameterMap.put("HILFSPRODUKTDATASOURCE", new TechnikListenDataSource(model.getHilfBnbs(), model.getArbeitHilf(), vorgaenger));
            }
            parameterMap.put("AUSSTATTUNG_DATASOURCE", new JREmptyDataSource());
            if (isFax) {
                reportName = "Fax.jasper";
                actualSource = new FaxDataSource(this.mPrintDialog.getFaxBetreff(), this.mPrintDialog.getFaxReceiver(), this.mPrintDialog.getFaxReceiverFax(), this.mPrintDialog.getFaxSender(), this.mPrintDialog.getFaxSenderFax(), this.mPrintDialog.getFaxSenderTel());
                if (onlyMarketing) {
                    parameterMap.put("ANFRAGEDATASOURCE", new JREmptyDataSource());
                } else {
                    parameterMap.put("ANFRAGEDATASOURCE", AnfrageFactory.getAnfrageSource(isAngebot));
                }
                if (onlyMarketing) {
                    parameterMap.put("OHNE_ANFRAGE", true);
                } else {
                    parameterMap.put("OHNE_ANFRAGE", false);
                }
                parameterMap.put("PRINT_PAGENR", false);
                parameterMap.put("PRINT_PAGENR", false);
            } else if (isAngebot) {
                reportName = "Angebot.jasper";
                actualSource = AnfrageFactory.getAnfrageSource(isAngebot);
            } else {
                reportName = "Anfrage.jasper";
                actualSource = AnfrageFactory.getAnfrageSource(isAngebot);
            }
        }
        try {
            InputStream is = this.getReportInputStream(reportName);
            if (toEmail) {
                EmailData email = new EmailData(this.mPrintDialog.getAnEMail(), this.mPrintDialog.getVonEmail(), this.mPrintDialog.getAnName(), this.mPrintDialog.getBetreffEmail(), this.mPrintDialog.getFreitextEmail());
                JasperPrintHelper.print(reportName, is, parameterMap, (JRDataSource)actualSource, email);
            } else {
                JasperPrintHelper.print(is, parameterMap, (JRDataSource)actualSource);
            }
        }
        catch (JRException e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e1) {
            log.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private String getReportPath() {
        String path = "reports/";
        return path;
    }

    private InputStream getReportInputStream(String reportName) throws ClassNotFoundException {
        String sComplName = "/reports/" + reportName;
        InputStream is = ControllerPrintDialog.class.getResourceAsStream(sComplName);
        if (is == null) {
            String sErrMsg = sComplName + " not found";
            log.error((Object)sErrMsg);
            throw new ClassNotFoundException(sErrMsg);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(Resource.getInstance().getAlsFaxDrucken())) {
            this.mPrintDialog.setFaxPanel();
            String betreffFax = this.getBetreff();
            if ((this.mPrintDialog.getBetreffFaxField().getText() == null || this.mPrintDialog.getBetreffFaxField().getText().length() == 0) && betreffFax != null) {
                this.mPrintDialog.getBetreffFaxField().setText(betreffFax);
            }
            this.mPrintDialog.getAnField1().addActionListener(this);
            this.mPrintDialog.getAnField2().addActionListener(this);
            this.mPrintDialog.getAnField3().addActionListener(this);
        } else if (e.getActionCommand().equals(Resource.getInstance().getAngebotDrucken()) || e.getActionCommand().equals(Resource.getInstance().getAnfrageDrucken())) {
            this.doVorbelegungBetreff();
            for (JCheckBox box : this.mPrintDialog.getWhatToPrint()) {
                if (!box.getName().equals(Resource.getInstance().getKalkulationsinfo())) continue;
                if (e.getActionCommand().equals(Resource.getInstance().getAngebotDrucken())) {
                    box.setEnabled(false);
                    box.setSelected(true);
                    this.mPrintDialog.setActionButtonEnabled(true);
                    continue;
                }
                box.setEnabled(true);
            }
        } else if (e.getActionCommand().equals(Resource.getInstance().getAlsEMailVersenden())) {
            String betreff = this.getBetreff();
            this.mPrintDialog.setEmailPanel();
            if ((this.mPrintDialog.getBetreffEmailField().getText() == null || this.mPrintDialog.getBetreffEmailField().getText().length() == 0) && betreff != null) {
                this.mPrintDialog.getBetreffEmailField().setText(betreff);
            }
        } else if (e.getActionCommand().equals(Resource.getInstance().getDrucken())) {
            this.mPrintDialog.setDruckenPanel();
        } else if (e.getSource() instanceof JTextField) {
            JTextField field = (JTextField)e.getSource();
            String txtKundenname = field.getText();
            if (txtKundenname != null && txtKundenname.length() > 0) {
                if (txtKundenname.length() > 40) {
                    txtKundenname = txtKundenname.substring(0, 40);
                }
                try {
                    MainController.getInstance().getMainFrame().setBusiCursor();
                    this.mPrintDialog.mDialog.setCursor(Cursor.getPredefinedCursor(3));
                    this.sucheNachKundenname(txtKundenname, field);
                }
                finally {
                    MainController.getInstance().getMainFrame().setDefaultCursor();
                    this.mPrintDialog.mDialog.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        } else {
            for (JCheckBox box : this.mPrintDialog.getWhatToPrint()) {
                if (!box.isSelected()) continue;
                this.mPrintDialog.getActionButton().setEnabled(true);
                this.mPrintDialog.setActionButtonEnabled(true);
                return;
            }
            this.mPrintDialog.getActionButton().setEnabled(false);
            this.mPrintDialog.setActionButtonEnabled(false);
        }
        this.mPrintDialog.setRequiredFields();
    }

    private void doVorbelegungBetreff() {
        for (JRadioButton button : this.mPrintDialog.getActions()) {
            if (button.getActionCommand().equals(Resource.getInstance().getAlsFaxDrucken()) && button.isSelected()) {
                String betreff = this.getBetreff();
                if (betreff == null) break;
                this.mPrintDialog.getBetreffFaxField().setText(this.getBetreff());
                break;
            }
            if (!button.getActionCommand().equals(Resource.getInstance().getAlsEMailVersenden()) || !button.isSelected()) continue;
            String betreff = this.getBetreff();
            if (betreff == null) break;
            this.mPrintDialog.getBetreffEmailField().setText(this.getBetreff());
            break;
        }
    }

    private String getBetreff() {
        boolean isAngebot = false;
        for (JRadioButton button : this.mPrintDialog.getHowToPrint()) {
            if (!button.getName().equals("als Angebot") || !button.isSelected()) continue;
            isAngebot = true;
        }
        String betreffText = "";
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        Angebot angebot = ClientKonfiguration.getClientKonfiguration().getAngebot();
        betreffText = isAngebot && angebot != null ? Resource.getInstance().getAngebot() + " " + angebot.getAngebotsnummer() + " - " + angebot.getAngebotsName() : (!isAngebot ? format.format(new Date()) + " " + ControllerMarketingPanel.getInstance().getModel().getProductName() : null);
        return betreffText;
    }

    private void sucheNachKundenname(String kundenname, final JTextField field) {
        this.mKundenListe = NavigationPanelDataLoader.loadKundeZuName(kundenname);
        if (this.mKundenListe.size() == 1) {
            this.mKunde = this.mKundenListe.get(0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StringBuilder bui = new StringBuilder();
                    bui.append(ControllerPrintDialog.this.mKunde.getName());
                    if (ControllerPrintDialog.this.mKunde.getVorname() != null) {
                        bui.append("  " + ControllerPrintDialog.this.mKunde.getVorname());
                    }
                    field.setText(bui.toString());
                }
            });
        }
        if (this.mKundenListe.size() == 0) {
            this.mNoSuchKunde = true;
        }
    }

    public PrintDialog getPrintDialog() {
        return this.mPrintDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caretUpdate(CaretEvent e) {
        if (e.getDot() != this.oldKundennameDot) {
            try {
                MainController.getInstance().getMainFrame().setBusiCursor();
                this.mPrintDialog.mDialog.setCursor(Cursor.getPredefinedCursor(3));
                this.mPrintDialog.getNameEmailField().setCursor(Cursor.getPredefinedCursor(3));
                this.handleKundennameCaretUpdate((JTextField)e.getSource());
            }
            finally {
                MainController.getInstance().getMainFrame().setDefaultCursor();
                this.mPrintDialog.mDialog.setCursor(Cursor.getPredefinedCursor(0));
                this.mPrintDialog.getNameEmailField().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        this.oldKundennameDot = e.getDot();
    }

    private void handleKundennameCaretUpdate(JTextField field) {
        if (field.getText().length() == this.oldKundenname.length() + 1) {
            if (field.getText().length() == 1) {
                this.mNoSuchKunde = false;
            }
            this.oldKundenname = field.getText();
            if (field.getText().length() >= 4 && !field.getText().contains(" ") && this.isKundennameValid(field.getText())) {
                this.sucheNachKundenname(field.getText(), field);
            }
        } else {
            this.oldKundenname = field.getText();
        }
    }

    private boolean isKundennameValid(String kdname) {
        return kdname.length() > 0 && kdname.length() <= 40 && !this.mNoSuchKunde;
    }
}

