/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.zub.common.AbstractDialog;
import de.esg.zub.common.Constants;
import de.esg.zub.common.ControllerAgbDialog;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JCheckBox;
import de.esg.zub.utilities.viewcomp.JLabelButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import webetk.resources.Resource;

public class DialogAgb
extends AbstractDialog {
    public static final String BUTTON_ABBRECHEN = "ButtonAbbrechen";
    public static final String BUTTON_OK = "ButtonOK";
    public static final String CHECKBOX_BESTAETIGT = "CheckBoxBestaetigt";
    public static final int MODUS_ANZEIGEN = 1;
    public static final int MODUS_BESTAETIGEN = 2;
    private int mModus;
    private MarkenLayout mMarkenLayout = null;
    private JTextPane mAgbPane = null;
    private JCheckBox mChkBestaetigt = null;
    private JLabelButton mButAbbrechen = null;
    private JLabelButton mButOk = null;
    private static final Dimension dialogSize = new Dimension(500, 400);

    public DialogAgb(int modus) {
        super(MainController.getInstance().getMainFrame(), Resource.getInstance().getTitelAgb(), WorkflowController.getInstance().getMarkenLayout(), dialogSize);
        this.mModus = modus == 2 ? 2 : 1;
        this.mMarkenLayout = WorkflowController.getInstance().getMarkenLayout();
        this.mDialog.setDefaultCloseOperation(2);
        this.mChkBestaetigt = new JCheckBox(Resource.getInstance().getBestaetigen(), false);
        this.mChkBestaetigt.setName(CHECKBOX_BESTAETIGT);
        this.mChkBestaetigt.setOpaque(false);
        this.mChkBestaetigt.addActionListener(ControllerAgbDialog.getInstance());
        this.init();
        this.mChkBestaetigt.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mDialog.getContentPane().setBackground(this.mMarkenLayout.getPrimaryBackground());
    }

    private void init() {
        this.mDialog.setLayout(new GridBagLayout());
        this.mDialog.setBackground(this.mMarkenLayout.getPrimaryBackground());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 1, 18, new Insets(10, 10, 10, 10));
        this.mDialog.add((Component)this.getAgbPane(), gbc);
        if (this.mModus == 2) {
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 1, 18, new Insets(0, 10, 0, 10));
            this.mDialog.add((Component)this.getCheckBoxBestaetigt(), gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 0, 18, new Insets(10, 10, 10, 10));
            this.mDialog.add((Component)this.getButtonOk(), gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 0, 12, new Insets(10, 10, 10, 10));
            this.mDialog.add((Component)this.getButtonAbbrechen(), gbc);
        }
        if (this.mModus == 1) {
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 0, 11, new Insets(10, 10, 10, 10));
            this.mDialog.add((Component)this.getButtonSchliessen(), gbc);
        }
    }

    private JScrollPane getAgbPane() {
        return new JScrollPane(this.getAgbPanel());
    }

    public JTextPane getAgbPanel() {
        if (this.mAgbPane == null) {
            this.mAgbPane = new JTextPane();
            this.mAgbPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.mAgbPane.setFont(Constants.Layout.getZubDefaultFont());
            this.mAgbPane.setEditable(false);
            this.mAgbPane.setContentType("text/html; charset=UTF-8");
        }
        return this.mAgbPane;
    }

    public JCheckBox getCheckBoxBestaetigt() {
        return this.mChkBestaetigt;
    }

    public JLabelButton getButtonAbbrechen() {
        if (this.mButAbbrechen == null) {
            this.mButAbbrechen = new JLabelButton(Resource.getInstance().getAbbrechen(), BUTTON_ABBRECHEN, true, this.mMarkenLayout);
            this.mButAbbrechen.setEnabled(true, this.mMarkenLayout);
            this.mButAbbrechen.addMouseListener(ControllerAgbDialog.getInstance());
        }
        return this.mButAbbrechen;
    }

    public JLabelButton getButtonOk() {
        if (this.mButOk == null) {
            this.mButOk = new JLabelButton(Resource.getInstance().getOk(), BUTTON_OK, false, this.mMarkenLayout);
            this.mButOk.setEnabled(false, this.mMarkenLayout);
            this.mButOk.addMouseListener(ControllerAgbDialog.getInstance());
        }
        return this.mButOk;
    }

    public JLabelButton getButtonSchliessen() {
        if (this.mButAbbrechen == null) {
            this.mButAbbrechen = new JLabelButton(Resource.getInstance().getOk(), BUTTON_ABBRECHEN, true, this.mMarkenLayout);
            this.mButAbbrechen.setEnabled(true, this.mMarkenLayout);
            this.mButAbbrechen.addMouseListener(ControllerAgbDialog.getInstance());
        }
        return this.mButAbbrechen;
    }

    @Override
    public void hideDialog() {
        if (this.isVisible) {
            this.isVisible = false;
            this.mDialog.setVisible(this.isVisible);
        }
    }

    @Override
    public void showDialog(MarkenLayout markenLayout) {
        this.mDialog.setModal(true);
        this.setDialogLocation();
        this.isVisible = true;
        this.mDialog.validate();
        this.mDialog.setVisible(this.isVisible);
    }
}

