/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.AbstractDialog;
import de.esg.zub.common.Constants;
import de.esg.zub.common.ControllerDialogKundeKeyReader;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.common.TextFieldPatternFormatter;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JFormattedTextField;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.app.zub.verwaltung.Kunde;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class DialogKundeKeyReader
extends AbstractDialog {
    private static Logger log = Logger.getLogger(DialogKundeKeyReader.class);
    private String vin = "";
    public static final String SUCHEN = "Suchen";
    public static final String NEW_KUNDE = "NewKunde";
    public static final String BEARBEITE_KUNDE = "BearbeiteKunde";
    public static final String LISTENELEMENT_DIALOGKUNDE = "ListenelementDialogkunde";
    public static final String LISTENELEMENT_FAHRZEUGDATEN = "ListenelementFahrzeugdaten";
    public static final String KUNDENSICHT = "Kundensicht";
    public static final String FAHRZEUGSICHT = "Fahrzeugsicht";
    public String mModus = "";
    public static final int HEIGHT_LISTE = 200;
    public static final int HEIGHT_MASKE = 300;
    public static final int DIALOG_OK = 1;
    public static final int DIALOG_ABBRECHEN = -1;
    public static final String KUNDENLISTE = "1";
    public static final String FAHRZEUGDATEN = "2";
    public static final String LEER = "3";
    private int mDialogResult = -1;
    private JPanel mPanKundenauswahl;
    private JPanel mPanKeyreader;
    private JPanel mPanContainer;
    private JPanel mPanKundenListe;
    private JPanel mPanFahrzeugdaten;
    private JPanel mPanEmpty;
    private JLabel keyReaderLabel;
    private JLabel mLabKundennummer;
    private JFormattedTextField mTfKundennummer;
    private JLabel mLabKundenname;
    private JTextField mTfKundenname;
    private JLabel mLabSuchenButton;
    private JLabel mKeyReader;
    private ArrayList<JLabel> mAktuellKundenListe;
    private ArrayList<JLabel> mAktuellFahrzeugListe;
    private ArrayList<JPanel> mKundenPanels;
    private ArrayList<JPanel> mFahrzeugPanels;
    private ArrayList<Fahrzeug> mMarkenFahrzeuge;
    private JLabel[] mLabKunde;
    private JLabel[] mLabFahrzeug;

    public DialogKundeKeyReader(JFrame owner, String title, MarkenLayout markenLayout, Dimension dialogSize) {
        super(owner, title, markenLayout, dialogSize);
        this.mDialog.setDefaultCloseOperation(2);
        this.init();
        this.setLayout();
    }

    private void init() {
        log.debug((Object)"creating layout");
        this.mDialog.setLayout(new GridBagLayout());
        this.mPanKundenauswahl = this.getPanKundenauswahl();
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 18, new Insets(5, 5, 5, 5));
        this.mDialog.add((Component)this.mPanKundenauswahl, gbc);
        this.mPanKeyreader = this.getPanKeyreader();
        gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 1, 18, new Insets(5, 5, 5, 5));
        this.mDialog.add((Component)this.mPanKeyreader, gbc);
        this.mPanContainer = new JPanel(new CardLayout());
        this.mPanContainer.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mPanKundenListe = new JPanel();
        this.mPanFahrzeugdaten = new JPanel();
        this.mPanEmpty = new JPanel();
        this.mPanContainer.add((Component)this.mPanKundenListe, KUNDENLISTE);
        this.mPanContainer.add((Component)this.mPanFahrzeugdaten, FAHRZEUGDATEN);
        this.mPanContainer.add((Component)this.mPanEmpty, LEER);
        ((CardLayout)this.mPanContainer.getLayout()).show(this.mPanContainer, LEER);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 1, 18, new Insets(0, 5, 0, 5));
        this.mDialog.add((Component)this.mPanContainer, gbc);
        this.mButtonPanel = this.setButtonsPanel(Resource.getInstance().getUebernehmen(), Resource.getInstance().getAbbrechen(), false, 10);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 2, 10, new Insets(5, 5, 5, 5));
        this.mDialog.add((Component)this.mButtonPanel, gbc);
    }

    private JPanel getPanKundenauswahl() {
        if (this.mPanKundenauswahl == null) {
            this.mPanKundenauswahl = new JPanel();
            this.mPanKundenauswahl.setLayout(new GridBagLayout());
            this.mLabKundennummer = new JLabel(Resource.getInstance().getKundennummer() + ":");
            GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(15, 8, 0, 0));
            this.mPanKundenauswahl.add((Component)this.mLabKundennummer, gbc);
            this.mLabKundenname = new JLabel(Resource.getInstance().getKundenname() + ":");
            gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(15, 8, 0, 0));
            this.mPanKundenauswahl.add((Component)this.mLabKundenname, gbc);
            Pattern pKundennummer = Pattern.compile("[0-9]{0,7}");
            TextFieldPatternFormatter format = new TextFieldPatternFormatter(pKundennummer);
            format.setAllowsInvalid(false);
            this.mTfKundennummer = new JFormattedTextField(format);
            this.mTfKundennummer.setPreferredSize(new Dimension(100, 19));
            this.mTfKundennummer.setMinimumSize(new Dimension(100, 19));
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 0, 18, new Insets(14, 5, 0, 15));
            this.mPanKundenauswahl.add((Component)this.mTfKundennummer, gbc);
            this.mTfKundenname = new JTextField(15);
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(14, 5, 0, 15));
            this.mPanKundenauswahl.add((Component)this.mTfKundenname, gbc);
            this.mLabSuchenButton = new JLabel();
            this.mLabSuchenButton.setName(SUCHEN);
            this.mLabSuchenButton.setCursor(Cursor.getPredefinedCursor(12));
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 0, 14, new Insets(15, 0, 15, 15));
            this.mPanKundenauswahl.add((Component)this.mLabSuchenButton, gbc);
        }
        return this.mPanKundenauswahl;
    }

    private JPanel getPanKeyreader() {
        if (this.mPanKeyreader == null) {
            this.mPanKeyreader = new JPanel();
            this.mPanKeyreader.setLayout(new GridBagLayout());
            this.keyReaderLabel = new JLabel(Resource.getInstance().getKeyreader() + ":");
            this.keyReaderLabel.setSmallboldFont();
            GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(10, 10, 10, 5));
            this.mPanKeyreader.add((Component)this.keyReaderLabel, gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 18, new Insets(10, 5, 10, 10));
            this.mPanKeyreader.add((Component)this.getKeyReaderLabel(), gbc);
        }
        return this.mPanKeyreader;
    }

    public JLabel getKeyReaderLabel() {
        if (this.mKeyReader == null) {
            this.mKeyReader = new JLabel();
            this.mKeyReader.setName("KeyReader");
            this.mKeyReader.setIcon(new ImageIcon(ImageCache.getInstance().getImage("Icons/keyreader.gif")));
            if (GlobalObjects.getInstance().isKeyReaderAktiv() && GlobalObjects.getInstance().existiertKeyreaderFile()) {
                this.mKeyReader.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.mKeyReader.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return this.mKeyReader;
    }

    @Override
    public void hideDialog() {
        if (this.isVisible) {
            this.isVisible = false;
            this.mDialog.setVisible(this.isVisible);
        }
    }

    @Override
    public void showDialog(MarkenLayout markenLayout) {
        this.mDialog.setModal(true);
        this.mDialog.getContentPane().validate();
        this.mModus = "";
        this.hideZusatzPanel();
        this.setButtonLayout();
        this.setActionButtonEnabled(false);
        this.mAktuellKundenListe = null;
        this.mTfKundenname.setText("");
        this.mTfKundennummer.setText("");
        this.mDialog.validate();
        this.setDialogLocation();
        this.isVisible = true;
        this.setLayout();
        this.mDialog.setVisible(this.isVisible);
        this.mDialog.validate();
    }

    public void showKundenListe(ArrayList<Kunde> kundeListe) {
        this.mModus = KUNDENSICHT;
        this.mPanKundenListe.removeAll();
        int treffer = kundeListe.size();
        if (treffer > 1 && treffer <= 50) {
            this.mPanKundenListe.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getKundenauswahl(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderColor()));
            this.mPanKundenListe.setPreferredSize(new Dimension(this.mDialogSize.width - 16, 200));
            this.mPanKundenListe.add(this.getKundenListe(kundeListe));
            this.mPanKundenListe.validate();
            this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + 200));
        } else {
            if (treffer == 1) {
                this.showFahrzeugListe(kundeListe.get(0));
                return;
            }
            if (treffer == 0) {
                this.mPanKundenListe.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getKundenauswahl(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderColor()));
                this.mPanKundenListe.setPreferredSize(new Dimension(this.mDialogSize.width - 16, 200));
                this.mPanKundenListe.add(this.getInfotext(Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getKundenauswahl()));
                this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + 200));
            } else if (treffer > 50) {
                this.mPanKundenListe.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getKundenauswahl(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderColor()));
                this.mPanKundenListe.setPreferredSize(new Dimension(this.mDialogSize.width - 16, 200));
                String text = StringUtils.substituteStringStraight(Resource.getInstance().getInfotextZuVieleTreffer(), "{0}", Integer.toString(treffer));
                this.mPanKundenListe.add(this.getInfotext(text, Resource.getInstance().getKundenauswahl()));
                this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + 200));
            } else {
                this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height));
            }
        }
        this.mPanKundenListe.updateUI();
        this.mDialog.validate();
        ((CardLayout)this.mPanContainer.getLayout()).show(this.mPanContainer, KUNDENLISTE);
    }

    public void hideZusatzPanel() {
        this.mPanKundenListe.removeAll();
        this.mPanFahrzeugdaten.removeAll();
        ((CardLayout)this.mPanContainer.getLayout()).show(this.mPanContainer, LEER);
        this.mPanKundenListe.updateUI();
        this.mDialog.setSize(this.mDialogSize);
        this.mDialog.validate();
    }

    private JScrollPane getKundenListe(ArrayList<Kunde> kundenListe) {
        JPanel panel = new JPanel();
        JScrollPane panelScroll = new JScrollPane(panel, 20, 31);
        panelScroll.setPreferredSize(new Dimension(this.mDialogSize.width - 30, 170));
        panelScroll.setBorder(BorderFactory.createEmptyBorder());
        panel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        panel.setLayout(new BoxLayout(panel, 1));
        this.mLabKunde = new JLabel[kundenListe.size()];
        this.mLabFahrzeug = new JLabel[kundenListe.size()];
        this.mAktuellKundenListe = new ArrayList();
        this.mKundenPanels = new ArrayList();
        JPanel labelPanel = new JPanel(new GridBagLayout());
        labelPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        labelPanel.setPreferredSize(new Dimension(this.mDialogSize.getSize().width - 35, 16));
        for (int ii = 0; ii < kundenListe.size(); ++ii) {
            labelPanel = new JPanel(new GridBagLayout());
            labelPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
            labelPanel.setPreferredSize(new Dimension(this.mDialogSize.getSize().width - 35, 16));
            labelPanel.setMinimumSize(new Dimension(this.mDialogSize.getSize().width - 35, 16));
            labelPanel.setMaximumSize(new Dimension(this.mDialogSize.getSize().width - 35, 16));
            this.mLabKunde[ii] = new JLabel("   " + kundenListe.get(ii).toString(), 2);
            this.mLabKunde[ii].setName(LISTENELEMENT_DIALOGKUNDE + ii);
            this.mLabKunde[ii].setOpaque(false);
            this.mLabKunde[ii].setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.mLabKunde[ii].setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.mLabKunde[ii].addMouseListener(ControllerDialogKundeKeyReader.getInstance());
            this.mLabKunde[ii].setCursor(Cursor.getPredefinedCursor(12));
            this.mAktuellKundenListe.add(this.mLabKunde[ii]);
            GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, ii, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 0, 0, 0));
            labelPanel.add((Component)this.mLabKunde[ii], gbc);
            if (this.isCorrectMark(kundenListe.get(ii)).size() > 0) {
                gbc = this.mMarkenLayout.setGridBagConstraints(1, ii, 1, 1, 1.0, 0.0, 2, 18, new Insets(0, 0, 0, 0));
                labelPanel.add((Component)new JLabel(" "), gbc);
                ImageIcon icon = (ImageIcon)ImageCache.getInstance().getIcon(this.mMarkenLayout.getDefaultIconPath() + "vorwaerts.gif");
                this.mLabFahrzeug[ii] = new JLabel(icon);
                this.mLabFahrzeug[ii].setName(LISTENELEMENT_FAHRZEUGDATEN + ii);
                this.mLabFahrzeug[ii].addMouseListener(ControllerDialogKundeKeyReader.getInstance());
                this.mLabFahrzeug[ii].setCursor(Cursor.getPredefinedCursor(12));
                gbc = this.mMarkenLayout.setGridBagConstraints(2, ii, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 0, 0, 10));
                labelPanel.add((Component)this.mLabFahrzeug[ii], gbc);
                this.mKundenPanels.add(labelPanel);
            } else {
                gbc = this.mMarkenLayout.setGridBagConstraints(1, ii, 2, 1, 1.0, 0.0, 2, 18, new Insets(0, 0, 0, 0));
                labelPanel.add((Component)new JLabel(" "), gbc);
                this.mKundenPanels.add(labelPanel);
            }
            for (int i = 0; i < this.mKundenPanels.size(); ++i) {
                panel.add(this.mKundenPanels.get(i));
            }
        }
        return panelScroll;
    }

    private ArrayList<Fahrzeug> isCorrectMark(Kunde kunde) {
        ArrayList<Fahrzeug> correctFahrzeuge = new ArrayList<Fahrzeug>();
        for (int i = 0; i < kunde.getFahrzeuge().size(); ++i) {
            String sProduktFzg = String.valueOf(kunde.getFahrzeuge().get(i).getProduktArt());
            if (!kunde.getFahrzeuge().get(i).getMarke().equals(this.mMarkenLayout.getMarke()) || !sProduktFzg.equals(this.mMarkenLayout.getProdukt())) continue;
            correctFahrzeuge.add(kunde.getFahrzeuge().get(i));
        }
        this.mMarkenFahrzeuge = correctFahrzeuge;
        return this.mMarkenFahrzeuge;
    }

    private JPanel getInfotext(String infoText, String ueberschrift) {
        JPanel panel = new JPanel();
        panel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel lab = new JLabel("<html>" + infoText + "</html>", 0);
        lab.setForeground(this.mMarkenLayout.getPrimaryForeground());
        panel.add(lab);
        return panel;
    }

    public void showFahrzeugListe(Kunde kunde) {
        this.mModus = FAHRZEUGSICHT;
        this.mPanKundenListe.removeAll();
        this.mPanFahrzeugdaten.removeAll();
        int treffer = kunde.getFahrzeuge().size();
        if (treffer > 0 && treffer <= 10) {
            this.mPanFahrzeugdaten.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getFahrzeugauswahl(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderColor()));
            this.mPanFahrzeugdaten.setPreferredSize(new Dimension(this.mDialogSize.width - 16, 200));
            this.mPanFahrzeugdaten.add(this.getFahrzeugListe(kunde));
            this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + 200));
        } else if (treffer == 0) {
            this.mPanFahrzeugdaten.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getFahrzeugauswahl(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderColor()));
            this.mPanFahrzeugdaten.setPreferredSize(new Dimension(this.mDialogSize.width - 16, 200));
            this.mPanFahrzeugdaten.add(this.getInfotext(Resource.getInstance().getKeineDatenGefunden(), Resource.getInstance().getFahrzeugauswahl()));
            this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + 200));
        } else if (treffer > 10) {
            this.mPanFahrzeugdaten.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getFahrzeugauswahl(), 1, 2, Constants.Layout.getZubBoldFont(), this.mMarkenLayout.getBorderColor()));
            this.mPanFahrzeugdaten.setPreferredSize(new Dimension(this.mDialogSize.width - 16, 200));
            String text = StringUtils.substituteStringStraight(Resource.getInstance().getInfotextZuVieleTreffer(), "{0}", Integer.toString(treffer));
            this.mPanKundenListe.add(this.getInfotext(text, Resource.getInstance().getFahrzeugauswahl()));
            this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height + 200));
        } else {
            this.mDialog.setSize(new Dimension(this.mDialogSize.width, this.mDialogSize.height));
        }
        this.mPanKundenListe.updateUI();
        this.mDialog.validate();
        ((CardLayout)this.mPanContainer.getLayout()).show(this.mPanContainer, FAHRZEUGDATEN);
    }

    public JPanel getFahrzeugListe(Kunde kunde) {
        int i;
        JPanel panel = new JPanel();
        panel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        panel.setLayout(new BoxLayout(panel, 1));
        if (kunde == null) {
            return null;
        }
        this.isCorrectMark(kunde);
        Fahrzeug fahrzeugdaten = null;
        this.mLabFahrzeug = new JLabel[this.mMarkenFahrzeuge.size()];
        this.mAktuellFahrzeugListe = new ArrayList();
        this.mFahrzeugPanels = new ArrayList();
        JPanel labelPanel = new JPanel(new GridBagLayout());
        labelPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        labelPanel.setPreferredSize(new Dimension(this.mDialogSize.getSize().width - 25, 16));
        for (i = 0; i < this.mMarkenFahrzeuge.size(); ++i) {
            labelPanel = new JPanel(new GridBagLayout());
            labelPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
            labelPanel.setPreferredSize(new Dimension(this.mDialogSize.getSize().width - 25, 16));
            labelPanel.setMinimumSize(new Dimension(this.mDialogSize.getSize().width - 25, 16));
            labelPanel.setMaximumSize(new Dimension(this.mDialogSize.getSize().width - 25, 16));
            String anzeigeText = "";
            fahrzeugdaten = this.mMarkenFahrzeuge.get(i);
            if (fahrzeugdaten.getMarke() != null) {
                anzeigeText = anzeigeText + fahrzeugdaten.getMarke();
                anzeigeText = anzeigeText + ", ";
            }
            if (fahrzeugdaten.getBaureihe() != null) {
                anzeigeText = anzeigeText + fahrzeugdaten.getBaureihe();
                anzeigeText = anzeigeText + ", ";
            }
            if (fahrzeugdaten.getModellBezeichnung() != null) {
                anzeigeText = anzeigeText + fahrzeugdaten.getModellBezeichnung();
                anzeigeText = anzeigeText + ", ";
            }
            if (fahrzeugdaten.getFahrgestellnummer() != null) {
                anzeigeText = anzeigeText + fahrzeugdaten.getFahrgestellnummer();
                anzeigeText = anzeigeText + " ";
            }
            if (fahrzeugdaten.getKennzeichen() != null) {
                anzeigeText = anzeigeText + fahrzeugdaten.getKennzeichen();
            }
            this.mLabFahrzeug[i] = new JLabel("   " + anzeigeText, 2);
            this.mLabFahrzeug[i].setName(LISTENELEMENT_FAHRZEUGDATEN + i);
            this.mLabFahrzeug[i].setOpaque(false);
            this.mLabFahrzeug[i].setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.mLabFahrzeug[i].setForeground(this.mMarkenLayout.getPrimaryForeground());
            this.mLabFahrzeug[i].addMouseListener(ControllerDialogKundeKeyReader.getInstance());
            this.mLabFahrzeug[i].setCursor(Cursor.getPredefinedCursor(12));
            this.mAktuellFahrzeugListe.add(this.mLabFahrzeug[i]);
            GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, i, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 0, 0, 10));
            labelPanel.add((Component)this.mLabFahrzeug[i], gbc);
            gbc = this.mMarkenLayout.setGridBagConstraints(1, i, 1, 1, 1.0, 0.0, 0, 18, new Insets(0, 0, 0, 10));
            labelPanel.add((Component)new JLabel(), gbc);
            this.mFahrzeugPanels.add(labelPanel);
        }
        for (i = 0; i < this.mFahrzeugPanels.size(); ++i) {
            panel.add(this.mFahrzeugPanels.get(i));
        }
        return panel;
    }

    public void setLayout() {
        this.mDialog.getContentPane().setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mDialog.getContentPane().setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mPanKundenauswahl.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getKundenauswahl(), 1, 2, Constants.Layout.getZubSmallBoldFont(), this.mMarkenLayout.getBorderColor()));
        this.mLabKundennummer.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mLabKundenname.setForeground(this.mMarkenLayout.getPrimaryForeground());
        this.mLabSuchenButton.setIcon(ImageCache.getInstance().getIcon(this.mMarkenLayout.getIconPath() + "suchen_aktiv.gif"));
        this.mPanKeyreader.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.mMarkenLayout.getBorderColor()), Resource.getInstance().getUeberKeyreader(), 1, 2, Constants.Layout.getZubSmallBoldFont(), this.mMarkenLayout.getBorderColor()));
        this.mPanKeyreader.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mPanKundenauswahl.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mButtonPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mPanContainer.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mPanEmpty.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mPanFahrzeugdaten.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.mPanKundenListe.setBackground(this.mMarkenLayout.getPrimaryBackground());
        this.keyReaderLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
    }

    public int getDialogResult() {
        return this.mDialogResult;
    }

    public void setDialogResult(int result) {
        this.mDialogResult = result;
    }

    public JLabel getButSuchen() {
        return this.mLabSuchenButton;
    }

    public JTextField getTfKundenname() {
        return this.mTfKundenname;
    }

    public JFormattedTextField getTfKundennummer() {
        return this.mTfKundennummer;
    }

    public String getVin() {
        return this.vin;
    }

    public void setVin(String vin) {
        this.vin = vin;
    }

    public ArrayList<JLabel> getAktuellKundenListe() {
        return this.mAktuellKundenListe;
    }

    public JLabel getSuchenButton() {
        return this.mLabSuchenButton;
    }

    public void setSuchenButton(JLabel labSuchenButton) {
        this.mLabSuchenButton = labSuchenButton;
    }

    public ArrayList<JPanel> getKundenPanels() {
        return this.mKundenPanels;
    }

    public String getModus() {
        return this.mModus;
    }

    public void setModus(String modus) {
        this.mModus = modus;
    }

    public ArrayList<JPanel> getFahrzeugPanels() {
        return this.mFahrzeugPanels;
    }

    public ArrayList<Fahrzeug> getMarkenFahrzeuge() {
        return this.mMarkenFahrzeuge;
    }

    public ArrayList<JLabel> getAktuellFahrzeugListe() {
        return this.mAktuellFahrzeugListe;
    }

    public void setAktuellFahrzeugListe(ArrayList<JLabel> aktuellFahrzeugListe) {
        this.mAktuellFahrzeugListe = aktuellFahrzeugListe;
    }
}

