/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.common;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.Constants;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.utilities.viewcomp.JTextField;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.Border;
import org.apache.log4j.Logger;
import webetk.mrkprd.Marken;
import webetk.mrkprd.Produkte;

public class MarkenLayout {
    private static Logger log = Logger.getLogger(MarkenLayout.class);
    private String mMarke;
    private String mProdukt;
    private ArrayList<String> possibleMarks = null;
    private ArrayList<String> possibleProdukte = null;
    private Color primaryBackground;
    private Color primaryForeground;
    private Color secondaryBackground;
    private Color secondaryForeground;
    private Color tertiaryBackground;
    private Color tertiaryForeground;
    private Color disabledButtonBackground;
    private Color disabledButtonForeground;
    private Color enabledButtonBackground;
    private Color enabledButtonForeground;
    private Color selectedReiterBackground;
    private Color deselectedReiterBackground;
    private Color selectedReiterForeground;
    private Color deselectedReiterForeground;
    private Color borderColor;
    private Color borderTextColor;
    private String iconPath;
    private String defaultIconPath;
    private Cursor detailCursor;
    private Color naviHeaderColor;
    private Color naviHeaderFont;
    private Color naviSubHeaderColor;
    private Color naviSubHeaderFont;
    private Border naviBorderSelect;
    private Border naviBorderOpenheader;
    private Border naviBorderCompactheader;
    private Color caretColor = null;
    private int borderSize;

    public MarkenLayout() {
        this.setGeneralLayoutData();
        this.changeLayout(null, null);
        log.debug((Object)"Das MarkenLayout wurde erstellt!");
    }

    public MarkenLayout(String marke, String produkt) {
        this.setGeneralLayoutData();
        this.changeLayout(marke, produkt);
    }

    public void setPossibleMarks(Collection<String> markenInfo) {
        if (this.possibleMarks == null) {
            this.possibleMarks = new ArrayList<String>(markenInfo);
        }
    }

    public ArrayList<String> getPossibleProdukte() {
        return this.possibleProdukte;
    }

    public void setPossibleProdukte(Collection<String> possibleProdukte) {
        if (this.possibleProdukte == null) {
            this.possibleProdukte = new ArrayList<String>(possibleProdukte);
        }
    }

    private void setGeneralLayoutData() {
        this.defaultIconPath = "Icons/";
    }

    public void changeLayout(String marke, String produkt) {
        if (marke == null || produkt == null) {
            this.primaryBackground = Constants.Layout.WHITE_COLOR;
            this.primaryForeground = Constants.Layout.DARKGRAY_COLOR;
            this.secondaryBackground = Constants.Layout.LIGHTGRAY_COLOR;
            this.secondaryForeground = Constants.Layout.BLACK_COLOR;
            this.tertiaryBackground = Constants.Layout.DARKGRAY_COLOR;
            this.tertiaryForeground = Constants.Layout.WHITE_COLOR;
            this.disabledButtonBackground = Constants.Layout.LIGHTGRAY_COLOR;
            this.disabledButtonForeground = Constants.Layout.WHITE_COLOR;
            this.enabledButtonBackground = Constants.Layout.DARKGRAY_COLOR;
            this.enabledButtonForeground = Constants.Layout.WHITE_COLOR;
            this.selectedReiterBackground = Constants.Layout.LIGHTGRAY_COLOR;
            this.deselectedReiterBackground = Constants.Layout.DARKGRAY_COLOR;
            this.selectedReiterForeground = Constants.Layout.BLACK_COLOR;
            this.deselectedReiterForeground = Constants.Layout.WHITE_COLOR;
            this.borderColor = Constants.Layout.LIGHTGRAY_COLOR;
            this.borderTextColor = Constants.Layout.DARKGRAY_COLOR;
            this.borderSize = 2;
            this.iconPath = "Icons/";
            this.detailCursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(ImageCache.getInstance().getImage(this.iconPath + "detailcursor.gif")).getImage(), new Point(10, 10), "");
            this.caretColor = Color.BLACK;
            this.naviHeaderColor = null;
            this.naviHeaderFont = null;
            this.naviSubHeaderColor = null;
            this.naviSubHeaderFont = null;
            this.naviBorderSelect = null;
            this.naviBorderOpenheader = null;
            this.naviBorderCompactheader = null;
        } else if (marke.equals(Marken.getInstance().getMarke("MINI").getBerechtigung()) && produkt.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            this.primaryBackground = Constants.Layout.BLACK_COLOR;
            this.primaryForeground = Constants.Layout.WHITE_COLOR;
            this.secondaryBackground = Constants.Layout.BLACK_COLOR;
            this.secondaryForeground = new Color(224, 224, 224);
            this.tertiaryBackground = Constants.Layout.LIGHTGRAY_COLOR;
            this.tertiaryForeground = Constants.Layout.BLACK_COLOR;
            this.disabledButtonBackground = Constants.Layout.DARKGRAY_COLOR;
            this.disabledButtonForeground = Constants.Layout.BLACK_COLOR;
            this.enabledButtonBackground = Constants.Layout.WHITE_COLOR;
            this.enabledButtonForeground = Constants.Layout.BLACK_COLOR;
            this.selectedReiterBackground = Constants.Layout.ORANGE_COLOR;
            this.deselectedReiterBackground = Constants.Layout.BLACK_COLOR;
            this.selectedReiterForeground = Constants.Layout.BLACK_COLOR;
            this.deselectedReiterForeground = Constants.Layout.WHITE_COLOR;
            this.borderColor = Constants.Layout.DARKGRAY_COLOR;
            this.borderTextColor = Constants.Layout.LIGHTGRAY_COLOR;
            this.borderSize = 10;
            this.iconPath = "Icons/Mini/";
            this.detailCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.getTransparentImageIcon(ImageCache.getInstance().getImage(this.iconPath + "detailcursor.gif"), Color.white).getImage(), new Point(10, 10), "");
            this.caretColor = Color.ORANGE;
            this.naviHeaderColor = Color.BLACK;
            this.naviHeaderFont = Color.WHITE;
            this.naviSubHeaderColor = Constants.Layout.LIGHTGRAY_COLOR;
            this.naviSubHeaderFont = Color.BLACK;
            this.naviBorderSelect = BorderFactory.createMatteBorder(4, 4, 4, 4, Constants.Layout.DUNKEL_ROT);
            this.naviBorderOpenheader = BorderFactory.createMatteBorder(3, 3, 7, 3, Constants.Layout.DUNKEL_ROT);
            this.naviBorderCompactheader = BorderFactory.createMatteBorder(3, 3, 3, 3, Constants.Layout.DUNKEL_ROT);
        } else if (marke.equals(Marken.getInstance().getMarke("BMW").getBerechtigung()) && produkt.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung()) || marke.equals(Marken.getInstance().getMarke("BMWi").getBerechtigung()) && produkt.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            this.primaryBackground = Constants.Layout.WHITE_COLOR;
            this.primaryForeground = Constants.Layout.BLACK_COLOR;
            this.secondaryBackground = Constants.Layout.LIGHTGRAY_COLOR;
            this.secondaryForeground = Constants.Layout.BLACK_COLOR;
            this.tertiaryBackground = Constants.Layout.DARKGRAY_COLOR;
            this.tertiaryForeground = Constants.Layout.WHITE_COLOR;
            this.disabledButtonBackground = Constants.Layout.LIGHTGRAY_COLOR;
            this.disabledButtonForeground = Constants.Layout.WHITE_COLOR;
            this.enabledButtonBackground = Constants.Layout.DARKGRAY_COLOR;
            this.enabledButtonForeground = Constants.Layout.WHITE_COLOR;
            this.selectedReiterBackground = Constants.Layout.BLUE_COLOR;
            this.deselectedReiterBackground = Constants.Layout.WHITE_COLOR;
            this.selectedReiterForeground = Constants.Layout.WHITE_COLOR;
            this.deselectedReiterForeground = Constants.Layout.BLACK_COLOR;
            this.borderColor = Constants.Layout.LIGHTGRAY_COLOR;
            this.borderTextColor = Constants.Layout.DARKGRAY_COLOR;
            this.borderSize = 2;
            this.iconPath = "Icons/Bmw/";
            this.detailCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.getTransparentImageIcon(ImageCache.getInstance().getImage(this.iconPath + "detailcursor.gif"), Color.white).getImage(), new Point(10, 10), "");
            this.caretColor = Color.BLACK;
            this.naviHeaderColor = Constants.Layout.DARKGRAY_COLOR;
            this.naviHeaderFont = Color.WHITE;
            this.naviSubHeaderColor = Constants.Layout.LIGHTGRAY_COLOR;
            this.naviSubHeaderFont = Constants.Layout.DARKGRAY_COLOR;
            this.naviBorderSelect = BorderFactory.createMatteBorder(2, 2, 2, 2, Constants.Layout.DARKGRAY_COLOR);
            this.naviBorderOpenheader = BorderFactory.createEmptyBorder();
            this.naviBorderCompactheader = BorderFactory.createEmptyBorder();
        } else if (marke.equals(Marken.getInstance().getMarke("BMW").getBerechtigung()) && produkt.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            this.primaryBackground = Constants.Layout.WHITE_COLOR;
            this.primaryForeground = Constants.Layout.BLACK_COLOR;
            this.secondaryBackground = Constants.Layout.LIGHTGRAY_COLOR;
            this.secondaryForeground = Constants.Layout.BLACK_COLOR;
            this.tertiaryBackground = Constants.Layout.BLACK_COLOR;
            this.tertiaryForeground = Constants.Layout.WHITE_COLOR;
            this.disabledButtonBackground = Constants.Layout.LIGHTGRAY_COLOR;
            this.disabledButtonForeground = Constants.Layout.WHITE_COLOR;
            this.enabledButtonBackground = Constants.Layout.BLACK_COLOR;
            this.enabledButtonForeground = Constants.Layout.WHITE_COLOR;
            this.selectedReiterBackground = Constants.Layout.BLUE_COLOR;
            this.deselectedReiterBackground = Constants.Layout.WHITE_COLOR;
            this.selectedReiterForeground = Constants.Layout.WHITE_COLOR;
            this.deselectedReiterForeground = Constants.Layout.BLACK_COLOR;
            this.borderColor = Constants.Layout.LIGHTGRAY_COLOR;
            this.borderTextColor = Constants.Layout.BLACK_COLOR;
            this.borderSize = 2;
            this.iconPath = "Icons/Motorrad/";
            this.detailCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.getTransparentImageIcon(ImageCache.getInstance().getImage(this.iconPath + "detailcursor.gif"), Color.white).getImage(), new Point(10, 10), "");
            this.caretColor = Color.BLACK;
            this.naviHeaderColor = Color.BLACK;
            this.naviHeaderFont = Color.WHITE;
            this.naviSubHeaderColor = Constants.Layout.LIGHTGRAY_COLOR;
            this.naviSubHeaderFont = Color.BLACK;
            this.naviBorderSelect = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.BLACK);
            this.naviBorderOpenheader = BorderFactory.createEmptyBorder();
            this.naviBorderCompactheader = BorderFactory.createEmptyBorder();
        }
        this.mMarke = marke != null ? marke : "";
        this.mProdukt = produkt != null ? produkt : "";
    }

    public GridBagConstraints setGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int fill, int anchor, Insets insets) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gridx;
        c.gridy = gridy;
        c.gridwidth = gridwidth;
        c.gridheight = gridheight;
        c.weightx = weightx;
        c.weighty = weighty;
        c.fill = fill;
        c.insets = insets;
        c.anchor = anchor;
        return c;
    }

    public JLabel getBoldHeaderLabel(String beschriftung) {
        JLabel label = new JLabel(beschriftung);
        label.setBigBoldFont();
        return label;
    }

    public JLabel getBoldLabel(String beschriftung) {
        JLabel label = new JLabel(beschriftung);
        label.setBoldFont();
        return label;
    }

    public JLabel getLabel(String beschriftung) {
        JLabel label = new JLabel(beschriftung);
        return label;
    }

    public JLabel getLabel() {
        JLabel label = new JLabel();
        return label;
    }

    public JLabel getBoldLabel() {
        JLabel label = new JLabel();
        label.setBoldFont();
        return label;
    }

    public JTextField getTextField() {
        JTextField textField = new JTextField();
        textField.setBackground(Color.WHITE);
        return textField;
    }

    public JTextField getTextField(int size) {
        JTextField textField = new JTextField(size);
        textField.setBackground(Color.WHITE);
        return textField;
    }

    public JLabel getButton(String beschriftung, Color foreground, Color background) {
        JLabel button = new JLabel(beschriftung, 0);
        button.setOpaque(true);
        button.setPreferredSize(new Dimension(140, 25));
        button.setMinimumSize(new Dimension(140, 25));
        button.setBackground(background);
        button.setForeground(foreground);
        return button;
    }

    public ImageIcon getTransparentImageIcon(Image img, Color colorToFilter) {
        TransparentFilter tfilter = new TransparentFilter(colorToFilter.getRGB());
        FilteredImageSource imageprod = new FilteredImageSource(img.getSource(), tfilter);
        Image img2 = Toolkit.getDefaultToolkit().createImage(imageprod);
        return new ImageIcon(img2);
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public Color getDisabledButtonBackground() {
        return this.disabledButtonBackground;
    }

    public Color getDisabledButtonForeground() {
        return this.disabledButtonForeground;
    }

    public Color getEnabledButtonBackground() {
        return this.enabledButtonBackground;
    }

    public Color getEnabledButtonForeground() {
        return this.enabledButtonForeground;
    }

    public String getMarke() {
        return this.mMarke;
    }

    public String getProdukt() {
        return this.mProdukt;
    }

    public Color getPrimaryBackground() {
        return this.primaryBackground;
    }

    public Color getPrimaryForeground() {
        return this.primaryForeground;
    }

    public Color getSecondaryBackground() {
        return this.secondaryBackground;
    }

    public Color getSecondaryForeground() {
        return this.secondaryForeground;
    }

    public Color getTertiaryBackground() {
        return this.tertiaryBackground;
    }

    public Color getTertiaryForeground() {
        return this.tertiaryForeground;
    }

    public ArrayList<String> getPossibleMarks() {
        return this.possibleMarks;
    }

    public Color getDeselectedReiterBackground() {
        return this.deselectedReiterBackground;
    }

    public Color getDeselectedReiterForeground() {
        return this.deselectedReiterForeground;
    }

    public Color getSelectedReiterBackground() {
        return this.selectedReiterBackground;
    }

    public Color getSelectedReiterForeground() {
        return this.selectedReiterForeground;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getBorderTextColor() {
        return this.borderTextColor;
    }

    public String getDefaultIconPath() {
        return this.defaultIconPath;
    }

    public Cursor getDetailCursor() {
        return this.detailCursor;
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public Border getNaviBorderOpenheader() {
        return this.naviBorderOpenheader;
    }

    public Border getNaviBorderCompactheader() {
        return this.naviBorderCompactheader;
    }

    public Border getNaviBorderSelect() {
        return this.naviBorderSelect;
    }

    public Color getNaviHeaderColor() {
        return this.naviHeaderColor;
    }

    public Color getNaviHeaderFont() {
        return this.naviHeaderFont;
    }

    public Color getNaviSubHeaderColor() {
        return this.naviSubHeaderColor;
    }

    public Color getNaviSubHeaderFont() {
        return this.naviSubHeaderFont;
    }

    public String cleanText(String text, String zeichen, String substitut) {
        String cleanedText = "";
        if (text != null) {
            int beginIndex = 0;
            int endIndex = 0;
            String dummy = text;
            endIndex = text.indexOf(zeichen);
            if (endIndex != -1) {
                while (beginIndex + 2 < text.length()) {
                    cleanedText = !cleanedText.equals("") ? cleanedText + substitut + text.substring(beginIndex, endIndex) : text.substring(beginIndex, endIndex);
                    if (endIndex != text.length()) {
                        beginIndex = endIndex + 1;
                        dummy = text.substring(beginIndex, text.length());
                        if (dummy.contains(zeichen)) {
                            endIndex = beginIndex + dummy.indexOf(zeichen);
                            continue;
                        }
                        endIndex = text.length();
                        continue;
                    }
                    beginIndex = endIndex;
                }
            } else {
                cleanedText = text;
            }
        }
        return cleanedText;
    }

    public String cleanTextMaxZeichen(String text, String zeichen, String substitut, int maxZeichen) {
        String cleanedText = "";
        if (text != null) {
            int beginIndex = 0;
            int endIndex = 0;
            String dummy = text;
            endIndex = text.indexOf(zeichen);
            if (endIndex != -1) {
                while (beginIndex + 2 < text.length()) {
                    String zeile;
                    if (text.substring(beginIndex, endIndex).length() > maxZeichen) {
                        zeile = text.substring(beginIndex, beginIndex + text.substring(beginIndex, beginIndex + maxZeichen).lastIndexOf(" "));
                        endIndex = beginIndex + text.substring(beginIndex, beginIndex + maxZeichen).lastIndexOf(" ");
                    } else {
                        zeile = text.substring(beginIndex, endIndex);
                    }
                    cleanedText = !cleanedText.equals("") ? cleanedText + substitut + zeile : zeile;
                    if (endIndex != text.length()) {
                        beginIndex = endIndex + 1;
                        dummy = text.substring(beginIndex, text.length());
                        if (dummy.contains(zeichen)) {
                            endIndex = beginIndex + dummy.indexOf(zeichen);
                            continue;
                        }
                        endIndex = text.length();
                        continue;
                    }
                    beginIndex = endIndex;
                }
            } else {
                cleanedText = this.formatText(text, maxZeichen, "<br>");
            }
        }
        return cleanedText;
    }

    public String cleanTextComplete(String text, String zeichen, String substitut) {
        String cleanedText = "";
        if (text != null) {
            if (!text.substring(text.length()).equals(zeichen)) {
                text = text + zeichen;
            }
            int beginIndex = 0;
            int endIndex = 0;
            String dummy = text;
            endIndex = text.indexOf(zeichen);
            if (endIndex != -1) {
                while (beginIndex + 2 < text.length()) {
                    cleanedText = !cleanedText.equals("") ? cleanedText + substitut + text.substring(beginIndex, endIndex) : text.substring(beginIndex, endIndex);
                    beginIndex = endIndex + 1;
                    dummy = text.substring(beginIndex, text.length());
                    endIndex = beginIndex + dummy.indexOf(zeichen);
                }
            } else {
                cleanedText = text;
            }
            cleanedText = cleanedText.replaceAll("<u>", "");
            cleanedText = cleanedText.replaceAll("</u>", "");
            cleanedText = cleanedText.replaceAll("<br>", "");
        }
        return cleanedText;
    }

    public String cleanTextWithNewLine(String text, String zeichen, String aufzaehlungszeichen) {
        String cleanedText = "";
        if (text != null) {
            if (!text.substring(text.length()).equals(zeichen)) {
                text = text + zeichen;
            }
            int beginIndex = 0;
            int endIndex = 0;
            String dummy = text;
            endIndex = text.indexOf(zeichen);
            if (endIndex != -1) {
                while (beginIndex + 2 < text.length()) {
                    cleanedText = !cleanedText.equals("") ? cleanedText + aufzaehlungszeichen + text.substring(beginIndex, endIndex) + "<br>" : aufzaehlungszeichen + text.substring(beginIndex, endIndex) + "<br>";
                    beginIndex = endIndex + 1;
                    dummy = text.substring(beginIndex, text.length());
                    if (dummy.indexOf(zeichen) != -1) {
                        endIndex = beginIndex + dummy.indexOf(zeichen);
                        continue;
                    }
                    beginIndex = text.length();
                }
            } else {
                cleanedText = text;
            }
        }
        return cleanedText;
    }

    public ArrayList<String> cleanTextIntoArray(String text, String zeichen, String aufzaehlungszeichen) {
        ArrayList<String> textList = new ArrayList<String>();
        if (text != null) {
            if (!text.substring(text.length()).equals(zeichen)) {
                text = text + zeichen;
            }
            int beginIndex = 0;
            int endIndex = 0;
            String dummy = text;
            endIndex = text.indexOf(zeichen);
            if (endIndex != -1) {
                while (beginIndex + 2 < text.length()) {
                    textList.add(aufzaehlungszeichen + text.substring(beginIndex, endIndex));
                    beginIndex = endIndex + 1;
                    dummy = text.substring(beginIndex, text.length());
                    if (dummy.indexOf(zeichen) != -1) {
                        endIndex = beginIndex + dummy.indexOf(zeichen);
                        continue;
                    }
                    beginIndex = text.length();
                }
            } else {
                textList.add(text);
            }
        }
        return textList;
    }

    public String cleanTextWithNewLine(String text, String zeichen, String aufzaehlungszeichen, int maxZeichenProZeile) {
        String cleanedText = "";
        if (text != null) {
            if (!text.substring(text.length()).equals(zeichen)) {
                text = text + zeichen;
            }
            int beginIndex = 0;
            int endIndex = 0;
            String dummy = text;
            endIndex = text.indexOf(zeichen);
            if (endIndex != -1) {
                while (beginIndex + 2 < text.length()) {
                    cleanedText = !cleanedText.equals("") ? cleanedText + aufzaehlungszeichen + this.formatText(text.substring(beginIndex, endIndex), maxZeichenProZeile, "<br>&nbsp;&nbsp;") + "<br>" : aufzaehlungszeichen + this.formatText(text.substring(beginIndex, endIndex), maxZeichenProZeile, "<br>&nbsp;&nbsp;") + "<br>";
                    beginIndex = endIndex + 1;
                    dummy = text.substring(beginIndex, text.length());
                    if (dummy.indexOf(zeichen) != -1) {
                        endIndex = beginIndex + dummy.indexOf(zeichen);
                        continue;
                    }
                    beginIndex = text.length();
                }
            } else {
                cleanedText = this.formatText(text, maxZeichenProZeile, "<br>");
            }
        }
        return cleanedText;
    }

    public String formatText(String text, int maxZeichenproZeile, String fromatZeichen) {
        String formattedText = "";
        int index = 0;
        text = text.replaceAll("<br>", " ");
        while (text.length() > index + maxZeichenproZeile) {
            if (text.length() > index + maxZeichenproZeile) {
                String dummy = text.substring(index, index + maxZeichenproZeile);
                int position = dummy.lastIndexOf(" ");
                if (position > 0) {
                    formattedText = formattedText + text.substring(index, index + position) + fromatZeichen;
                    index += position;
                    continue;
                }
                formattedText = formattedText + text.substring(index, index + maxZeichenproZeile) + fromatZeichen;
                index += maxZeichenproZeile;
                continue;
            }
            index = text.length();
            formattedText = formattedText + text.substring(index, text.length()) + fromatZeichen;
        }
        return formattedText + text.substring(index, text.length());
    }

    public static void setSessionMarke(String marke, String produkt) {
        GlobalObjects.getInstance().getSessionInfo().setMarke(marke);
        GlobalObjects.getInstance().getSessionInfo().setProduktart(produkt);
    }

    public String formatTextWithHtml(String text, int maxZeichenproZeile) {
        return "<html>" + this.formatText(text, maxZeichenproZeile, "<br>") + "</html>";
    }

    public String insertNewLinesInAufz(String text, int maxZeichenproZeile) {
        String formattedText = "";
        int index = 0;
        String formatZeichen = "<br>";
        while (text.length() > index + maxZeichenproZeile) {
            if (text.length() > index + maxZeichenproZeile) {
                String dummy = text.substring(index, index + maxZeichenproZeile);
                if (!dummy.contains(formatZeichen)) {
                    int position = dummy.lastIndexOf(" ");
                    if (position > 0) {
                        formattedText = formattedText + text.substring(index, index + position) + formatZeichen;
                        index += position;
                        continue;
                    }
                    formattedText = formattedText + text.substring(index, index + maxZeichenproZeile) + formatZeichen;
                    index += maxZeichenproZeile;
                    continue;
                }
                formattedText = formattedText + dummy;
                index += maxZeichenproZeile;
                continue;
            }
            index = text.length();
            formattedText = formattedText + text.substring(index, text.length()) + formatZeichen;
        }
        return formattedText + text.substring(index, text.length());
    }

    public boolean isBMWMotorrad() {
        return this.mMarke.equals(Marken.getInstance().getMarke("BMW").getBerechtigung()) && this.mProdukt.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung());
    }

    public boolean isMINI() {
        return this.mMarke.equals(Marken.getInstance().getMarke("MINI").getBerechtigung()) && this.mProdukt.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
    }

    public boolean isBMW() {
        return this.mMarke.equals(Marken.getInstance().getMarke("BMW").getBerechtigung()) && this.mProdukt.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
    }

    public boolean isBMWi() {
        return this.mMarke.equals(Marken.getInstance().getMarke("BMWi").getBerechtigung()) && this.mProdukt.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
    }

    private static class TransparentFilter
    extends RGBImageFilter {
        private int rgb;

        public TransparentFilter(int rgb) {
            this.rgb = rgb;
            this.canFilterIndexColorModel = false;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            if (rgb == this.rgb) {
                rgb &= 0xFFFFFF;
            }
            return rgb;
        }
    }
}

